/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.attachment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.attachment.util.AttachmentOpLogUtil;
import kd.bos.attachment.util.BillFileMappingWriter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.ControlTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.control.events.attach.manager.AttachOpEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.AttachmentInfo;
import kd.bos.mservice.attachment.AttachmentModel;
import kd.bos.mservice.attachment.AttachmentOpType;
import kd.bos.mservice.attachment.AttachmentType;
import kd.bos.mservice.attachment.IAttachmentManagerService;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterReader;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.JSONUtils;
import org.apache.commons.collections.CollectionUtils;

public class AttachmentManagerService
implements IAttachmentManagerService {
    private static final Log log = LogFactory.getLog(AttachmentManagerService.class);
    private static final String FACTORY_QUALIFIED_PREFIX = "factoryqualifiedprefix";
    private static final String SERVICE_NAME = "servicename";
    private static final String APPID = "appid";
    private static final String ENTITY_BOS_ATTACH_OPLOG = "bos_attachment_oplog";
    private static final String FIELD_USER = "user";
    private static final String FIELD_USERNAME = "username";
    private static final String FIELD_ORG = "org";
    private static final String FIELD_ORG_NAME = "orgname";
    private static final String FIELD_OPTYPE = "optype";
    private static final String FIELD_OPTIME = "optime";
    private static final String FIELD_CLIENTTYPE = "clienttype";
    private static final String FIELD_FILENAME = "filename";
    private static final String FIELD_FILEEXT = "fileext";
    private static final String FIELD_BIZOBJ = "bizobj";
    private static final String FIELD_BIZOBJ_NAME = "bizobjname";
    private static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_URL = "url";
    private static final String FIELD_BILLNO = "billno";
    private static final String FIELD_FILELOCATION = "filelocation";
    private static final String FIELD_ATTTYPE = "atttype";
    private static final String FIELD_ATTKEY = "attkey";
    private static final String FIELD_ATTPKID = "attpkid";
    private static final String FIELD_BILLPKID = "billpkid";
    private static final String FIELD_CLIENTIP = "clientip";
    private static final String BILL_PK_ID = "billPkId";
    private static String BOS_SVC_COMMON = "bos-svc-common";
    private static final String BOS_ATTACHMENT = "bos-attachment";
    private static final String ENTITY_NUM = "entityNum";

    public List<Map<String, Object>> loadServiceList() {
        Map configs = ParameterReader.loadPublicParameterFromCache();
        if (configs == null) {
            return new ArrayList<Map<String, Object>>();
        }
        String serviceInfos = (String)configs.get("managerservice");
        if (StringUtils.isBlank((CharSequence)serviceInfos)) {
            return new ArrayList<Map<String, Object>>();
        }
        log.debug("\u9644\u4ef6\u7ba1\u7406\u670d\u52a1\u6ce8\u518c\u5168\u5c40\u63d2\u4ef6:" + serviceInfos);
        Map services = (Map)SerializationUtils.fromJsonString((String)serviceInfos, Map.class);
        ArrayList<Map<String, Object>> serviceList = new ArrayList<Map<String, Object>>();
        serviceList.add(services);
        return serviceList;
    }

    public List<AttachmentInfo> beforeSendData(List<AttachmentInfo> infos) {
        BillFileMappingWriter.syncWriteFileBillMapping(infos);
        List<Map<String, Object>> serviceList = this.loadServiceList();
        for (Map<String, Object> row : serviceList) {
            String factoryQualifiedPrefix = String.valueOf(row.get(FACTORY_QUALIFIED_PREFIX));
            String appId = String.valueOf(row.get(APPID));
            String serviceName = String.valueOf(row.get(SERVICE_NAME));
            try {
                log.debug("\u9644\u4ef6\u670d\u52a1AttachmentManagerService.beforeSendData\u524d\u6570\u636e : -----" + JSONUtils.toString(infos));
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
            infos = (List)DispatchServiceHelper.invokeService((String)factoryQualifiedPrefix, (String)appId, (String)serviceName, (String)"checkAttachPerm", (Object[])new Object[]{infos});
            try {
                log.debug("\u9644\u4ef6\u670d\u52a1AttachmentManagerService.beforeSendData\u540e\u6570\u636e : -----" + JSONUtils.toString((Object)infos));
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
        return infos;
    }

    public Map<String, Object> beforeDoOperation(List<AttachmentInfo> infos, AttachmentOpType opType) {
        List<Map<String, Object>> serviceList = this.loadServiceList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("enable", true);
        for (Map<String, Object> row : serviceList) {
            String factoryQualifiedPrefix = String.valueOf(row.get(FACTORY_QUALIFIED_PREFIX));
            String appId = String.valueOf(row.get(APPID));
            String serviceName = String.valueOf(row.get(SERVICE_NAME));
            AttachOpEvent event = new AttachOpEvent(opType, infos);
            if (!(event = (AttachOpEvent)DispatchServiceHelper.invokeService((String)factoryQualifiedPrefix, (String)appId, (String)serviceName, (String)"checkOpRight", (Object[])new Object[]{event})).isCancel()) continue;
            map.put("enable", false);
            map.put("cancleMsg", event.getCancelMsg());
        }
        return map;
    }

    public void afterDoOperation(List<AttachmentInfo> infos, AttachmentOpType opType) {
        List<Map<String, Object>> serviceList = this.loadServiceList();
        this.doLog(infos, opType);
        for (Map<String, Object> row : serviceList) {
            String factoryQualifiedPrefix = String.valueOf(row.get(FACTORY_QUALIFIED_PREFIX));
            String appId = String.valueOf(row.get(APPID));
            String serviceName = String.valueOf(row.get(SERVICE_NAME));
            AttachOpEvent event = new AttachOpEvent(opType, infos);
            DispatchServiceHelper.invokeService((String)factoryQualifiedPrefix, (String)appId, (String)serviceName, (String)"afterDoOperation", (Object[])new Object[]{event});
        }
    }

    private void doLog(List<AttachmentInfo> infos, AttachmentOpType opType) {
        if (CollectionUtils.isEmpty(infos)) {
            return;
        }
        RequestContext rc = RequestContext.get();
        Date now = new Date();
        DynamicObject[] oplogArr = new DynamicObject[infos.size()];
        int index = 0;
        HashMap<String, String> entityIdToDisplayNameMap = new HashMap<String, String>(infos.size());
        for (AttachmentInfo info : infos) {
            DynamicObject attOpLog = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_BOS_ATTACH_OPLOG);
            attOpLog.set(FIELD_USER, (Object)rc.getCurrUserId());
            if (rc.getCurrUserId() <= 0L) {
                return;
            }
            attOpLog.set(FIELD_USERNAME, (Object)rc.getUserName());
            attOpLog.set(FIELD_ORG, (Object)rc.getOrgId());
            if (rc.getOrgId() == 0L) {
                return;
            }
            QFilter idFilter = new QFilter("id", "=", (Object)rc.getOrgId());
            QFilter[] filters = new QFilter[]{idFilter};
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"name", (QFilter[])filters);
            if (org == null) {
                return;
            }
            attOpLog.set(FIELD_ORG_NAME, (Object)org.getLocaleString("name"));
            attOpLog.set(FIELD_OPTYPE, (Object)opType.getValue());
            attOpLog.set(FIELD_OPTIME, (Object)now);
            attOpLog.set(FIELD_CLIENTTYPE, (Object)AttachmentOpLogUtil.converString((String)info.getClient()));
            attOpLog.set(FIELD_FILENAME, (Object)AttachmentOpLogUtil.converString((String)info.getFileName()));
            attOpLog.set(FIELD_FILEEXT, (Object)AttachmentOpLogUtil.getExtFromFileName((String)attOpLog.getString(FIELD_FILENAME)));
            attOpLog.set(FIELD_BIZOBJ, (Object)AttachmentOpLogUtil.converString((String)info.getEntityNum()));
            if (StringUtils.isEmpty((CharSequence)info.getEntityNum())) {
                return;
            }
            String formDisplayName = this.getFormDisplayName(entityIdToDisplayNameMap, info.getEntityNum());
            attOpLog.set(FIELD_BIZOBJ_NAME, (Object)formDisplayName);
            attOpLog.set(FIELD_CLIENTIP, (Object)rc.getLoginIP());
            String param = "";
            if (AttachmentOpType.Rename == opType) {
                param = AttachmentOpLogUtil.converString((String)info.getFileName());
            }
            if (AttachmentOpType.Mark == opType) {
                param = AttachmentOpLogUtil.converString((String)info.getMark());
            }
            attOpLog.set(FIELD_DESCRIPTION, (Object)this.genOpDescription(opType, param));
            String downloadUrl = AttachmentOpLogUtil.converString((String)info.getDownloadUrl());
            String locationType = AttachmentOpLogUtil.getLocationTypeByUrlV1((String)downloadUrl);
            String url = AttachmentOpLogUtil.getPathFromUrl((String)downloadUrl, (String)locationType);
            if (url.length() > 450) {
                url = url.substring(0, 450);
            }
            attOpLog.set(FIELD_URL, (Object)url);
            attOpLog.set(FIELD_FILELOCATION, (Object)locationType);
            attOpLog.set(FIELD_ATTTYPE, (Object)AttachmentOpLogUtil.converString((String)info.getAttSourceType().getValue()));
            attOpLog.set(FIELD_ATTKEY, (Object)AttachmentOpLogUtil.converString((String)info.getAttKey()));
            attOpLog.set(FIELD_ATTPKID, (Object)info.getAttPkId());
            attOpLog.set(FIELD_BILLPKID, (Object)AttachmentOpLogUtil.convertoLong((String)info.getBillPkId()));
            oplogArr[index++] = attOpLog;
        }
        try (TXHandle h = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])oplogArr);
        }
    }

    private LocaleString genOpDescription(AttachmentOpType opType, String param) {
        LocaleString description = new LocaleString();
        switch (opType) {
            case Save: {
                description = ResManager.getLocaleString((String)"\u9644\u4ef6\u4fdd\u5b58\u6210\u529f\u3002", (String)"OpLog_Description_Save", (String)BOS_SVC_COMMON);
                break;
            }
            case Upload: {
                description = ResManager.getLocaleString((String)"\u4e0a\u4f20\u6210\u529f\u3002", (String)"OpLog_Description_Upload", (String)BOS_SVC_COMMON);
                break;
            }
            case PreView: {
                description = ResManager.getLocaleString((String)"\u9884\u89c8\u6210\u529f\u3002", (String)"OpLog_Description_Preview", (String)BOS_SVC_COMMON);
                break;
            }
            case Download: {
                description = ResManager.getLocaleString((String)"\u4e0b\u8f7d\u6210\u529f\u3002", (String)"OpLog_Description_Download", (String)BOS_SVC_COMMON);
                break;
            }
            case DownloadFromUrl: {
                description = ResManager.getLocaleString((String)"\u901a\u8fc7\u94fe\u63a5\u4e0b\u8f7d\u6210\u529f\u3002", (String)"OpLog_Description_DownloadUrl", (String)BOS_SVC_COMMON);
                break;
            }
            case Remove: {
                description = ResManager.getLocaleString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"OpLog_Description_Remove", (String)BOS_SVC_COMMON);
                break;
            }
            case Mark: {
                description = ResManager.getLocaleString((String)"\u5907\u6ce8\uff1a", (String)"OpLog_Description_Mark_v2", (String)BOS_SVC_COMMON);
                for (Map.Entry entry : description.entrySet()) {
                    String value = (String)entry.getValue();
                    description.setItem((String)entry.getKey(), (Object)String.format(value + "%s", param));
                }
                break;
            }
            case Rename: {
                description = ResManager.getLocaleString((String)"\u91cd\u547d\u540d\u4e3a\uff1a", (String)"OpLog_Description_Rename_v2", (String)BOS_SVC_COMMON);
                for (Map.Entry entry : description.entrySet()) {
                    String value = (String)entry.getValue();
                    description.setItem((String)entry.getKey(), (Object)String.format(value + "%s", param));
                }
                break;
            }
        }
        return description;
    }

    private String getFormDisplayName(Map<String, String> entityIdToDisplayNameMap, String entityNum) {
        FormConfig formConfig;
        if (entityIdToDisplayNameMap.get(entityNum) != null) {
            return entityIdToDisplayNameMap.get(entityNum);
        }
        String formConfigStr = "";
        try {
            MetadataService metadataService = (MetadataService)ServiceFactory.getService((String)"MetadataService");
            formConfigStr = metadataService.loadFormConfig(entityNum);
            if (StringUtils.isBlank((CharSequence)formConfigStr)) {
                entityIdToDisplayNameMap.put(entityNum, entityNum);
                return entityNum;
            }
            formConfig = (FormConfig)ControlTypes.fromJsonStringToObj((String)formConfigStr);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            try {
                formConfig = (FormConfig)SerializationUtils.fromJsonString((String)formConfigStr, FormConfig.class);
            }
            catch (Exception e2) {
                log.error((Throwable)e2);
                entityIdToDisplayNameMap.put(entityNum, entityNum);
                return entityNum;
            }
        }
        if (StringUtils.isBlank((Object)formConfig)) {
            String val = ResManager.loadKDString((String)"\u7a7a\u5bf9\u8c61", (String)"AttachmentOptLog_1", (String)BOS_ATTACHMENT, (Object[])new Object[0]);
            entityIdToDisplayNameMap.put(entityNum, val);
            return val;
        }
        String localeValue = formConfig.getCaption().getLocaleValue();
        entityIdToDisplayNameMap.put(entityNum, localeValue);
        return localeValue;
    }

    public List<AttachmentInfo> packageAttachmentInfo(List<Map<String, Object>> attachs, AttachmentModel attachmentModel) {
        ArrayList<AttachmentInfo> resultList = new ArrayList<AttachmentInfo>(attachs.size());
        for (Map<String, Object> attach : attachs) {
            AttachmentInfo attachmentInfo = attach instanceof Map ? this.getAttachmentInfo(attachmentModel, attach) : this.createNewAttachmentInfoWithUrl(attachmentModel, attach);
            resultList.add(attachmentInfo);
        }
        return resultList;
    }

    private AttachmentInfo createNewAttachmentInfoWithUrl(AttachmentModel attachmentModel, Object attach) {
        Date now = new Date();
        RequestContext rc = RequestContext.get();
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)attachmentModel.getName());
        String entityNum = formConfig.getEntityTypeId();
        String appId = formConfig.getAppId();
        String path = String.valueOf(attach);
        AttachmentInfo attachmentInfo = new AttachmentInfo();
        attachmentInfo.setAttSourceType(AttachmentType.attachmentfield);
        attachmentInfo.setFieldType(attachmentModel.getFieldType());
        attachmentInfo.setFieldKey(attachmentModel.getKey());
        attachmentInfo.setFileName(AttachmentOpLogUtil.getFileName((String)path));
        attachmentInfo.setExt(AttachmentOpLogUtil.getFileExt((String)path));
        attachmentInfo.setEntityNum(entityNum);
        attachmentInfo.setAppId(appId);
        attachmentInfo.setAttKey(attachmentModel.getKey());
        attachmentInfo.setBillPkId(attachmentModel.getBillPkId());
        attachmentInfo.setDownloadUrl(path);
        attachmentInfo.setCreateTime(now);
        attachmentInfo.setCreateUserId(rc.getUserId());
        attachmentInfo.setModifyTime(now);
        attachmentInfo.setBillno(attachmentModel.getBillno());
        return attachmentInfo;
    }

    private AttachmentInfo getAttachmentInfo(AttachmentModel attachmentModel, Map attach) {
        RequestContext rc = RequestContext.get();
        Date now = new Date();
        AttachmentInfo attachmentInfo = new AttachmentInfo();
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)attachmentModel.getName());
        String entityNum = formConfig.getEntityTypeId();
        String appId = formConfig.getAppId();
        Map attMap = attach;
        attachmentInfo.setAttSourceType(AttachmentType.attachmentfield);
        attachmentInfo.setEntityNum(entityNum != null ? entityNum : (String)attMap.get(ENTITY_NUM));
        attachmentInfo.setAttKey(attachmentModel.getKey());
        attachmentInfo.setBillPkId((String)attMap.get(BILL_PK_ID));
        attachmentInfo.setAttPkId((Long)attMap.get("attPkId"));
        attachmentInfo.setExt((String)attMap.get("type"));
        attachmentInfo.setFileName((String)attMap.get("name"));
        attachmentInfo.setFileSize(Long.valueOf(Long.parseLong(attMap.get("size").toString())));
        attachmentInfo.setDownloadUrl(attMap.get(FIELD_URL) == null ? "" : (String)attMap.get(FIELD_URL));
        attachmentInfo.setPreviewUrl(attachmentInfo.getDownloadUrl().replace("download.do", "preview.do"));
        attachmentInfo.setMark(attMap.get(FIELD_DESCRIPTION) == null ? "" : (String)attMap.get(FIELD_DESCRIPTION));
        attachmentInfo.setAppId(appId);
        attachmentInfo.setFieldType(attachmentModel.getFieldType());
        attachmentInfo.setFieldKey(attachmentModel.getKey());
        if (attMap.containsKey("createdate")) {
            now = new Date();
            Object createdate = attMap.get("createdate");
            if (createdate instanceof Date) {
                now = (Date)createdate;
            }
            if (createdate instanceof Long) {
                now = new Date((Long)createdate);
            }
        }
        if (attMap.containsKey("uploadTime")) {
            now = new Date((Long)attMap.get("uploadTime"));
        }
        attachmentInfo.setCreateTime(now);
        attachmentInfo.setCreateUserId(rc.getUserId());
        attachmentInfo.setModifyTime(now);
        attachmentInfo.setBillno(attachmentModel.getBillno());
        attachmentInfo.setClient(attachmentModel.isWeb() ? "web" : "mobile");
        return attachmentInfo;
    }

    public void syncWriteFileBillMapping(List<AttachmentInfo> infos) {
        BillFileMappingWriter.syncWriteFileBillMapping(infos);
    }
}

