/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.attachment;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import kd.bos.attachment.manage.AttachManageService;
import kd.bos.attachment.manage.ImageManageService;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileService;
import kd.bos.service.attachment.AttachFileException;
import kd.bos.service.attachment.AttachFileService;

public class FileServiceInterceptor
implements InvocationHandler {
    private AttachFileService targetService = null;

    public FileServiceInterceptor(AttachFileService attachFileService) {
        this.targetService = attachFileService;
    }

    public static FileService createFileService(FileService fileService, String type) {
        AttachFileService attachFileService = "1".equals(type) ? new AttachFileService(fileService, (AttachManageService)new ImageManageService()) : new AttachFileService(fileService, new AttachManageService());
        ClassLoader classLoader = attachFileService.getClass().getClassLoader();
        Class<?>[] interfaces = attachFileService.getClass().getInterfaces();
        FileServiceInterceptor logHandler = new FileServiceInterceptor(attachFileService);
        FileService proxy = (FileService)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)logHandler);
        return proxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (method.isDefault() && !StringUtils.equals((CharSequence)method.getName(), (CharSequence)"moveTempFile")) {
                FileService fileService = this.targetService.getTargetService();
                Object result = method.invoke((Object)fileService, args);
                return result;
            }
            Object result = method.invoke((Object)this.targetService, args);
            return result;
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof AttachFileException) {
                throw ((AttachFileException)targetException).getTarget();
            }
            throw targetException;
        }
        catch (AttachFileException e) {
            throw e.getTarget();
        }
    }
}

