/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.svc.attachment.wps.action;

import java.io.Closeable;
import java.io.InputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.attachment.util.FileSecurityUtil;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileItemParser;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.svc.attachment.wps.edit.WpsEditHandle;
import kd.bos.svc.attachment.wps.pri.WpsPrivateHandle;
import kd.bos.svc.attachment.yozo.YozoDocumentHandle;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class WpsAttachAction {
    private static Log log = LogFactory.getLog(WpsAttachAction.class);

    public static void renameForWps(HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.debug("enter renameForWps");
        response.setStatus(200);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)"");
    }

    public static void online(HttpServletRequest request, HttpServletResponse response) {
        log.debug("online  ... getRequestURL() is " + request.getRequestURL().toString());
        log.debug("online  ... get paramMap is " + SerializationUtils.toJsonString((Object)request.getParameterMap()));
    }

    public static void version(HttpServletRequest request, HttpServletResponse response) {
        log.debug("version  ... getRequestURL() is " + request.getRequestURL().toString());
        log.debug("version  ... get paramMap is " + SerializationUtils.toJsonString((Object)request.getParameterMap()));
    }

    public static void history(HttpServletRequest request, HttpServletResponse response) {
        log.debug("history  ... getRequestURL() is " + request.getRequestURL().toString());
        log.debug("history  ... get paramMap is " + SerializationUtils.toJsonString((Object)request.getParameterMap()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFileForWps(HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.debug("enter saveFileForWps");
        InputStream in = null;
        try {
            String resData;
            String identifyType = request.getParameter("p");
            String fileId = request.getHeader("x-weboffice-file-id");
            log.debug("wps save file get fileId is:" + fileId);
            boolean isPrivate = "1".equals(request.getParameter("isPrivate"));
            boolean iSYozo = "1".equals(request.getParameter("isYozo"));
            if (isPrivate) {
                fileId = request.getHeader("X-Weboffice-File-Id");
            } else if (iSYozo) {
                fileId = request.getParameter("fileId");
            }
            String customEditInfo = request.getParameter("customEditInfo");
            log.debug("get param p is:" + identifyType + ",customEditInfo:" + customEditInfo);
            FileItem fileItem = FileItemParser.parseHttpRequest((HttpServletRequest)request);
            in = fileItem.getInputStream();
            String fileName = fileItem.getFileName();
            log.debug("get file name from file item:" + fileName);
            if (isPrivate) {
                boolean isTempFile = "1".equals(request.getParameter("isTempFile"));
                resData = WpsPrivateHandle.saveFile(identifyType, fileName, in, fileId, customEditInfo, isTempFile);
            } else {
                resData = iSYozo ? YozoDocumentHandle.saveDocument(identifyType, fileName, in, fileId) : WpsEditHandle.saveFile(identifyType, fileName, in, fileId, customEditInfo);
            }
            response.setStatus(200);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)resData);
            FileSecurityUtil.safeClose((Closeable)in);
        }
        catch (Exception e) {
            log.error("saveFileForWps error", (Throwable)e);
            response.setStatus(500);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)"saveFileForWps error");
        }
        finally {
            FileSecurityUtil.safeClose(in);
        }
    }

    public static void createNewFileForWps(HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.debug("createNewFileForWps  ... getRequestURL() is " + request.getRequestURL().toString());
        log.debug("createNewFileForWps  ... get paramMap is " + SerializationUtils.toJsonString((Object)request.getParameterMap()));
    }

    public static void getUserInfoForWps(HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.debug("enter getUserInfoForWps");
        String[] userIds = request.getParameterValues("ids");
        String resData = WpsEditHandle.getUserInfoForWps(userIds);
        response.setStatus(200);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)resData);
    }
}

