/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.svc.attachment.wps.edit;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.attachment.util.ParamUtil;
import kd.bos.form.control.UrlUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.svc.attachment.preview.WpsPerviewSignture;
import kd.bos.svc.attachment.preview.WpsPreviewHandle;
import kd.bos.svc.attachment.preview.WpsPreviewInfo;
import kd.bos.svc.attachment.wps.dto.WpsUserInfo;
import kd.bos.svc.attachment.wps.pri.dto.Watermark;
import kd.bos.web.actions.utils.FilePathUtil;

public class WpsEditHandle
extends WpsPreviewHandle {
    private static final Log log = LogFactory.getLog(WpsEditHandle.class);

    public static String getUserInfoForWps(String[] userIds) {
        List<WpsUserInfo> list = WpsEditHandle.getUserInfoList(userIds);
        return SerializationUtils.toJsonString(list);
    }

    public static List<WpsUserInfo> getUserInfoList(String[] userIds) {
        ArrayList<WpsUserInfo> list = new ArrayList<WpsUserInfo>(10);
        ArrayList<Long> userIdLong = new ArrayList<Long>(10);
        for (String userId : userIds) {
            userIdLong.add(Long.parseLong(userId));
        }
        List userInfos = UserServiceHelper.getUserInfoByID(userIdLong);
        for (Map userInfo : userInfos) {
            WpsUserInfo wpsUserInfo = new WpsUserInfo();
            wpsUserInfo.setId(String.valueOf(userInfo.get("id")));
            wpsUserInfo.setName((String)userInfo.get("name"));
            list.add(wpsUserInfo);
        }
        return list;
    }

    public static String saveFile(String identifyType, String fileName, InputStream in, String fileId) throws IOException {
        return WpsEditHandle.saveFile(identifyType, fileName, in, fileId, null);
    }

    public static String saveFile(String identifyType, String fileName, InputStream in, String fileId, String customEditInfo) throws IOException {
        return WpsEditHandle.saveFileAndSendMessage(identifyType, fileName, in, fileId, 1, customEditInfo);
    }

    public static String createWpsEditUrl(String url, String rootPageId) throws Exception {
        log.debug("createWpsEditUrl param url is:" + url);
        String path = UrlUtil.getParam((String)url, (String)"path");
        path = FilePathUtil.dealPath((String)URLDecoder.decode(path, "UTF-8"), (String)"attach");
        log.debug("createWpsEditUrl path is:" + path);
        Map previewSetting = ParamUtil.getWpsPublicParam((boolean)false);
        String appId = previewSetting.getOrDefault("wps.appid", "");
        String appSecret = previewSetting.getOrDefault("wps.appsecret", "");
        return WpsEditHandle.createWpsPreViewUrl(path, appId, appSecret, true, rootPageId, new Watermark());
    }

    public static String createNewFileUrlBySelf(String url, String rootPageId, String name, Integer size) {
        Map wpsSetting = ParamUtil.getWpsPublicParam((boolean)false);
        String appId = wpsSetting.getOrDefault("wps.appid", "");
        String appSecret = wpsSetting.getOrDefault("wps.appsecret", "");
        String attPkId = UUID.randomUUID().toString().replace("-", "");
        WpsPreviewInfo wpsPreviewInfo = new WpsPreviewInfo(attPkId, url, name, size.intValue());
        String wpsFileInfoId = WpsEditHandle.convertBillFillMapping(wpsPreviewInfo, true, new Watermark());
        String type = WpsEditHandle.getFileType(name);
        HashMap<String, String> paramMap = new HashMap<String, String>(2);
        paramMap.put("_w_appid", String.valueOf(appId));
        paramMap.put("_w_id", wpsFileInfoId);
        paramMap.put("_w_fname", name);
        String signature = WpsPerviewSignture.getSignature(paramMap, String.valueOf(appSecret));
        String wpsPreviewUrl = "https://wwo.wps.cn/office/" + type + "/" + attPkId + "?_w_appid=" + appId + "&_w_id=" + wpsFileInfoId + "&_w_signature=" + signature;
        wpsPreviewUrl = wpsPreviewUrl + "&p=" + rootPageId + "&_w_fname=" + name;
        return AttachmentServiceHelper.getEncreptURL((String)wpsPreviewUrl);
    }
}

