/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.actions;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.grapecity.documents.excel.Workbook;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.attachment.util.AttachExceptionHandler;
import kd.bos.attachment.util.AttachmentCommonUtils;
import kd.bos.attachment.util.BillFileMappingWriter;
import kd.bos.attachment.util.FileSecurityUtil;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.decode.DecodeHandlerFactory;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.param.CustomParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.file.security.FileCheckResult;
import kd.bos.file.security.FileChecker;
import kd.bos.fileservice.BatchDownloadRequest;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileItemParser;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.config.FileServiceTenantConfig;
import kd.bos.fileservice.enums.PreviewParams;
import kd.bos.fileservice.utils.ExceptionUtil;
import kd.bos.fileservice.utils.FileTimeoutUtil;
import kd.bos.fileservice.utils.FileUtil;
import kd.bos.fileservice.utils.JsonUtil;
import kd.bos.fileservice.watermark.IWatermarkHandler;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.attachment.common.AttachmentKit;
import kd.bos.form.attachment.util.AttachmentPreviewUtil;
import kd.bos.form.attachment.util.ParamUtil;
import kd.bos.form.attachment.util.SupportPreviewTypeConstant;
import kd.bos.form.watermark.common.WaterMarkKit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.AttachmentType;
import kd.bos.mservice.attachment.IAttachmentService;
import kd.bos.param.service.IParameterHelperService;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.service.attachment.FileItemExt;
import kd.bos.service.attachment.FileSource;
import kd.bos.service.attachment.PreviewCallBackService;
import kd.bos.service.attachment.extend.action.FileActionExtensionFactory;
import kd.bos.service.attachment.extend.permission.FilePermissionExtensionFactory;
import kd.bos.service.attachment.extend.permission.FilePermissionParam;
import kd.bos.service.attachment.extend.permission.FileTypeEnum;
import kd.bos.service.attachment.extend.permission.IFilePermissionExtension;
import kd.bos.service.attachment.extend.permission.PermissionResult;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.FileRecord;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.util.FileRecordUtil;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.svc.attachment.preview.WpsPreviewHandle;
import kd.bos.svc.attachment.service.KKFileViewPreviewService;
import kd.bos.svc.attachment.service.args.KKFileViewPreviewArgs;
import kd.bos.svc.attachment.service.impl.KKFileViewPreviewServiceImpl;
import kd.bos.svc.attachment.wps.pri.WpsPrivateHandle;
import kd.bos.svc.attachment.wps.pri.dto.Watermark;
import kd.bos.svc.attachment.wps.v3.WpsV3Handle;
import kd.bos.svc.attachment.yozo.YozoDocumentHandle;
import kd.bos.svc.util.FileHandlerUtil;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.FileNameUtils;
import kd.bos.util.FileUtils;
import kd.bos.web.DispatchServiceHelper;
import kd.bos.web.actions.FileContentTypeFactory;
import kd.bos.web.actions.handler.HandleFactory;
import kd.bos.web.actions.utils.AttachmentUtil;
import kd.bos.web.actions.utils.CtsyActionDispatchServiceHelper;
import kd.bos.web.actions.utils.EncryptDownloadUtil;
import kd.bos.web.actions.utils.FileOperationLog;
import kd.bos.web.actions.utils.FilePathUtil;
import kd.bos.web.actions.utils.FilePremissionUtil;
import kd.bos.web.actions.utils.FileReqLimitUtil;
import kd.bos.web.actions.utils.FileUploadUrlUtil;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.io.IOUtils;

@SdkPublic
public class AttachmentAction {
    private static final String TEMPFILE_DOWNLOAD_DO_CONFIG_KEY = "tempfile/download.do?configKey";
    private static Log log = LogFactory.getLog(AttachmentAction.class);
    private static final String ERROR = "error";
    private static final String FILE_NAME = "fileName";
    private static final String BOS_WEBACTIONS = "bos-webactions";
    private static final String BOS_ATTACHMENT = "bos-attachment";
    private static final String USER_AGENT = "USER-AGENT";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String UTF_8 = "UTF-8";
    private static final String STATUS = "status";
    private static final String DESCRIPTION = "description";
    private static final String SUCCESS = "success";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String ANDORID = "Andorid";
    private static final String ANDROID = "Android";
    private static final String ATTACHMENT_FILENAME = "attachment;filename=\"";
    private static final String STRING = "attachment;filename*=UTF-8''";
    private static final String LOCAL_ID_KEY = "AttachmentAction:uploadFile:localIds:";
    private static final String[] IEBrowserSignals = new String[]{"MSIE", "Trident", "Edge"};
    private static final String KINGDEEYUNPAN = "https://www.yunzhijia.com";
    private static final String IMG_EXT = "bmp,gif,jpg,png,jpeg,dib,emf,jfif,jpe,rle,wmf,tif,pcx,tga,exif,fpx,svg,psd,cdr,pcd,dxf,ufo,eps,ai,raw,webp,avif";
    private static final String PDF_EXT = "pdf";
    private static DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));
    private ErrorCode returnErrorCode = new ErrorCode("return", "do return");

    protected static FileService getFileService() {
        return FileServiceFactory.getAttachmentFileService();
    }

    private static KKFileViewPreviewService getKKFileViewPreviewService() {
        return new KKFileViewPreviewServiceImpl();
    }

    protected static IFilePermissionExtension getFilePermissionExtension() {
        return FilePermissionExtensionFactory.getFilePermissionExtension();
    }

    private String getContentType(String fileName) {
        Optional<String> fileSuffix = this.getFileSuffix(fileName);
        if (!fileSuffix.isPresent()) {
            return PreviewParams.BAD_EXT.getEnumName();
        }
        boolean flag = FileUtil.isExtExist((String)fileSuffix.get());
        if (!(flag = AttachmentKit.isCustomExtExist((boolean)flag, (String)fileSuffix.get()))) {
            return PreviewParams.BAD_EXT.getEnumName();
        }
        Optional<String> fileContentType = FileContentTypeFactory.getFileContentTypeBySuffix(fileSuffix.get());
        return fileContentType.orElse(null);
    }

    private Optional<String> getFileSuffix(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index < 0 || index == fileName.length() - 1) {
            return Optional.empty();
        }
        return Optional.of(fileName.substring(fileName.lastIndexOf(46) + 1));
    }

    public void preview(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            if (CtsyActionDispatchServiceHelper.isCtsyRequest(request)) {
                CtsyActionDispatchServiceHelper.redirectHttpAction(request, response);
                return;
            }
            this.doPreview(request, response);
        }
        catch (KDBizException e) {
            if (e.getErrorCode() == this.returnErrorCode) {
                return;
            }
            throw new KDBizException((Throwable)e, e.getErrorCode(), new Object[0]);
        }
    }

    private void doPreview(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map<String, Object> result;
        this.setOperationContext("bos", "", "", "preview", "preview");
        request.setAttribute("permItem", (Object)"2NJ5VA7D2ONF");
        String path = this.getPathFromRequest(request, response);
        String fileName = this.getFileName(request, response, path);
        String previewType = ParamUtil.getPreviewType();
        Optional<String> fileSuffix = this.getFileSuffix(fileName);
        Map customParameterFromCache = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)new CustomParam());
        boolean spreadJsPreview = Boolean.parseBoolean((String)customParameterFromCache.get("SPREAD_JS_PREVIEW")) && fileSuffix.isPresent() && (fileSuffix.get().equalsIgnoreCase("xls") || fileSuffix.get().equalsIgnoreCase("xlsx"));
        boolean yzjPreView = "1".equals(previewType);
        boolean customPreView = "5".equals(previewType);
        boolean wpsPreView = "21".equals(previewType);
        boolean yozoPreView = "4".equals(previewType);
        boolean wpsPrivatePreview = "22".equals(previewType);
        boolean onlyOfficePreview = "3".equals(previewType);
        String formId = request.getParameter("fId");
        if (onlyOfficePreview) {
            boolean supportPreview = true;
            if (fileSuffix.isPresent()) {
                String fileExt = fileSuffix.get();
                supportPreview = Arrays.asList(SupportPreviewTypeConstant.onlyOfficeSupportPreview).contains(fileExt);
            }
            if (supportPreview) {
                String param = request.getParameter("onlyOfficeData");
                HashMap<String, Object> onlyOfficeResult = new HashMap<String, Object>(2);
                if (StringUtils.isNotBlank((CharSequence)param)) {
                    Map params = (Map)SerializationUtils.fromJsonString((String)param, Map.class);
                    String key = ParamUtil.getOnlyOfficeJwtKey();
                    if (StringUtils.isNotBlank((CharSequence)key)) {
                        String token = AttachmentCommonUtils.generateJWTByMapParameters((Map)params, (String)key, (long)(System.currentTimeMillis() + 86400000L), (boolean)false);
                        onlyOfficeResult.put(STATUS, SUCCESS);
                        onlyOfficeResult.put("token", token);
                        this.dealPreviewResult(response, onlyOfficeResult, previewType);
                        return;
                    }
                }
                onlyOfficeResult.put(STATUS, SUCCESS);
                onlyOfficeResult.put("token", "");
                this.dealPreviewResult(response, onlyOfficeResult, previewType);
                return;
            }
            previewType = "0";
        }
        if (wpsPrivatePreview) {
            Watermark watermarkInfo = AttachmentUtil.getWatermarkForWpsPreview(formId);
            Map<String, Object> wpsPreviewResult = WpsPrivateHandle.createWpsPreViewResult(path, watermarkInfo);
            if (((Boolean)wpsPreviewResult.get("support")).booleanValue()) {
                this.dealPreviewResult(response, wpsPreviewResult, previewType);
                return;
            }
            previewType = "0";
        }
        if (wpsPreView) {
            Watermark watermarkInfo = AttachmentUtil.getWatermarkForWpsPreview(formId);
            Map<String, Object> wpsPreviewResult = ParamUtil.isWpsV3() ? WpsV3Handle.getPreviewResult(path, watermarkInfo) : WpsPreviewHandle.createWpsPreViewResult(path, ParamUtil.getWpsPublicParam((boolean)true), watermarkInfo);
            if (((Boolean)wpsPreviewResult.get("support")).booleanValue()) {
                this.dealPreviewResult(response, wpsPreviewResult, previewType);
                return;
            }
            previewType = "0";
        }
        if (yozoPreView) {
            Map<String, Object> watermarkForYozo = AttachmentUtil.getWatermarkForYozoPreview(formId);
            Map<String, Object> yozoPreviewResult = YozoDocumentHandle.createYozoPreViewResult(fileName, path, watermarkForYozo);
            if (((Boolean)yozoPreviewResult.get("support")).booleanValue()) {
                this.dealPreviewResult(response, yozoPreviewResult, previewType);
                return;
            }
            previewType = "0";
        }
        String isFromCache = request.getParameter("isFromCache");
        String userAgent = request.getHeader(USER_AGENT);
        KKFileViewPreviewService kkFileViewPreviewService = AttachmentAction.getKKFileViewPreviewService();
        if ("6".equals(previewType) && fileSuffix.isPresent() && kkFileViewPreviewService.isSupportFileType(fileSuffix.get())) {
            KKFileViewPreviewArgs previewArgs = new KKFileViewPreviewArgs(fileName, path, userAgent, WaterMarkKit.getWaterMarkMap((String)fileName, (String)formId, (boolean)true));
            result = kkFileViewPreviewService.getPreviewResult(previewArgs);
        } else {
            path = this.tryEncryPath(request, path);
            Optional<InputStream> cacheInputStream = this.createCacheInputStream(request, path);
            result = this.getPreViewResult(path, cacheInputStream, fileName, ParamUtil.getYzjParam(), isFromCache, yzjPreView, customPreView, spreadJsPreview, userAgent);
            boolean isAddWaterMark = WaterMarkKit.dealWaterMark((HttpServletRequest)request, (String)fileName, result, (boolean)true);
            String contentType = this.getContentType(fileName);
            if (contentType != null) {
                this.validateContentType(response, fileName, contentType);
                this.injectReponseCharset(request, response, result, isAddWaterMark, contentType);
                fileName = FileSecurityUtil.getSecurityHeader((String)fileName);
                response.addHeader(CONTENT_DISPOSITION, "inline;filename=\"" + URLEncoder.encode(fileName, UTF_8) + "\"");
            }
        }
        this.dealPreviewResult(response, result, previewType);
    }

    private Map<String, Object> getPreViewResult(String path, Optional<InputStream> cacheInputStream, String fileName, Map<String, String> setting, String isFromCache, boolean yzjPreView, boolean customPreview, boolean spreadJsPreview, String userAgent) {
        Map<String, Object> result;
        if (yzjPreView || customPreview) {
            return this.preViewAboutYJZ(path, cacheInputStream.orElse(null), fileName, setting, isFromCache, userAgent);
        }
        if (spreadJsPreview && (result = this.spreadJsPreview(path, cacheInputStream.orElse(null), isFromCache)).get(PreviewParams.STATUS.getEnumName()).equals(PreviewParams.SPREADJS_SUCCESS.getEnumName())) {
            return result;
        }
        return this.YunPanCovertPreview(path, cacheInputStream.orElse(null), fileName, isFromCache, userAgent);
    }

    private Map<String, Object> spreadJsPreview(String path, InputStream cacheInputStream, String isFromCache) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        InputStream inputStream = Boolean.parseBoolean(isFromCache) ? cacheInputStream : FileServiceFactory.getAttachmentFileService().getInputStream(path);
        try {
            Workbook workbook = new Workbook();
            workbook.open(inputStream);
            String json = workbook.toJson();
            result.put(PreviewParams.STATUS.getEnumName(), PreviewParams.SPREADJS_SUCCESS.getEnumName());
            result.put(PreviewParams.RESULT.getEnumName(), json);
        }
        catch (Exception e) {
            Map resultMsg = ExceptionUtil.setErrorInfo((String)e.getMessage());
            result.put(PreviewParams.STATUS.getEnumName(), PreviewParams.ERROR.getEnumName());
            result.put(PreviewParams.RESULT.getEnumName(), resultMsg);
            log.error("spreadJsPreview fail --- goto yunPanConvert", (Throwable)e);
        }
        return result;
    }

    private String getPathFromRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String path;
        block2: {
            path = "";
            try {
                path = HandleFactory.getHandle(request).handler(request);
            }
            catch (KDException e) {
                if (!AttachExceptionHandler.dealException((KDException)e, (HttpServletResponse)response).booleanValue()) break block2;
                throw new KDBizException((Throwable)e, this.returnErrorCode, new Object[0]);
            }
        }
        this.validatePath(request, response, path);
        return path;
    }

    private void injectReponseCharset(HttpServletRequest request, HttpServletResponse response, Map<String, Object> result, boolean hasWaterMark, String contentType) {
        if ("text/plain".equals(contentType)) {
            this.injectResponseCharsetIfContentTypeIsText(request, response, result, hasWaterMark);
        } else {
            response.setContentType(contentType);
        }
    }

    private void injectResponseCharsetIfContentTypeIsText(HttpServletRequest request, HttpServletResponse response, Map<String, Object> result, boolean hasWaterMark) {
        String charset = (String)result.get(PreviewParams.CHARSET.getEnumName());
        if (StringUtils.isNotEmpty((CharSequence)charset)) {
            switch (charset) {
                case "GBK": {
                    if (this.isIEBrowser(request)) break;
                    charset = PreviewParams.ANSI.getEnumName();
                    break;
                }
                case "UTF-16LE": {
                    charset = PreviewParams.UNICODE.getEnumName();
                    break;
                }
                case "UTF-16BE": {
                    charset = PreviewParams.UNICODE_BIG_ENDIAN.getEnumName();
                    break;
                }
                default: {
                    charset = PreviewParams.UTF_8.getEnumName();
                }
            }
            if (hasWaterMark) {
                response.setContentType("application/pdf;charset=" + charset);
            } else {
                response.setContentType("text/plain;charset=" + charset);
            }
        }
    }

    private void validateContentType(HttpServletResponse response, String fileName, String contentType) throws IOException {
        if ("false".equals(contentType)) {
            Map result = ExceptionUtil.setErrorInfo((String)ResManager.loadKDString((String)"\u6587\u4ef6\u540e\u7f00\u540d\u4e0d\u5b58\u5728", (String)"AttachmentAction_2", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
            this.dealResult(response, result);
            throw new KDBizException(this.returnErrorCode, new Object[0]);
        }
        if ("badExt".equals(contentType)) {
            Map result = ExceptionUtil.setErrorInfo((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u7c7b\u578b\u4e0d\u652f\u6301\u9884\u89c8\uff1a%s", (String)"AttachmentAction_3", (String)BOS_ATTACHMENT, (Object[])new Object[0]), fileName.substring(fileName.lastIndexOf(46))));
            this.dealResult(response, result);
            throw new KDBizException(this.returnErrorCode, new Object[0]);
        }
    }

    private Map<String, Object> preViewAboutYJZ(String path, InputStream cacheInputStream, String fileName, Map<String, String> setting, String isFromCache, String userAgent) {
        log.info("kd.bos.web.actions.AttachmentAction.preViewAboutYJZ --- YzjConfig --- " + setting);
        Map result = Boolean.parseBoolean(isFromCache) ? AttachmentAction.getFileService().previewFromCacheWPS(fileName, path, userAgent, cacheInputStream, setting) : AttachmentAction.getFileService().previewWPS(fileName, path, userAgent, setting);
        return result;
    }

    private Map<String, Object> YunPanCovertPreview(String path, InputStream cacheInputStream, String fileName, String isFromCache, String userAgent) {
        Map result = Boolean.parseBoolean(isFromCache) ? AttachmentAction.getFileService().previewFromCache(fileName, path, userAgent, cacheInputStream) : AttachmentAction.getFileService().preview(fileName, path, userAgent);
        return result;
    }

    private String getFileName(HttpServletRequest request, HttpServletResponse response, String path) throws IOException {
        String isFromCache = request.getParameter("isFromCache");
        String fileName = Boolean.parseBoolean(isFromCache) ? this.getFileNameFromCache(response, path) : this.getFileNameFromPath(path);
        this.validateFileName(response, fileName);
        return fileName;
    }

    private String getFileNameFromCache(HttpServletResponse response, String path) throws IOException {
        Map<String, Object> fileInfoFromCache = this.getFileInfoFromCache(path);
        String errorInfo = (String)fileInfoFromCache.get(ERROR);
        if (StringUtils.isNotBlank((CharSequence)errorInfo)) {
            Map result = ExceptionUtil.setErrorInfo((String)errorInfo);
            this.dealResult(response, result);
            throw new KDBizException(this.returnErrorCode, new Object[0]);
        }
        return (String)fileInfoFromCache.get(FILE_NAME);
    }

    private String getFileNameFromPath(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    private void validateFileName(HttpServletResponse response, String fileName) throws IOException {
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            Map result = ExceptionUtil.setErrorInfo((String)ResManager.loadKDString((String)"\u8bf7\u6c42\u7684path\u4e2d\u672a\u5305\u542b\u6587\u4ef6\u4fe1\u606f,\u6587\u4ef6\u540d\u4e0d\u5b58\u5728", (String)"AttachmentAction_1", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
            this.dealResult(response, result);
            throw new KDBizException(this.returnErrorCode, new Object[0]);
        }
    }

    private boolean checkDownloadUrl(HttpServletResponse response, String downloadUrl) throws IOException {
        if (StringUtils.isBlank((CharSequence)downloadUrl) || !this.getCheckuploadurl()) {
            return true;
        }
        String yzjUrl = this.getYZJUrl();
        if (StringUtils.isBlank((CharSequence)yzjUrl)) {
            return true;
        }
        if (downloadUrl.startsWith(yzjUrl)) {
            return true;
        }
        if (downloadUrl.startsWith(KINGDEEYUNPAN)) {
            return true;
        }
        String errorMsg = ResManager.loadKDString((String)"\u9644\u4ef6\u4e0a\u4f20\u57df\u540d\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u7cfb\u7edf\u4e0d\u5141\u8bb8\u4e0a\u4f20\u3002", (String)"AttachmentAction_6", (String)BOS_ATTACHMENT, (Object[])new Object[0]);
        AttachmentAction.writeErrorMessage(response, errorMsg);
        return false;
    }

    private String tryEncryPath(HttpServletRequest request, String path) {
        String isFromCache = request.getParameter("isFromCache");
        if (Boolean.parseBoolean(isFromCache)) {
            path = EncreptSessionUtils.encryptSession((String)path);
        }
        return path;
    }

    private Optional<InputStream> createCacheInputStream(HttpServletRequest request, String path) throws IOException {
        Map<String, Object> fileInfoFromCache;
        String errorInfo;
        String isFromCache = request.getParameter("isFromCache");
        if (Boolean.parseBoolean(isFromCache) && StringUtils.isBlank((CharSequence)(errorInfo = (String)(fileInfoFromCache = this.getFileInfoFromCache(path)).get(ERROR)))) {
            return Optional.of((InputStream)fileInfoFromCache.get("in"));
        }
        return Optional.empty();
    }

    private void validatePath(HttpServletRequest request, HttpServletResponse response, String path) throws IOException {
        if (kd.bos.util.StringUtils.isBlank((String)path)) {
            Map result = ExceptionUtil.setErrorInfo((String)ResManager.loadKDString((String)"path\u4e3a\u7a7a,\u4e0d\u5b58\u5728", (String)"AttachmentAction_0", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
            this.dealResult(response, result);
            throw new KDBizException(this.returnErrorCode, new Object[0]);
        }
    }

    public void removeExcelPreview(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        String id = request.getParameter("id");
        if (StringUtils.isEmpty((CharSequence)id)) {
            result.put(STATUS, ERROR);
            result.put(DESCRIPTION, "the param(id) can not be null!");
        } else {
            try {
                AttachmentAction.getFileService().removePreview(id);
                result.put(STATUS, SUCCESS);
            }
            catch (Exception e) {
                result.put(STATUS, ERROR);
                result.put(DESCRIPTION, ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
        String jsonResult = SerializationUtils.toJsonString(result);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)jsonResult);
    }

    private String getPathfromDownloadUrl(String url) throws IOException {
        String path = StringUtils.substringAfter((String)url, (String)"path=");
        path = URLDecoder.decode(path, UTF_8);
        return FilePathUtil.dealPath((String)path, (String)"attach");
    }

    private String getPathfromTempDownloadUrl(String url) throws IOException {
        String path = TEMPFILE_DOWNLOAD_DO_CONFIG_KEY + StringUtils.substringAfter((String)url, (String)TEMPFILE_DOWNLOAD_DO_CONFIG_KEY);
        return FilePathUtil.dealPath((String)path, (String)"attach");
    }

    public void download(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Boolean sucess = Boolean.FALSE;
        String fileName = "";
        try {
            if (CtsyActionDispatchServiceHelper.isCtsyRequest(request)) {
                CtsyActionDispatchServiceHelper.redirectHttpAction(request, response);
                return;
            }
            fileName = request.getParameter(FILE_NAME);
            request.setAttribute("permItem", (Object)"2NJ5XVVCMBCL");
            String path = HandleFactory.getHandle(request).handler(request);
            if (StringUtils.isBlank((CharSequence)fileName) && path != null) {
                fileName = path.substring(path.lastIndexOf(47) + 1);
            }
            if (FileReqLimitUtil.checkLimitReq("download", 0)) {
                AttachmentAction.writeErrorMessage(request, response, AttachmentUtil.getUploadOrDownloadLimitTips("downloadlimit"));
                return;
            }
            String type = request.getParameter("type");
            String id = request.getParameter("id");
            if (StringUtils.isBlank((CharSequence)path) && StringUtils.isNotBlank((CharSequence)type) && StringUtils.isNotBlank((CharSequence)id)) {
                this.downloadFormAtt(id, type, request, response);
                return;
            }
            if (StringUtils.isBlank((CharSequence)path)) {
                AttachmentAction.writeErrorMessage(request, response, ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff1a\u7f3a\u5c11path\u53c2\u6570\u3002", (String)"AttachmentAction_17", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
                return;
            }
            if (!AttachmentAction.getFileService().exists(path)) {
                if (AttachmentUtil.isFrom3rdPreviewOrEdit(request)) {
                    response.setStatus(500);
                }
                ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)ResManager.loadKDString((String)"\u9644\u4ef6\u4e0d\u5b58\u5728\uff01", (String)"AttachmentAction_13", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
                return;
            }
            FilePermissionParam filePermissionParam = new FilePermissionParam(request.getParameter("fId"), request.getParameter("appId"), path, FileTypeEnum.ATTACHMENT, request);
            PermissionResult permissionResult = AttachmentAction.getFilePermissionExtension().checkPermission(filePermissionParam);
            if (!permissionResult.getHasPermission().booleanValue()) {
                AttachmentAction.writeErrorMessage(request, response, permissionResult.getMsg());
                return;
            }
            String userAgent = request.getHeader(USER_AGENT);
            response.setCharacterEncoding(UTF_8);
            response.setContentType(APPLICATION_OCTET_STREAM);
            fileName = FileActionExtensionFactory.getFileActionExtension().getFileName(path, fileName);
            fileName = FileSecurityUtil.getSecurityHeader((String)fileName);
            String encryptPassword = request.getParameter("password");
            if (StringUtils.isNotBlank((CharSequence)encryptPassword)) {
                EncryptDownloadUtil.encryptDownLoad(request, response, path, fileName, encryptPassword, null);
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)userAgent) && (userAgent.contains(ANDORID) || userAgent.contains(ANDROID))) {
                response.addHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + URLEncoder.encode(fileName, UTF_8).replaceAll("\\+", "%20") + "\"");
            } else if (this.checkIsWpsEdit(request)) {
                response.addHeader(CONTENT_DISPOSITION, "attachment;filename=" + URLEncoder.encode(fileName, UTF_8).replaceAll("\\+", "%20"));
            } else {
                response.addHeader(CONTENT_DISPOSITION, STRING + URLEncoder.encode(fileName, UTF_8).replaceAll("\\+", "%20"));
            }
            String rangeString = request.getHeader("Range");
            if (rangeString != null && fileName.endsWith("mp4")) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                AttachmentAction.getFileService().download(path, (OutputStream)stream, userAgent);
                this.breakpointContinuation(request, response, stream);
                sucess = Boolean.TRUE;
                return;
            }
            this.doDownload(fileName, path, request, response, userAgent);
            sucess = Boolean.TRUE;
        }
        catch (KDException e) {
            log.error((Throwable)e);
            if (AttachmentUtil.isFrom3rdPreviewOrEdit(request)) {
                response.setStatus(500);
            }
            if (AttachExceptionHandler.dealException((KDException)e, (HttpServletResponse)response).booleanValue()) {
                return;
            }
            HashMap<String, String> result = new HashMap<String, String>();
            result.put(STATUS, ERROR);
            String jsonResult = SerializationUtils.toJsonString(result);
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)jsonResult);
            return;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            this.doFileDownloadLog(sucess, request, fileName);
        }
    }

    private void doDownload(String fileName, String path, HttpServletRequest request, HttpServletResponse response, String userAgent) throws IOException {
        boolean isFromYunPan = StringUtils.equals((CharSequence)request.getParameter("source"), (CharSequence)"preview");
        userAgent = isFromYunPan ? request.getParameter("source") : userAgent;
        boolean fromOnlyOffice = AttachmentPreviewUtil.fromOnlyOfficeDownLoad((HttpServletRequest)request);
        boolean isAddDownloadWaterMark = WaterMarkKit.isAddDownloadWaterMark((String)fileName, (HttpServletRequest)request, (boolean)fromOnlyOffice);
        if (!isAddDownloadWaterMark || isFromYunPan) {
            this.tryAddContentLengthHeader(path, response);
            AttachmentAction.getFileService().download(path, response, userAgent);
            return;
        }
        this.doWatermark(path, userAgent, request, fileName, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWatermark(String path, String userAgent, HttpServletRequest request, String fileName, HttpServletResponse response) throws IOException {
        block6: {
            FileOutputStream fileOutputStream = null;
            ServletOutputStream out = null;
            try {
                int len;
                String tempFilePath = FileUtils.checkFileUrl((String)(IWatermarkHandler.TEMP_DIR + "tempFile" + UUID.randomUUID().toString().replace("-", "")));
                FileTimeoutUtil.removeFile((String)tempFilePath, null, (long)120000L);
                fileOutputStream = new FileOutputStream(tempFilePath);
                AttachmentAction.getFileService().download(path, (OutputStream)fileOutputStream, userAgent);
                FileInputStream tempInputStream = new FileInputStream(tempFilePath);
                InputStream waterMarked = WaterMarkKit.addWaterMark((HttpServletRequest)request, (String)fileName, (InputStream)tempInputStream);
                response.addHeader(CONTENT_LENGTH, String.valueOf(waterMarked.available()));
                out = response.getOutputStream();
                byte[] buffer = new byte[8192];
                while ((len = waterMarked.read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
                out.flush();
                FileSecurityUtil.safeClose((Closeable)fileOutputStream);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                break block6;
            }
            finally {
                FileSecurityUtil.safeClose(fileOutputStream);
                FileSecurityUtil.safeClose(out);
            }
            FileSecurityUtil.safeClose((Closeable)out);
        }
    }

    private void tryAddContentLengthHeader(String path, HttpServletResponse response) {
        try {
            long fileSize = AttachmentAction.getFileService().getFileSize(path);
            if (fileSize > 0L) {
                response.addHeader(CONTENT_LENGTH, fileSize + "");
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private void doFileDownloadLog(Boolean sucess, HttpServletRequest request, String fileName) {
        Object path = request.getAttribute("path");
        if (StringUtils.isBlank((CharSequence)fileName) && path instanceof String && StringUtils.isNotBlank((Object)path)) {
            fileName = (String)path;
            fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
        }
        String entityNum = request.getParameter("fId");
        if (sucess.booleanValue()) {
            FileOperationLog.getInstance().createAttachLog(request, fileName);
            return;
        }
        FileOperationLog.getInstance().createAppLog(entityNum, FileOperationLog.FileOperationEnum.DOWNLOAD_FAIL.getOpNameBridge(), FileOperationLog.FileOperationEnum.DOWNLOAD_FAIL.getOpDescFormatBridge(), fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void breakpointContinuation(HttpServletRequest servletRequest, HttpServletResponse servletResponse, ByteArrayOutputStream outstream) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(outstream.toByteArray());
        long fileLength = ((InputStream)in).available();
        long start = 0L;
        long end = fileLength - 1L;
        long contentLength = 0L;
        String requestRange = "";
        String contentRange = "bytes ";
        BufferedInputStream bis = new BufferedInputStream(in);
        servletResponse.setHeader("Accept-Ranges", "bytes");
        String range = servletRequest.getHeader("Range");
        if (StringUtils.isNotBlank((CharSequence)range)) {
            servletResponse.setStatus(206);
            requestRange = range.replaceAll("bytes=", "");
            String[] split = requestRange.split("-");
            if (split.length == 1) {
                start = Long.parseLong(split[0].trim());
            } else if (split.length > 1) {
                start = Long.parseLong(split[0].trim());
                long requestEnd = Long.parseLong(split[1].trim());
                end = Math.min(end, requestEnd);
            }
            contentLength = end - start + 1L;
        }
        if (contentLength < 0L) {
            throw new KDException(new ErrorCode("parameter is illegal", ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u5408\u6cd5\uff01", (String)"AttachmentAction_12", (String)BOS_WEBACTIONS, (Object[])new Object[0])), new Object[0]);
        }
        contentRange = new StringBuffer(contentRange).append(start).append("-").append(end).append("/").append(fileLength).toString();
        servletResponse.setHeader(CONTENT_LENGTH, String.valueOf(contentLength));
        servletResponse.setHeader("Content-Range", contentRange);
        servletResponse.setHeader("Content-Type", "video/mp4");
        bis.skip(start);
        BufferedOutputStream bos = new BufferedOutputStream((OutputStream)servletResponse.getOutputStream());
        try {
            byte[] bytes = new byte[8192];
            if (!range.endsWith("-")) {
                long sumReadLen;
                int len;
                for (sumReadLen = 0L; sumReadLen <= contentLength - (long)bytes.length; sumReadLen += (long)len) {
                    len = bis.read(bytes);
                    ((OutputStream)bos).write(bytes, 0, len);
                }
                if (sumReadLen <= contentLength) {
                    int len2 = bis.read(bytes, 0, (int)(contentLength - sumReadLen));
                    ((OutputStream)bos).write(bytes, 0, len2);
                }
            } else {
                int len;
                while ((len = bis.read(bytes)) != -1) {
                    ((OutputStream)bos).write(bytes, 0, len);
                }
            }
            ((OutputStream)bos).flush();
        }
        catch (Exception e) {
            try {
                IOUtils.close((Closeable[])new Closeable[]{outstream, in, bos, bis});
            }
            catch (Throwable throwable) {
                IOUtils.close((Closeable[])new Closeable[]{outstream, in, bos, bis});
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{outstream, in, bos, bis});
        }
        IOUtils.close((Closeable[])new Closeable[]{outstream, in, bos, bis});
    }

    private void downloadFormAtt(String id, String type, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map map = (Map)DispatchServiceHelper.invokeBOSService((String)IAttachmentService.class.getSimpleName(), (String)"getAttachmentInfoById", (Object[])new Object[]{AttachmentType.getTypeByValue((String)type), id});
        String path = map.get("path").toString();
        if (!AttachmentAction.getFileService().exists(path)) {
            if (AttachmentUtil.isFrom3rdPreviewOrEdit(request)) {
                response.setStatus(500);
            }
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)ResManager.loadKDString((String)"\u9644\u4ef6\u4e0d\u5b58\u5728\uff01", (String)"AttachmentAction_13", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
            return;
        }
        String fileName = map.get(FILE_NAME).toString();
        String userAgent = request.getHeader(USER_AGENT);
        response.setCharacterEncoding(UTF_8);
        response.setContentType(APPLICATION_OCTET_STREAM);
        fileName = FileSecurityUtil.getSecurityHeader((String)fileName);
        if (StringUtils.isNotBlank((CharSequence)userAgent) && (userAgent.contains(ANDORID) || userAgent.contains(ANDROID))) {
            response.addHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + URLEncoder.encode(fileName, UTF_8).replaceAll("\\+", "%20") + "\"");
        } else {
            response.addHeader(CONTENT_DISPOSITION, STRING + URLEncoder.encode(fileName, UTF_8).replaceAll("\\+", "%20"));
        }
        AttachmentAction.getFileService().download(path, response, userAgent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadAll(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block38: {
            try {
                if (CtsyActionDispatchServiceHelper.isCtsyRequest(request)) {
                    CtsyActionDispatchServiceHelper.redirectHttpAction(request, response);
                    return;
                }
            }
            catch (Exception e) {
                log.error("downloadAll ctsy dispatch failed", (Throwable)e);
            }
            if (FileReqLimitUtil.checkLimitReq("download", 0)) {
                AttachmentAction.writeErrorMessage(response, AttachmentUtil.getUploadOrDownloadLimitTips("downloadlimit"));
                return;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String fId = request.getParameter("fId");
            String pageId = request.getParameter("pageId");
            Object billPkId = FilePremissionUtil.genBillPkId((String)pageId);
            String date = dateFormat.format(new Date());
            String fileName = this.getDoloadAllZipFileName(fId, date);
            boolean hasRight = FilePremissionUtil.tryGetHasRightValue((HttpServletRequest)request);
            if (!hasRight) {
                Boolean hasPermission;
                block36: {
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("permItem", "2NJ5XVVCMBCL");
                    param.put("entityNum", fId);
                    param.put("billPkId", billPkId);
                    ArrayList<HashMap<String, Object>> refEntityList = new ArrayList<HashMap<String, Object>>();
                    refEntityList.add(param);
                    hasPermission = Boolean.TRUE;
                    try {
                        hasPermission = FilePremissionUtil.hasEntityPermission(refEntityList);
                    }
                    catch (KDException e) {
                        if (!AttachExceptionHandler.dealException((KDException)e, (HttpServletResponse)response).booleanValue()) break block36;
                        return;
                    }
                }
                if (!hasPermission.booleanValue()) {
                    AttachmentAction.writeErrorMessage(response, FilePremissionUtil.genNoPermissionTips((String)fId, (String)"2NJ5XVVCMBCL"));
                    return;
                }
            }
            List fileInfoList = (List)SerializationUtils.fromJsonString((String)request.getParameter("fileInfo"), ArrayList.class);
            ArrayList<BatchDownloadRequest.File> fileList = new ArrayList<BatchDownloadRequest.File>(fileInfoList.size());
            HashMap<String, String> urlMap = new HashMap<String, String>();
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            for (Map fileMap : fileInfoList) {
                String path;
                block37: {
                    String url = (String)fileMap.get("url");
                    path = "";
                    try {
                        if (this.isTempFile(url)) {
                            if (!cache.exists(url)) continue;
                            path = this.getPathfromTempDownloadUrl(url);
                        } else {
                            path = this.getPathfromDownloadUrl(url);
                        }
                    }
                    catch (KDException e) {
                        log.error((Throwable)e);
                        if (!AttachExceptionHandler.dealException((KDException)e, (HttpServletResponse)response).booleanValue()) break block37;
                        return;
                    }
                }
                if (this.verifyFilePermissions(request, path)) continue;
                String newSingleFileName = (String)fileMap.get("name");
                String speSymbol = AttachmentAction.checkSpeSymbol(newSingleFileName, response);
                if (StringUtils.isNotBlank((CharSequence)speSymbol)) {
                    AttachmentAction.writeErrorMessage(response, String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u540d\u4e0d\u80fd\u5305\u542b\u4e0b\u5217\u4efb\u4f55\u5b57\u7b26\uff1a%s\u3002", (String)"AttachmentAction_15", (String)BOS_WEBACTIONS, (Object[])new Object[0]), speSymbol));
                    return;
                }
                String subFile = path.substring(path.lastIndexOf(47) + 1);
                if (StringUtils.isNotBlank((CharSequence)newSingleFileName)) {
                    subFile = newSingleFileName;
                }
                subFile = FileActionExtensionFactory.getFileActionExtension().getFileName(path, subFile);
                BatchDownloadRequest.File file = new BatchDownloadRequest.File(subFile, path);
                fileList.add(file);
                urlMap.put(path, subFile);
            }
            if (urlMap.isEmpty()) {
                AttachmentAction.writeErrorMessage(response, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u4e0b\u8f7d\u5df2\u8fc7\u671f\u7684\u4e34\u65f6\u6587\u4ef6\u3002", (String)"AttachmentAction_16", (String)BOS_ATTACHMENT, (Object[])new Object[0]));
                return;
            }
            this.renameForDuplicateName(urlMap);
            BatchDownloadRequest.File[] files = fileList.toArray(new BatchDownloadRequest.File[fileList.size()]);
            String userAgent = request.getHeader(USER_AGENT);
            fileName = FileActionExtensionFactory.getFileActionExtension().getFileName(fileName);
            BatchDownloadRequest batchDownloadRequest = new BatchDownloadRequest(fileName);
            batchDownloadRequest.setFiles(files);
            response.setCharacterEncoding(UTF_8);
            response.setContentType(APPLICATION_OCTET_STREAM);
            fileName = FileSecurityUtil.getSecurityHeader((String)fileName);
            File saveDir = null;
            InputStream in = null;
            InputStream zipInputStream = null;
            ServletOutputStream out = null;
            String zipForLocalUrl = null;
            try {
                int len;
                saveDir = FileHandlerUtil.createSaveDir((String)"download_all");
                long freeSpace = saveDir.getFreeSpace();
                if (freeSpace < AttachmentServiceHelper.getDownloadNeedFreeSpace()) {
                    log.error("[\u9644\u4ef6\u5168\u90e8\u4e0b\u8f7d\uff1a\u78c1\u76d8\u7a7a\u95f4\u4e0d\u8db3\uff1a]\u5927\u5c0f\u4e3a" + freeSpace);
                    AttachmentAction.writeErrorMessage(response, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5bb9\u5668\u78c1\u76d8\u7a7a\u95f4\u4e0d\u8db3\uff0c\u8bf7\u6e05\u7406\u78c1\u76d8\u540e\u518d\u8bd5\u3002", (String)"AttachUploadLimitPlugin_14", (String)BOS_ATTACHMENT, (Object[])new Object[0]), new Object[0]));
                    return;
                }
                if (StringUtils.isNotBlank((CharSequence)userAgent) && (userAgent.contains(ANDORID) || userAgent.contains(ANDROID))) {
                    response.addHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + URLEncoder.encode(fileName, UTF_8).replaceAll("\\+", "%20") + "\"");
                } else {
                    response.addHeader(CONTENT_DISPOSITION, STRING + URLEncoder.encode(fileName, UTF_8).replaceAll("\\+", "%20"));
                }
                for (Map.Entry entry : urlMap.entrySet()) {
                    String name = (String)entry.getValue();
                    String url = (String)entry.getKey();
                    in = this.isTempFile(url) ? cache.getInputStream(url) : AttachmentAction.getFileService().getInputStream(url);
                    boolean isAddDownloadWaterMark = WaterMarkKit.isAddDownloadWaterMark((String)name, (HttpServletRequest)request);
                    if (isAddDownloadWaterMark) {
                        in = WaterMarkKit.addWaterMark((HttpServletRequest)request, (String)name, (InputStream)in);
                    }
                    FileHandlerUtil.flushToLocal((String)name, (String)"", (InputStream)in, (File)saveDir, (boolean)false);
                }
                String password = request.getParameter("password");
                zipForLocalUrl = StringUtils.isNotEmpty((CharSequence)password) ? EncryptDownloadUtil.createZipForEncrypt(fileName, saveDir, password, true) : FileHandlerUtil.createZipForLocal((String)fileName, (String)"", (File)saveDir, (boolean)false);
                zipInputStream = Files.newInputStream(Paths.get(zipForLocalUrl, new String[0]), new OpenOption[0]);
                HashMap params = new HashMap();
                Map ret = FileServiceFactory.getAttachmentFileService().getFileServiceExt().beforeWrite(zipForLocalUrl, zipInputStream, userAgent, params);
                zipInputStream = (InputStream)ret.get("returnInputStream");
                if (FileServiceTenantConfig.DOWNLOAD_FILE_SIZE_DEF_ENABLE.getBooleanTenant()) {
                    response.setHeader(CONTENT_LENGTH, String.valueOf(zipInputStream.available()));
                }
                if (ret.get("fileSize") != null) {
                    response.setHeader(CONTENT_LENGTH, (String)ret.get("fileSize"));
                }
                out = response.getOutputStream();
                byte[] buffer = new byte[8192];
                while ((len = zipInputStream.read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
                out.flush();
                FileSecurityUtil.safeClose((Closeable)out);
            }
            catch (IOException e) {
                log.error("[\u9644\u4ef6\u5168\u90e8\u4e0b\u8f7d\u5f02\u5e38\uff1a]" + e);
                break block38;
            }
            finally {
                FileSecurityUtil.safeClose(out);
                FileSecurityUtil.safeClose(in);
                FileSecurityUtil.safeClose(zipInputStream);
                if (saveDir != null) {
                    for (File dirFile : saveDir.listFiles()) {
                        FileSecurityUtil.safeDeleteFile((File)dirFile);
                    }
                }
                FileSecurityUtil.safeDeleteFile((File)saveDir);
                if (zipForLocalUrl != null) {
                    FileSecurityUtil.safeDeleteFile((File)new File(zipForLocalUrl));
                }
            }
            FileSecurityUtil.safeClose((Closeable)in);
            FileSecurityUtil.safeClose((Closeable)zipInputStream);
            if (saveDir != null) {
                for (File dirFile : saveDir.listFiles()) {
                    FileSecurityUtil.safeDeleteFile((File)dirFile);
                }
            }
            FileSecurityUtil.safeDeleteFile((File)saveDir);
            if (zipForLocalUrl != null) {
                FileSecurityUtil.safeDeleteFile((File)new File(zipForLocalUrl));
            }
        }
    }

    private void renameForDuplicateName(Map<String, String> urlMap) {
        HashMap<String, Integer> fileNameIndex = new HashMap<String, Integer>(urlMap.size());
        HashSet<String> fileNameList = new HashSet<String>(urlMap.size());
        for (Map.Entry<String, String> entry : urlMap.entrySet()) {
            String name;
            String uniqueName = name = entry.getValue();
            boolean flag = false;
            while (fileNameList.contains(uniqueName) || flag) {
                StringBuilder sb = new StringBuilder(name);
                Integer index = fileNameIndex.getOrDefault(name, 0) + 1;
                uniqueName = name.contains(".") ? sb.insert(name.lastIndexOf("."), "(" + index + ")").toString() : sb.append("(").append(index).append(")").toString();
                fileNameIndex.put(name, index);
                flag = urlMap.containsValue(uniqueName);
            }
            fileNameList.add(uniqueName);
            entry.setValue(uniqueName);
        }
    }

    private boolean isTempFile(String url) {
        return url.contains(TEMPFILE_DOWNLOAD_DO_CONFIG_KEY);
    }

    private boolean verifyFilePermissions(HttpServletRequest request, String path) {
        FilePermissionParam filePermissionParam = new FilePermissionParam(request.getParameter("fId"), request.getParameter("appId"), path, FileTypeEnum.ATTACHMENT, request);
        PermissionResult permissionResult = AttachmentAction.getFilePermissionExtension().checkPermission(filePermissionParam);
        return permissionResult.getHasPermission() == false;
    }

    private String getDoloadAllZipFileName(String fId, String date) {
        String fileName = String.format(ResManager.loadKDString((String)"\u5168\u90e8\u9644\u4ef6_%s.zip", (String)"AttachmentAction_4", (String)BOS_ATTACHMENT, (Object[])new Object[0]), date);
        if (StringUtils.isBlank((CharSequence)fId)) {
            return fileName;
        }
        fileName = fId + "_" + date + ".zip";
        LocaleString displayName = null;
        FormConfig formConfig = null;
        try {
            formConfig = FormMetadataCache.getFormConfig((String)fId);
            if (formConfig != null) {
                displayName = formConfig.getCaption();
                fileName = displayName.toString() + "_" + date + ".zip";
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return fileName;
    }

    public void upload(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            if (CtsyActionDispatchServiceHelper.isCtsyRequest(request)) {
                CtsyActionDispatchServiceHelper.redirectHttpAction(request, response);
                return;
            }
        }
        catch (Exception e) {
            log.error("upload ctsy dispatch failed", (Throwable)e);
        }
        boolean isTempStorage = Boolean.parseBoolean(request.getParameter("tempstorage"));
        if (isTempStorage) {
            this.uploadFile(request, response);
        } else {
            FileItem fileItem = FileItemParser.parseHttpRequest((HttpServletRequest)request);
            if (!FileUploadUrlUtil.isFileUploadWithUrl()) {
                fileItem.setPath(FileUploadUrlUtil.getAttachmentRandomUrl(fileItem.getFileName()));
            }
            this.upload0(fileItem, request, response, FileSource.UPLOAD_BUTTON);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void uploadFile(HttpServletRequest request, HttpServletResponse response) {
        Iterator iterator;
        boolean onlyOfficePreview;
        ArrayList<FilePermissionParam> permissionParamList;
        ArrayList<FileRecord> recordList;
        ArrayList<Map<String, Object>> listMaps;
        int timeout;
        String contentType;
        block93: {
            try {
                if (CtsyActionDispatchServiceHelper.isCtsyRequest(request)) {
                    CtsyActionDispatchServiceHelper.redirectHttpAction(request, response);
                    return;
                }
                contentType = request.getContentType();
                timeout = 7200;
                String type = request.getParameter("type");
                if ("mobile".equals(type)) {
                    if (!FilePremissionUtil.checkUploadPermission((HttpServletRequest)request, (HttpServletResponse)response, (String)request.getParameter("appId"), (String)request.getParameter("fId"), (String)"2NJ5SR4NUEJ=").booleanValue()) {
                        return;
                    }
                    listMaps = new ArrayList<Map<String, Object>>();
                    recordList = new ArrayList<FileRecord>(10);
                    permissionParamList = new ArrayList<FilePermissionParam>(10);
                    String files = request.getParameter("files");
                    JSONArray jsonArray = JSON.parseArray((String)files);
                    log.info("kd.bos.web.actions.AttachmentAction.uploadFile mobile ---- files" + files);
                    onlyOfficePreview = AttachmentPreviewUtil.isOnlyOfficePreView();
                    iterator = jsonArray.iterator();
                    break block93;
                }
                try (FileItem fileItem = FileItemParser.parseHttpRequest((HttpServletRequest)request);){
                    String address;
                    InputStream inputStream = fileItem.getInputStream();
                    BufferedInputStream buffInputStream = new BufferedInputStream(inputStream);
                    log.info("uploadFile InputStream.available() " + buffInputStream.available());
                    String fileName = fileItem.getFileName();
                    log.info("kd.bos.web.actions.AttachmentAction.uploadFile fileName ---- " + fileName);
                    if (!FilePremissionUtil.checkUploadPermission((HttpServletRequest)request, (HttpServletResponse)response, (String)fileItem.getAppId(), (String)fileItem.getFId(), (String)"2NJ5SR4NUEJ=", (FileItem)fileItem).booleanValue()) {
                        return;
                    }
                    String speSymbol = null;
                    if (!this.isWebOffice(contentType) && !AttachmentAction.fileExtCheck(fileName, response)) {
                        return;
                    }
                    if (!this.isWebOffice(contentType)) {
                        speSymbol = AttachmentAction.checkSpeSymbol(fileName, response);
                    }
                    if (StringUtils.isNotBlank(speSymbol)) {
                        AttachmentAction.writeErrorMessage(response, String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u540d\u4e0d\u80fd\u5305\u542b\u4e0b\u5217\u4efb\u4f55\u5b57\u7b26\uff1a%s\u3002", (String)"AttachmentAction_15", (String)BOS_WEBACTIONS, (Object[])new Object[0]), speSymbol));
                        return;
                    }
                    if (this.isForbidUpload(request, response, fileName, buffInputStream)) {
                        return;
                    }
                    if (!this.checkMaxSize(response, buffInputStream.available())) {
                        return;
                    }
                    if (FileReqLimitUtil.checkLimitReq("uploadFile", buffInputStream.available())) {
                        AttachmentAction.writeErrorMessage(response, AttachmentUtil.getUploadOrDownloadLimitTips("uploadlimit"));
                        return;
                    }
                    TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                    InputStream finalInputStream = FileChecker.addSecurityWaterMark(fileName, buffInputStream);
                    Map<String, String> resultMap = this.save2TempUrl(timeout, fileName, finalInputStream.available(), cache, finalInputStream);
                    String tempUrl = resultMap.get("tempUrl");
                    if ("mobilelocal".equals(type) || "mobilelocal".equals(fileItem.getType()) || AttachmentPreviewUtil.isOnlyOfficePreView()) {
                        tempUrl = EncreptSessionUtils.encryptSession((String)tempUrl);
                    }
                    if (!(address = RequestContext.get().getClientFullContextPath()).endsWith("/")) {
                        address = address + "/";
                    }
                    String fullUrl = address + tempUrl;
                    FileRecord fileRecord = new FileRecord();
                    fileRecord.setUrl(tempUrl);
                    fileRecord.setType("1");
                    fileRecord.setUserId(Long.valueOf(RequestContext.get().getCurrUserId()));
                    fileRecord.setCreateTime(new Date());
                    FileRecordUtil.doLog(Collections.singletonList(fileRecord));
                    FilePermissionParam filePermissionParam = new FilePermissionParam(fileItem.getFId(), fileItem.getAppId(), fullUrl, FileTypeEnum.TEMPFILE, request);
                    AttachmentAction.getFilePermissionExtension().dealPermissionParam(Collections.singletonList(filePermissionParam));
                    this.writeTempUrl(response, fullUrl, fileItem.getFId(), tempUrl, Integer.parseInt(resultMap.get("size")));
                    return;
                }
            }
            catch (Exception e) {
                try {
                    log.error((Throwable)e);
                    if (e instanceof KDException && AttachExceptionHandler.dealException((KDException)((KDException)((Object)e)), (HttpServletResponse)response).booleanValue()) {
                        return;
                    }
                    HashMap<String, String> result = new HashMap<String, String>();
                    result.put(STATUS, ERROR);
                    String msg = ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"AttachmentAction_32", (String)BOS_ATTACHMENT, (Object[])new Object[0]);
                    result.put(DESCRIPTION, msg);
                    String jsonResult = SerializationUtils.toJsonString(result);
                    ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)jsonResult);
                    return;
                }
                catch (IOException e1) {
                    log.error((Throwable)e1);
                }
            }
            return;
        }
        while (true) {
            if (!iterator.hasNext()) {
                FileRecordUtil.doLog(recordList);
                AttachmentAction.getFilePermissionExtension().dealPermissionParam(permissionParamList);
                this.writeTempUrls(response, listMaps);
                return;
            }
            Object object = iterator.next();
            JSONObject jsonObject = (JSONObject)object;
            String downloadUrl = (String)jsonObject.get((Object)"downloadUrl");
            log.info("kd.bos.web.actions.AttachmentAction.uploadFile mobile ---- downloadUrl " + downloadUrl);
            String tempFileId = "";
            String fileName = (String)jsonObject.get((Object)FILE_NAME);
            String urlLower = downloadUrl.toLowerCase(Locale.ENGLISH);
            if (!urlLower.startsWith("https") && urlLower.startsWith("http")) {
                String right = downloadUrl.substring(4);
                downloadUrl = "https" + right;
            }
            if (!this.checkDownloadUrl(response, downloadUrl)) {
                return;
            }
            InputStream in = AttachmentKit.getInputStreamByUrl((String)downloadUrl, (boolean)false);
            Throwable throwable = null;
            try {
                BufferedInputStream buffInputStream = new BufferedInputStream(in);
                Throwable throwable2 = null;
                try {
                    Object localId;
                    InputStream finalInputStream;
                    Map<String, String> resultMap;
                    String tempUrl;
                    String[] split;
                    log.info("uploadFile InputStream.available() " + buffInputStream.available());
                    String speSymbol = null;
                    if (!this.isWebOffice(contentType) && !AttachmentAction.fileExtCheck(fileName, response)) {
                        return;
                    }
                    if (!this.isWebOffice(contentType)) {
                        speSymbol = AttachmentAction.checkSpeSymbol(fileName, response);
                    }
                    if (StringUtils.isNotBlank(speSymbol)) {
                        AttachmentAction.writeErrorMessage(response, String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u540d\u4e0d\u80fd\u5305\u542b\u4e0b\u5217\u4efb\u4f55\u5b57\u7b26\uff1a%s\u3002", (String)"AttachmentAction_15", (String)BOS_WEBACTIONS, (Object[])new Object[0]), speSymbol));
                        return;
                    }
                    if (this.isForbidUpload(request, response, fileName, buffInputStream)) {
                        return;
                    }
                    int fileSize = new URL(downloadUrl).openConnection().getContentLength();
                    if (!this.checkMaxSize(response, fileSize)) {
                        return;
                    }
                    if (FileReqLimitUtil.checkLimitReq("uploadFile", buffInputStream.available())) {
                        AttachmentAction.writeErrorMessage(response, AttachmentUtil.getUploadOrDownloadLimitTips("uploadlimit"));
                        return;
                    }
                    TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                    log.info("before cache.saveAsUrl InputStream.available() " + buffInputStream.available());
                    if (fileName.toLowerCase(Locale.ENGLISH).startsWith("timeouttest")) {
                        String tempTime = fileName.replace("timeouttest", "");
                        timeout = Integer.parseInt(tempTime.substring(0, tempTime.lastIndexOf(46))) * 60;
                    }
                    if ((split = (tempUrl = (resultMap = this.save2TempUrl(timeout, fileName, fileSize, cache, finalInputStream = FileChecker.addSecurityWaterMark(fileName, buffInputStream))).get("tempUrl")).split("id=")).length >= 2) {
                        tempFileId = split[1];
                    }
                    tempUrl = EncreptSessionUtils.encryptSession((String)tempUrl);
                    String address = RequestContext.get().getClientFullContextPath();
                    if (!address.endsWith("/")) {
                        address = address + "/";
                    }
                    tempUrl = address + tempUrl;
                    HashMap<String, Object> maps = new HashMap<String, Object>();
                    maps.put("downloadUrl", tempUrl);
                    maps.put("fileExt", jsonObject.get((Object)"fileExt"));
                    maps.put("fileId", jsonObject.get((Object)"fileId"));
                    maps.put(FILE_NAME, fileName);
                    maps.put("fileSize", jsonObject.get((Object)"fileSize"));
                    maps.put("fileTime", jsonObject.get((Object)"fileTime"));
                    if (onlyOfficePreview) {
                        maps.put("onlyOfficeDownloadUrl", AttachmentPreviewUtil.setOnlyOfficeDownloadUrl((String)tempUrl, (String)request.getParameter("fId")));
                    }
                    if ((localId = jsonObject.get((Object)"localId")) != null) {
                        redisCache.put(LOCAL_ID_KEY + tempFileId, (Object)((String)localId), 7200);
                        maps.put("localId", localId);
                    }
                    listMaps.add(maps);
                    FileRecord fileRecord = new FileRecord();
                    fileRecord.setUrl(tempUrl);
                    fileRecord.setType("1");
                    fileRecord.setUserId(Long.valueOf(RequestContext.get().getCurrUserId()));
                    fileRecord.setCreateTime(new Date());
                    recordList.add(fileRecord);
                    FilePermissionParam filePermissionParam = new FilePermissionParam(request.getParameter("fId"), request.getParameter("appId"), tempUrl, FileTypeEnum.TEMPFILE, request);
                    permissionParamList.add(filePermissionParam);
                    continue;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (buffInputStream == null) continue;
                    if (throwable2 != null) {
                        try {
                            buffInputStream.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    buffInputStream.close();
                    continue;
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                in.close();
                continue;
            }
            break;
        }
    }

    private Map<String, String> save2TempUrl(int timeout, String fileName, int fileSize, TempFileCache cache, InputStream finalInputStream) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>(2);
        long compressPicSize = 0L;
        String[] splits = fileName.trim().split("\\.");
        String fileType = splits[splits.length - 1];
        if ("jpg,jpeg,png,gif,bmp,tiff,tga,ico,dib,rle,emf,jpe,jfif,pcx,dcx,pic,tif,wmf".contains(fileType.toLowerCase())) {
            compressPicSize = AttachmentServiceHelper.getCompressPicSize();
        }
        if (compressPicSize != 0L && (long)fileSize > compressPicSize) {
            finalInputStream = FileUtil.compressPic((String)fileName, (InputStream)finalInputStream, (long)compressPicSize);
        }
        result.put("size", String.valueOf(finalInputStream.available()));
        String tempUrl = cache.saveAsUrl(fileName, finalInputStream, timeout);
        result.put("tempUrl", tempUrl);
        return result;
    }

    private boolean isWebOffice(String contentType) {
        return contentType == null || contentType.contains("WebCtrlWebOffice");
    }

    public static boolean fileExtCheck(String fileName, HttpServletResponse response) throws IOException {
        if (!fileName.contains(".")) {
            AttachmentAction.writeErrorMessage(response, String.format(ResManager.loadKDString((String)"%s\u6587\u4ef6\u65e0\u540e\u7f00\u540d\uff0c\u4e0d\u652f\u6301\u4e0a\u4f20\u3002", (String)"AttachmentAction_15", (String)BOS_ATTACHMENT, (Object[])new Object[0]), fileName));
            return false;
        }
        String ext = fileName.substring(fileName.lastIndexOf(46) + 1);
        if (ext.contains(" ")) {
            AttachmentAction.writeErrorMessage(response, String.format(ResManager.loadKDString((String)"%s\u6587\u4ef6\u540e\u7f00\u540d\u5305\u542b\u7a7a\u683c\uff0c\u4e0d\u652f\u6301\u4e0a\u4f20\u3002", (String)"AttachmentAction_27", (String)BOS_ATTACHMENT, (Object[])new Object[0]), fileName));
            return false;
        }
        return true;
    }

    public static long getMaxSize() {
        long mcSizeMb;
        Object sizeMb = DispatchServiceHelper.invokeBOSService((String)"SystemParamService", (String)"loadPublicParameterFromCache", (Object[])new Object[]{"maxuploadsize"});
        long l = mcSizeMb = AttachmentAction.getFileService().maxUploadSize() == 0L ? 0x3200000L : AttachmentAction.getFileService().maxUploadSize();
        if (sizeMb != null && !"0".equals(sizeMb.toString())) {
            long size = Long.parseLong(String.valueOf(sizeMb));
            return Math.min(size * 1024L * 1024L, mcSizeMb);
        }
        return mcSizeMb;
    }

    public boolean getCheckuploadurl() {
        Object checkUploadUrlStr = DispatchServiceHelper.invokeBOSService((String)"SystemParamService", (String)"loadPublicParameterFromCache", (Object[])new Object[]{"checkuploadurl"});
        if (checkUploadUrlStr == null) {
            return false;
        }
        return Boolean.parseBoolean(checkUploadUrlStr.toString());
    }

    private String getYZJUrl() {
        AppParam appParam = new AppParam();
        appParam.setAppId("83bfebc8000037ac");
        appParam.setViewType("15");
        appParam.setOrgId(Long.valueOf(((IParameterHelperService)ServiceSvcFactory.getService(IParameterHelperService.class)).getParamRootOrgId()));
        appParam.setActBookId(Long.valueOf(0L));
        Object yzjurlStr = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"yzjurl");
        if (yzjurlStr == null) {
            return "";
        }
        return yzjurlStr.toString();
    }

    private boolean checkIsWpsEdit(HttpServletRequest request) {
        String fileHeader = request.getParameter("fileHeader");
        return StringUtils.equals((CharSequence)"1", (CharSequence)fileHeader);
    }

    private boolean checkMaxSize(HttpServletResponse response, long fileSize) throws IOException {
        long maxSize = AttachmentAction.getMaxSize();
        if (fileSize > maxSize) {
            FileReqLimitUtil.writeOverMaxSize(response, fileSize, maxSize);
            return false;
        }
        return FileReqLimitUtil.checkTotalFileSize(response, "uploadFile", fileSize, maxSize * 3L, "", true);
    }

    private void writeTempUrl(HttpServletResponse response, String url, String fid, String tempUrl, int finalFileSize) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("url", url);
        if (AttachmentPreviewUtil.isOnlyOfficePreView()) {
            String onlyOfficeDownloadUrl = AttachmentPreviewUtil.addFileIdParam((String)url, (String)fid);
            result.put("onlyOfficeDownloadUrl", AttachmentPreviewUtil.getReplaceUrl((String)onlyOfficeDownloadUrl, (String)"0", (boolean)true));
        }
        result.put("downloadFilePath", tempUrl);
        result.put("size", finalFileSize);
        result.put(STATUS, SUCCESS);
        String jsonResult = SerializationUtils.toJsonString(result);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)jsonResult);
    }

    private void writeTempUrls(HttpServletResponse response, List<Map<String, Object>> listMaps) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("files", listMaps);
        result.put(STATUS, SUCCESS);
        String jsonResult = SerializationUtils.toJsonString(result);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)jsonResult);
    }

    public void upload2(String fileName, String path, InputStream in, HttpServletResponse servletResponse) {
        try {
            FileItem fileItem = this.createFileItem(fileName, path, in, FileSource.Unknown, null, null);
            this.upload0(fileItem, null, servletResponse, FileSource.Unknown);
        }
        catch (Exception e) {
            try {
                log.error((Throwable)e);
                HashMap<String, String> result = new HashMap<String, String>();
                result.put(STATUS, ERROR);
                String msg = ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"AttachmentAction_32", (String)BOS_ATTACHMENT, (Object[])new Object[0]);
                result.put(DESCRIPTION, msg);
                String jsonResult = SerializationUtils.toJsonString(result);
                ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)jsonResult);
            }
            catch (IOException e1) {
                log.error((Throwable)e1);
            }
        }
    }

    private String getNewFilePath(String oldPath, String fileName) {
        String selfPath = oldPath;
        boolean encrptyPath = Boolean.parseBoolean(String.valueOf(DispatchServiceHelper.invokeBOSService((String)IAttachmentService.class.getSimpleName(), (String)"isEncrptyPath", (Object[])new Object[0])));
        if (oldPath == null || !oldPath.contains("/")) {
            selfPath = this.generateAttPath(fileName);
        }
        if (!encrptyPath) {
            return selfPath;
        }
        return this.generateAttPath(fileName);
    }

    private String generateAttPath(String fileName) {
        String rootPath = System.getProperty("attachment.rootpath", "/");
        if (!rootPath.startsWith("/")) {
            rootPath = "/" + rootPath;
        }
        if (rootPath.endsWith("/")) {
            rootPath = rootPath.substring(0, rootPath.length() - 1);
        }
        String uuid = UUID.randomUUID().toString().replace("-", "");
        RequestContext rc = RequestContext.get();
        return rootPath + FileNameUtils.getAttachmentFileName((String)rc.getTenantCode(), (String)rc.getAccountId(), (Object)uuid, (String)fileName);
    }

    /*
     * Exception decompiling
     */
    private void upload0(FileItem fileItem, HttpServletRequest request, HttpServletResponse response, FileSource fileSource) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void remove(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            if (CtsyActionDispatchServiceHelper.isCtsyRequest(request)) {
                CtsyActionDispatchServiceHelper.redirectHttpAction(request, response);
                return;
            }
            request.setAttribute("permItem", (Object)"2NJ5YJOIS+MJ");
            String path = HandleFactory.getHandle(request).handler(request);
            AttachmentAction.getFileService().delete(path);
            BillFileMappingWriter.removeMappingRecord((String)path, (String)"attach");
            result.put(STATUS, SUCCESS);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            if (e instanceof KDException && AttachExceptionHandler.dealException((KDException)((KDException)((Object)e)), (HttpServletResponse)response).booleanValue()) {
                return;
            }
            result.put(STATUS, ERROR);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            String msg = sw.toString();
            result.put(DESCRIPTION, msg);
        }
        String jsonResult = SerializationUtils.toJsonString(result);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)jsonResult);
    }

    private void dealResult(HttpServletResponse response, Map<String, Object> result) throws IOException {
        String jsonResult = SerializationUtils.toJsonString(result);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)jsonResult);
    }

    private void dealPreviewResult(HttpServletResponse response, Map<String, Object> result, String previewType) throws IOException {
        String status = (String)result.get(PreviewParams.STATUS.getEnumName());
        Map<String, Object> mapResult = new HashMap<String, String>();
        InputStream in = null;
        boolean yzjPreview = "1".equals(previewType);
        boolean wpsPreview = "21".equals(previewType);
        boolean wpsPrivatePreview = "22".equals(previewType);
        boolean yozoPreview = "4".equals(previewType);
        boolean onlyOfficePreview = "3".equals(previewType);
        if (yzjPreview && PreviewParams.ERROR.getEnumName().equals(status)) {
            mapResult.put(PreviewParams.STATUS.getEnumName(), PreviewParams.ERROR.getEnumName());
            mapResult.put(PreviewParams.DESCRIPTION.getEnumName(), result.get(PreviewParams.DESCRIPTION.getEnumName()));
            String jsonResult = SerializationUtils.toJsonString(mapResult);
            JsonUtil.writeResponseJson((HttpServletResponse)response, (CharSequence)jsonResult);
        } else if (PreviewParams.ERROR.getEnumName().equals(status) || PreviewParams.XLSX_SUCCESS.getEnumName().equals(status)) {
            mapResult = (Map)result.get(PreviewParams.RESULT.getEnumName());
            String jsonResult = SerializationUtils.toJsonString(mapResult);
            JsonUtil.writeResponseJson((HttpServletResponse)response, (CharSequence)jsonResult);
        } else if (PreviewParams.PDF_SUCCESS.getEnumName().equals(status) || PreviewParams.NOT_NEED_CHANGE.getEnumName().equals(status)) {
            in = (InputStream)result.get(PreviewParams.RESULT.getEnumName());
            JsonUtil.writeResponseStream((HttpServletResponse)response, (InputStream)in);
        } else if (PreviewParams.URL.getEnumName().equals(status)) {
            mapResult.put("url", result.get(PreviewParams.RESULT.getEnumName()));
            mapResult.put(PreviewParams.STATUS.getEnumName(), PreviewParams.SUCCESS.getEnumName());
            String jsonResult = SerializationUtils.toJsonString(mapResult);
            JsonUtil.writeResponseJson((HttpServletResponse)response, (CharSequence)jsonResult);
        } else if (wpsPreview || wpsPrivatePreview || yozoPreview || onlyOfficePreview) {
            mapResult.putAll(result);
            String jsonResult = SerializationUtils.toJsonString(mapResult);
            JsonUtil.writeResponseJson((HttpServletResponse)response, (CharSequence)jsonResult);
        } else if (PreviewParams.SPREADJS_SUCCESS.getEnumName().equals(status)) {
            mapResult.put(PreviewParams.STATUS.getEnumName(), PreviewParams.SUCCESS.getEnumName());
            mapResult.put("data", JSON.parseObject((String)String.valueOf(result.get(PreviewParams.RESULT.getEnumName())), HashMap.class));
            JsonUtil.writeResponseJson((HttpServletResponse)response, (CharSequence)SerializationUtils.toJsonString(mapResult));
        }
    }

    private Map<String, Object> getFileInfoFromCache(String path) throws IOException {
        String param_path = path.substring(path.lastIndexOf(63) + 1, path.length());
        String[] params = param_path.split("&");
        HashMap map = Maps.newHashMapWithExpectedSize((int)params.length);
        HashMap result = Maps.newHashMapWithExpectedSize((int)2);
        for (String param : params) {
            String[] parameters = param.split("=");
            map.put(parameters[0], parameters[1]);
        }
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        if (!(cache instanceof TempFileCacheDownloadable)) {
            result.put(ERROR, cache.getClass().getName() + " must implements " + TempFileCacheDownloadable.class.getName());
            return result;
        }
        TempFileCacheDownloadable downloader = (TempFileCacheDownloadable)cache;
        String configKey = (String)map.get("configKey");
        String id = (String)map.get("id");
        if (StringUtils.isEmpty((CharSequence)configKey) || StringUtils.isEmpty((CharSequence)id)) {
            result.put(ERROR, ResManager.loadKDString((String)"\u8bf7\u6c42\u8def\u5f84\u4e2dconfigKey\u6216id\u4e0d\u5b58\u5728,\u8bbf\u95ee\u4e34\u65f6\u6587\u4ef6\u7f13\u5b58\u5931\u8d25", (String)"AttachmentAction_9", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
            return result;
        }
        TempFileCacheDownloadable.Content content = downloader.get(configKey, id);
        if (content == null) {
            result.put(ERROR, ResManager.loadKDString((String)"\u4ece\u4e34\u65f6\u6587\u4ef6\u7f13\u5b58\u4e2d\u83b7\u53d6\u6587\u4ef6\u5931\u8d25,\u7f13\u5b58\u6587\u4ef6\u53ef\u80fd\u5931\u6548,\u8bf7\u91cd\u65b0\u4e0a\u4f20", (String)"AttachmentAction_10", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
            return result;
        }
        result.put(FILE_NAME, content.getFilename());
        result.put("in", content.getInputStream());
        return result;
    }

    private boolean isForbidUpload(HttpServletRequest request, HttpServletResponse response, String fileName, BufferedInputStream buffInputStream) throws IOException {
        List<String> controlWhiteTypeList = this.tryGetControlWhiteTypeList(request);
        FileCheckResult fileCheckResult = FileChecker.isForbidUpload(buffInputStream, controlWhiteTypeList, fileName, false);
        if (!fileCheckResult.isCheckReuslt()) {
            this.writeForbidUploadErrorMessage(response, fileCheckResult);
        }
        return !fileCheckResult.isCheckReuslt();
    }

    private void writeForbidUploadErrorMessage(HttpServletResponse response, FileCheckResult fileCheckResult) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(STATUS, ERROR);
        String msg = fileCheckResult.getErrorMsg();
        if (StringUtils.isBlank((CharSequence)msg)) {
            String fileName = fileCheckResult.getRealFileName();
            String fileExt = fileName.substring(fileName.lastIndexOf(".") + 1);
            msg = String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u5141\u8bb8\u4e0a\u4f20%s\u6587\u4ef6\u7c7b\u578b\uff0c\u53ef\u524d\u5f80\u201c\u516c\u5171\u8bbe\u7f6e>\u7cfb\u7edf\u53c2\u6570>\u9644\u4ef6\u56fe\u7247\u53c2\u6570>\u9644\u4ef6\u4e0a\u4f20\u9650\u5236>\u7981\u6b62\u4e0a\u4f20\u9644\u4ef6\u7c7b\u578b\u6216\u6587\u4ef6\u670d\u52a1\u5668\u201d\uff0c\u4fee\u6539\u9644\u4ef6\u4e0a\u4f20\u9ed1\u540d\u5355\u3002", (String)"AttachmentAction_14", (String)BOS_ATTACHMENT, (Object[])new Object[0]), fileExt);
        }
        result.put(DESCRIPTION, msg);
        try {
            String jsonResult = SerializationUtils.toJsonString(result);
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)jsonResult);
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
    }

    private List<String> tryGetControlWhiteTypeList(HttpServletRequest request) {
        String awet = request.getHeader("awet");
        ArrayList<String> controlWhiteTypeList = new ArrayList<String>(10);
        try {
            if (StringUtils.isNotBlank((CharSequence)awet)) {
                String[] controlWhiteTypeArray;
                awet = DecodeHandlerFactory.getDecodeHandler((String)"base64").decode(awet);
                for (String controlWhiteType : controlWhiteTypeArray = awet.split(",")) {
                    controlWhiteTypeList.add(controlWhiteType.replace(".", ""));
                }
            }
            log.info("tryGetControlWhiteTypeList result is " + SerializationUtils.toJsonString(controlWhiteTypeList));
            return controlWhiteTypeList;
        }
        catch (Exception var27) {
            log.error("tryGetControlWhiteTypeList --- failed to decrypt , source awet is " + awet);
            return controlWhiteTypeList;
        }
    }

    public static String checkSpeSymbol(String fileFullName, HttpServletResponse response) {
        return AttachmentServiceHelper.checkSpeSymbol((String)fileFullName);
    }

    public static void writeErrorMessage(HttpServletRequest request, HttpServletResponse response, String errorMessage) throws IOException {
        if (AttachmentUtil.isFrom3rdPreviewOrEdit(request)) {
            response.setStatus(500);
        }
        AttachmentAction.writeErrorMessage(response, errorMessage);
    }

    public static void writeErrorMessage(HttpServletResponse response, String errorMessage) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(STATUS, ERROR);
        result.put(DESCRIPTION, errorMessage);
        String jsonResult = SerializationUtils.toJsonString(result);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)jsonResult);
    }

    public boolean isIEBrowser(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        for (String signal : IEBrowserSignals) {
            if (!userAgent.contains(signal)) continue;
            return true;
        }
        return false;
    }

    private void setOperationContext(String appId, String formId, String formname, String method, String opKey) {
        OperationContext oc = new OperationContext();
        oc.setAppId(appId);
        oc.setFormId(formId);
        oc.setFormName(formname);
        oc.setOpKey(opKey);
        oc.setOpMethod(method);
        OperationContext.set((OperationContext)oc);
    }

    public static void fileInfoForWps(HttpServletRequest request, HttpServletResponse response) throws Exception {
        PreviewCallBackService.fileInfoForWps(request, response);
    }

    public static void onNotifyForWps(HttpServletRequest request, HttpServletResponse response) throws Exception {
        PreviewCallBackService.onNotifyForWps(request);
    }

    private FileItem createFileItem(String fileName, String path, InputStream in, FileSource fileSource, String appId, String fId) {
        FileItemExt fileItemExt = new FileItemExt(fileName, path, in);
        fileItemExt.setSource(fileSource);
        fileItemExt.setAppId(appId);
        fileItemExt.setFId(fId);
        return fileItemExt;
    }

    public void onlyOfficeEditCallback(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PreviewCallBackService.onlyOfficeEditCallback(request, response);
    }

    private static String dealUrl4OnlyOffice(String tempUrl, String fid) {
        String urlForOnlyOffice = "";
        if (AttachmentPreviewUtil.isOnlyOfficePreView()) {
            urlForOnlyOffice = AttachmentPreviewUtil.addFileIdParam((String)tempUrl, (String)fid);
        }
        return urlForOnlyOffice;
    }
}

