/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.actions.handler;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.svc.util.PermissionParam;
import kd.bos.web.actions.handler.IAttachHandle;
import kd.bos.web.actions.utils.FilePremissionUtil;

public class CustomAttachHandle
implements IAttachHandle {
    private static Log log = LogFactory.getLog(CustomAttachHandle.class);
    private static final String BOS_ATTACHMENT = "bos-attachment";

    @Override
    public String handler(HttpServletRequest request) throws KDException, UnsupportedEncodingException {
        long disableTime;
        String customAttachId = request.getParameter("customAttachId");
        Map<String, Object> customParam = this.getCustomPermMap(customAttachId);
        String path = this.verifyPath(String.valueOf(customParam.get("path")));
        customParam.put("path", path);
        Object countObj = customParam.get("count");
        Object disableTimeObj = customParam.get("disableTime");
        if (disableTimeObj instanceof Long && (disableTime = ((Long)disableTimeObj).longValue()) > 0L && new Date().getTime() > disableTime) {
            PermissionParam.removePermissionParam((String)customAttachId);
            throw new KDException(new ErrorCode("timeout!", ResManager.loadKDString((String)"\u94fe\u63a5\u5df2\u8d85\u65f6\uff01", (String)"AttachmentAction_34", (String)BOS_ATTACHMENT, (Object[])new Object[0])), new Object[0]);
        }
        if (countObj instanceof Integer) {
            int count = (Integer)countObj;
            if (count < 1) {
                throw new KDException(new ErrorCode("timeout!", ResManager.loadKDString((String)"\u94fe\u63a5\u5df2\u8d85\u65f6\uff01", (String)"AttachmentAction_34", (String)BOS_ATTACHMENT, (Object[])new Object[0])), new Object[0]);
            }
            customParam.put("count", --count);
            if (count == 0) {
                PermissionParam.removePermissionParam((String)customAttachId);
                return path;
            }
            PermissionParam.updatePermissionParam((String)customAttachId, customParam);
            return path;
        }
        PermissionParam.removePermissionParam((String)customAttachId);
        if (FilePremissionUtil.tryGetHasRightValue((HttpServletRequest)request).booleanValue()) {
            return path;
        }
        ArrayList<Map<String, Object>> refEntityList = new ArrayList<Map<String, Object>>();
        refEntityList.add(customParam);
        if (!FilePremissionUtil.hasEntityPermission(refEntityList).booleanValue()) {
            throw new KDException(new ErrorCode("NO Permission!", ResManager.loadKDString((String)"\u65e0\u8bbf\u95ee\u6743\u9650\uff01", (String)"AttachmentAction_33", (String)BOS_ATTACHMENT, (Object[])new Object[0])), new Object[0]);
        }
        return path;
    }

    private Map<String, Object> getCustomPermMap(String customAttachId) {
        Map customParam = PermissionParam.getPermissionParam((String)customAttachId);
        if (customParam.size() == 0) {
            throw new KDException(new ErrorCode("Invalid Path!", ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u94fe\u63a5\u5931\u6548\uff01", (String)"AttachmentAction_29", (String)BOS_ATTACHMENT, (Object[])new Object[0])), new Object[0]);
        }
        log.debug("kd.bos.web.actions.handler.CustomAttachHandle---customParam---" + customParam);
        return customParam;
    }

    private String verifyPath(String path) throws UnsupportedEncodingException {
        if ("/".equals(path)) {
            throw new KDException(new ErrorCode("ILLEGAL_PATH", ResManager.loadKDString((String)"\u4e0b\u8f7d\u8def\u5f84\u4e0d\u5408\u6cd5\uff01", (String)"AttachmentAction_28", (String)BOS_ATTACHMENT, (Object[])new Object[0])), new Object[0]);
        }
        while (path.contains("//")) {
            path = path.replaceAll("//", "/");
        }
        if (StringUtils.isNotBlank((CharSequence)path)) {
            path = this.dealPath(URLDecoder.decode(path, "UTF-8"));
        }
        return path;
    }
}

