/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.actions.handler;

import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.web.actions.handler.CustomAttachHandle;
import kd.bos.web.actions.handler.DafaultAttachHandle;
import kd.bos.web.actions.handler.ExportAttachHandle;
import kd.bos.web.actions.handler.IAttachHandle;
import kd.bos.web.actions.handler.ImportAttachHandle;
import kd.bos.web.actions.handler.ReportExportHandle;

public class HandleFactory {
    private static final String DEFAULT = "DEFAULT";
    private static Map<String, IAttachHandle> SERVICE_MAP = new HashMap<String, IAttachHandle>();
    private static DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));

    public static IAttachHandle getHandle(HttpServletRequest request) throws KDException, UnsupportedEncodingException {
        String customAttachId = request.getParameter("customAttachId");
        if (StringUtils.isNotBlank((CharSequence)customAttachId)) {
            return SERVICE_MAP.get("customAttachService");
        }
        String attachId = request.getParameter("attachId");
        String serviceKey = DEFAULT;
        if (StringUtils.isNotBlank((CharSequence)attachId)) {
            String permissionParamJson = (String)redisCache.get(attachId);
            if (HandleFactory.encodeAttachId(attachId).booleanValue()) {
                attachId = new String(Base64.getDecoder().decode(attachId), "UTF-8");
                String[] arr = attachId.split("@");
                if (arr.length != 2 && arr.length != 3) {
                    throw new KDException(new ErrorCode("parameter is illegal", ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u5408\u6cd5\uff01", (String)"AttachmentAction_12", (String)"bos-webactions", (Object[])new Object[0])), new Object[0]);
                }
                serviceKey = arr[1];
            } else {
                if (StringUtils.isBlank((CharSequence)permissionParamJson)) {
                    throw new KDException(new ErrorCode("NO Permission!", ResManager.loadKDString((String)"\u65e0\u8bbf\u95ee\u6743\u9650!", (String)"AttachmentAction_11", (String)"bos-webactions", (Object[])new Object[0])), new Object[0]);
                }
                Map permissionParam = (Map)SerializationUtils.fromJsonString((String)permissionParamJson, Map.class);
                serviceKey = (String)permissionParam.get("logEntityNum");
            }
        }
        if (!SERVICE_MAP.containsKey(serviceKey)) {
            serviceKey = DEFAULT;
        }
        return SERVICE_MAP.get(serviceKey);
    }

    private static Boolean encodeAttachId(String attachId) {
        DafaultAttachHandle handle = new DafaultAttachHandle();
        return handle.encodeAttachId(attachId);
    }

    static {
        SERVICE_MAP.put("bos_exportlog", new ExportAttachHandle());
        SERVICE_MAP.put("bos_importlog", new ImportAttachHandle());
        SERVICE_MAP.put("report_export", new ReportExportHandle());
        SERVICE_MAP.put("customAttachService", new CustomAttachHandle());
        SERVICE_MAP.put(DEFAULT, new DafaultAttachHandle());
    }
}

