/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.actions.utils;

import java.awt.Color;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.svc.attachment.wps.pri.dto.Watermark;
import kd.bos.web.DispatchServiceHelper;

public class AttachmentUtil {
    private static final Log log = LogFactory.getLog(AttachmentUtil.class);
    private static final Map<String, String> typeMap = AttachmentUtil.getTypeMap();
    private static final String BOS_ATTACHMENT = "bos-attachment";

    @Deprecated
    public static String getImageContentType(String fileName) {
        return AttachmentUtil.getFileContentType(fileName);
    }

    public static String getFileContentType(String fileName) {
        String ext = fileName.substring(fileName.lastIndexOf(46) + 1);
        if (typeMap.containsKey(ext)) {
            return typeMap.get(ext);
        }
        for (Map.Entry<String, String> entry : typeMap.entrySet()) {
            String key = entry.getKey();
            if (!key.equalsIgnoreCase(ext)) continue;
            return entry.getValue();
        }
        return "application/octet-stream";
    }

    private static Map<String, String> getTypeMap() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("jpeg", "image/jpeg");
        map.put("jpg", "image/jpeg");
        map.put("jpe", "image/jpeg");
        map.put("jfif", "image/jpeg");
        map.put("gif", "image/gif");
        map.put("bmp", "image/bmp");
        map.put("dib", "image/dib");
        map.put("png", "image/png");
        map.put("rle", "image/rle");
        map.put("emf", "image/x-emf");
        map.put("pcx", "image/x-pcx");
        map.put("dcx", "application/x-dcx");
        map.put("pic", "image/pict");
        map.put("tga", "image/x-tga");
        map.put("tif", "image/tiff");
        map.put("wmf", "image/x-wmf");
        map.put("pdf", "application/pdf");
        return map;
    }

    public static String getUploadOrDownloadLimitTips(String fieldKey) {
        String limit = AttachmentUtil.getDownloadOrUploadTimesLimit(fieldKey);
        String action = ResManager.loadKDString((String)"\u4e0a\u4f20", (String)"AttachUploadLimitPlugin_9", (String)BOS_ATTACHMENT, (Object[])new Object[0]);
        if (fieldKey.equals("downloadlimit")) {
            action = ResManager.loadKDString((String)"\u4e0b\u8f7d", (String)"AttachUploadLimitPlugin_10", (String)BOS_ATTACHMENT, (Object[])new Object[0]);
        }
        return String.format(ResManager.loadKDString((String)"%1$s\u6b21\u6570\u8d85\u8fc7\u9650\u5236%2$s\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u4fee\u6539\u516c\u5171\u8bbe\u7f6e-\u7cfb\u7edf\u53c2\u6570-\u9644\u4ef6\u56fe\u7247\u53c2\u6570-\u9644\u4ef6%1$s\u9650\u5236-\u9644\u4ef6%1$s\u6b21\u6570\u9650\u5236\u7684\u8bbe\u7f6e\u503c\u3002", (String)"AttachUploadLimitPlugin_12", (String)BOS_ATTACHMENT, (Object[])new Object[0]), action, limit);
    }

    private static String getDownloadOrUploadTimesLimit(String fieldKey) {
        Object setStr = DispatchServiceHelper.invokeBOSService((String)"SystemParamService", (String)"loadPublicParameterFromCache", (Object[])new Object[]{fieldKey});
        return setStr.toString();
    }

    public static List<Map<String, Object>> assembleParam(String tempUrl, String key) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> buildMap = new HashMap<String, Object>();
        buildMap.put("a", "saveOfficeDocument");
        ArrayList paramList = new ArrayList();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("url", tempUrl);
        paramMap.put("fileKey", key);
        paramList.add(paramMap);
        buildMap.put("p", paramList);
        list.add(buildMap);
        return list;
    }

    public static String encodePath(String path) {
        String encodePath = "";
        try {
            log.debug("before encodePath get path is:" + path);
            if (path.startsWith("/")) {
                encodePath = path.substring(1);
            }
            encodePath = URLEncoder.encode(encodePath, "utf-8");
            log.debug("after encodePath get path is:" + encodePath);
        }
        catch (UnsupportedEncodingException e) {
            log.error("path encode error:" + path, (Throwable)e);
        }
        return StringUtils.isBlank((CharSequence)encodePath) ? path : encodePath;
    }

    public static int getSecondTimestamp() {
        Date date = new Date();
        String timestamp = String.valueOf(date.getTime());
        int length = timestamp.length();
        if (length > 3) {
            return Integer.parseInt(timestamp.substring(0, length - 3));
        }
        return 0;
    }

    public static Watermark getWatermarkForWpsPreview(String formNumber) {
        Watermark wpsWatermark = new Watermark();
        if (StringUtils.isBlank((CharSequence)formNumber)) {
            return wpsWatermark;
        }
        Object watermarkInfo = DispatchServiceHelper.invokeBOSService((String)"IAttachmentService", (String)"getAttachmentWaterMark", (Object[])new Object[]{formNumber});
        if (watermarkInfo instanceof Map && ((Map)watermarkInfo).size() > 0) {
            Map watermarkMap = (Map)watermarkInfo;
            boolean addPreviewWatermark = Boolean.parseBoolean(watermarkMap.get("addpreviewwatermark") + "");
            if (!addPreviewWatermark) {
                return wpsWatermark;
            }
            int fontSize = AttachmentUtil.getFontSize(watermarkMap);
            wpsWatermark.setType(Boolean.parseBoolean(String.valueOf(watermarkMap.get("visible"))) ? 1 : 0);
            wpsWatermark.setValue(String.valueOf(watermarkMap.get("text")));
            wpsWatermark.setFont("bold " + fontSize + "px Serif");
            wpsWatermark.setFillstyle(AttachmentUtil.getFillStyle(watermarkMap));
        }
        log.debug("wps get watermark is:" + SerializationUtils.toJsonString((Object)wpsWatermark));
        return wpsWatermark;
    }

    private static String getFillStyle(Map<String, Object> watermarkMap) {
        float alpha = AttachmentUtil.getAlpha(watermarkMap);
        String colorString = (String)watermarkMap.get("color");
        if (StringUtils.isBlank((CharSequence)colorString)) {
            return null;
        }
        Color color = Color.decode(colorString);
        return "rgba(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "," + alpha + ")";
    }

    public static String addDownloadSourceParam(String url, String source) {
        return url + source;
    }

    public static boolean isFrom3rdPreviewOrEdit(HttpServletRequest request) {
        return StringUtils.isNotEmpty((CharSequence)request.getParameter("isFromWps")) || StringUtils.isNotEmpty((CharSequence)request.getParameter("isFromYozo")) || StringUtils.isNotEmpty((CharSequence)request.getParameter("fromOnlyOffice"));
    }

    public static Map<String, Object> getWatermarkForYozoPreview(String formNumber) {
        HashMap<String, Object> watermarkParam = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)formNumber)) {
            return watermarkParam;
        }
        Object watermarkInfo = DispatchServiceHelper.invokeBOSService((String)"IAttachmentService", (String)"getAttachmentWaterMark", (Object[])new Object[]{formNumber});
        if (watermarkInfo instanceof Map && ((Map)watermarkInfo).size() > 0) {
            Map watermarkMap = (Map)watermarkInfo;
            boolean addPreviewWatermark = Boolean.parseBoolean(watermarkMap.get("addpreviewwatermark") + "");
            if (!addPreviewWatermark) {
                return watermarkParam;
            }
            int fontSiz = AttachmentUtil.getFontSize(watermarkMap);
            float alpha = AttachmentUtil.getAlpha(watermarkMap);
            String colorString = (String)watermarkMap.get("color");
            if (StringUtils.isBlank((CharSequence)colorString)) {
                colorString = "#000000";
            }
            watermarkParam.put("wmContent", watermarkMap.get("text"));
            watermarkParam.put("wmSize", fontSiz);
            watermarkParam.put("wmColor", colorString);
            watermarkParam.put("wmTransparency", Float.valueOf(alpha));
        }
        log.debug("yozo get watermark is:" + SerializationUtils.toJsonString(watermarkParam));
        return watermarkParam;
    }

    private static float getAlpha(Map<String, Object> watermarkMap) {
        Integer globalAlpha = (Integer)watermarkMap.get("globalAlpha");
        if (globalAlpha == null) {
            globalAlpha = 10;
        }
        return (float)globalAlpha.intValue() / 100.0f;
    }

    private static int getFontSize(Map<String, Object> watermarkMap) {
        String fontSize = (String)watermarkMap.get("fontSize");
        String substring = "12";
        if (StringUtils.isNotBlank((CharSequence)fontSize) && fontSize.endsWith("px")) {
            substring = fontSize.substring(0, fontSize.length() - 2);
        }
        return Integer.parseInt(substring);
    }
}

