/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.actions.utils;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.attachment.util.FileSecurityUtil;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.BatchDownloadRequest;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.watermark.common.WaterMarkKit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.bos.svc.util.FileHandlerUtil;
import kd.bos.util.EncryptUtils;
import kd.bos.util.SecurityUtils;
import kd.bos.zip.ZipFile;
import kd.bos.zip.exception.ZipException;
import kd.bos.zip.model.ZipParameters;
import kd.bos.zip.model.enums.CompressionLevel;
import kd.bos.zip.model.enums.CompressionMethod;
import kd.bos.zip.model.enums.EncryptionMethod;
import org.apache.commons.io.FilenameUtils;

public class EncryptDownloadUtil {
    private static final Log log = LogFactory.getLog(EncryptDownloadUtil.class);
    static final byte[] buffer = new byte[8192];
    private static final String USER_AGENT = "USER-AGENT";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String UTF_8 = "UTF-8";
    private static final String ANDROID = "Android";
    private static final String ATTACHMENT_FILENAME = "attachment;filename=\"";
    private static final String STRING = "attachment;filename*=UTF-8''";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String BOS_SVC_COMMON = "bos-svc-common";
    private static final String[] ENCRYPT_DIRECT = new String[]{"docx", "pptx", "xlsx"};
    public static final String ERROR = "error";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void encryptDownLoad(HttpServletRequest request, HttpServletResponse response, String url, String fileName, String password, InputStream originFileIn) throws IOException {
        File saveDir;
        String zipForLocalUrl;
        ServletOutputStream out;
        BufferedInputStream in;
        block21: {
            block20: {
                in = null;
                out = null;
                String downloadName = fileName;
                zipForLocalUrl = null;
                saveDir = FileHandlerUtil.createSaveDir((String)"encrypt");
                boolean packZip = EncryptDownloadUtil.packZip(fileName);
                if (packZip) {
                    downloadName = fileName.substring(0, fileName.lastIndexOf(".")) + ".zip";
                }
                EncryptDownloadUtil.setResponse(request, response, downloadName);
                try {
                    int len;
                    boolean isAddDownloadWaterMark;
                    if (null == originFileIn) {
                        if (url.contains("tempfile/download.do?configKey")) {
                            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                            originFileIn = cache.getInputStream(url);
                        } else {
                            originFileIn = FileServiceFactory.getAttachmentFileService().getInputStream(url);
                        }
                    }
                    if (isAddDownloadWaterMark = WaterMarkKit.isAddDownloadWaterMark((String)fileName, (HttpServletRequest)request)) {
                        originFileIn = WaterMarkKit.addWaterMark((HttpServletRequest)request, (String)fileName, (InputStream)originFileIn);
                    }
                    out = response.getOutputStream();
                    String decryptPassword = EncryptDownloadUtil.decryptPassWord(password);
                    if (!packZip) {
                        PrivacyCenterServiceHelper.buildEncryptDoc((InputStream)originFileIn, (OutputStream)out, (String)decryptPassword);
                        out.flush();
                        FileSecurityUtil.safeClose((Closeable)out);
                        break block20;
                    }
                    FileHandlerUtil.flushToLocal((String)fileName, (String)"", (InputStream)originFileIn, (File)saveDir, (boolean)false);
                    zipForLocalUrl = EncryptDownloadUtil.createZipForEncrypt(downloadName, saveDir, decryptPassword, false);
                    in = new BufferedInputStream(Files.newInputStream(new File(FilenameUtils.getFullPath((String)SecurityUtils.normalize((String)zipForLocalUrl)), FilenameUtils.getName((String)SecurityUtils.normalize((String)zipForLocalUrl))).toPath(), new OpenOption[0]));
                    while ((len = in.read(buffer)) != -1) {
                        out.write(buffer, 0, len);
                    }
                    out.flush();
                    FileSecurityUtil.safeClose((Closeable)out);
                    break block21;
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    return;
                }
            }
            FileSecurityUtil.safeClose(in);
            FileSecurityUtil.safeClose((Closeable)originFileIn);
            File[] tempFiles = saveDir.listFiles();
            if (null != tempFiles) {
                for (File dirFile : tempFiles) {
                    FileSecurityUtil.safeDeleteFile((File)dirFile);
                }
            }
            FileSecurityUtil.safeDeleteFile((File)saveDir);
            if (null == zipForLocalUrl) return;
            FileSecurityUtil.safeDeleteFile((File)new File(FilenameUtils.getFullPath((String)SecurityUtils.normalize((String)zipForLocalUrl)), FilenameUtils.getName((String)SecurityUtils.normalize((String)zipForLocalUrl))));
            return;
        }
        FileSecurityUtil.safeClose((Closeable)in);
        FileSecurityUtil.safeClose((Closeable)originFileIn);
        File[] tempFiles = saveDir.listFiles();
        if (null != tempFiles) {
            for (File dirFile : tempFiles) {
                FileSecurityUtil.safeDeleteFile((File)dirFile);
            }
        }
        FileSecurityUtil.safeDeleteFile((File)saveDir);
        if (null == zipForLocalUrl) return;
        FileSecurityUtil.safeDeleteFile((File)new File(FilenameUtils.getFullPath((String)SecurityUtils.normalize((String)zipForLocalUrl)), FilenameUtils.getName((String)SecurityUtils.normalize((String)zipForLocalUrl))));
        return;
        finally {
            FileSecurityUtil.safeClose(out);
            FileSecurityUtil.safeClose(in);
            FileSecurityUtil.safeClose((Closeable)originFileIn);
            tempFiles = saveDir.listFiles();
            if (null != tempFiles) {
                for (File dirFile : tempFiles) {
                    FileSecurityUtil.safeDeleteFile((File)dirFile);
                }
            }
            FileSecurityUtil.safeDeleteFile((File)saveDir);
            if (null != zipForLocalUrl) {
                FileSecurityUtil.safeDeleteFile((File)new File(FilenameUtils.getFullPath((String)SecurityUtils.normalize(zipForLocalUrl)), FilenameUtils.getName((String)SecurityUtils.normalize(zipForLocalUrl))));
            }
        }
    }

    public static String createZipForEncrypt(String fileName, File saveDir, String password, boolean passwordEncrypt) {
        File tempZipFile;
        File[] files = saveDir.listFiles();
        if (files == null || files.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672c\u5730\u7f13\u5b58\u76ee\u5f55\u91cc\u6ca1\u6709\u6587\u4ef6", (String)"FileHandlerUtil_3", (String)BOS_SVC_COMMON, (Object[])new Object[0]));
        }
        ZipParameters parameters = new ZipParameters();
        parameters.setCompressionMethod(CompressionMethod.DEFLATE);
        parameters.setCompressionLevel(CompressionLevel.NORMAL);
        parameters.setEncryptFiles(true);
        parameters.setEncryptionMethod(EncryptionMethod.ZIP_STANDARD);
        try {
            String decryptPassword = password;
            if (passwordEncrypt) {
                decryptPassword = EncryptDownloadUtil.decryptPassWord(password);
            }
            tempZipFile = new File(System.getProperty("java.io.tmpdir"), FilenameUtils.getName((String)fileName));
            ZipFile zipFile = new ZipFile(tempZipFile, decryptPassword.toCharArray());
            zipFile.setCharset(Charset.forName("GBK"));
            for (File file : files) {
                zipFile.addFile(file, parameters);
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode("", String.format(ResManager.loadKDString((String)"\u751f\u6210\u538b\u7f29\u5305\u5931\u8d25\uff1a%s", (String)"FileHandlerUtil_4", (String)BOS_SVC_COMMON, (Object[])new Object[0]), e.getMessage())), new Object[0]);
        }
        return tempZipFile.getAbsolutePath();
    }

    public static void batchDownloadEncrypt(BatchDownloadRequest request, File tempFile, String password) {
        if (null == tempFile) {
            throw new KDBizException("temp file is null");
        }
        File saveDir = FileHandlerUtil.createSaveDir((String)"encrypt_batch");
        try {
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(CompressionMethod.DEFLATE);
            parameters.setCompressionLevel(CompressionLevel.NORMAL);
            parameters.setEncryptFiles(true);
            parameters.setEncryptionMethod(EncryptionMethod.ZIP_STANDARD);
            password = EncryptDownloadUtil.decryptPassWord(password);
            ZipFile zipFile = new ZipFile(tempFile, password.toCharArray());
            zipFile.setCharset(Charset.forName("GBK"));
            EncryptDownloadUtil.filesZip(request.getFiles(), "", saveDir, zipFile, parameters);
            EncryptDownloadUtil.DirsZip(request.getDirs(), "", saveDir, zipFile, parameters);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException("file package error");
        }
        finally {
            File[] tempFiles = saveDir.listFiles();
            if (null != tempFiles) {
                for (File dirFile : tempFiles) {
                    FileSecurityUtil.safeDeleteFile((File)dirFile);
                }
            }
        }
    }

    private static void setResponse(HttpServletRequest request, HttpServletResponse response, String fileName) throws UnsupportedEncodingException {
        String userAgent = request.getHeader(USER_AGENT);
        response.setCharacterEncoding(UTF_8);
        response.setContentType(APPLICATION_OCTET_STREAM);
        fileName = FileSecurityUtil.getSecurityHeader((String)fileName);
        if (StringUtils.isNotBlank((CharSequence)userAgent) && userAgent.contains(ANDROID)) {
            response.setHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + URLEncoder.encode(fileName, UTF_8).replaceAll("\\+", "%20") + "\"");
        } else {
            response.setHeader(CONTENT_DISPOSITION, STRING + URLEncoder.encode(fileName, UTF_8).replaceAll("\\+", "%20"));
        }
    }

    private static boolean packZip(String fileName) {
        String fileExt = fileName.substring(fileName.lastIndexOf(".") + 1);
        for (String type : ENCRYPT_DIRECT) {
            if (!fileExt.equalsIgnoreCase(type)) continue;
            return false;
        }
        return true;
    }

    private static void DirsZip(BatchDownloadRequest.Dir[] dirs, String path, File saveDir, ZipFile zipFile, ZipParameters parameters) throws ZipException {
        if (dirs != null) {
            for (BatchDownloadRequest.Dir dir : dirs) {
                EncryptDownloadUtil.simpleDirZip(dir, path, saveDir, zipFile, parameters);
            }
        }
    }

    private static void simpleDirZip(BatchDownloadRequest.Dir dir, String path, File saveDir, ZipFile zipFile, ZipParameters parameters) throws ZipException {
        String dirname = dir.getName();
        String dirInZip = "".equals(path) ? dirname : path + "/" + dirname;
        EncryptDownloadUtil.filesZip(dir.getFiles(), dirInZip, saveDir, zipFile, parameters);
        EncryptDownloadUtil.DirsZip(dir.getDirs(), dirInZip, saveDir, zipFile, parameters);
    }

    private static void filesZip(BatchDownloadRequest.File[] files, String path, File saveDir, ZipFile zipFile, ZipParameters parameters) throws ZipException {
        if (files != null) {
            for (BatchDownloadRequest.File file : files) {
                if (file == null) continue;
                EncryptDownloadUtil.packFile2TempDir(file, path, saveDir, zipFile, parameters);
            }
        }
    }

    private static void packFile2TempDir(BatchDownloadRequest.File file, String path, File saveDir, ZipFile zipFile, ZipParameters parameters) {
        String url = file.getUrl();
        String entryName = file.getName();
        InputStream originFileIn = null;
        try {
            originFileIn = FileServiceFactory.getAttachmentFileService().getInputStream(url);
            String filepath = FileHandlerUtil.flushToLocal((String)entryName, (String)"", (InputStream)originFileIn, (File)saveDir, (boolean)false);
            if (kd.bos.util.StringUtils.isNotEmpty((String)path)) {
                parameters.setRootFolderNameInZip(path);
            }
            zipFile.addFile(new File(FilenameUtils.getFullPath((String)SecurityUtils.normalize((String)filepath)), FilenameUtils.getName((String)SecurityUtils.normalize((String)filepath))), parameters);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{url + ERROR});
        }
        finally {
            FileSecurityUtil.safeClose((Closeable)originFileIn);
        }
    }

    private static String decryptPassWord(String password) {
        String decryptPassword;
        try {
            decryptPassword = EncryptUtils.decrypt(null, (String)URLDecoder.decode(password, "utf-8"));
        }
        catch (Exception e) {
            log.error("decryptPassword failed\uff1a", (Throwable)e);
            decryptPassword = EncryptUtils.decrypt(null, (String)password);
        }
        return decryptPassword;
    }
}

