/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.actions.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kd.bos.attachment.util.AttachmentOpLogUtil;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.mservice.attachment.AttachmentInfo;
import kd.bos.mservice.attachment.AttachmentOpType;
import kd.bos.mservice.attachment.AttachmentType;
import kd.bos.mservice.attachment.FieldType;
import kd.bos.mservice.attachment.IAttachmentManagerService;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.web.actions.utils.FileClientUtil;

public class FileOperationLog {
    private static final String PAGE_ID = "pageId";
    private static final String APP_ID = "appId";
    private static FileOperationLog fileOperationLog = new FileOperationLog();
    private ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final String ATTATCHMENT_CHECKID = "TempFileCheckId:";
    private static final String REPORT_CHECKID = "ReportTempFileCheckId:";
    private static final String ID_MAP_KEY = "id";
    private static final String I_ATTACHMENT_MANAGER_SERVICE = "IAttachmentManagerService";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));

    private FileOperationLog() {
    }

    public static FileOperationLog getInstance() {
        return fileOperationLog;
    }

    @Deprecated
    public void createAppLog(String bizObjID, String opName, String opDesc) {
        AppLogInfo appLogInfo = new AppLogInfo();
        appLogInfo.setBizAppID(BizAppServiceHelp.getAppIdByFormNum((String)bizObjID));
        appLogInfo.setBizObjID(bizObjID);
        appLogInfo.setOpName(opName);
        appLogInfo.setOpDescription(opDesc);
        this.service.addLog(appLogInfo);
    }

    public void createAppLog(String bizObjID, MultiLangEnumBridge opNameBridge, MultiLangEnumBridge opDescBridge, String ... opDescArgs) {
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setBizAppID(BizAppServiceHelp.getAppIdByFormNum((String)bizObjID));
        appLogInfo.setBizObjID(bizObjID);
        appLogInfo.setOpName("attachOp", opNameBridge);
        appLogInfo.setOpDesc(opDescBridge, opDescArgs);
        this.service.addLog((AppLogInfo)appLogInfo);
    }

    public void createAttachLog(HttpServletRequest request, String fileName) {
        String appId;
        boolean isWeb;
        boolean bl = isWeb = !FileClientUtil.checkAgentIsMobile(request);
        if (isWeb && StringUtils.isNotEmpty((CharSequence)request.getParameter(PAGE_ID))) {
            return;
        }
        if (!isWeb && StringUtils.isNotEmpty((CharSequence)request.getParameter(PAGE_ID)) && StringUtils.isNotEmpty((CharSequence)request.getHeader("Referer"))) {
            return;
        }
        String path = request.getParameter("path");
        if (StringUtils.isEmpty((CharSequence)path) || path.length() < 1) {
            path = FileOperationLog.dealPathWithOutPath(request);
        } else {
            while (path.startsWith("//")) {
                path = path.substring(1);
            }
        }
        RequestContext rc = RequestContext.get();
        AttachmentInfo attachmentInfo = new AttachmentInfo();
        attachmentInfo.setAttSourceType(AttachmentType.attachmenturl);
        String fid = request.getParameter("fId");
        if (StringUtils.isEmpty((CharSequence)fid)) {
            fid = request.getParameter("formid");
        }
        if (StringUtils.isEmpty((CharSequence)(appId = request.getParameter(APP_ID)))) {
            fid = request.getParameter("routeappid");
        }
        if (StringUtils.isEmpty((CharSequence)appId)) {
            String id = request.getParameter(ID_MAP_KEY);
            String value = (String)cache.get(ATTATCHMENT_CHECKID + id);
            if (StringUtils.isBlank((CharSequence)value)) {
                value = (String)cache.get(REPORT_CHECKID + id);
            }
            Map refEntitiyMap = null;
            if (StringUtils.isNotBlank((CharSequence)value)) {
                refEntitiyMap = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
            }
            if (!CollectionUtils.isEmpty(refEntitiyMap)) {
                if (refEntitiyMap.containsKey("entityNum")) {
                    fid = refEntitiyMap.get("entityNum").toString();
                }
                if (refEntitiyMap.containsKey(APP_ID)) {
                    appId = refEntitiyMap.get(APP_ID).toString();
                }
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)fid)) {
            attachmentInfo.setEntityNum(fid);
        }
        if (StringUtils.isNotEmpty((CharSequence)appId)) {
            attachmentInfo.setAppId(appId);
        } else {
            attachmentInfo.setAppId(ResManager.loadKDString((String)"\u7a7a\u5e94\u7528", (String)"AttachmentAction_30", (String)"bos-attachment", (Object[])new Object[0]));
        }
        String billNo = request.getParameter("billNo");
        attachmentInfo.setBillno(billNo);
        attachmentInfo.setExt(AttachmentOpLogUtil.getExtFromFileName((String)fileName));
        attachmentInfo.setFileName(fileName);
        attachmentInfo.setFilelocation(AttachmentOpLogUtil.getLocationTypeByUrlV1((String)path));
        attachmentInfo.setDownloadUrl(path);
        attachmentInfo.setPreviewUrl(attachmentInfo.getDownloadUrl().replace("download.do", "preview.do"));
        attachmentInfo.setMark("");
        attachmentInfo.setFieldKey("");
        attachmentInfo.setFieldType(FieldType.Single);
        attachmentInfo.setBillPkId("");
        Date now = new Date();
        attachmentInfo.setCreateTime(now);
        attachmentInfo.setCreateUserId(rc.getUserId());
        attachmentInfo.setModifyTime(now);
        attachmentInfo.setClient(isWeb ? "web" : "mobile");
        ArrayList<AttachmentInfo> resultList = new ArrayList<AttachmentInfo>(16);
        resultList.add(attachmentInfo);
        IAttachmentManagerService managerService = (IAttachmentManagerService)ServiceFactory.getService((String)I_ATTACHMENT_MANAGER_SERVICE);
        managerService.afterDoOperation(resultList, AttachmentOpType.DownloadFromUrl);
    }

    private static String dealPathWithOutPath(HttpServletRequest request) {
        String path = StringUtils.isNotEmpty((CharSequence)request.getParameter("configKey")) && StringUtils.isNotEmpty((CharSequence)request.getParameter(ID_MAP_KEY)) ? request.getRequestURL().append("?configKey=").append(request.getParameter("configKey")).append("&id=").append(request.getParameter(ID_MAP_KEY)).toString() : request.getRequestURL().append("?").append(request.getQueryString()).toString();
        return path;
    }

    public static enum FileOperationEnum {
        DOWNLOAD_SUCCESS(1, new MultiLangEnumBridge("\u6587\u4ef6\u4e0b\u8f7d", "FileOperationLog_0", "bos-attachment"), new MultiLangEnumBridge("\u4e0b\u8f7d\u6587\u4ef6%s\u6210\u529f", "FileOperationLog_1", "bos-attachment")),
        DOWNLOAD_FAIL(2, new MultiLangEnumBridge("\u6587\u4ef6\u4e0b\u8f7d", "FileOperationLog_0", "bos-attachment"), new MultiLangEnumBridge("\u4e0b\u8f7d\u6587\u4ef6%s\u5931\u8d25", "FileOperationLog_2", "bos-attachment"));

        private int type;
        private MultiLangEnumBridge opNameBridge = null;
        private MultiLangEnumBridge opDescFormatBridge = null;

        private FileOperationEnum(int type, MultiLangEnumBridge opNameBridge, MultiLangEnumBridge opDescFormatBridge) {
            this.type = type;
            this.opNameBridge = opNameBridge;
            this.opDescFormatBridge = opDescFormatBridge;
        }

        public String getOpName() {
            return this.opNameBridge.loadKDString();
        }

        public String getOpDescFormat() {
            return this.opDescFormatBridge.loadKDString();
        }

        public MultiLangEnumBridge getOpNameBridge() {
            return this.opNameBridge;
        }

        public MultiLangEnumBridge getOpDescFormatBridge() {
            return this.opDescFormatBridge;
        }
    }
}

