/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.actions.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class FileTypeUtil {
    private static Log log = LogFactory.getLog(FileTypeUtil.class);
    private static final HashMap<String, String> mFileTypes = new HashMap(16);
    private static List<String> presetExtList = new ArrayList<String>(10);
    private static final String T_BAS_FILETYPE_MAGICNUM = "t_bas_filetype_magicnum";
    private static final String ROUTE_KEY_SYS = "sys";

    public static String getFileRealName(String fileName, BufferedInputStream buffInputStream) throws IOException {
        String ext_old = fileName.substring(fileName.lastIndexOf(46) + 1);
        if (!presetExtList.contains(ext_old = ext_old.toLowerCase()) && !StringUtils.endsWithIgnoreCase((CharSequence)"txt", (CharSequence)ext_old)) {
            return fileName;
        }
        String ext_new = FileTypeUtil.getFileType(buffInputStream);
        if (ext_new == null) {
            return fileName;
        }
        if (ext_new.equals("")) {
            return "errorfile.errorfile";
        }
        if (ext_new.contains(",")) {
            String[] extArray = ext_new.split(",");
            List<String> extList = Arrays.asList(extArray);
            for (String ext : extList) {
                if (!ext.equalsIgnoreCase(ext_old)) continue;
                ext_new = ext_old;
                break;
            }
            ext_new = ext_new.split(",")[0];
        }
        return fileName.substring(0, fileName.lastIndexOf(46)) + "." + ext_new;
    }

    public static String getFileType(BufferedInputStream buffInputStream) throws IOException {
        String fileHeader = FileTypeUtil.getFileHeader(buffInputStream, 4);
        return mFileTypes.get(fileHeader);
    }

    public static String getFileHeader(BufferedInputStream buffInputStream, int byteCount) throws IOException {
        String value = null;
        try {
            byte[] b = new byte[byteCount];
            buffInputStream.mark(byteCount);
            buffInputStream.read(b, 0, b.length);
            buffInputStream.reset();
            value = FileTypeUtil.bytesToHexString(b);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u8def\u5f84\u5931\u8d25", (Throwable)e);
        }
        return value;
    }

    public static ByteArrayOutputStream cloneInputStream(InputStream input) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = input.read(buffer)) > -1) {
            baos.write(buffer, 0, len);
        }
        baos.flush();
        return baos;
    }

    private static String bytesToHexString(byte[] src) {
        StringBuilder builder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (byte aSrc : src) {
            String hv = Integer.toHexString(aSrc & 0xFF).toUpperCase();
            if (hv.length() < 2) {
                builder.append(0);
            }
            builder.append(hv);
        }
        return builder.toString();
    }

    public static String getContentType(String filename) {
        String type = null;
        Path path = Paths.get(filename, new String[0]);
        try {
            type = Files.probeContentType(path);
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6\u6587\u4ef6ContentType\u5931\u8d25,err:" + e);
        }
        return type;
    }

    public static Map<String, String> getMFileTypes() {
        return mFileTypes;
    }

    static {
        mFileTypes.put("25215053", "ps,eps");
        mFileTypes.put("89504E47", "png");
        mFileTypes.put("5B6D6169", "ini");
        mFileTypes.put("AC9EBD8F", "qdf");
        mFileTypes.put("47494638", "gif");
        mFileTypes.put("41433130", "dwg");
        mFileTypes.put("44656C69", "eml");
        mFileTypes.put("000001BA", "mpg");
        mFileTypes.put("00001A00", "wk4,wk3");
        mFileTypes.put("6D6F6F76", "mov");
        mFileTypes.put("504B0304", "jar,doc,docx,xlsx,zip,ppt,pptx,war,xls,pdf,boq");
        mFileTypes.put("2E524D46", "rm,rmvb");
        mFileTypes.put("FFD8FF", "jpg");
        mFileTypes.put("2E7261FD", "ram");
        mFileTypes.put("E3828596", "pwl");
        mFileTypes.put("57415645", "wav");
        mFileTypes.put("3026B275", "asf");
        mFileTypes.put("49545346", "chm");
        mFileTypes.put("FF575043", "wpb");
        mFileTypes.put("CFAD12FE ", "dbx");
        mFileTypes.put("49492A00", "tif,tiff,dcx");
        mFileTypes.put("2142444E", "pst");
        mFileTypes.put("45860000", "qbb");
        mFileTypes.put("41564920", "avi");
        mFileTypes.put("696B2E71", "js");
        mFileTypes.put("2877696E", "js");
        mFileTypes.put("3C21444F", "html");
        mFileTypes.put("53520100", "sly");
        mFileTypes.put("D0CF11E0", "doc,docx,xls,xlsx,ppt,pptx");
        mFileTypes.put("576F7264", "lwp");
        mFileTypes.put("49443303", "mp3");
        mFileTypes.put("25504446", "pdf");
        mFileTypes.put("00000020", "mp4");
        mFileTypes.put("7F454C46", "elf");
        mFileTypes.put("7061636B", "java");
        mFileTypes.put("60EA", "arj");
        mFileTypes.put("7B5C7274", "rtf");
        mFileTypes.put("38425053", "psd");
        mFileTypes.put("464C5601", "flv");
        mFileTypes.put("1F8B08", "gz");
        mFileTypes.put("6431303A", "torrent");
        mFileTypes.put("48544D4C", "css");
        mFileTypes.put("20006040", "wk1");
        mFileTypes.put("40656368", "bat");
        mFileTypes.put("40456368", "bat");
        mFileTypes.put("494E5345", "sql");
        mFileTypes.put("4D5A9000", "exe");
        mFileTypes.put("4D5A5000", "exe");
        mFileTypes.put("4D546864", "mid");
        mFileTypes.put("CAFEBABE", "class");
        mFileTypes.put("d0cf11e0", "wps,vsd");
        mFileTypes.put("52617221", "rar,arar");
        mFileTypes.put("0xD0CF11", "ole2");
        mFileTypes.put("EFBBBF3C", "xml");
        mFileTypes.put("5374616E", "mdb");
        mFileTypes.put("4D616E69", "mf");
        mFileTypes.put("308203C9", "cer");
        mFileTypes.put("3C68746D", "html,doc");
        mFileTypes.put("23212F75", "py");
        mFileTypes.put("44435301", "asp");
        mFileTypes.put("00010000", "ttf");
        mFileTypes.put("424D5218", "dib,pcx,bmp");
        mFileTypes.put("2F2A2A0A", "java");
        mFileTypes.put("3C254020", "jsp,aspx,doc");
        mFileTypes.put("3C3F786D", "xml,jmx");
        mFileTypes.put("E4BDA0E6", "jar");
        mFileTypes.put("23204143", "crt");
        mFileTypes.put("2D2D2D2D", "cer,sql,pem");
        mFileTypes.put("30820AC8", "p12");
        mFileTypes.put("7B22636F", "json");
        mFileTypes.put("4A616D65", "csv");
        mFileTypes.put("5B4D616E", "cfg");
        mFileTypes.put("FFD8FFE0", "jpeg,jpg,pcx,tga,ppt");
        mFileTypes.put("74746366", "ttc");
        mFileTypes.put("3C3F7068", "php");
        mFileTypes.put("093CB99C", "log");
        mFileTypes.put("6578706F", "bash,sh");
        mFileTypes.put("00000014", "mp4");
        mFileTypes.put("420D0D0A", "pyc");
        mFileTypes.put("00000000", "");
        ResultSetHandler fileTypeMagicRs = rs -> {
            HashMap<String, String> fileTypeMagicNumMap = new HashMap<String, String>(8);
            while (rs.next()) {
                String fileHead = rs.getString(1);
                String fileTypeStr = rs.getString(2);
                fileTypeMagicNumMap.put(fileHead, fileTypeStr);
            }
            return fileTypeMagicNumMap;
        };
        try {
            boolean tableExist = DB.exitsTable((DBRoute)new DBRoute(ROUTE_KEY_SYS), (String)T_BAS_FILETYPE_MAGICNUM);
            if (tableExist) {
                Map fileTypeMagicNumMap = (Map)DB.query((DBRoute)new DBRoute(ROUTE_KEY_SYS), (String)"select ffileheader,ffiletypes from t_bas_filetype_magicnum", (ResultSetHandler)fileTypeMagicRs);
                for (Map.Entry fileTypeMagicNumMapEntry : fileTypeMagicNumMap.entrySet()) {
                    if (((String)fileTypeMagicNumMapEntry.getValue()).equals("NULL")) {
                        mFileTypes.remove(fileTypeMagicNumMapEntry.getKey());
                        continue;
                    }
                    mFileTypes.put((String)fileTypeMagicNumMapEntry.getKey(), (String)fileTypeMagicNumMapEntry.getValue());
                }
            }
        }
        catch (Exception e) {
            log.error("[\u9644\u4ef6\u7c7b\u578b\u5de5\u5177\u7c7b\u521d\u59cb\u5316\u5f02\u5e38\uff1a]" + e);
        }
        for (Map.Entry<String, String> it : mFileTypes.entrySet()) {
            String extString = it.getValue();
            if (extString.contains(",")) {
                presetExtList.addAll(Arrays.asList(extString.split(",")));
                continue;
            }
            presetExtList.add(extString);
        }
    }
}

