/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.property.AbstractPropertyPlugin;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;

public class UploadConfigEditPlugin
extends AbstractPropertyPlugin {
    public static final String KEY_MULTIPLE = "Multiple";
    public static final String KEY_SUFFIX = "Suffix";
    public static final String KEY_LIMITSIZE = "LimitSize";
    public static final String KEY_LIMITCOUNT = "LimitCount";
    public static final String KEY_URL = "Url";
    public static final String KEY_TEMPSTORAGE = "TempStorage";
    public static final String KEY_UNCOMPRESSPIC = "UnCompresspic";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        this.lockOkButton();
        Map value = (Map)this.getView().getFormShowParameter().getCustomParam("value");
        if (value == null) {
            return;
        }
        IDataModel model = this.getModel();
        model.setValue(KEY_MULTIPLE, (Object)value.getOrDefault(KEY_MULTIPLE, false));
        model.setValue(KEY_SUFFIX, value.get(KEY_SUFFIX));
        model.setValue(KEY_LIMITSIZE, (Object)value.getOrDefault(KEY_LIMITSIZE, 0));
        model.setValue(KEY_LIMITCOUNT, (Object)value.getOrDefault(KEY_LIMITCOUNT, 0));
        Object url = value.get(KEY_URL);
        if (StringUtils.isNotBlank(url) && url.toString().contains("?")) {
            url = url.toString().split("\\?")[0];
        }
        model.setValue(KEY_URL, url);
        model.setValue(KEY_TEMPSTORAGE, (Object)value.getOrDefault(KEY_TEMPSTORAGE, false));
        model.setValue(KEY_UNCOMPRESSPIC, (Object)value.getOrDefault(KEY_UNCOMPRESSPIC, false));
    }

    private void lockOkButton() {
        String isLock = (String)this.getView().getFormShowParameter().getCustomParam("isLock");
        if ("true".equals(isLock)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"btnok"});
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equalsIgnoreCase("btnok")) {
            this.returnDefValue();
        }
    }

    private void returnDefValue() {
        String propertyName = (String)this.getView().getFormShowParameter().getCustomParams().get("propertyName");
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", propertyName);
        para.put("value", this.getUploadConfig());
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    private Object getUploadConfig() {
        HashMap<String, Object> option = new HashMap<String, Object>(16);
        IDataModel model = this.getModel();
        String suffix = (String)model.getValue(KEY_SUFFIX);
        option.put(KEY_MULTIPLE, (Boolean)model.getValue(KEY_MULTIPLE));
        option.put(KEY_SUFFIX, suffix);
        option.put(KEY_LIMITSIZE, (Integer)model.getValue(KEY_LIMITSIZE));
        option.put(KEY_LIMITCOUNT, (Integer)model.getValue(KEY_LIMITCOUNT));
        String url = (String)model.getValue(KEY_URL);
        boolean isTempStorage = (Boolean)model.getValue("tempstorage");
        boolean uncompresspic = (Boolean)model.getValue("uncompresspic");
        boolean hasParam = false;
        if (isTempStorage) {
            option.put(KEY_URL, url.split("\\?")[0] + "?tempstorage=" + isTempStorage);
            hasParam = true;
        } else {
            option.put(KEY_URL, url.split("\\?")[0]);
        }
        if (uncompresspic) {
            option.put(KEY_URL, option.get(KEY_URL) + (hasParam ? "&uncompresspic=" + uncompresspic : "?uncompresspic=" + uncompresspic));
            hasParam = true;
        }
        if (StringUtils.isNotBlank((CharSequence)suffix)) {
            option.put(KEY_URL, option.get(KEY_URL) + (hasParam ? "&suffix=" + suffix : "?suffix=" + suffix));
        }
        option.put(KEY_TEMPSTORAGE, isTempStorage);
        option.put(KEY_UNCOMPRESSPIC, uncompresspic);
        option.put("_Type_", "UploadOption");
        return option;
    }
}

