/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.picture;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;

public class IconSelectorPlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener,
ListboxClickListener,
SearchEnterListener {
    private static final String ENTRYKEY = "entryentity";
    private static final String KEY_SEARCH = "btnsearch";
    private static final String ICON_PAGE_CACHE_ITEM_ID = "icon_pageCacheitemId";
    private static final String FNAME = "fname";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btnedit", "btnreset", "btncancel"});
        Listbox listbox = (Listbox)this.getView().getControl("listboxap");
        listbox.addListboxClickListener((ListboxClickListener)this);
        Search search = (Search)this.getView().getControl(KEY_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRYKEY);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        String level = "unit";
        String visible = "all";
        String deploystatus = "all";
        this.getPageCache().put("level", level);
        this.getPageCache().put("visible", visible);
        this.getPageCache().put("deploystatus", deploystatus);
        Listbox listbox = (Listbox)this.getControl("listboxap");
        List<ListboxItem> listboxItems = this.getCategoryNodes();
        listbox.addItems(listboxItems);
        if (listboxItems != null && listboxItems.size() > 0) {
            ListboxItem firstItem = listboxItems.get(0);
            String firstItemId = firstItem.getId();
            this.getPageCache().put(ICON_PAGE_CACHE_ITEM_ID, firstItemId);
            this.showPictureGrid(firstItemId, "");
        }
    }

    public void click(EventObject evt) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRYKEY);
        int rowIndex = grid.getEntryState().getFocusRow();
        Button btn = (Button)evt.getSource();
        switch (btn.getKey().toLowerCase()) {
            case "btnnew": {
                this.showPictureEditer(null);
                break;
            }
            case "btnedit": {
                Object id = this.getModel().getValue("id", rowIndex);
                this.showPictureEditer(id);
                break;
            }
            case "btnok": {
                if (rowIndex > -1) {
                    Object newValue = this.getModel().getValue("url0", rowIndex);
                    this.returnData(newValue);
                    break;
                }
                this.getView().close();
                break;
            }
            case "btnreset": {
                String resetValue = "";
                this.returnData(resetValue);
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() == null) {
            return;
        }
        String itemId = this.getPageCache().get(ICON_PAGE_CACHE_ITEM_ID);
        this.showPictureGrid(itemId, "");
    }

    public void entryRowClick(RowClickEvent evt) {
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRYKEY);
        int rowIndex = grid.getEntryState().getFocusRow();
        Object url = this.getModel().getValue("url0", rowIndex);
        if (StringUtils.isNotBlank((Object)url)) {
            String[] urls = new String[]{(String)url};
            this.getView().showPictureView(urls, 1);
        }
    }

    private void showPictureEditer(Object id) {
        String categoryId = this.getPageCache().get(ICON_PAGE_CACHE_ITEM_ID);
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("id", id);
        parameter.setCustomParam("categoryid", (Object)categoryId);
        parameter.setCustomParam("from", (Object)"selector");
        parameter.setFormId("ide_pictureresediter");
        String type = "view";
        if (ObjectUtils.isEmpty((Object)id)) {
            parameter.setStatus(OperationStatus.ADDNEW);
            type = "add";
        } else {
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setPkId(id);
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, type));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void returnData(Object value) {
        String newValue = "";
        if (StringUtils.isNotBlank((Object)value)) {
            if (value.toString().contains("?")) {
                String[] arrValue = value.toString().split("\\?");
                if (arrValue.length > 1) {
                    newValue = arrValue[0];
                }
            } else {
                newValue = value.toString();
            }
            String rootUrl = UrlService.getDomainContextUrl();
            if (rootUrl.endsWith("/")) {
                rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
            }
            newValue = StringUtils.substringAfter((String)newValue, (String)rootUrl);
        }
        HashMap para = new HashMap(16);
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        para.put("value", newValue);
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    private void showPictureGrid(String categoryId, String searchtxt) {
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData(ENTRYKEY);
        model.getDataEntity(true);
        model.endInit();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter pathFilter = null;
        if (StringUtils.equals((CharSequence)categoryId, (CharSequence)"root")) {
            String rootNumber = this.getLongNumber();
            String path = "/" + rootNumber.replace(".", "/") + "/";
            pathFilter = new QFilter("fpath", "like", (Object)(path + "%"));
        } else {
            pathFilter = new QFilter("categoryid", "=", (Object)Long.parseLong(categoryId));
        }
        filters.add(pathFilter);
        if (StringUtils.isNotBlank((CharSequence)searchtxt)) {
            String tt = searchtxt;
            if (tt.contains(",")) {
                ArrayList<QFilter> searchFilters = new ArrayList<QFilter>(10);
                String[] arrSearchTxt = tt.split(",");
                for (int i = 0; i < arrSearchTxt.length; ++i) {
                    QFilter nameFilter = new QFilter(FNAME, "like", (Object)("%" + arrSearchTxt[i] + "%"));
                    QFilter tagFilter = new QFilter("ftag", "like", (Object)("%" + arrSearchTxt[i] + "%"));
                    searchFilters.add(nameFilter);
                    searchFilters.add(tagFilter);
                }
                QFilter f1 = (QFilter)searchFilters.get(0);
                for (int i = 1; i < searchFilters.size(); ++i) {
                    f1 = f1.or((QFilter)searchFilters.get(i));
                }
                filters.add(f1);
            } else {
                QFilter f1 = new QFilter(FNAME, "like", (Object)("%" + searchtxt + "%"));
                QFilter f2 = new QFilter("ftag", "like", (Object)("%" + searchtxt + "%"));
                filters.add(f1.or(f2));
            }
        }
        String orderBy = "fname asc";
        Map pics = BusinessDataServiceHelper.loadFromCache((String)"ide_pictureresediter", (String)"id, fname, furl0", (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)orderBy);
        if (pics.size() > 0) {
            int i = 0;
            String rootUrl = UrlService.getDomainContextUrl();
            if (rootUrl.endsWith("/")) {
                rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
            }
            model.beginInit();
            model.batchCreateNewEntryRow(ENTRYKEY, pics.size());
            for (DynamicObject obj : pics.values()) {
                model.setValue("id", obj.get("id"), i);
                model.setValue("name", (Object)obj.getLocaleString(FNAME), i);
                Object url0 = obj.get("furl0");
                if (StringUtils.isNotBlank((Object)url0)) {
                    if (url0.toString().startsWith("/")) {
                        model.setValue("url0", (Object)(rootUrl + url0), i);
                    } else {
                        model.setValue("url0", (Object)(rootUrl + "/" + url0), i);
                    }
                }
                ++i;
            }
            model.endInit();
        }
        this.getView().updateView(ENTRYKEY);
    }

    private List<ListboxItem> getCategoryNodes() {
        ArrayList<ListboxItem> nodes = new ArrayList<ListboxItem>();
        String longNumber = this.getLongNumber();
        QFilter[] filters = null;
        QFilter f1 = new QFilter("longnumber", "like", (Object)(longNumber + ".%"));
        filters = new QFilter[]{f1};
        String orderby = "name asc";
        Map bizClouds = BusinessDataServiceHelper.loadFromCache((String)"bos_resourcecategory", (String)"*", (QFilter[])filters, (String)orderby);
        for (DynamicObject row : bizClouds.values()) {
            Object id = row.get("id");
            Object number = row.get("number");
            String name = row.getString("name");
            if (!StringUtils.isNotBlank((Object)number) || !StringUtils.isNotBlank((Object)name)) continue;
            ListboxItem node = new ListboxItem();
            node.setId(id.toString());
            node.setContent(row.getString("name"));
            nodes.add(node);
        }
        return nodes;
    }

    public void search(SearchEnterEvent evt) {
        String path = this.getPageCache().get(ICON_PAGE_CACHE_ITEM_ID);
        Search search = (Search)evt.getSource();
        if (StringUtils.equals((CharSequence)KEY_SEARCH, (CharSequence)search.getKey())) {
            String searchText = evt.getText();
            if (StringUtils.isBlank((CharSequence)searchText)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6807\u9898\u6216\u6807\u7b7e", (String)"IconSelectorPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
            } else {
                this.showPictureGrid(path, searchText);
            }
        }
    }

    private String getLongNumber() {
        Object modeType = this.getView().getFormShowParameter().getCustomParams().get("modelType");
        Object isPc = this.getView().getFormShowParameter().getCustomParams().get("isPC");
        StringBuilder sb = new StringBuilder();
        sb.append("icons");
        sb.append(".");
        if ("MobileBillFormModel".equals(modeType) || "MobileFormModel".equals(modeType)) {
            sb.append("mobile");
        } else if (isPc == null || ((Boolean)isPc).booleanValue()) {
            sb.append("pc");
        } else {
            sb.append("mobile");
        }
        return sb.toString();
    }

    public void listboxClick(ListboxEvent evt) {
        String itemId = evt.getItemId();
        this.getPageCache().put(ICON_PAGE_CACHE_ITEM_ID, itemId);
        this.showPictureGrid(itemId, "");
    }
}

