/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.picture;

import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.property.picture.common.PictureResourceKit;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FieldTip;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.upload.UploadOption;

public class PictureResourcePlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String BTN_UPLOAD = "btnupload";
    private static final String FPATH = "fpath";
    private static final String FURL_0 = "furl0";
    private static final String CATEGORY_ID = "categoryid";
    private static final String FNAME = "fname";
    private static final String BOS_PICTURE = "bos-picture";

    public void initialize() {
        this.addClickListeners(new String[]{"btncancel", BTN_UPLOAD, "btnok", FPATH});
    }

    public void afterCreateNewData(EventObject evt) {
        String currentIsv = ISVService.getISVInfo().getId();
        if (StringUtils.isNotBlank((CharSequence)currentIsv) && !"kingdee".equalsIgnoreCase(currentIsv)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{FPATH});
        }
    }

    public void afterBindData(EventObject e) {
        Object fname;
        DynamicObject pictureInfo;
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        Object fullPath = this.getModel().getValue(FURL_0);
        if (StringUtils.isNotBlank((Object)fullPath)) {
            String fileName = StringUtils.substringAfterLast((String)fullPath.toString(), (String)"/");
            fileName = StringUtils.substringBefore((String)fileName, (String)".");
            this.getModel().setValue("ffilename", (Object)fileName);
        }
        if (status == OperationStatus.VIEW) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{CATEGORY_ID, "ftag", FURL_0, "fnumber", FNAME});
        } else if (status == OperationStatus.EDIT) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{CATEGORY_ID, FURL_0});
        } else if (status == OperationStatus.ADDNEW) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{FURL_0});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{CATEGORY_ID, FPATH, "ftag", FURL_0, "fnumber", FNAME});
        }
        String currentIsv = ISVService.getISVInfo().getId();
        this.getModel().setValue("isv", (Object)currentIsv);
        String name = "";
        Object id = this.getView().getFormShowParameter().getCustomParam("id");
        if (!ObjectUtils.isEmpty((Object)id) && (pictureInfo = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ide_pictureresediter", (String)FNAME)) != null && (fname = pictureInfo.get(FNAME)) != null) {
            name = ((OrmLocaleValue)fname).getLocaleValue();
            if (StringUtils.isEmpty((CharSequence)name)) {
                name = ((OrmLocaleValue)fname).getLocaleValue_zh_CN();
            }
            this.getModel().setValue(FNAME, (Object)name);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        switch (btn.getKey().toLowerCase()) {
            case "btnupload": {
                UploadOption opt = new UploadOption();
                opt.setMultiple(true);
                opt.setTitle(ResManager.loadKDString((String)"\u4e0a\u4f20\u56fe\u7247", (String)"PictureResourcePlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
                opt.setSuffix(".png");
                this.getView().showUpload(opt, BTN_UPLOAD);
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object path;
        super.closedCallBack(event);
        if ("edit".equals(event.getActionId()) && (path = event.getReturnData()) != null) {
            this.getModel().setValue(FPATH, path);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String categoryPath = String.valueOf(this.getView().getModel().getValue(FPATH));
        FieldTip fieldTip = this.genFieldTip(FPATH);
        if (!PictureResourceKit.checkPathValidity(categoryPath)) {
            this.getView().showFieldTip(fieldTip);
            args.setCancel(true);
        }
        if (!PictureResourceKit.checkPathCategoryValidity(categoryPath)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8def\u5f84\u9519\u8bef\u65f6\u63d0\u793a\u5206\u7c7b\u8def\u5f84\u683c\u5f0f\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u6839\u636e\u9759\u6001\u8d44\u6e90git\u4ed3\u5e93\u5730\u5740\u586b\u5199\uff0c\u8def\u5f84\u89c4\u8303\uff1a/icons/...\u3001/images/...\u3001/kingdee/\u9886\u57df\u6807\u8bc6/images/...", (String)"ImageAction_5", (String)BOS_PICTURE, (Object[])new Object[0]));
            args.setCancel(true);
        }
        Object path = this.getModel().getValue(FPATH);
        Object fileName = this.getModel().getValue("ffilename");
        Object format = this.getModel().getValue("fformat");
        String fullPath = null;
        fullPath = fileName.toString().contains(".") ? path.toString() + fileName.toString() : path.toString() + fileName.toString() + "." + format;
        this.getModel().setValue(FURL_0, (Object)fullPath);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        boolean isCategoryChanged = e.getProperty().getName().equals(CATEGORY_ID);
        boolean isPath = e.getProperty().getName().equals(FPATH);
        if (isCategoryChanged) {
            if (e.getChangeSet()[0].getNewValue() != null) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{FURL_0});
                this.getModel().setValue(FURL_0, (Object)"");
                this.setPath();
            } else {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{FURL_0});
                this.getModel().setValue(FURL_0, (Object)"");
            }
        }
        if (isPath) {
            String categoryPath = String.valueOf(this.getView().getModel().getValue(FPATH));
            FieldTip fieldTip = this.genFieldTip(FPATH);
            if (!PictureResourceKit.checkPathValidity(categoryPath)) {
                this.getView().showFieldTip(fieldTip);
            } else {
                fieldTip.setSuccess(true);
                this.getView().showFieldTip(fieldTip);
            }
        }
    }

    private FieldTip genFieldTip(String fieldKey) {
        FieldTip fieldTip = new FieldTip();
        fieldTip.setTip(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u82f1\u6587\u5b57\u7b26\u3001\u6570\u5b57\u3001-\u3001_\u3001\u7a7a\u683c\u548c/", (String)"ImageAction_4", (String)BOS_PICTURE, (Object[])new Object[0]));
        fieldTip.setFieldKey(fieldKey);
        fieldTip.setTipsType(FieldTip.FieldTipsTypes.others);
        fieldTip.setLevel(FieldTip.FieldTipsLevel.Info);
        fieldTip.setSuccess(false);
        return fieldTip;
    }

    private void setPath() {
        DynamicObject categoryId = (DynamicObject)this.getModel().getValue(CATEGORY_ID);
        DynamicObject categoryObj = BusinessDataServiceHelper.loadSingle((Object)categoryId.getPkValue(), (String)"bos_resourcecategory");
        String longNumber = (String)categoryObj.get("longnumber");
        String path = "/" + longNumber.replace(".", "/") + "/";
        this.getModel().setValue(FPATH, (Object)path);
    }
}

