/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.image;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import kd.bos.attachment.manage.ImageManageService;
import kd.bos.fileservice.BatchDownloadRequest;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.web.actions.utils.FilePathUtil;

public class ImgFileService
implements FileService {
    private FileService targetService;
    private ImageManageService manageService = new ImageManageService();

    public ImgFileService() {
        this.targetService = FileServiceFactory.getImageFileService();
    }

    private String getReturnUpload(FileItem fileItem, String upload) {
        String path = fileItem.getPath();
        String suffix = path.substring(path.lastIndexOf("."));
        if (!upload.contains(suffix)) {
            return upload + suffix;
        }
        return upload;
    }

    public String dealPath(String path) {
        path = FilePathUtil.dealPathParam((String)path);
        if (this.manageService.isFilePath(path = this.handRequestPath(path))) {
            return path;
        }
        return this.manageService.getAttachPath(path);
    }

    private String handRequestPath(String path) {
        if (this.manageService.isFilePath(path)) {
            return path;
        }
        if (path.contains("_thumbnails_")) {
            path = this.manageService.getThumbnailPathByOri(path);
        }
        return path;
    }

    public String compressPicUpload(FileItem fileItem, long capacity) {
        String upload = this.targetService.compressPicUpload(fileItem, capacity);
        return this.getReturnUpload(fileItem, upload);
    }

    public void download(String path, OutputStream out, String userAgent) {
        path = this.handRequestPath(path);
        this.targetService.download(path, out, userAgent);
    }

    public boolean exists(String path) {
        path = this.handRequestPath(path);
        return this.targetService.exists(path);
    }

    public void download(String path, HttpServletResponse servletResponse, String userAgent) {
        path = this.handRequestPath(path);
        this.targetService.download(path, servletResponse, userAgent);
    }

    public Map<String, Object> download(String path, String userAgent, String ext) {
        path = this.handRequestPath(path);
        return this.targetService.download(path, userAgent, ext);
    }

    public InputStream download(String path, Map<String, String> header, Map<String, String> resHeader) {
        path = this.handRequestPath(path);
        return this.targetService.download(path, header, resHeader);
    }

    public InputStream getInputStream(String path) {
        return this.targetService.getInputStream(path);
    }

    public String upload(FileItem fileItem) {
        String upload = this.targetService.upload(fileItem);
        return this.getReturnUpload(fileItem, upload);
    }

    public List<String> upload(FileItem[] fileItems) {
        List uploads = this.targetService.upload(fileItems);
        ArrayList<String> returns = new ArrayList<String>(uploads.size());
        for (int i = 0; i < fileItems.length; ++i) {
            returns.add(this.getReturnUpload(fileItems[i], (String)uploads.get(i)));
        }
        return returns;
    }

    public void delete(String path) {
        path = this.handRequestPath(path);
        this.targetService.delete(path);
    }

    public void batchDownload(BatchDownloadRequest request, OutputStream out, String userAgent) {
        this.targetService.batchDownload(request, out, userAgent);
    }

    public void batchDownload(BatchDownloadRequest request, HttpServletResponse servletResponse, String userAgent) {
        this.targetService.batchDownload(request, servletResponse, userAgent);
    }

    public List<String> getForbiddenExtensions() {
        return this.targetService.getForbiddenExtensions();
    }

    public List<String> getAllowExtensions() {
        return this.targetService.getAllowExtensions();
    }

    public int getMaxUploadSize() {
        return this.targetService.getMaxUploadSize();
    }

    public String getTicket() {
        return this.targetService.getTicket();
    }

    public Map<String, Object> preview(String fileName, String path, String userAgent) {
        return this.targetService.preview(fileName, path, userAgent);
    }

    public void removePreview(String id) {
        this.targetService.removePreview(id);
    }

    public Map<String, Object> previewFromCache(String fileName, String path, String userAgent, InputStream cacheIn) {
        return this.targetService.previewFromCache(fileName, path, userAgent, cacheIn);
    }

    public Map<String, Object> previewWPS(String fileName, String path, String userAgent, Map<String, String> config) {
        return this.targetService.previewWPS(fileName, path, userAgent, config);
    }

    public Map<String, Object> previewFromCacheWPS(String fileName, String path, String userAgent, InputStream cacheIn, Map<String, String> config) {
        return this.targetService.previewFromCacheWPS(fileName, path, userAgent, cacheIn, config);
    }

    public void deletePreviewCacheWps(String url, Map<String, String> config) {
        this.targetService.deletePreviewCacheWps(url, config);
    }

    public void deletePreviewWps(String path, Map<String, String> config) {
        this.targetService.deletePreviewWps(path, config);
    }
}

