/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.watermark.common;

import java.awt.Color;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kd.bos.attachment.util.FileSecurityUtil;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.impl.WatermarkService;
import kd.bos.fileservice.watermark.WatermarkParameter;
import kd.bos.form.attachment.util.AttachmentPreviewUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.bos.web.DispatchServiceHelper;

public class WaterMarkKit {
    private static Log log = LogFactory.getLog(WaterMarkKit.class);
    private static final String IMG_EXT = "bmp,gif,jpg,png,jpeg,dib,emf,jfif,jpe,rle,wmf,tif,pcx,tga,exif,fpx,svg,psd,cdr,pcd,dxf,ufo,eps,ai,raw,webp,avif";
    private static final String PDF_EXT = "pdf";

    public static InputStream addWaterMark(HttpServletRequest request, String name, InputStream in) {
        try {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("result", in);
            result.put("status", "doDownloadAllWaterMark");
            boolean fromOnlyOffice = AttachmentPreviewUtil.fromOnlyOfficeDownLoad((HttpServletRequest)request);
            WaterMarkKit.dealWaterMark(request, name, result, fromOnlyOffice);
            if (result.get("result") instanceof InputStream) {
                return (InputStream)result.get("result");
            }
        }
        catch (IOException e) {
            log.error("kd.bos.web.actions.AttachmentAction.addWaterMark -- ", (Throwable)e);
        }
        return in;
    }

    public static boolean isAddDownloadWaterMark(String fileName, HttpServletRequest request) {
        return WaterMarkKit.isAddDownloadWaterMark(fileName, request, false);
    }

    public static boolean isAddDownloadWaterMark(String fileName, HttpServletRequest request, boolean isFromOnlyOffice) {
        String ext = fileName.substring(fileName.lastIndexOf(46) + 1).toLowerCase();
        return (PDF_EXT.contains(ext) || IMG_EXT.contains(ext)) && (Boolean)WaterMarkKit.getWaterMarkMap(fileName, request.getParameter("fId"), isFromOnlyOffice).get("isAddWaterMark") != false;
    }

    public static Boolean dealWaterMark(HttpServletRequest request, String fileName, Map<String, Object> result, boolean isPreview) throws IOException {
        String fId = request.getParameter("fId");
        Map<String, Object> watermarkMap = WaterMarkKit.getWaterMarkMap(fileName, fId, isPreview);
        Boolean isAddWaterMark = (Boolean)watermarkMap.get("isAddWaterMark");
        String type = (String)watermarkMap.get("type");
        if (isAddWaterMark.booleanValue()) {
            WatermarkService watermarkService;
            InputStream imageInputStream;
            String text;
            block9: {
                log.debug("AttachmentAction.preview.watermarkMap : " + SerializationUtils.toJsonString(watermarkMap));
                text = (String)watermarkMap.get("text");
                String picture = (String)watermarkMap.get("picture");
                imageInputStream = null;
                if (!"1".equals(type) && StringUtils.isNotBlank((CharSequence)picture)) {
                    String domainContextUrl = UrlService.getDomainContextUrl();
                    picture = domainContextUrl.endsWith("/") ? domainContextUrl.substring(0, domainContextUrl.lastIndexOf(47)) + picture : domainContextUrl + picture;
                    try {
                        URL url = new URL(picture);
                        imageInputStream = url.openConnection().getInputStream();
                    }
                    catch (Exception e) {
                        imageInputStream = null;
                        type = "1";
                        log.debug("AttachmentAction.preview.\u83b7\u53d6\u6587\u4ef6\u6d41\u5931\u8d25,url : " + picture);
                    }
                }
                if ((watermarkService = new WatermarkService()).checkValid(imageInputStream, text, Integer.parseInt(type))) break block9;
                log.debug("watermarkService.checkValid.param : text = " + text + "&type=" + type + "&fileName=" + fileName + "&imageInputStream=" + (imageInputStream == null));
                Boolean e = Boolean.FALSE;
                FileSecurityUtil.safeClose((Closeable)imageInputStream);
                return e;
            }
            try {
                log.debug("watermarkService.addWaterPreview.param : text = " + text + "&type=" + type + "&fileName=" + fileName + "&imageInputStream=" + (imageInputStream == null));
                WatermarkParameter parameter = WaterMarkKit.getWatermarkParameter(watermarkMap, type, text, imageInputStream);
                watermarkService.addWatermark(result, fileName, parameter);
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    FileSecurityUtil.safeClose(imageInputStream);
                    throw throwable;
                }
            }
            FileSecurityUtil.safeClose((Closeable)imageInputStream);
        }
        return isAddWaterMark;
    }

    private static WatermarkParameter getWatermarkParameter(Map<String, Object> watermarkMap, String type, String text, InputStream imageInputStream) {
        log.debug(watermarkMap.toString());
        WatermarkParameter.Builder builder = new WatermarkParameter.Builder(Integer.valueOf(Integer.parseInt(type)), text, imageInputStream);
        String fontSize = (String)watermarkMap.get("fontSize");
        String substring = "12";
        if (StringUtils.isNotBlank((CharSequence)fontSize) && fontSize.endsWith("px")) {
            substring = fontSize.substring(0, fontSize.length() - 2);
        }
        int size = Integer.parseInt(substring);
        Integer globalAlpha = (Integer)watermarkMap.get("globalAlpha");
        if (globalAlpha == null) {
            globalAlpha = 10;
        }
        float alpha = (float)globalAlpha.intValue() / 100.0f;
        Color color = Color.BLACK;
        String colorString = (String)watermarkMap.get("color");
        if (StringUtils.isNotBlank((CharSequence)colorString)) {
            color = Color.decode(colorString);
        }
        WatermarkParameter parameter = builder.setPosition("").setRotation(Integer.valueOf(10)).setSize(Integer.valueOf(size)).setAlpha(Float.valueOf(alpha)).setColor(color).setImage(imageInputStream).build();
        return parameter;
    }

    public static Map<String, Object> getWaterMarkMap(String fileName, String fid, boolean isPreview) {
        HashMap<String, Object> watermarkMap = new HashMap<String, Boolean>();
        Object watermark = WaterMarkKit.getWatermark(fileName, fid);
        if (!(watermark instanceof Map) || ((Map)watermark).size() <= 0) {
            watermarkMap.put("isAddWaterMark", false);
            return watermarkMap;
        }
        watermarkMap = (Map)watermark;
        String type = (String)watermarkMap.get("type");
        Boolean hasWaterMark = (Boolean)watermarkMap.get("visible") != false && StringUtils.isNotBlank((CharSequence)type) && !"0".equals(type);
        boolean addPreviewWatermark = Boolean.parseBoolean(watermarkMap.get("addpreviewwatermark") + "");
        boolean addDownloadWatermark = Boolean.parseBoolean(watermarkMap.get("adddownloadwatermark") + "");
        Boolean isAddWaterMark = hasWaterMark != false && (isPreview ? addPreviewWatermark : addDownloadWatermark);
        watermarkMap.put("isAddWaterMark", isAddWaterMark);
        return watermarkMap;
    }

    private static Object getWatermark(String fileName, String formNumber) {
        Object watermark = null;
        if (StringUtils.isBlank((CharSequence)formNumber)) {
            if (fileName == null || !fileName.endsWith(".txt")) {
                HashMap watermarkMap = new HashMap();
                return watermarkMap;
            }
            watermark = WaterMarkKit.getTxtMobileWaterMark(fileName);
            return watermark;
        }
        watermark = DispatchServiceHelper.invokeBOSService((String)"IAttachmentService", (String)"getAttachmentWaterMark", (Object[])new Object[]{formNumber});
        watermark = watermark instanceof Map && ((Map)watermark).size() > 0 ? watermark : WaterMarkKit.getTxtMobileWaterMark(fileName);
        return watermark;
    }

    private static Map<String, Object> getTxtMobileWaterMark(String fileName) {
        HashMap<String, Object> watermarkMap = new HashMap<String, Object>();
        if (fileName == null || !fileName.toLowerCase(Locale.ENGLISH).endsWith(".txt")) {
            return watermarkMap;
        }
        watermarkMap.put("type", "1");
        watermarkMap.put("visible", Boolean.TRUE);
        watermarkMap.put("text", " ");
        watermarkMap.put("addpreviewwatermark", true);
        watermarkMap.put("adddownloadwatermark", false);
        return watermarkMap;
    }
}

