/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.servicehelper.smc.ManageServiceHelper;
import kd.bos.svc.util.TreeNodeFilter;

public class WaterMarkLoadUtils {
    private WaterMarkLoadUtils() {
    }

    public static List<TreeNode> loadCloudNodes(TreeNode root) {
        if (root == null) {
            return new ArrayList<TreeNode>(0);
        }
        List<TreeNode> cloudNodes = WaterMarkLoadUtils.getCloudNodes();
        root.setChildren(cloudNodes);
        if (!WaterMarkLoadUtils.hasChildren(root)) {
            root.setChildren(new ArrayList(1));
        }
        return root.getChildren();
    }

    public static List<TreeNode> loadAppNodes(TreeNode cloudNode) {
        if (cloudNode == null) {
            return new ArrayList<TreeNode>(0);
        }
        if (WaterMarkLoadUtils.hasChildren(cloudNode)) {
            return cloudNode.getChildren();
        }
        List<TreeNode> appNodes = WaterMarkLoadUtils.getAppNodesByCloudId(cloudNode.getId());
        cloudNode.setChildren(appNodes);
        if (!WaterMarkLoadUtils.hasChildren(cloudNode)) {
            cloudNode.setChildren(new ArrayList(1));
        }
        return cloudNode.getChildren();
    }

    public static List<TreeNode> loadEntityNodes(TreeNode appNode) {
        QFilter bizAppFilter;
        if (appNode == null) {
            return new ArrayList<TreeNode>(0);
        }
        if (WaterMarkLoadUtils.hasChildren(appNode)) {
            return appNode.getChildren();
        }
        ArrayList<TreeNode> childrenNode = new ArrayList<TreeNode>(10);
        QFilter modelTypeFilter = new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel", "QueryListModel"));
        QFilter[] filters = new QFilter[]{modelTypeFilter, bizAppFilter = new QFilter("bizappid", "in", WaterMarkLoadUtils.getAppIdsBy(appNode.getId()))};
        Map formCol = BusinessDataServiceHelper.loadFromCache((String)"bos_entityobject", (String)"id,number,name,basedatafield", (QFilter[])filters);
        if (formCol == null || formCol.size() == 0) {
            appNode.setChildren(new ArrayList(1));
            return appNode.getChildren();
        }
        for (DynamicObject object : formCol.values()) {
            TreeNode subNode = new TreeNode();
            subNode.setId(object.getString("number"));
            subNode.setText(object.getString("name"));
            subNode.setData((Object)"object");
            subNode.setParentid(appNode.getId());
            childrenNode.add(subNode);
        }
        appNode.setChildren(childrenNode);
        return appNode.getChildren();
    }

    public static Map<String, Set<String>> queryBizappByName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return new HashMap<String, Set<String>>(0);
        }
        String localeid = RequestContext.get().getLang().name();
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fid, A.FMASTERID, al.fname,a.fbizcloudid ");
        sql.append(" from t_meta_bizapp a ");
        sql.append(" inner join t_meta_bizapp_l al ");
        sql.append(" on a.fid = al.fid ");
        sql.append(" where al.flocaleid = '").append(localeid).append("' ");
        sql.append(" and al.fname like ? escape '/'");
        sql.append(" order by a.fbizcloudid, a.fid asc");
        Object[] params = new SqlParameter[]{new SqlParameter(":fname", 12, (Object)("%" + name + "%"))};
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])params, rs -> {
            HashMap result = new HashMap(16);
            while (rs.next()) {
                LinkedHashSet<String> set;
                String cloudId;
                String id = rs.getString(1);
                if (StringUtils.isBlank((CharSequence)id)) continue;
                String masterid = rs.getString(2);
                if (StringUtils.isNotBlank((CharSequence)masterid)) {
                    id = masterid;
                }
                if (StringUtils.isBlank((CharSequence)(cloudId = rs.getString(4)))) continue;
                if (result.containsKey(cloudId)) {
                    set = (LinkedHashSet<String>)result.get(cloudId);
                    set.add(id);
                    continue;
                }
                set = new LinkedHashSet<String>(10);
                set.add(id);
                result.put(cloudId, set);
            }
            return result;
        });
    }

    public static Map<String, Set<String>> queryEntityByText(String searchText) {
        HashMap<String, Set<String>> res = new HashMap<String, Set<String>>(16);
        if (StringUtils.isBlank((CharSequence)searchText)) {
            return res;
        }
        QFilter modelTypeFilter = new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel", "QueryListModel"));
        QFilter nameFilter = new QFilter("name", "like", (Object)("%" + searchText + "%"));
        QFilter[] filters = new QFilter[]{modelTypeFilter, nameFilter};
        filters = RunModeServiceHelper.getEntityIdBlacklistFilters((QFilter[])filters, (String)"dentityid");
        Map formCol = BusinessDataServiceHelper.loadFromCache((String)"bos_entityobject", (String)"id,bizappid,number,name,basedatafield", (QFilter[])filters, (String)"bizappid,id asc");
        for (DynamicObject object : formCol.values()) {
            DynamicObject appDyObj = object.getDynamicObject("bizappid");
            if (appDyObj == null) continue;
            Object appId = appDyObj.getPkValue();
            Set<String> nodes = new LinkedHashSet<String>(10);
            if (res.containsKey(String.valueOf(appId))) {
                nodes = (Set)res.get(String.valueOf(appId));
            }
            String id = object.getString("number");
            nodes.add(id);
            res.put((String)appId, nodes);
        }
        return res;
    }

    public static String searchCloudIdByAppId(String appId) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            return "";
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select fid, fbizcloudid");
        sql.append(" from t_meta_bizapp");
        sql.append(" where fid = '").append(appId).append("' ");
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), null, rs -> {
            String result = "";
            while (rs.next()) {
                String bizcloudid = rs.getString(2);
                if (StringUtils.isBlank((CharSequence)bizcloudid)) continue;
                result = bizcloudid;
            }
            return result;
        });
    }

    private static boolean hasChildren(TreeNode node) {
        return node.getChildren() != null && !node.getChildren().isEmpty();
    }

    public static List<String> getAppIdsBy(String appId) {
        DynamicObjectCollection allApps = BizAppServiceHelp.getAllBizApps();
        String masterId = allApps.stream().filter(obj -> StringUtils.equals((CharSequence)appId, (CharSequence)obj.getString("id"))).findFirst().map(app -> {
            String tType = app.getString("type");
            if (StringUtils.equals((CharSequence)"0", (CharSequence)tType)) {
                return app.getString("id");
            }
            return app.getString("masterid");
        }).orElse("");
        if (StringUtils.isBlank((CharSequence)masterId)) {
            return new ArrayList<String>();
        }
        Set disabledAppIds = ManageServiceHelper.getDisabledAppIds();
        return allApps.stream().filter(obj -> {
            String tId = obj.getString("id");
            String tMasterId = obj.getString("masterid");
            return (StringUtils.equals((CharSequence)masterId, (CharSequence)tId) || StringUtils.equals((CharSequence)masterId, (CharSequence)tMasterId)) && !disabledAppIds.contains(tId);
        }).map(obj -> obj.getString("id")).collect(Collectors.toList());
    }

    public static List<TreeNode> getCloudNodes() {
        TreeNode root = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree(null, null, null, (String)"cloud");
        List clouds = null;
        if (root != null) {
            clouds = root.getChildren();
        }
        if (clouds == null) {
            return new ArrayList<TreeNode>();
        }
        for (TreeNode cloud : clouds) {
            cloud.setChildren(new ArrayList());
        }
        return new TreeNodeFilter(TreeNodeFilter.FilterTypeEnum.ONLY_CLOUD).filterCloudTreeNode(clouds);
    }

    public static List<TreeNode> getAppNodesByCloudId(String cloudNodeId) {
        TreeNode root = (TreeNode)BizAppServiceHelp.getRuntimeSubsysTree((String[])new String[]{cloudNodeId}, null, null, (String)"app");
        List clouds = null;
        if (root != null) {
            clouds = root.getChildren();
        }
        if (clouds == null || clouds.isEmpty()) {
            return new ArrayList<TreeNode>();
        }
        List apps = ((TreeNode)clouds.get(0)).getChildren();
        if (apps == null || apps.isEmpty()) {
            return new ArrayList<TreeNode>();
        }
        for (TreeNode app : apps) {
            if (app == null) continue;
            app.setChildren(new ArrayList(0));
        }
        return new TreeNodeFilter(TreeNodeFilter.FilterTypeEnum.ONLY_APP).filterAppTreeNode(apps);
    }
}

