/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.impt;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kd.bos.bill.events.ConvertPkEvent;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.ModelEventProxy;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.export.util.ImpExpAttachmentUtil;
import kd.bos.form.FormShowParameter;
import kd.bos.form.impt.AbstractSave;
import kd.bos.form.impt.ImportBillData;
import kd.bos.form.impt.ImportRequestDataResolve;
import kd.bos.form.impt.context.MetadataContext;
import kd.bos.form.impt.context.ResultContext;
import kd.bos.form.impt.process.ImportDataProcess;
import kd.bos.form.impt.process.ImportDataSaveFunction;
import kd.bos.form.impt.process.factory.ImportDataProcessFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import org.apache.commons.beanutils.ConvertUtils;

public class ImportDataSaveNew
extends AbstractSave {
    private static final Log log = LogFactory.getLog(ImportDataSaveNew.class);
    private static final String BOS_IMPORT = "bos-import";
    private ImportRequestDataResolve importRequestDataResolve;
    private MetadataContext metadataContext;
    private ResultContext resultContext;
    private List<ImportDataProcess> importDataProcesses;

    public void initialize(String formId, Map<String, Object> requestData) {
        super.initialize(formId, requestData);
        this.importRequestDataResolve = new ImportRequestDataResolve(this.requestData);
        this.metadataContext = this.createMetadataContext(requestData);
        this.resultContext = new ResultContext();
        if (this.importDataProcesses == null) {
            ImportDataProcessFactory processFactory = new ImportDataProcessFactory(this.getView());
            this.importDataProcesses = processFactory.newInstances();
            this.importDataProcesses.stream().filter(importDataProcess -> importDataProcess instanceof ImportDataSaveFunction).forEach(importDataProcess -> this.initImportDataSaveFunction((ImportDataSaveFunction)((Object)importDataProcess)));
            this.importDataProcesses.forEach(importDataProcess -> importDataProcess.init(this.getView(), this.metadataContext, this.resultContext));
        }
    }

    public ApiResult execute() {
        if (this.metadataContext.getSourceDatas().isEmpty()) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5728\u8f93\u5165\u53c2\u6570\u5b57\u5178\u4e2d\uff0c\u6ca1\u6709\u627e\u5230\u6570\u636e\u53c2\u6570data\u6216datas\u8282\u70b9", (String)"ImportDataSave_0", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
        IDataModel model = this.getView().getModel();
        model.putContextVariable("MODEL_INIT_BY_WEBAPI", (Object)Boolean.TRUE);
        this.importEventWhenInit(model);
        this.executeProcess();
        return this.resultContext.getApiResult();
    }

    private void executeProcess() {
        try {
            for (ImportDataProcess importDataProcess : this.importDataProcesses) {
                importDataProcess.process(this.getView(), this.metadataContext, this.resultContext);
            }
        }
        catch (Throwable e) {
            log.warn(e);
            ApiResult ex = ApiResult.ex((Throwable)e, (boolean)SystemParamServiceHelper.isShowStackTrace());
            this.resultContext.setApiResult(ex);
        }
    }

    private MetadataContext createMetadataContext(Map<String, Object> requestData) {
        List<Map<String, Object>> sourceDatas = this.importRequestDataResolve.getSourceDatas();
        String importType = this.importRequestDataResolve.getImportType();
        String keyFields = this.importRequestDataResolve.getKeyFields();
        String appId = this.importRequestDataResolve.getAppId();
        boolean forUpdateMultiLangFields = this.importRequestDataResolve.isForUpdateMultiLangFields();
        boolean firePropChanged = this.importRequestDataResolve.isFirePropChanged();
        String operationNumber = this.importRequestDataResolve.getOperationNumber(this.getOperationNumber());
        String attDirPath = this.importRequestDataResolve.getAttDirPath();
        boolean overrideEntry = this.importRequestDataResolve.isOverrideEntry();
        boolean onlyValidate = this.importRequestDataResolve.isOnlyValidate();
        Map<String, Object> option = this.importRequestDataResolve.getOptions();
        String formShowParameterAppId = this.importRequestDataResolve.getFormShowParameterAppId();
        List<ImportBillData> importBillDatas = this.buildImportBillData(sourceDatas);
        MetadataContext metadataContext = new MetadataContext();
        metadataContext.setImportBillDatas(importBillDatas);
        metadataContext.setImportType(importType);
        metadataContext.setKeyFields(keyFields);
        metadataContext.setAppId(appId);
        metadataContext.setForUpdateMultiLangFields(forUpdateMultiLangFields);
        metadataContext.setFirePropChanged(firePropChanged);
        metadataContext.setOperationNumber(operationNumber);
        metadataContext.setDataConvertOrder(this.dataConvertOrder);
        metadataContext.setOverrideEntry(overrideEntry);
        metadataContext.setOnlyValidate(onlyValidate);
        metadataContext.setAttDirPath(attDirPath);
        metadataContext.setAttachmentPanelAps(this.getAttachmentPanelAps());
        metadataContext.setOptions(option);
        metadataContext.setRequestData(requestData);
        metadataContext.setSourceDatas(sourceDatas);
        metadataContext.setFormShowParameterAppId(formShowParameterAppId);
        metadataContext.setImportMonitor(this.importRequestDataResolve.getImportMonitor());
        metadataContext.setAbstractSave(this);
        return metadataContext;
    }

    private List<AttachmentPanelAp> getAttachmentPanelAps() {
        try {
            return ImpExpAttachmentUtil.getAttachmentPanelAps((String)this.formId);
        }
        catch (Exception e) {
            log.error("[\u5bfc\u5165\u9644\u4ef6\u5f02\u5e38]\uff1a\u521d\u59cb\u5316MetadataContext\u65f6\u6784\u5efa\u9644\u4ef6\u9762\u677f\u96c6\u5408\u5f02\u5e38" + e);
            return null;
        }
    }

    private List<ImportBillData> buildImportBillData(List<Map<String, Object>> sourceDatas) {
        ArrayList<ImportBillData> importBillDatas = new ArrayList<ImportBillData>(sourceDatas.size());
        for (int i = 0; i < sourceDatas.size(); ++i) {
            Map<String, Object> dataObject = sourceDatas.get(i);
            this.tryConvertPkId(dataObject, i);
            importBillDatas.add(new ImportBillData(i, dataObject));
        }
        return importBillDatas;
    }

    private void tryConvertPkId(Map<String, Object> dataObject, int i) {
        dataObject.put("_dindex_", i);
        ConvertPkEvent e = new ConvertPkEvent((Object)this.getView(), this.getOperationNumber(), dataObject);
        this.fireConvertPkEvent(e);
        if (e.getPK() == null) {
            Object pkId = dataObject.get("id");
            Class propertyType = this.getView().getModel().getDataEntityType().getPrimaryKey().getPropertyType();
            if (StringUtils.isNotBlank((Object)pkId) && pkId.getClass() != propertyType) {
                dataObject.put("_source_id_", pkId);
                pkId = ConvertUtils.convert((Object)pkId, (Class)propertyType);
                dataObject.put("id", pkId);
            }
        } else {
            dataObject.put("id", e.getPK());
        }
    }

    private void importEventWhenInit(IDataModel model) {
        ModelEventProxy eventProxy = (ModelEventProxy)model.getService(ModelEventProxy.class);
        this.clearInitImportDataArgs();
        if (eventProxy != null && !this.metadataContext.isForUpdateMultiLangFields()) {
            InitImportDataEventArgs eventArgs = new InitImportDataEventArgs((Object)model, this.metadataContext.getSourceDatas(), this.metadataContext.getOptions(), this.dataConvertOrder);
            this.metadataContext.getImportMonitor().addPluginMonitor("before InitImportData", this.metadataContext.getImportMonitor().safeToJsonStrng(eventArgs.getSourceDataList()));
            eventProxy.fireInitImportData(eventArgs);
            this.metadataContext.getImportMonitor().addPluginMonitor("after InitImportData", this.metadataContext.getImportMonitor().safeToJsonStrng(eventArgs.getSourceDataList()));
            this.setInitImportDataEventArgs(eventArgs);
            this.metadataContext.setInitImportDataEventArgs(eventArgs);
        }
    }

    private void initImportDataSaveFunction(ImportDataSaveFunction importDataSaveFunction) {
        importDataSaveFunction.setFuncGetNeedUpdateFields(this::getNeedUpdateFields);
        importDataSaveFunction.setFuncGetDataConverter(this::getDataConverter);
        importDataSaveFunction.setFuncIsFireAfterImportData(this::isFireAfterImportData);
        importDataSaveFunction.setFuncMergeCancelMessages(this::mergeCancelMessages);
    }

    @Override
    @Deprecated
    protected OperationResult prepareDataEntity(IDataModel model, Map<String, Object> dataObject, int indexOfData, Supplier<OperationResult> initializer) {
        return null;
    }

    protected FormShowParameter createShowParameter() {
        FormShowParameter showParameter = super.createShowParameter();
        showParameter.setAppId(this.getFormShowAppId());
        return showParameter;
    }

    private String getFormShowAppId() {
        String formShowAppId = (String)this.requestData.get("formShowParameterAppId");
        return formShowAppId;
    }
}

