/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.impt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.util.CollectionUtils;

public class ImportDataUtil {
    private static final String BOS_IMPORT = "bos-import";

    public static String getFilterDesc(IDataModel model, Map<String, Object> option, Map<String, Object> dataObject, List<Map<String, Object>> sourceDatas) {
        Map<String, String> keyFields = ImportDataUtil.getSelectField((BillEntityType)model.getDataEntityType(), option);
        StringBuilder sb = new StringBuilder();
        Map<String, Object> sourceData = sourceDatas.get((Integer)dataObject.get("_dindex_"));
        for (Map.Entry<String, String> entry : keyFields.entrySet()) {
            if (sb.length() != 0) {
                sb.append(ResManager.loadKDString((String)"\u4e14", (String)"ImportDataSave_9", (String)BOS_IMPORT, (Object[])new Object[0]));
            }
            sb.append(entry.getValue());
            Object sourceValue = sourceData.get(entry.getKey());
            if ("id".equals(entry.getKey()) && StringUtils.isNotBlank((Object)sourceData.get("_source_id_"))) {
                sb.append('=').append(sourceData.get("_source_id_"));
                continue;
            }
            if (StringUtils.isNotBlank((Object)sourceValue)) {
                if (sourceValue instanceof Map) {
                    Map sourceValueMap = (Map)sourceValue;
                    if (CollectionUtils.isEmpty((Map)sourceValueMap)) continue;
                    sb.append('=').append('{');
                    for (Map.Entry entryTmp : sourceValueMap.entrySet()) {
                        sb.append(entry.getKey()).append('.').append(entryTmp.getKey()).append('=').append(entryTmp.getValue()).append(',');
                    }
                    sb.deleteCharAt(sb.length() - 1);
                    sb.append('}');
                    continue;
                }
                sb.append('=').append(sourceValue);
                continue;
            }
            sb.append(ResManager.loadKDString((String)"\u4e3a\u7a7a", (String)"ImportDataSave_10", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
        return sb.toString();
    }

    private static Map<String, String> getSelectField(BillEntityType dt, Map<String, Object> option) {
        HashMap<String, String> fields = new HashMap<String, String>();
        List<Object> fieldkeys = new ArrayList<String>();
        String keyfields = (String)option.get("KeyFields");
        if (StringUtils.isBlank((CharSequence)keyfields)) {
            if (StringUtils.isNotBlank((CharSequence)dt.getMainOrg())) {
                fieldkeys.add(dt.getMainOrg());
            }
            if (StringUtils.isNotBlank((CharSequence)dt.getBillNo())) {
                fieldkeys.add(dt.getBillNo());
            }
            if (StringUtils.isNotBlank((CharSequence)dt.getBillStatus())) {
                fieldkeys.add(dt.getBillStatus());
            }
        } else {
            fieldkeys = Arrays.asList(keyfields.split(","));
        }
        if (fieldkeys == null || fieldkeys.isEmpty()) {
            return fields;
        }
        for (int i = 0; i < fieldkeys.size(); ++i) {
            LocaleString displayName;
            DynamicProperty prop;
            String field = (String)fieldkeys.get(i);
            if (!StringUtils.isNotBlank((CharSequence)field) || (prop = dt.getProperty(field)) == null) continue;
            String fieldName = null;
            fieldName = "id".equals(field) ? ResManager.loadKDString((String)"\u5185\u7801", (String)"ImportDataSave_1", (String)BOS_IMPORT, (Object[])new Object[0]) : ("pid".equals(field) ? ResManager.loadKDString((String)"\u4e0a\u7ea7\u5185\u7801", (String)"ImportDataSave_2", (String)BOS_IMPORT, (Object[])new Object[0]) : ((displayName = prop.getDisplayName()) != null && StringUtils.isNotBlank((CharSequence)displayName.toString()) ? displayName.toString() : field));
            fields.put(field, fieldName);
        }
        return fields;
    }
}

