/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.impt;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.impt.monitor.ImportMonitor;

public class ImportRequestDataResolve {
    private static final String IMPORT_TYPE = "importtype";
    private static final String OPTION = "option";
    private static final String BOS_IMPORT = "bos-import";
    private final Map<String, Object> requestData;

    public ImportRequestDataResolve(Map<String, Object> requestData) {
        this.requestData = requestData;
    }

    public List<Map<String, Object>> getSourceDatas() {
        if (this.requestData.containsKey("data")) {
            Map dataObject = (Map)this.requestData.get("data");
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            list.add(dataObject);
            return list;
        }
        if (this.requestData.containsKey("datas")) {
            return (List)this.requestData.get("datas");
        }
        return new ArrayList<Map<String, Object>>();
    }

    public String getImportType() {
        Map<String, Object> option = this.getOptionData();
        return (String)option.get(IMPORT_TYPE);
    }

    public String getKeyFields() {
        Map<String, Object> option = this.getOptionData();
        return (String)option.get("KeyFields");
    }

    public boolean isForUpdateMultiLangFields() {
        Map<String, Object> option = this.getOptionData();
        Object forUpdateMultiLangFields = option.get("ForUpdateMultiLangFields");
        return Boolean.TRUE.equals(forUpdateMultiLangFields);
    }

    public boolean isFirePropChanged() {
        Map<String, Object> option = this.getOptionData();
        Object paramValue = option.get("firePropChanged");
        if (StringUtils.isBlank((Object)paramValue)) {
            return false;
        }
        return Boolean.parseBoolean(paramValue.toString());
    }

    public String getAppId() {
        Map<String, Object> option = this.getOptionData();
        Object appid = option.get("appid");
        if (StringUtils.isBlank((Object)appid)) {
            return "";
        }
        return appid.toString();
    }

    public String getOperationNumber(String defaultOperationNumber) {
        Map<String, Object> option = this.getOptionData();
        String submit = (String)this.requestData.get("forcedsubmit");
        if (StringUtils.isEmpty((CharSequence)submit)) {
            return defaultOperationNumber;
        }
        return submit;
    }

    public boolean isOverrideEntry() {
        Map<String, Object> option = this.getOptionData();
        Object paramValue = option.get("OverrideEntry");
        if (StringUtils.isBlank((Object)paramValue)) {
            return false;
        }
        return Boolean.parseBoolean(paramValue.toString());
    }

    public boolean isOnlyValidate() {
        Map<String, Object> option = this.getOptionData();
        Object paramValue = option.get("onlyValidate");
        if (StringUtils.isBlank((Object)paramValue)) {
            return false;
        }
        return Boolean.parseBoolean(paramValue.toString());
    }

    public Map<String, Object> getOptions() {
        Map<String, Object> option = this.getOptionData();
        return option;
    }

    private Map<String, Object> getOptionData() {
        Map option = (Map)this.requestData.get(OPTION);
        if (option == null) {
            String errMsg = ResManager.loadKDString((String)"BatchImportPlugin \u672a\u4f20\u9012 option \u64cd\u4f5c\u53c2\u6570, \u8bf7\u68c0\u67e5\uff01", (String)"ImportDataSave_16", (String)BOS_IMPORT, (Object[])new Object[0]);
            throw new RuntimeException(errMsg);
        }
        return option;
    }

    public String getFormShowParameterAppId() {
        String formShowParameterAppId = (String)this.requestData.get("formShowParameterAppId");
        return formShowParameterAppId;
    }

    public ImportMonitor getImportMonitor() {
        Object importMonitor = this.requestData.get("importMonitor");
        if (importMonitor instanceof ImportMonitor) {
            return (ImportMonitor)importMonitor;
        }
        return new ImportMonitor();
    }

    public String getAttDirPath() {
        Map<String, Object> option = this.getOptionData();
        Object paramValue = option.get("attDirPath");
        if (StringUtils.isBlank((Object)paramValue)) {
            return "";
        }
        return paramValue.toString();
    }
}

