/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.impt.monitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.ReportCotent;
import kd.bos.entity.report.ReportData;
import kd.bos.entity.report.ReportItems;
import kd.bos.form.impt.monitor.ReportMoudleEnum;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.session.SystemPropertyUtils;

public class ImportMonitor {
    private static final Log log = LogFactory.getLog(ImportMonitor.class);
    private final List<List<String>> importParmRows = new ArrayList<List<String>>();
    private final List<List<String>> pluginMonitorRows = new ArrayList<List<String>>();
    private final List<List<String>> importLogRows = new ArrayList<List<String>>();
    private static final String BOS_IMPORT = "bos-import";
    private boolean monitorEnable = false;
    private Map<ReportMoudleEnum, ReportCotent> reportCotentMap = new HashMap<ReportMoudleEnum, ReportCotent>(3);
    private final Map<ReportMoudleEnum, List<List<String>>> moudleDataRowsMapping = new HashMap<ReportMoudleEnum, List<List<String>>>(3);

    public ImportMonitor() {
        ArrayList<String> titleRow = new ArrayList<String>(3);
        titleRow.add(ResManager.loadKDString((String)"\u53c2\u6570\u540d", (String)"ImportMonitor_0", (String)BOS_IMPORT, (Object[])new Object[0]));
        titleRow.add(ResManager.loadKDString((String)"\u53c2\u6570\u503c", (String)"ImportMonitor_1", (String)BOS_IMPORT, (Object[])new Object[0]));
        titleRow.add(ResManager.loadKDString((String)"\u53c2\u6570\u63cf\u8ff0", (String)"ImportMonitor_2", (String)BOS_IMPORT, (Object[])new Object[0]));
        this.importParmRows.add(titleRow);
        titleRow = new ArrayList(3);
        titleRow.add(ResManager.loadKDString((String)"\u63d2\u4ef6\u8282\u70b9\u540d\u79f0", (String)"ImportMonitor_3", (String)BOS_IMPORT, (Object[])new Object[0]));
        titleRow.add(ResManager.loadKDString((String)"\u6570\u636e\u5185\u5bb9", (String)"ImportMonitor_4", (String)BOS_IMPORT, (Object[])new Object[0]));
        this.pluginMonitorRows.add(titleRow);
        titleRow = new ArrayList(2);
        titleRow.add(ResManager.loadKDString((String)"\u5bfc\u5165\u8282\u70b9\u540d\u79f0", (String)"ImportMonitor_5", (String)BOS_IMPORT, (Object[])new Object[0]));
        titleRow.add(ResManager.loadKDString((String)"\u5bfc\u5165\u8282\u70b9\u65e5\u5fd7", (String)"ImportMonitor_6", (String)BOS_IMPORT, (Object[])new Object[0]));
        this.importLogRows.add(titleRow);
        this.moudleDataRowsMapping.put(ReportMoudleEnum.IMPORTPARM, this.importParmRows);
        this.moudleDataRowsMapping.put(ReportMoudleEnum.PLUGINMONITOR, this.pluginMonitorRows);
        this.moudleDataRowsMapping.put(ReportMoudleEnum.IMPORTLOG, this.importLogRows);
    }

    public ReportCotent buildReportCotent(int order, String logId, int moudleCount, ReportMoudleEnum reportMoudleEnum) {
        ReportCotent reportCotent = new ReportCotent();
        reportCotent.setMoudleKey("import");
        reportCotent.setUniqueKey(logId);
        reportCotent.setMoudleCount(Integer.valueOf(moudleCount));
        ReportData reportData = new ReportData();
        reportData.setReportTitle(ResManager.loadKDString((String)"\u5bfc\u5165\u76d1\u63a7\u62a5\u544a", (String)"ImportMonitor_7", (String)BOS_IMPORT, (Object[])new Object[0]));
        ReportItems reportItems = new ReportItems();
        reportItems.setPartTitle(reportMoudleEnum.getPartTitle());
        reportItems.setCells(this.moudleDataRowsMapping.get((Object)reportMoudleEnum));
        reportItems.setOrder(Integer.valueOf(order));
        reportData.setReportItems(reportItems);
        reportCotent.setData(reportData);
        return reportCotent;
    }

    public void addParam(String paramName, Object paramValue, String paramDesc) {
        if (!this.monitorEnable) {
            return;
        }
        ArrayList<String> paramRow = new ArrayList<String>(3);
        paramRow.add(paramName);
        paramRow.add(String.valueOf(paramValue));
        paramRow.add(paramDesc);
        this.importParmRows.add(paramRow);
    }

    public void addPluginMonitor(String pluginName, String data) {
        if (!this.monitorEnable) {
            return;
        }
        ArrayList<String> paramRow = new ArrayList<String>(3);
        paramRow.add(pluginName);
        paramRow.add(data);
        this.pluginMonitorRows.add(paramRow);
    }

    public void addImportLog(String stepName, String logContent) {
        if (!this.monitorEnable) {
            return;
        }
        ArrayList<String> paramRow = new ArrayList<String>(3);
        paramRow.add(stepName);
        paramRow.add(logContent);
        this.importLogRows.add(paramRow);
    }

    public boolean isMonitorEnable() {
        return this.monitorEnable;
    }

    public void setMonitorEnable(boolean monitorEnable) {
        this.monitorEnable = monitorEnable;
    }

    public Map<ReportMoudleEnum, ReportCotent> getReportCotentMap() {
        return this.reportCotentMap;
    }

    public void setReportCotentMap(Map<ReportMoudleEnum, ReportCotent> reportCotentMap) {
        this.reportCotentMap = reportCotentMap;
    }

    public String safeToJsonStrng(Object obj) {
        try {
            if (obj == null || !this.monitorEnable) {
                return " --import monitorEnable is false-- ";
            }
            return SerializationUtils.toJsonString((Object)obj).replaceAll("\\\\", "");
        }
        catch (Exception e) {
            return "safeToJsonStrng fail : " + e;
        }
    }

    public void clear() {
        this.importParmRows.clear();
        this.pluginMonitorRows.clear();
        this.importLogRows.clear();
        this.reportCotentMap.clear();
        this.moudleDataRowsMapping.clear();
    }

    public boolean checkImportMonitorRowLimit(int row) {
        if (!this.monitorEnable) {
            this.setMonitorEnable(false);
            return false;
        }
        int importMonitorRowLimit = SystemPropertyUtils.getInteger((String)RequestContext.get().getTenantId(), (String)"importmonitor.limit.rowsize", (Integer)1000);
        log.debug("totalRow count is " + (row -= 4) + " , importMonitorRowLimit is " + importMonitorRowLimit);
        if (row >= importMonitorRowLimit) {
            this.setMonitorEnable(false);
            return false;
        }
        return true;
    }
}

