/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.impt.process.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.ModelEventProxy;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.impt.ImportBillData;
import kd.bos.form.impt.ImportBillResult;
import kd.bos.form.impt.SingleBillResult;
import kd.bos.form.impt.process.AbstractImportDataProcess;
import kd.bos.form.impt.process.ImportDataProcessPriority;
import kd.bos.form.impt.process.ImportDataSaveFunction;
import kd.bos.form.operate.imptapi.ApiPropConvertContext;
import kd.bos.form.operate.imptapi.AttachmentFieldForImportDto;
import kd.bos.form.operate.imptapi.AttachmentPanelForImportDto;
import kd.bos.form.operate.imptapi.EntyRowMatchStyle;
import kd.bos.form.operate.imptapi.OperateDataConverter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class ConvertDataEntityProcess
extends AbstractImportDataProcess
implements ImportDataSaveFunction {
    private Supplier<Set<String>> funcGetNeedUpdateFields;
    protected BiFunction<IDataModel, ApiPropConvertContext, OperateDataConverter> funcGetDataConverter;
    private Supplier<Boolean> funcIsFireAfterImportData;
    private BiConsumer<Map<Integer, List<String>>, Map<Integer, List<String>>> funcMergeCancelMessages;

    @Override
    public ImportDataProcessPriority priority() {
        return ImportDataProcessPriority.CONVERT_DATA_ENTITY;
    }

    @Override
    public final void doProcess() {
        this.tagModifyAtImportBillData();
        this.convertData();
    }

    private void tagModifyAtImportBillData() {
        for (ImportBillData rowMapper : this.metadataContext.getImportBillDatas()) {
            DynamicObject dataEntity = this.metadataContext.getDataEntityByImportRowMapper(rowMapper);
            PKFieldProp pkProp = (PKFieldProp)dataEntity.getDataEntityType().getPrimaryKey();
            Object pkValue = dataEntity.getPkValue();
            rowMapper.setModifyTag(!pkProp.getValueComparator().compareValue(pkValue));
        }
    }

    protected void convertData() {
        PKFieldProp pkProp = (PKFieldProp)this.formView.getModel().getDataEntityType().getPrimaryKey();
        for (ImportBillData rowMapper : this.metadataContext.getImportBillDatas()) {
            SingleBillResult billResult = new SingleBillResult();
            billResult.setDIndex(rowMapper.getRowIndex());
            this.resultContext.addSingleBillResult(rowMapper.getRowIndex(), billResult);
            if (!this.validateBeforeConvertMapToDataEntity(pkProp, rowMapper, billResult)) {
                this.buildBillResult(pkProp, billResult, false);
                continue;
            }
            this.switchModelDataEntity(rowMapper);
            boolean success = this.convertMapToDataEntityWithException(rowMapper);
            this.buildBillResult(pkProp, billResult, success);
        }
    }

    private boolean validateBeforeConvertMapToDataEntity(PKFieldProp pkProp, ImportBillData rowMapper, SingleBillResult billResult) {
        Map cancelMessage;
        if (this.metadataContext.getInitImportDataEventArgs() != null && (cancelMessage = this.metadataContext.getInitImportDataEventArgs().getCancelMessage(this.getRowNumFormRowMapper(rowMapper))) != null && cancelMessage.size() > 0) {
            OperationResult operationResult = this.buildInitResult(cancelMessage);
            this.resultContext.setResultForConvertMapToDataEntity(operationResult);
            return false;
        }
        ImportBillResult resultForCreateDataEntity = this.resultContext.getResultForCreateDataEntity(rowMapper.getRowIndex());
        if (resultForCreateDataEntity != null && !resultForCreateDataEntity.isSuccess()) {
            this.resultContext.setResultForConvertMapToDataEntity(resultForCreateDataEntity.convertToOperationResult());
            return false;
        }
        return true;
    }

    private int getRowNumFormRowMapper(ImportBillData rowMapper) {
        return (Integer)rowMapper.getSourceObj().getOrDefault("rowNum", 3);
    }

    private void buildBillResult(PKFieldProp pkProp, SingleBillResult billResult, boolean success) {
        if (!success) {
            billResult.setSuccess(false);
            String msg = this.resultContext.getResultForConvertMapToDataEntity().getMessage();
            if (msg != null && msg.startsWith("{") && msg.endsWith("}")) {
                try {
                    billResult.setConvertResult(JSONObject.parseObject((String)msg, HashMap.class));
                }
                catch (Exception e) {
                    log.warn(String.format("appid:%s", this.metadataContext.getAppId()), (Throwable)e);
                    billResult.setMessage(msg);
                }
            } else {
                billResult.setMessage(msg);
            }
            return;
        }
        billResult.setSuccess(true);
        DynamicObject billObj = this.formView.getModel().getDataEntity(true);
        billResult.setId(pkProp.getValueFast((Object)billObj));
        this.resultContext.addBillObj(billObj);
        this.resultContext.addPkId(billResult.getId().toString());
    }

    private void switchModelDataEntity(ImportBillData rowMapper) {
        DynamicObject dataEntity = this.metadataContext.getDataEntityByImportRowMapper(rowMapper);
        this.formView.getModel().beginInit();
        this.formView.getModel().createNewData((Object)dataEntity);
        this.formView.getModel().endInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean convertMapToDataEntityWithException(ImportBillData rowMapper) {
        boolean result = false;
        try {
            this.formView.getModel().beginInit();
            result = this.convertMapToDataEntity(rowMapper);
        }
        catch (KDBizException bizExp) {
            OperationResult operationResult = new OperationResult();
            operationResult.setSuccess(false);
            operationResult.setMessage(bizExp.getMessage());
            this.resultContext.setResultForConvertMapToDataEntity(operationResult);
        }
        catch (Throwable exp) {
            if (SystemParamServiceHelper.isShowStackTrace()) {
                throw exp;
            }
            log.warn(exp);
            OperationResult operationResult = new OperationResult();
            operationResult.setSuccess(false);
            operationResult.setMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u89e3\u6790\u6570\u636e\u5305\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"AbstractSave_0", (String)"bos-import", (Object[])new Object[0]));
            this.resultContext.setResultForConvertMapToDataEntity(operationResult);
        }
        finally {
            this.formView.getModel().endInit();
        }
        return result;
    }

    private boolean convertMapToDataEntity(ImportBillData rowMapper) {
        boolean errorOccurred;
        Set<String> needUpDateFields = this.funcGetNeedUpdateFields.get();
        OperateDataConverter convert = this.getOperateDataConverter();
        convert.beginNewBill(this.getRowNumFormRowMapper(rowMapper));
        PKFieldProp pkProp = (PKFieldProp)this.formView.getModel().getDataEntityType().getPrimaryKey();
        Object pkValue = this.formView.getModel().getDataEntity().getPkValue();
        if (pkProp.getValueComparator().compareValue(pkValue)) {
            if (pkProp instanceof LongProp) {
                this.formView.getModel().getDataEntity().set((IDataEntityProperty)pkProp, (Object)DBServiceHelper.genGlobalLongId());
            } else if (pkProp instanceof VarcharProp) {
                this.formView.getModel().getDataEntity().set((IDataEntityProperty)pkProp, (Object)DBServiceHelper.genStringId());
            }
        }
        convert.setModify(rowMapper.isModifyTag());
        convert.setNeedUpdateFields(needUpDateFields);
        convert.setDataConvertOrder(this.metadataContext.getDataConvertOrder());
        this.formView.getModel().putContextVariable("IGNORE_RELOADDATAMODEL", (Object)Boolean.TRUE);
        Map<Integer, List<String>> contextErrorMap = convert.getContextErrorInfo();
        boolean isForUpdateMultiLang = this.metadataContext.isForUpdateMultiLangFields();
        boolean fireAfterImportData = this.funcIsFireAfterImportData.get() != false && !isForUpdateMultiLang;
        ModelEventProxy eventProxy = convert.getModelEventProxy();
        if (eventProxy != null && !isForUpdateMultiLang) {
            BeforeImportDataEventArgs eventArgs = new BeforeImportDataEventArgs((Object)this.formView.getModel(), rowMapper.getSourceObj(), convert.getBasePKs(), this.metadataContext.getOptions());
            eventProxy.fireBeforeImportData(eventArgs);
            convert.setCheckImportable(eventArgs.isCheckImportable());
            boolean bl = fireAfterImportData = fireAfterImportData && eventArgs.isFireAfterImportData();
            if (eventArgs.isCancel()) {
                this.funcMergeCancelMessages.accept(eventArgs.getCancelMessages(), contextErrorMap);
                OperationResult operationResult = this.buildInitResult(contextErrorMap);
                this.resultContext.setResultForConvertMapToDataEntity(operationResult);
                return false;
            }
        }
        boolean overrideEntry = this.metadataContext.isOverrideEntry();
        if (isForUpdateMultiLang || convert.isModify() && !overrideEntry) {
            convert.setEntyRowMatchStyle(EntyRowMatchStyle.PrimaryKey);
        } else if (!convert.isModify()) {
            convert.setEntyRowMatchStyle(EntyRowMatchStyle.Postion);
        }
        convert.filterBasedatas(rowMapper.getSourceObj(), this.formView.getModel().getDataEntity(), 0);
        convert.cacheBasedataPKIds();
        convert.convertComplexProperty(rowMapper.getSourceObj(), this.formView.getModel().getDataEntity(), 0);
        List<AttachmentPanelForImportDto> attachmentPanelTempUrlList = convert.getAttachmentPanelTempUrlList();
        Set<AttachmentFieldForImportDto> attachmentFieldPkSet = convert.getAttachmentFieldPkSet();
        this.resultContext.getSingleBillResult().get(rowMapper.getRowIndex()).getAttachmentPanelTempUrlList().addAll(attachmentPanelTempUrlList);
        this.resultContext.getSingleBillResult().get(rowMapper.getRowIndex()).getAttachmentFieldPkSet().addAll(attachmentFieldPkSet);
        boolean bl = errorOccurred = rowMapper.getSourceObj().get("_ERROR_DATA_") != null;
        if (!errorOccurred && eventProxy != null && fireAfterImportData) {
            ImportDataEventArgs eventArgs = new ImportDataEventArgs((Object)this.formView.getModel(), rowMapper.getSourceObj(), convert.getBasePKs(), this.metadataContext.getOptions());
            eventProxy.fireAfterImportData(eventArgs);
            if (eventArgs.isCancel()) {
                this.funcMergeCancelMessages.accept(eventArgs.getCancelMessages(), contextErrorMap);
                OperationResult operationResult = this.buildInitResult(contextErrorMap);
                this.resultContext.setResultForConvertMapToDataEntity(operationResult);
                return false;
            }
        }
        this.formView.getModel().clearNoDataRow();
        this.formView.getModel().removeContextVariable("IGNORE_RELOADDATAMODEL");
        OperationResult initResult = this.buildInitResult(contextErrorMap);
        if (!initResult.isSuccess() && StringUtils.isNotBlank((CharSequence)initResult.getMessage())) {
            throw new KDBizException(initResult.getMessage());
        }
        if (errorOccurred) {
            initResult.setSuccess(false);
        }
        this.resultContext.setResultForConvertMapToDataEntity(initResult);
        return true;
    }

    protected OperateDataConverter getOperateDataConverter() {
        return this.funcGetDataConverter.apply(this.formView.getModel(), null);
    }

    private OperationResult buildInitResult(Map<Integer, List<String>> contextErrorMap) {
        OperationResult initResult = new OperationResult();
        if (!contextErrorMap.isEmpty()) {
            initResult.setSuccess(false);
            initResult.setMessage(JSONObject.toJSONString(contextErrorMap));
        }
        return initResult;
    }

    @Override
    public void setFuncGetNeedUpdateFields(Supplier<Set<String>> funcGetNeedUpdateFields) {
        this.funcGetNeedUpdateFields = funcGetNeedUpdateFields;
    }

    @Override
    public void setFuncGetDataConverter(BiFunction<IDataModel, ApiPropConvertContext, OperateDataConverter> funcGetDataConverter) {
        this.funcGetDataConverter = funcGetDataConverter;
    }

    @Override
    public void setFuncIsFireAfterImportData(Supplier<Boolean> funcIsFireAfterImportData) {
        this.funcIsFireAfterImportData = funcIsFireAfterImportData;
    }

    @Override
    public void setFuncMergeCancelMessages(BiConsumer<Map<Integer, List<String>>, Map<Integer, List<String>>> funcMergeCancelMessages) {
        this.funcMergeCancelMessages = funcMergeCancelMessages;
    }
}

