/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.impt.process.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.impt.SingleBillResult;
import kd.bos.form.impt.process.AbstractImportDataProcess;
import kd.bos.form.impt.process.ImportDataProcessPriority;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class SaveDataEntityProcess
extends AbstractImportDataProcess {
    @Override
    public ImportDataProcessPriority priority() {
        return ImportDataProcessPriority.SAVE_DATA_ENTITY;
    }

    @Override
    public final void doProcess() {
        this.saveBillObjs();
        ApiResult apiResult = this.buildApiResult();
        this.resultContext.setApiResult(apiResult);
    }

    private void saveBillObjs() {
        if (this.resultContext.getBillObjs().isEmpty()) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("importtype", this.metadataContext.getImportType());
        option.setVariableValue("autogeneratebillno", String.valueOf(true));
        option.setVariableValue("currbizappid", this.metadataContext.getFormShowParameterAppId());
        option.setVariableValue("ignorewarn", String.valueOf(true));
        option.setVariableValue("batchImport", String.valueOf(true));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        option.setVariableValue("onlyvalidate", String.valueOf(this.metadataContext.isOnlyValidate()));
        option.setVariableValue("appnumber", this.metadataContext.getFormShowParameterAppId());
        option.setVariableValue("importtag_of_datasource", String.valueOf(true));
        option.setVariableValue("SpecialDataPerm_CurrentAppId", this.metadataContext.getFormShowParameterAppId());
        option.setVariableValue("updateEntrySummaryEnable", String.valueOf(true));
        if (this.metadataContext.getOptions().get("customParamMap") != null) {
            option.setVariableValue("customParamMap", SerializationUtils.toJsonString((Object)this.metadataContext.getOptions().get("customParamMap")));
        }
        try {
            this.metadataContext.getImportMonitor().addImportLog("before execute save Operate option ", this.metadataContext.getImportMonitor().safeToJsonStrng(option));
            this.metadataContext.getImportMonitor().addImportLog("before execute save Operate BillObjs ", this.metadataContext.getImportMonitor().safeToJsonStrng(this.resultContext.getBillObjs().toArray(new DynamicObject[0])));
            log.debug("before executeOperate save , option.VariableValue OperateOptionConst.BATCHIMPORT is " + option.getVariableValue("batchImport") + ",resultContext.getBillObjs().size is " + this.resultContext.getBillObjs().size());
            this.resultContext.setResultForSaveBillObjs(OperationServiceHelper.executeOperate((String)this.metadataContext.getOperationNumber(), (String)this.formView.getModel().getDataEntityType().getName(), (DynamicObject[])this.resultContext.getBillObjs().toArray(new DynamicObject[0]), (OperateOption)option));
        }
        catch (Throwable e) {
            log.warn(e);
            this.resultContext.setResultForSaveBillObjs(this.doExceptionWithSaveBillObjs(e));
        }
    }

    private OperationResult doExceptionWithSaveBillObjs(Throwable e) {
        OperationResult errResult = new OperationResult();
        errResult.setSuccess(false);
        Throwable cause = e.getCause();
        if (cause instanceof KDException && ((KDException)cause).getErrorCode() != null) {
            if ("bos.sQLDuplicateKey".equals(((KDException)cause).getErrorCode().getCode())) {
                log.debug(e.getMessage());
                String errMsg = ResManager.loadKDString((String)"\u5206\u5f55\u5185\u7801\u5728\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u6570\u636e\uff0c\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"ImportDataSave_15", (String)"bos-import", (Object[])new Object[0]);
                try {
                    errMsg = this.tryDealErrorMessage(e, errMsg);
                }
                catch (Throwable ignore) {
                    log.debug("doExceptionWithSaveBillObjs.tryDealErrorMessage,error is : " + ignore);
                }
                errResult.setMessage(errMsg);
                return errResult;
            }
            if ("xdb.xdbMultiDBWrited".equals(((KDException)cause).getErrorCode().getCode())) {
                log.debug(e.getMessage());
                String errMsg = ResManager.loadKDString((String)"\u51fa\u73b0\u8de8\u5e93\u4e8b\u52a1\uff0c\u5bfc\u81f4\u5bfc\u5165\u5931\u8d25\u3002", (String)"ImportDataSave_19", (String)"bos-import", (Object[])new Object[0]);
                errResult.setMessage(errMsg);
                return errResult;
            }
        }
        if (cause instanceof RuntimeException && (cause = cause.getCause()) instanceof SQLException) {
            e = cause;
        }
        if (e instanceof KDBizException || e instanceof SQLException || !SystemParamServiceHelper.isShowStackTrace()) {
            errResult.setMessage(e.getMessage());
        } else if (SystemParamServiceHelper.isShowStackTrace()) {
            errResult.setMessage(ImportLogger.formatException((Throwable)e));
        }
        return errResult;
    }

    private String tryDealErrorMessage(Throwable e, String errMsg) {
        String message = e.getMessage();
        if (StringUtils.isBlank((CharSequence)message) || !message.contains("Key ") || !message.contains(" already exists")) {
            return errMsg;
        }
        String disPlayName = "";
        String value = "";
        message = message.substring(message.indexOf("Key ") + 4, message.indexOf(" already exists"));
        message = message.replace("(", "").replace(")", "");
        String[] keyValue = message.split("=");
        disPlayName = keyValue[0];
        value = keyValue[1];
        Map allEntities = this.formView.getModel().getDataEntityType().getAllEntities();
        Set entries = allEntities.entrySet();
        block0: for (Map.Entry entry : entries) {
            for (IDataEntityProperty next : ((EntityType)entry.getValue()).getProperties()) {
                if (!keyValue[0].equalsIgnoreCase(next.getAlias())) continue;
                if (next instanceof PKFieldProp) {
                    if (((EntityType)entry.getValue()).getParent() instanceof MainEntityType) {
                        disPlayName = ResManager.loadKDString((String)"\u5206\u5f55\u5185\u7801", (String)"SaveDataEntityProcess_1", (String)"bos-import", (Object[])new Object[0]);
                        continue block0;
                    }
                    disPlayName = ResManager.loadKDString((String)"\u5355\u636e\u5185\u7801", (String)"SaveDataEntityProcess_2", (String)"bos-import", (Object[])new Object[0]);
                    continue block0;
                }
                disPlayName = next.getDisplayName().getLocaleValue();
                continue block0;
            }
        }
        errMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s\u5728\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u6570\u636e\uff0c\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"SaveDataEntityProcess_0", (String)"bos-import", (Object[])new Object[0]), disPlayName, value);
        return errMsg;
    }

    private ApiResult buildApiResult() {
        IDataModel model = this.formView.getModel();
        List<SingleBillResult> convResults = this.resultContext.getSingleBillResult();
        Set<String> pkIds = this.resultContext.getPkIds();
        OperationResult saveResult = this.resultContext.getResultForSaveBillObjs();
        if (this.metadataContext.getRequestData().containsKey("data")) {
            if (saveResult != null && saveResult.isSuccess()) {
                return ApiResult.success((Object)saveResult);
            }
            ApiResult apiResult = new ApiResult();
            apiResult.setSuccess(false);
            if (saveResult != null) {
                apiResult.setData((Object)saveResult);
            } else if (convResults.size() > 0) {
                apiResult.setMessage(convResults.get(0).getMessage());
                apiResult.setData(SingleBillResult.toMap(convResults.get(0)));
            }
            return apiResult;
        }
        ApiResult apiResult = new ApiResult();
        ArrayList<Map<String, Object>> billResults = new ArrayList<Map<String, Object>>();
        if (saveResult == null) {
            for (SingleBillResult item : convResults) {
                billResults.add(SingleBillResult.toMap(item));
            }
            apiResult.setSuccess(false);
            apiResult.setData(billResults);
        } else {
            HashSet<String> successIds = new HashSet<String>();
            Map<Object, Object> fromDB = new HashMap();
            BillEntityType mainType = (BillEntityType)model.getDataEntityType();
            IDataEntityProperty numberProp = StringUtils.isBlank((CharSequence)mainType.getBillNo()) ? null : mainType.findProperty(mainType.getBillNo());
            MainOrgProp orgProp = mainType.getMainOrgProperty();
            if (saveResult.getSuccessPkIds() != null) {
                for (Object pk : saveResult.getSuccessPkIds()) {
                    if (pk == null) continue;
                    successIds.add(pk.toString());
                }
                fromDB = this.loadSuccessObjs(saveResult.getSuccessPkIds(), mainType, numberProp, (IDataEntityProperty)orgProp);
            }
            ArrayList<IOperateInfo> opFailInfos = new ArrayList<IOperateInfo>();
            HashMap<String, List<IOperateInfo>> billErrors = new HashMap<String, List<IOperateInfo>>();
            this.splitErrorInfoByBill(pkIds, saveResult, opFailInfos, billErrors);
            int successCount = successIds.size();
            for (SingleBillResult item : convResults) {
                DynamicObject obj = null;
                if (this.isIdExist(item.getId(), successIds) || item.isSuccess() && !this.isIdExist(item.getId(), billErrors.keySet())) {
                    successIds.remove(item.getId().toString());
                    item.setSuccess(true);
                    obj = (DynamicObject)fromDB.get(item.getId().toString());
                }
                if (obj != null) {
                    DynamicObject org;
                    if (numberProp != null) {
                        item.setNumber((String)numberProp.getValue(obj));
                    }
                    if (orgProp != null && (org = (DynamicObject)orgProp.getValue(obj)) != null) {
                        item.setOrgNumber(org.getString("number"));
                    }
                } else {
                    item.setSuccess(false);
                    if (this.isIdExist(item.getId(), billErrors.keySet())) {
                        item.setData(billErrors.get(item.getId().toString()));
                    } else {
                        if (CollectionUtils.isEmpty(opFailInfos)) {
                            log.error("\u5f02\u5e38\u64cd\u4f5c\u9519\u8bef\u7ed3\u679cErrorOpFailInfos\uff0c\u9519\u8bef\u4fe1\u606f\u4e2d\u65e0\u5185\u5bb9\u3002");
                            OperateErrorInfo operateInfo = new OperateErrorInfo("ErrorOpFailInfos", ErrorLevel.Error, item.getId());
                            operateInfo.setMessage(ResManager.loadKDString((String)"\u6570\u636e\u672a\u4fdd\u5b58\u6210\u529f\uff0c\u5e76\u4e14\u6ca1\u6709\u8fd4\u56de\u9519\u8bef\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6392\u67e5\u4e1a\u52a1\u63d2\u4ef6\u3002", (String)"SaveDataEntityProcess_3", (String)"bos-import", (Object[])new Object[0]));
                            opFailInfos.add((IOperateInfo)operateInfo);
                        }
                        item.setData(opFailInfos);
                    }
                }
                billResults.add(SingleBillResult.toMap(item));
            }
            apiResult.setSuccess(successCount == billResults.size());
            apiResult.setData(billResults);
        }
        return apiResult;
    }

    private Map<String, DynamicObject> loadSuccessObjs(List<Object> successIds, BillEntityType mainType, IDataEntityProperty numberProp, IDataEntityProperty orgProp) {
        ArrayList<String> selectedFields = new ArrayList<String>();
        selectedFields.add(mainType.getPrimaryKey().getName());
        if (numberProp != null) {
            selectedFields.add(numberProp.getName());
        }
        if (orgProp != null) {
            selectedFields.add(orgProp.getName());
        }
        MainEntityType subType = (MainEntityType)mainType.getSubEntityType(selectedFields);
        DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])successIds.toArray(), (DynamicObjectType)subType);
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
        if (objs != null) {
            for (DynamicObject obj : objs) {
                Object pkValue = subType.getPrimaryKey().getValueFast((Object)obj);
                map.put(pkValue.toString(), obj);
            }
        }
        return map;
    }

    private void splitErrorInfoByBill(Set<String> pkIds, OperationResult saveResult, List<IOperateInfo> opFailInfos, Map<String, List<IOperateInfo>> billErrors) {
        OperateErrorInfo errInfo;
        if (saveResult.getSuccessPkIds() != null && saveResult.getSuccessPkIds().isEmpty() && StringUtils.isNotBlank((CharSequence)saveResult.getMessage())) {
            errInfo = new OperateErrorInfo("", ErrorLevel.Error, null);
            errInfo.setMessage(saveResult.getMessage());
            opFailInfos.add((IOperateInfo)errInfo);
        }
        for (IOperateInfo info : saveResult.getAllErrorOrValidateInfo()) {
            Object pkValue = info.getPkValue();
            if (!this.isIdExist(pkValue, pkIds)) {
                opFailInfos.add(info);
                continue;
            }
            if (!this.isIdExist(pkValue, billErrors.keySet())) {
                billErrors.put(pkValue.toString(), new ArrayList());
            }
            billErrors.get(pkValue.toString()).add(info);
        }
        if (!saveResult.isSuccess() && opFailInfos.isEmpty()) {
            errInfo = new OperateErrorInfo("", ErrorLevel.Error, null);
            errInfo.setMessage(ResManager.loadKDString((String)"\u672a\u77e5\u539f\u56e0\u5bfc\u81f4\u7684\u4fdd\u5b58\u5931\u8d25\u3002", (String)"ImportDataSave_12", (String)"bos-import", (Object[])new Object[0]));
            opFailInfos.add((IOperateInfo)errInfo);
        }
    }

    private boolean isIdExist(Object id, Set<String> successIds) {
        if (StringUtils.isBlank((Object)id)) {
            return false;
        }
        return successIds.contains(id.toString());
    }
}

