/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.imptapi;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.attachment.util.FileSecurityUtil;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.export.util.ImpExpAttachmentUtil;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.operate.imptapi.ApiPropConverter;
import kd.bos.form.operate.imptapi.AttachmentFieldForImportDto;
import kd.bos.form.operate.imptapi.AttachmentPanelForImportDto;
import kd.bos.form.operate.imptapi.RowMapper;
import kd.bos.mservice.attachment.IAttachmentService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.attachment.FileItemExt;
import kd.bos.service.attachment.FileSource;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;

public class ApiAttachmentPropConverter
extends ApiPropConverter {
    protected static final String ATT_ENTITYID = "bd_attachment";
    protected static final String ATT_NAME = "name";
    protected static final String ATT_SIZE = "size";
    protected static final String ATT_UID = "uid";
    protected static final String ATT_URL = "url";
    protected static final String ATT_TYPE = "type";
    protected static final String FILESOURCE = "filesource";
    protected static final String REGEXATTACHMENT = "\n";
    protected int maxAtmCount;
    protected int maxAtmSize;
    protected String sortField;
    protected String sortType;
    protected String extendName;
    protected boolean checkDuplicateFileName;
    protected List<AttachmentPanelForImportDto> attachmentPanelForImportDtoList = new ArrayList<AttachmentPanelForImportDto>();
    protected List<AttachmentFieldForImportDto> attachmentFieldForImportDtoList = new ArrayList<AttachmentFieldForImportDto>();
    protected static final String BOS_IMPORT = "bos-import";
    protected Set<String> forbiddenFileTypeList = new LinkedHashSet<String>(16);
    protected Set<String> whiteTypeList = new LinkedHashSet<String>(16);
    private static final String FBASEDATAID = "fbasedataid";

    public ApiAttachmentPropConverter() {
        this.init();
    }

    private void init() {
        IAttachmentService service = (IAttachmentService)ServiceFactory.getService(IAttachmentService.class);
        Map setting = service.getAttSetting();
        if (setting == null) {
            return;
        }
        Object forbidFileType = setting.get("forbidfiletype");
        Object whitelist = setting.get("whitelist");
        if (forbidFileType instanceof List) {
            this.forbiddenFileTypeList.addAll((List)forbidFileType);
        }
        if (whitelist instanceof List) {
            this.whiteTypeList.addAll((List)whitelist);
        }
    }

    private String generateUid() {
        return "rc-upload-" + System.currentTimeMillis() + "-" + new SecureRandom().nextInt(10000);
    }

    protected String getAttType() {
        return ResManager.loadKDString((String)"\u9644\u4ef6\u5b57\u6bb5", (String)"ImportAttachment_7", (String)BOS_IMPORT, (Object[])new Object[0]);
    }

    protected String checkFileCanBeUploadAndCollectErrMsg(String[] attachmentFileNameArr, RowMapper rowMapper) {
        if (this.maxAtmCount != 0 && attachmentFileNameArr.length > this.maxAtmCount) {
            return String.format(ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u4e2d\u9644\u4ef6\u4e2a\u6570\u8d85\u8fc7\u6700\u5927\u503c\u201c%3$s\u201d\u4e2a\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u9644\u4ef6\u538b\u7f29\u5305\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u524d\u5f80\u8bbe\u8ba1\u5668\u4fee\u6539\u6700\u5927\u9644\u4ef6\u6570\u3002", (String)"ImportAttachment_0", (String)BOS_IMPORT, (Object[])new Object[0]), this.getAttType(), this.getName(), this.maxAtmCount);
        }
        if (this.checkDuplicateFileName) {
            List<String> duplicateFileNameList;
            List<String> duplicateAttName = this.findDuplicate(attachmentFileNameArr);
            if (duplicateAttName.size() > 0) {
                return String.format(ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u4e0d\u5141\u8bb8\u4e0a\u4f20\u540c\u540d\u6587\u4ef6\uff0c\u201c%3$s\u201c\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u5173\u95ed\u9644\u4ef6\u9762\u677f/\u9644\u4ef6\u5b57\u6bb5\u7684\u6587\u4ef6\u540d\u91cd\u590d\u9650\u5236\u3002", (String)"ImportAttachment_5", (String)BOS_IMPORT, (Object[])new Object[0]), this.getAttType(), this.getName(), String.join((CharSequence)",", duplicateAttName));
            }
            DynamicObject targetObj = rowMapper.getTargetObj();
            if (targetObj.getPkValue() != null && (duplicateFileNameList = this.checkAttachmentExistDuplicateFileName(attachmentFileNameArr, targetObj)).size() > 0) {
                return String.format(ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u4e0d\u5141\u8bb8\u4e0a\u4f20\u540c\u540d\u6587\u4ef6\uff0c\u201c%3$s\u201c\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u5173\u95ed\u9644\u4ef6\u9762\u677f/\u9644\u4ef6\u5b57\u6bb5\u7684\u6587\u4ef6\u540d\u91cd\u590d\u9650\u5236\u3002", (String)"ImportAttachment_5", (String)BOS_IMPORT, (Object[])new Object[0]), this.getAttType(), this.getName(), String.join((CharSequence)",", duplicateFileNameList));
            }
        }
        String attDirPath = this.getContext().getAttDirPath();
        ArrayList<String> errMsgList = new ArrayList<String>(4);
        for (String attachmentFileName : attachmentFileNameArr) {
            File tempFile = new File(attDirPath + File.separator, FilenameUtils.getName((String)attachmentFileName));
            long fileLength = tempFile.length();
            if (!tempFile.exists()) {
                errMsgList.add(String.format(ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u4e2d\u7684\u9644\u4ef6\u201c%3$s\u201d\u5728\u538b\u7f29\u5305\u5185\u4e0d\u5b58\u5728", (String)"ImportAttachment_1", (String)BOS_IMPORT, (Object[])new Object[0]), this.getAttType(), this.getName(), attachmentFileName));
            } else if (fileLength == 0L) {
                errMsgList.add(String.format(ResManager.loadKDString((String)"%1$s\u201d%2$s\u201c\u4e2d\u7684\u201d%3$s\u201c\uff0c\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u4e0a\u4f20\u3002", (String)"ImportAttachment_9", (String)BOS_IMPORT, (Object[])new Object[0]), this.getAttType(), this.getName(), attachmentFileName));
            }
            String fileType = tempFile.getName().substring(tempFile.getName().lastIndexOf(46) + 1);
            if (this.whiteTypeList.size() > 0 && !this.whiteTypeList.contains(fileType)) {
                errMsgList.add(String.format(ResManager.loadKDString((String)"%1$s\u201d%2$s\u201c\u4e2d\u7684\u201d%3$s\u201c\uff0c\u4e0d\u5c5e\u4e8e\u7cfb\u7edf\u53c2\u6570\u3001\u8bbe\u8ba1\u5668\u6216\u6587\u4ef6\u670d\u52a1\u5668\u4e2d\u8bbe\u7f6e\u7684\u5141\u8bb8\u4e0a\u4f20\u7684\u6587\u4ef6\u7c7b\u578b\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u4fee\u6539\u9650\u5236\u503c\u3002", (String)"ImportAttachment_2", (String)BOS_IMPORT, (Object[])new Object[0]), this.getAttType(), this.getName(), attachmentFileName));
            } else if (this.forbiddenFileTypeList.size() > 0 && this.forbiddenFileTypeList.contains(fileType)) {
                errMsgList.add(String.format(ResManager.loadKDString((String)"%1$s\u201d%2$s\u201c\u4e2d\u7684\u201d%3$s\u201c\uff0c\u5c5e\u4e8e\u7cfb\u7edf\u53c2\u6570\u3001\u8bbe\u8ba1\u5668\u6216\u6587\u4ef6\u670d\u52a1\u5668\u4e2d\u8bbe\u7f6e\u7684\u7981\u6b62\u4e0a\u4f20\u7684\u6587\u4ef6\u7c7b\u578b\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u4fee\u6539\u9650\u5236\u503c\u3002", (String)"ImportAttachment_3", (String)BOS_IMPORT, (Object[])new Object[0]), this.getAttType(), this.getName(), attachmentFileName));
            }
            if (fileLength == 0L) continue;
            BigDecimal fileLengthMBSize = new BigDecimal(fileLength).divide(BigDecimal.valueOf(0x100000L), 2, RoundingMode.HALF_UP);
            if (this.maxAtmSize == 20 || fileLengthMBSize.compareTo(new BigDecimal(this.maxAtmSize)) <= 0) continue;
            errMsgList.add(String.format(ResManager.loadKDString((String)"%1$s\u201d%2$s\u201c\u4e2d\u7684\u201d%3$s\u201c\u5927\u5c0f\u4e3a\u201c%4$s\u201dMB\uff0c\u8d85\u8fc7\u7cfb\u7edf\u53c2\u6570\u3001\u8bbe\u8ba1\u5668\u6216MC\u53c2\u6570\u8bbe\u7f6e\u7684\u4e0a\u4f20\u9644\u4ef6\u6700\u5927\u503c\u201c%5$s\u201dMB\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u4fee\u6539\u9650\u5236\u503c\u3002", (String)"ImportAttachment_4", (String)BOS_IMPORT, (Object[])new Object[0]), this.getAttType(), this.getName(), attachmentFileName, fileLengthMBSize, this.maxAtmSize));
        }
        return String.join((CharSequence)"\uff1b", errMsgList);
    }

    protected List<String> checkAttachmentExistDuplicateFileName(String[] attachmentFileNameArr, DynamicObject targetObj) {
        ArrayList<String> duplicateList = new ArrayList<String>(2);
        DynamicObjectCollection attDynamicObjectCollection = targetObj.getDynamicObjectCollection(this.getProp().getName());
        ArrayList<String> oldAttachmentFieldNameList = new ArrayList<String>();
        if (attDynamicObjectCollection != null && attDynamicObjectCollection.size() > 0) {
            for (DynamicObject addDynamicObject : attDynamicObjectCollection) {
                if (!addDynamicObject.containsProperty(FBASEDATAID)) continue;
                String name = addDynamicObject.getDynamicObject(FBASEDATAID).getLocaleString(ATT_NAME).getLocaleValue();
                oldAttachmentFieldNameList.add(name);
            }
        }
        if (oldAttachmentFieldNameList.size() > 0) {
            for (String oldAttachmentFieldName : oldAttachmentFieldNameList) {
                for (String attachmentFileName : attachmentFileNameArr) {
                    if (!StringUtils.equals((CharSequence)oldAttachmentFieldName, (CharSequence)attachmentFileName)) continue;
                    duplicateList.add(attachmentFileName);
                }
            }
        }
        return duplicateList;
    }

    protected String getKey() {
        return this.getProp().getName();
    }

    protected String getName() {
        return this.getProp().getDisplayName().getLocaleValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean uploadAttList(RowMapper rowMapper, String[] attachmentFileNameArr, boolean isPanel) {
        String errMsg = this.checkFileCanBeUploadAndCollectErrMsg(attachmentFileNameArr, rowMapper);
        if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
            this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), errMsg);
            return false;
        }
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        for (String attachmentFileName : attachmentFileNameArr) {
            FileInputStream fis;
            block7: {
                String attDirPath = this.getContext().getAttDirPath();
                File tempFile = new File(attDirPath + File.separator, FilenameUtils.getName((String)attachmentFileName));
                fis = null;
                try {
                    AttachmentPanelForImportDto attachmentPanelForImportDto = null;
                    fis = new FileInputStream(tempFile);
                    FileItemExt fileItemExt = new FileItemExt(tempFile.getName(), ImpExpAttachmentUtil.getAttachmentRandomUrl((String)tempFile.getName()), (InputStream)fis);
                    fileItemExt.setFId(this.getContext().getModel().getDataEntityType().getName());
                    fileItemExt.setAppId(this.getContext().getFormShowParameterAppId());
                    fileItemExt.setSource(FileSource.EXCEL_IMPORT);
                    String uploadResultUrl = fileService.upload((FileItem)fileItemExt);
                    if (isPanel) {
                        attachmentPanelForImportDto = new AttachmentPanelForImportDto(tempFile.length(), this.getKey());
                        attachmentPanelForImportDto.setFilePath(uploadResultUrl);
                        this.attachmentPanelForImportDtoList.add(attachmentPanelForImportDto);
                        break block7;
                    }
                    this.attachmentFieldForImportDtoList.add(new AttachmentFieldForImportDto(null, uploadResultUrl));
                }
                catch (FileNotFoundException e) {
                    boolean bl;
                    try {
                        log.error("[\u5bfc\u5165\u9644\u4ef6\u9762\u677f\u5f02\u5e38\uff1a\u4e0a\u4f20\u9644\u4ef6\u81f3\u7f13\u5b58\u670d\u52a1\u5668---]" + e);
                        bl = false;
                    }
                    catch (Throwable throwable) {
                        FileSecurityUtil.safeClose(fis);
                        throw throwable;
                    }
                    FileSecurityUtil.safeClose((Closeable)fis);
                    return bl;
                }
            }
            FileSecurityUtil.safeClose((Closeable)fis);
        }
        return true;
    }

    @Override
    protected void execSetValue(RowMapper rowMapper, DynamicObject activeRow, Object value) {
        if (value == null || StringUtils.isEmpty((CharSequence)value.toString())) {
            return;
        }
        this.attachmentFieldForImportDtoList.clear();
        this.rowMapper = rowMapper;
        AttachmentProp prop = (AttachmentProp)this.getProp();
        this.maxAtmCount = prop.getMaxAtmCount();
        this.maxAtmSize = prop.getMaxAtmSize();
        this.sortField = prop.getSortField();
        this.sortType = prop.getSortType();
        this.extendName = prop.getExtendName();
        if (StringUtils.isNotEmpty((CharSequence)this.extendName)) {
            List<String> extendNameList = Arrays.asList(this.extendName.split(","));
            ArrayList<String> tmpList = new ArrayList<String>(extendNameList);
            for (String extendName : extendNameList) {
                if (extendName.startsWith(".")) {
                    tmpList.add(extendName.substring(1));
                    continue;
                }
                tmpList.add(extendName);
            }
            this.whiteTypeList = new HashSet<String>(CollectionUtils.intersection(this.whiteTypeList, tmpList));
        }
        this.checkDuplicateFileName = prop.getCheckDuplicateFileName();
        CharSequence[] attachmentFileNameArr = value.toString().split(REGEXATTACHMENT);
        boolean uploadAttListResult = this.uploadAttList(rowMapper, (String[])attachmentFileNameArr, false);
        if (!uploadAttListResult) {
            return;
        }
        ArrayList<DynamicObject> attachList = new ArrayList<DynamicObject>(16);
        if (attachmentFileNameArr.length != this.attachmentFieldForImportDtoList.size()) {
            String errMsg = String.format(ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u7684\u9644\u4ef6\u201c%3$s\u201d\u4e2d\uff0c\u5b58\u5728\u9644\u4ef6\u4e0a\u4f20\u5931\u8d25\uff08\u53ef\u80fd\u9644\u4ef6\u538b\u7f29\u5305\u672a\u4e0a\u4f20\uff09\uff0c\u8bf7\u68c0\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"ImportAttachment_6", (String)BOS_IMPORT, (Object[])new Object[0]), this.getAttType(), this.getName(), String.join((CharSequence)",", attachmentFileNameArr));
            StringBuilder sb = new StringBuilder();
            for (AttachmentFieldForImportDto attachmentFieldForImportDto : this.attachmentFieldForImportDtoList) {
                String attachmentPanelForImportDtoMsg = attachmentFieldForImportDto.toString();
                sb.append(attachmentPanelForImportDtoMsg);
            }
            log.error("[\u5bfc\u5165\u9644\u4ef6\u5f02\u5e38]\uff1a\u4e0a\u4f20\u6210\u529f\u90e8\u5206\u9644\u4ef6" + sb);
            this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), errMsg);
            return;
        }
        for (int i = 0; i < attachmentFileNameArr.length; ++i) {
            String attDirPath = this.getContext().getAttDirPath();
            File tempFile = new File(attDirPath + File.separator, FilenameUtils.getName((String)attachmentFileNameArr[i]));
            DynamicObject attObj = BusinessDataServiceHelper.newDynamicObject((String)ATT_ENTITYID);
            String fileName = tempFile.getName();
            String type = fileName.substring(fileName.lastIndexOf(46) + 1);
            long size = tempFile.length();
            attObj.set(ATT_NAME, (Object)fileName);
            attObj.set(ATT_SIZE, (Object)size);
            attObj.set(ATT_UID, (Object)this.generateUid());
            attObj.set(ATT_URL, (Object)this.attachmentFieldForImportDtoList.get(i).getFilePath());
            attObj.set(ATT_TYPE, (Object)type);
            attObj.set(FILESOURCE, (Object)1);
            attObj.set("status", (Object)"B");
            attObj.set("tempfile", (Object)1);
            attachList.add(attObj);
        }
        DynamicObject[] attArr = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])attachList.toArray(new DynamicObject[0]));
        if (attArr == null) {
            return;
        }
        List pkList = Arrays.stream(attArr).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        DynamicObjectCollection attDynamicObjectCollection = activeRow.getDynamicObjectCollection(this.getProp().getName());
        ArrayList<Object> oldAttachmentFieldPkList = new ArrayList<Object>();
        if (attDynamicObjectCollection != null && attDynamicObjectCollection.size() > 0) {
            for (DynamicObject addDynamicObject : attDynamicObjectCollection) {
                if (!addDynamicObject.containsProperty(FBASEDATAID) || addDynamicObject.getDynamicObject(FBASEDATAID) == null) continue;
                Object pkValue = addDynamicObject.getDynamicObject(FBASEDATAID).getPkValue();
                oldAttachmentFieldPkList.add(pkValue);
            }
        }
        if (oldAttachmentFieldPkList.size() > 0) {
            pkList.addAll(oldAttachmentFieldPkList);
        }
        this.getContext().getModel().setFieldValueForWebApi(this.getProp(), activeRow, pkList, this.getContext().isCheckImportable());
        ArrayList<AttachmentFieldForImportDto> attachmentFieldForImportDtoList = new ArrayList<AttachmentFieldForImportDto>(attArr.length);
        for (DynamicObject dynamicObject : attArr) {
            attachmentFieldForImportDtoList.add(new AttachmentFieldForImportDto(dynamicObject.getPkValue(), dynamicObject.getString(ATT_URL)));
        }
        this.getContext().getAttachmentFieldAttPkSet().addAll(attachmentFieldForImportDtoList);
    }

    private List<String> findDuplicate(String[] attNames) {
        ArrayList<String> duplicateList = new ArrayList<String>(2);
        if (attNames == null || attNames.length <= 0) {
            return duplicateList;
        }
        for (int i = 0; i < attNames.length; ++i) {
            for (int j = i + 1; j < attNames.length; ++j) {
                if (!StringUtils.equals((CharSequence)attNames[i], (CharSequence)attNames[j])) continue;
                duplicateList.add(attNames[i]);
            }
        }
        return duplicateList;
    }
}

