/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.imptapi;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.form.operate.imptapi.ApiPropConverter;
import kd.bos.form.operate.imptapi.RowMapper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ApiDateTimePropConverter
extends ApiPropConverter {
    private static final Log log = LogFactory.getLog(ApiDateTimePropConverter.class);
    private static final String BOS_FORM_CORE = "bos-form-core";
    private static final long minTimestamp = -2209017600000L;
    private static final long maxTimestamp = 253402185600000L;

    @Override
    protected void execSetValue(RowMapper rowMapper, DynamicObject activeRow, Object value) {
        if (value instanceof String && ((String)value).contains("/")) {
            SimpleDateFormat tryAMoreSimpleDateFormat = new SimpleDateFormat("yyyy/M/dd HH:mm:ss");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date date = tryAMoreSimpleDateFormat.parse(String.valueOf(value));
                String dateStr = dateFormat.format(date);
                value = dateStr;
            }
            catch (ParseException e) {
                log.error("[importdata format datetimeprop --]" + value);
            }
        }
        if (this.validateTimeFormat(rowMapper, value) && this.validateTimeRange(rowMapper, activeRow)) {
            super.execSetValue(rowMapper, activeRow, value);
        }
    }

    private boolean validateTimeFormat(RowMapper rowMapper, Object value) {
        if (value instanceof String) {
            DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            IDataEntityProperty prop = this.getProp();
            String displayName = "";
            if (prop instanceof DateProp) {
                DateProp dateProp = (DateProp)prop;
                dateFormat = dateProp.getDateFormat();
                String string = displayName = dateProp.getDisplayName() == null ? dateProp.getName() : dateProp.getDisplayName().getLocaleValue();
            }
            if (prop instanceof DateTimeProp) {
                DateTimeProp timeProp = (DateTimeProp)prop;
                displayName = timeProp.getDisplayName() == null ? timeProp.getName() : timeProp.getDisplayName().getLocaleValue();
            }
            dateFormat.setLenient(false);
            String errorMsg = String.format(ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"ApiDateTimePropConverter_0", (String)"bos-import", (Object[])new Object[0]), displayName, value);
            try {
                SimpleDateFormat dateTimeFormat;
                Date dateTime;
                Date date = dateFormat.parse(String.valueOf(value));
                if (date.getTime() < -2209017600000L || date.getTime() > 253402185600000L) {
                    errorMsg = String.format(ResManager.loadKDString((String)"%1$s(\u65e5\u671f\u5b57\u6bb5)\u5bfc\u5165\u5931\u8d25\uff0c\u89e3\u6790\u540e\u7684\u65e5\u671f\u201c%2$s\u201d\u4e0d\u5728\u53ef\u9009\u65e5\u671f1900~9999\u5e74\u8303\u56f4\u4e4b\u5185", (String)"ApiDateTimePropConverter_3", (String)"bos-import", (Object[])new Object[0]), displayName, value);
                    this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), errorMsg);
                    return false;
                }
                if (value.equals(dateFormat.format(date))) {
                    return true;
                }
                if (prop instanceof DateProp && date.compareTo(dateTime = (dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).parse(String.valueOf(value))) == 0) {
                    return true;
                }
                String[] timeValue = String.valueOf(value).split(":");
                if (timeValue.length > 3 && timeValue[timeValue.length - 1].length() > 0) {
                    SimpleDateFormat msFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
                    msFormat.setLenient(false);
                    Date msdate = msFormat.parse(String.valueOf(value));
                    if (value.equals(msFormat.format(msdate))) {
                        return true;
                    }
                }
                this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), errorMsg);
                return false;
            }
            catch (ParseException e) {
                this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), errorMsg);
                return false;
            }
        }
        return true;
    }

    private boolean validateTimeRange(RowMapper rowMapper, DynamicObject activeRow) {
        DateTimeProp timeProp;
        IDataEntityProperty prop = this.getProp();
        if (prop instanceof DateTimeProp && StringUtils.isNotBlank((CharSequence)(timeProp = (DateTimeProp)prop).getRelateDateTimeRange())) {
            return this.validateTimeRangeForEmpty(timeProp, rowMapper) && this.validateDateTimeRangeForTimeUp(timeProp, rowMapper);
        }
        return true;
    }

    private boolean validateTimeRangeForEmpty(DateTimeProp timeProp, RowMapper rowMapper) {
        Object relateTimeRangeObj = rowMapper.getSourceObj().get(timeProp.getRelateDateTimeRange());
        Object timeObj = rowMapper.getSourceObj().get(timeProp.getName());
        if (StringUtils.isBlank((Object)relateTimeRangeObj) && StringUtils.isBlank((Object)timeObj)) {
            return true;
        }
        if (relateTimeRangeObj == null || StringUtils.isBlank((CharSequence)relateTimeRangeObj.toString())) {
            String displayName = timeProp.getDisplayName() == null ? timeProp.getName() : timeProp.getDisplayName().getLocaleValue();
            this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), String.format(ResManager.loadKDString((String)"%s\uff1a\u6b64\u5c5e\u6027\u5bf9\u5e94\u7684\u8d77\u59cb\u6216\u7ed3\u675f\u65f6\u95f4\u4e0d\u5b58\u5728", (String)"ApiTimePropConverter_0", (String)BOS_FORM_CORE, (Object[])new Object[0]), displayName));
            return false;
        }
        return true;
    }

    private boolean validateDateTimeRangeForTimeUp(DateTimeProp timeProp, RowMapper rowMapper) {
        String displayName = timeProp.getDisplayName() == null ? timeProp.getName() : timeProp.getDisplayName().getLocaleValue();
        String relateTimeRange = timeProp.getRelateDateTimeRange();
        if (!timeProp.isStartDateTimeRange() || StringUtils.isBlank((CharSequence)relateTimeRange)) {
            return true;
        }
        Object startTimeObj = rowMapper.getSourceObj().get(timeProp.getName());
        Object endTimeObj = rowMapper.getSourceObj().get(relateTimeRange);
        Optional<Object> startTime = Optional.empty();
        Optional<Object> endTime = Optional.empty();
        if (startTimeObj != null && !(startTime = this.parseTime(timeProp, startTimeObj, displayName)).isPresent()) {
            return false;
        }
        if (endTimeObj != null && !(endTime = this.parseTime(timeProp, endTimeObj, displayName)).isPresent()) {
            return false;
        }
        if (startTime.isPresent() && endTime.isPresent() && ((Date)startTime.get()).after((Date)endTime.get())) {
            this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), String.format(ResManager.loadKDString((String)"%s\uff1a\u8d77\u59cb\u65e5\u671f\u5927\u4e8e\u7ed3\u675f\u65e5\u671f", (String)"ApiTimePropConverter_1", (String)BOS_FORM_CORE, (Object[])new Object[0]), displayName));
            return false;
        }
        return true;
    }

    private Optional<Date> parseTime(DateTimeProp timeProp, Object timeObj, String displayName) {
        try {
            Date date = timeObj instanceof Date ? (Date)timeObj : timeProp.parse((Object)this.rowMapper.getTargetObj(), timeObj.toString());
            return Optional.of(date);
        }
        catch (ParseException e) {
            String errMsg = String.format(ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"ApiDateTimePropConverter_2", (String)"bos-import", (Object[])new Object[0]), displayName, timeObj);
            this.getContext().addErrorInfo(this.rowMapper.getExcelRowIndex(), errMsg);
            return Optional.empty();
        }
    }
}

