/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.imptapi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.FlexEntityType;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.operate.imptapi.ApiBasedataPropConverter;
import kd.bos.form.operate.imptapi.ApiPropConvertContext;
import kd.bos.form.operate.imptapi.ApiPropConvertSeq;
import kd.bos.form.operate.imptapi.ApiPropConverter;
import kd.bos.form.operate.imptapi.RowMapper;
import kd.bos.form.operate.webapi.FlexBasedataItem;
import kd.bos.form.operate.webapi.FlexEntityTypeReader;
import kd.bos.form.operate.webapi.FlexValueBasedataItem;
import kd.bos.form.operate.webapi.FlexValueCacheKey;
import kd.bos.form.operate.webapi.FlexValueReader;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IAssistantDataService;
import kd.bos.service.IBaseDataService;
import kd.bos.service.ServiceFactory;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import org.apache.commons.collections4.MapUtils;

class ApiFlexPropConverter
extends ApiPropConverter {
    private static final Log log = LogFactory.getLog(ApiFlexPropConverter.class);
    private static final String flex_log_out = "flex.log.out";
    private static boolean enableOutLog = false;
    private static final String NUMBER = "number";
    private static final String BOS_IMPORT = "bos-import";
    private static final String FLEXTYPE = "flextype";
    private FlexEntityTypeReader flexEntityTypeReader;
    private FlexValueReader flexValueReader;
    Map<Object, FlexEntityType> baseFlexEntityTypes = new HashMap<Object, FlexEntityType>();
    private final Map<BasedataItem, List<Object>> baseItems = new HashMap<BasedataItem, List<Object>>();

    ApiFlexPropConverter() {
    }

    @Override
    public void setContext(ApiPropConvertContext context) {
        super.setContext(context);
        this.flexEntityTypeReader = new FlexEntityTypeReader(context.getModel().getDataEntityType().getName());
    }

    public FlexProp getFlexProp() {
        return (FlexProp)super.getProp();
    }

    @Override
    public int getConvertSeq() {
        return ApiPropConvertSeq.FlexProp.getValue();
    }

    @Override
    public void beginParseValue(RowMapper rowMapper, Object value) {
        FlexProp fp = this.getFlexProp();
        Object val = rowMapper.getValueFromSourceObj(fp.getBasePropertyKey(), false);
        ApiBasedataPropConverter basePropConverter = (ApiBasedataPropConverter)this.getContext().getPropConverter(fp.getBasePropertyKey());
        BasedataItem bi = basePropConverter.buildBasedataItem(rowMapper, val);
        bi = this.tryBuildFlexBasedataItemIfNull(bi, basePropConverter, rowMapper, val);
        Object flexValue = rowMapper.getValueFromSourceObj(fp.getName(), false);
        if (flexValue != null && bi != null) {
            List<Object> flexValues = this.baseItems.get(bi);
            if (flexValues == null) {
                flexValues = new ArrayList<Object>();
                this.baseItems.put(bi, flexValues);
            }
            flexValues.add(flexValue);
        }
    }

    private BasedataItem tryBuildFlexBasedataItemIfNull(BasedataItem bi, ApiBasedataPropConverter basePropConverter, RowMapper rowMapper, Object val) {
        if (bi != null) {
            return bi;
        }
        if (!(val instanceof Map)) {
            return null;
        }
        Map map = (Map)val;
        if (map.containsKey("id")) {
            return this.createFlexBasedataItem(basePropConverter, rowMapper, val);
        }
        return null;
    }

    private FlexBasedataItem createFlexBasedataItem(ApiBasedataPropConverter basePropConverter, RowMapper rowMapper, Object val) {
        String searchKey;
        String dataType;
        if (!(val instanceof Map)) {
            return null;
        }
        BasedataEntityType bdType = basePropConverter.getRefBDType(rowMapper);
        if (bdType == null) {
            return null;
        }
        Map map = (Map)val;
        String importprop = (String)map.get("importprop");
        if (StringUtils.isBlank((CharSequence)importprop)) {
            importprop = map.containsKey(NUMBER) ? NUMBER : "name";
            BasedataEntityType refPropType = (BasedataEntityType)basePropConverter.getBasedataProp().getComplexType();
            dataType = basePropConverter.convertDefaultImportProp(refPropType, importprop);
        } else {
            dataType = importprop;
        }
        String searchValue = (String)map.get(importprop);
        MasterBasedataProp masterIdProp = null;
        BasedataEntityType refMasterType = null;
        if (bdType.getMasteridType() == 2 && (masterIdProp = (MasterBasedataProp)bdType.findProperty(bdType.getMasteridPropName())) != null) {
            refMasterType = (BasedataEntityType)masterIdProp.getComplexType();
        }
        if (StringUtils.isBlank((CharSequence)(searchKey = refMasterType == null ? dataType : masterIdProp.getName() + "." + dataType))) {
            return null;
        }
        Long useOrgId = basePropConverter.getUseOrgId(rowMapper);
        FlexBasedataItem item = new FlexBasedataItem(basePropConverter.getProp().getName(), bdType.getName(), bdType, useOrgId, searchKey, searchValue);
        item.setPkId(map.get("id"));
        return item;
    }

    @Override
    public void endParseValue() {
        BasedataEntityType bt = this.getBasedataType();
        Map<Object, DynamicObject> map = this.getContext().getBaseObjs().get(bt.getName());
        if (map == null) {
            return;
        }
        DynamicObject[] baseObjs = new DynamicObject[this.baseItems.size()];
        int idx = 0;
        for (BasedataItem item : this.baseItems.keySet()) {
            Object pk = this.getContext().getBasePKs().get(item);
            if (item instanceof FlexBasedataItem) {
                pk = ((FlexBasedataItem)item).getPkId();
            }
            baseObjs[idx++] = map.get(pk);
        }
        this.baseFlexEntityTypes.putAll(this.flexEntityTypeReader.read(this.getFlexProp(), this.getBasedataProp(), baseObjs));
        try {
            this.preLoadFlexData(baseObjs);
        }
        catch (KDBizException e) {
            log.error((Throwable)e);
            this.baseItems.clear();
        }
        this.baseItems.clear();
    }

    @Override
    protected void execSetValue(RowMapper rowMapper, DynamicObject activeRow, Object value) {
        try {
            Object flexValue = this.getFlexValue(this.getFlexProp(), value, rowMapper);
            this.getContext().getModel().setFieldValueForWebApi((IDataEntityProperty)this.getFlexProp(), activeRow, flexValue, this.getContext().isCheckImportable());
        }
        catch (Exception e) {
            if (e instanceof KDBizException) {
                this.getContext().addErrorInfo(rowMapper.getExcelRowIndex(), e.getMessage());
            }
            throw e;
        }
    }

    private Object getFlexValue(FlexProp flexProp, Object flexValue, RowMapper rowMapper) {
        if (flexValue == null) {
            return flexValue;
        }
        if (!(flexValue instanceof Map)) {
            return flexValue;
        }
        if (((Map)flexValue).containsKey("id")) {
            return flexValue;
        }
        Map flexVal = (Map)flexValue;
        IDataEntityProperty refProp = this.getContext().getModel().getProperty(flexProp.getBasePropertyKey());
        if (!(refProp instanceof BasedataProp)) {
            return null;
        }
        BasedataProp baseProp = (BasedataProp)refProp;
        RowDataModel rowDataModel = new RowDataModel(rowMapper.getTargetObj().getDataEntityType().getName(), this.getContext().getModel().getDataEntityType());
        rowDataModel.setRowContext(rowMapper.getTargetObj());
        Object baseObj = rowDataModel.getValue(baseProp.getName());
        if (!(baseObj instanceof DynamicObject)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u5f39\u6027\u57df\u5b57\u6bb5\u201c%1$s\u201d\u4f9d\u8d56\u7684\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u201c%2$s\u201c\u672a\u5f55\u5165", (String)"ApiFlexPropConverter_0", (String)BOS_IMPORT, (Object[])new Object[0]), flexProp.getDisplayName().toString(), baseProp.getDisplayName().toString());
            throw new KDBizException(errMsg);
        }
        Object pk = ((DynamicObject)baseObj).getPkValue();
        if (enableOutLog) {
            log.info("----begin--this.flexEntityTypeReader.read----" + ((DynamicObject)baseObj).getPkValue());
        }
        FlexEntityType flexEntityType = null;
        if (this.baseFlexEntityTypes.containsKey(pk)) {
            flexEntityType = this.baseFlexEntityTypes.get(pk);
        } else {
            flexEntityType = this.flexEntityTypeReader.read(flexProp, baseProp, (DynamicObject)baseObj);
            log.info("kd.bos.form.operate.imptapi.ApiFlexPropConverter.getFlexValue----\u6570\u636e>5000\u6216\u7f13\u5b58\u65e0\u6548\uff01\uff01");
        }
        if (flexEntityType == null) {
            return null;
        }
        this.preFlexValueNamebyNumber(flexVal, flexEntityType);
        HashMap cloneValues = new HashMap(flexVal);
        ArrayList<String> flexProps = new ArrayList<String>(64);
        for (FlexProperty prop : flexEntityType.getFlexProperties()) {
            if (prop.getName() != null) {
                cloneValues.remove(prop.getName().toString());
                flexProps.add(prop.getName().toString());
                continue;
            }
            flexProps.add(ResManager.loadKDString((String)"\u7ef4\u5ea6\u540d\u79f0\u5f53\u524d\u8bed\u8a00\u4e0b\u4e3a\u7a7a", (String)"ApiFlexPropConverter_5", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
        if (!cloneValues.isEmpty()) {
            log.warn("----end--this.flexEntityTypeReader.read----\u5b58\u5728\u627e\u4e0d\u5230\u7ef4\u5ea6\u7684\u6570\u636e--" + cloneValues.keySet() + "--\u67e5\u5230\u7684\u7ef4\u5ea6" + flexProps);
        }
        return this.getFlexValueReader().getFlexValue(baseProp, flexProp, flexEntityType, flexVal, ((DynamicObject)baseObj).getPkValue());
    }

    private void preFlexValueNamebyNumber(Map<String, Object> flexVal, FlexEntityType flexEntityType) {
        if (!NUMBER.equals(flexVal.remove(FLEXTYPE))) {
            return;
        }
        for (FlexProperty prop : flexEntityType.getFlexProperties()) {
            String propName;
            String propNumber = prop.getNumber();
            Object value = flexVal.get(propNumber);
            if (value == null || prop.getName() == null || !StringUtils.isNotEmpty((CharSequence)(propName = prop.getName().toString())) || propName.equals(propNumber)) continue;
            flexVal.put(propName, value);
            flexVal.remove(prop.getNumber());
        }
    }

    private void preLoadFlexEntityType(BasedataProp baseProp) {
        if (this.baseFlexEntityTypes != null) {
            return;
        }
    }

    private void preLoadFlexData(DynamicObject[] baseObjs) {
        HashMap<String, Map<String, List<FlexValueBasedataItem>>> groupMap = new HashMap<String, Map<String, List<FlexValueBasedataItem>>>();
        HashSet<FlexValueCacheKey> cacheKeyAllList = new HashSet<FlexValueCacheKey>();
        for (Map.Entry<BasedataItem, List<Object>> item : this.baseItems.entrySet()) {
            Object pk = this.getContext().getBasePKs().get(item.getKey());
            if (item.getKey() instanceof FlexBasedataItem) {
                pk = ((FlexBasedataItem)item.getKey()).getPkId();
            }
            if (pk == null) continue;
            FlexEntityType flexEntityType = this.baseFlexEntityTypes.get(pk);
            if (flexEntityType == null) {
                log.info("----preLoadFlexData----pk=" + pk + "----item.key=" + item.getKey() + "----item.value=" + item.getValue());
                continue;
            }
            List<Object> flexValues = item.getValue();
            for (Object val : flexValues) {
                Map flexValue = (Map)val;
                if (MapUtils.isEmpty((Map)flexValue)) continue;
                FlexValueCacheKey cacheKey = FlexValueCacheKey.create((BasedataProp)this.getBasedataProp(), (FlexProp)this.getFlexProp(), (FlexEntityType)flexEntityType, (Map)flexValue, (Object)pk);
                cacheKeyAllList.add(cacheKey);
                this.flexItemGroup(groupMap, cacheKey, flexEntityType);
            }
        }
        Long mainOrgId = this.getContext().getMainOrgId();
        HashMap baseObjMap = new HashMap();
        for (Map.Entry baseFlexValues : groupMap.entrySet()) {
            String entityName = (String)baseFlexValues.getKey();
            Map searchKeyMap = (Map)baseFlexValues.getValue();
            for (Map.Entry searchKeyEntry : searchKeyMap.entrySet()) {
                ArrayList<String> searchVal = new ArrayList<String>(16);
                HashMap<String, ArrayList<String>> groupAssistList = new HashMap<String, ArrayList<String>>(16);
                BasedataProp tempProp = null;
                AssistantProp assistProp = null;
                BasedataProp itemProp = null;
                for (FlexValueBasedataItem flexValueBasedataItem : (List)searchKeyEntry.getValue()) {
                    tempProp = flexValueBasedataItem.getBasedataProp();
                    if (tempProp instanceof AssistantProp) {
                        assistProp = (AssistantProp)tempProp;
                        ArrayList<String> assSearchVal = (ArrayList<String>)groupAssistList.get(assistProp.getAsstTypeId());
                        if (assSearchVal == null) {
                            assSearchVal = new ArrayList<String>(10);
                            groupAssistList.put(assistProp.getAsstTypeId(), assSearchVal);
                        }
                        assSearchVal.add(flexValueBasedataItem.getSearchValue());
                        continue;
                    }
                    if (itemProp == null) {
                        itemProp = tempProp;
                    }
                    searchVal.add(flexValueBasedataItem.getSearchValue());
                }
                if (itemProp != null) {
                    ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
                    filters.add(new QFilter((String)searchKeyEntry.getKey(), "in", searchVal));
                    this.addFilter(filters, entityName, mainOrgId, itemProp);
                    this.getFlexValueReader().getBaseValues(baseObjMap, entityName, (String)searchKeyEntry.getKey(), filters.toArray(new QFilter[0]));
                }
                for (Map.Entry entry : groupAssistList.entrySet()) {
                    ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
                    filters.add(new QFilter((String)searchKeyEntry.getKey(), "in", entry.getValue()));
                    this.addAssistPropFilter(filters, entityName, mainOrgId, (BasedataProp)assistProp, Long.parseLong((String)entry.getKey()));
                    this.getFlexValueReader().getAssistBaseValues(baseObjMap, entityName, (String)searchKeyEntry.getKey(), (String)entry.getKey(), filters.toArray(new QFilter[0]));
                }
            }
        }
        this.getFlexValueReader().getFlexValues(baseObjMap, cacheKeyAllList);
    }

    private void flexItemGroup(Map<String, Map<String, List<FlexValueBasedataItem>>> filterMap, FlexValueCacheKey cacheKey, FlexEntityType flexEntityType) {
        Long mainOrgId = this.getContext().getMainOrgId();
        for (int i = 0; i < cacheKey.getFlexItems().size(); ++i) {
            String itemPropName = (String)cacheKey.getFlexItems().get(i);
            IDataEntityProperty flexItemProp = flexEntityType.findProperty(itemPropName);
            if (!(flexItemProp instanceof BasedataProp)) continue;
            String[] fv = StringUtils.split((String)((String)cacheKey.getFlexItemValues().get(i)), (String)":=");
            if (fv == null) {
                fv = new String[]{"", ""};
            }
            if (fv != null && fv.length == 1) {
                String temp = fv[0];
                fv = new String[]{temp, ""};
            }
            BasedataProp flexItemBaseProp = (BasedataProp)flexItemProp;
            FlexValueBasedataItem flexValueBaseItem = new FlexValueBasedataItem(flexItemProp.getName(), flexItemBaseProp.getBaseEntityId(), (BasedataEntityType)flexItemBaseProp.getComplexType(), mainOrgId, fv != null ? fv[0] : "", fv != null ? fv[1] : "");
            flexValueBaseItem.setCacheKey(cacheKey);
            flexValueBaseItem.setBasedataProp(flexItemBaseProp);
            if (!"id".equals(fv[0]) && !this.getContext().getBasePKs().containsKey(flexValueBaseItem)) {
                Map serchKeyMap = filterMap.computeIfAbsent(flexValueBaseItem.getEntityNumber(), k -> new HashMap());
                List list = serchKeyMap.computeIfAbsent(flexValueBaseItem.getSearchKey(), k -> new ArrayList());
                list.add(flexValueBaseItem);
            }
            if (!(flexItemProp instanceof AssistantProp)) continue;
            AssistantProp assistantProp = (AssistantProp)flexItemProp;
            flexValueBaseItem.setBizTag(assistantProp.getAsstTypeId());
        }
    }

    private void addFilter(List<QFilter> filters, String entityName, Long mainOrgId, BasedataProp flexItemProp) {
        BasedataEntityType type = (BasedataEntityType)flexItemProp.getComplexType();
        String forbidStatusKey = type.getForbidStatus();
        if (mainOrgId != null && mainOrgId != 0L) {
            QFilter filter = this.getBaseDataFilterFromCache(entityName, mainOrgId);
            filters.add(filter);
        }
        if (StringUtils.isNotBlank((CharSequence)forbidStatusKey) && !type.getProperty(forbidStatusKey).isDbIgnore()) {
            filters.add(new QFilter(forbidStatusKey, "!=", (Object)"0"));
        }
    }

    private QFilter getBaseDataFilterFromCache(String entityName, Long mainOrgId) {
        Map<String, QFilter> entityOrgIdQFilterMapping = this.getContext().getEntityOrgIdQFilterMapping();
        String cacheKey = entityName + mainOrgId;
        if (entityOrgIdQFilterMapping != null && entityOrgIdQFilterMapping.containsKey(cacheKey)) {
            log.info("getBaseDataFilterFromCache find cache key success,cacheKey is " + cacheKey);
            return entityOrgIdQFilterMapping.get(cacheKey);
        }
        log.info("getBaseDataFilterFromCache find cache key fail,cacheKey is " + cacheKey);
        IBaseDataService baseDataService = (IBaseDataService)this.getContext().getModel().getService(IBaseDataService.class);
        QFilter baseDataFilter = baseDataService.getBaseDataFilter(entityName, mainOrgId);
        if (entityOrgIdQFilterMapping != null) {
            entityOrgIdQFilterMapping.put(cacheKey, baseDataFilter);
        }
        return baseDataFilter;
    }

    private void addAssistPropFilter(List<QFilter> filters, String entityName, Long mainOrgId, BasedataProp flexItemProp, long assisTypeId) {
        this.addAssistFilter(filters, entityName, mainOrgId, flexItemProp, assisTypeId);
        if (flexItemProp instanceof AssistantProp) {
            filters.add(new QFilter("group", "=", (Object)assisTypeId));
        }
    }

    private void addAssistFilter(List<QFilter> filters, String entityName, Long mainOrgId, BasedataProp flexItemProp, long assisTypeId) {
        BasedataEntityType type = (BasedataEntityType)flexItemProp.getComplexType();
        String forbidStatusKey = type.getForbidStatus();
        if (mainOrgId != null && mainOrgId != 0L) {
            IAssistantDataService assistantDataService = (IAssistantDataService)ServiceFactory.getService(IAssistantDataService.class);
            QFilter filter = assistantDataService.getAssistantDataFilter(Long.valueOf(assisTypeId), mainOrgId);
            filters.add(filter);
        }
        if (StringUtils.isNotBlank((CharSequence)forbidStatusKey) && !type.getProperty(forbidStatusKey).isDbIgnore()) {
            filters.add(new QFilter(forbidStatusKey, "!=", (Object)"0"));
        }
    }

    private BasedataEntityType getBasedataType() {
        BasedataProp baseProp = this.getBasedataProp();
        return (BasedataEntityType)baseProp.getComplexType();
    }

    private BasedataProp getBasedataProp() {
        FlexProp fp = this.getFlexProp();
        IDataEntityProperty refProp = this.getContext().getModel().getProperty(fp.getBasePropertyKey());
        if (!(refProp instanceof BasedataProp)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u5f39\u6027\u57df\u5b57\u6bb5\u201c%s\u201d\u4f9d\u8d56\u7684\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u672a\u5b9a\u4e49", (String)"ApiFlexPropConverter_1", (String)BOS_IMPORT, (Object[])new Object[0]), fp.getDisplayName().toString());
            throw new KDBizException(errMsg);
        }
        return (BasedataProp)refProp;
    }

    public FlexValueReader getFlexValueReader() {
        if (this.flexValueReader == null) {
            this.flexValueReader = new FlexValueReader(this.getContext().convert2WebApiApiPropConvertContext());
        }
        return this.flexValueReader;
    }

    public void setFlexValueReader(FlexValueReader flexValueReader) {
        this.flexValueReader = flexValueReader;
    }

    static {
        enableOutLog = Boolean.parseBoolean(System.getProperty(flex_log_out));
        ConfigurationUtil.observeChange((String)flex_log_out, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                enableOutLog = Boolean.parseBoolean(System.getProperty(ApiFlexPropConverter.flex_log_out));
            }
        });
    }
}

