/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.imptapi;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.DB;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ModelEventProxy;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.form.operate.imptapi.ApiFlexPropConverter;
import kd.bos.form.operate.imptapi.ApiPropConvertContext;
import kd.bos.form.operate.imptapi.ApiPropConvertItem;
import kd.bos.form.operate.imptapi.AttachmentFieldForImportDto;
import kd.bos.form.operate.imptapi.AttachmentPanelForImportDto;
import kd.bos.form.operate.imptapi.EntyRowMatchStyle;
import kd.bos.form.operate.imptapi.IApiPropConverter;
import kd.bos.form.operate.imptapi.RowMapper;
import kd.bos.form.plugin.importentry.model.ImportEntryTypeEnum;
import kd.bos.permission.api.HasPermDimObjResult;
import org.apache.commons.collections4.BidiMap;

public class OperateDataConverter {
    private final IDataModel model;
    private ModelEventProxy modelEventProxy;
    private final PKFieldProp pkFieldProp;
    private ApiPropConvertContext context;
    private List<String> dataConvertOrder = new ArrayList<String>();

    @Deprecated
    public OperateDataConverter(IDataModel model) {
        this(model, null);
    }

    public OperateDataConverter(IDataModel model, Map<BasedataItem, Object> basePKs) {
        this.model = model;
        this.modelEventProxy = (ModelEventProxy)model.getService(ModelEventProxy.class);
        this.context = new ApiPropConvertContext(model, this.modelEventProxy, basePKs);
        this.pkFieldProp = (PKFieldProp)this.model.getDataEntityType().getPrimaryKey();
    }

    public OperateDataConverter(IDataModel model, Map<BasedataItem, Object> basePKs, Map<String, Map<Object, DynamicObject>> baseObjs) {
        this.model = model;
        this.modelEventProxy = (ModelEventProxy)model.getService(ModelEventProxy.class);
        this.context = new ApiPropConvertContext(model, this.modelEventProxy, basePKs, baseObjs);
        this.pkFieldProp = (PKFieldProp)this.model.getDataEntityType().getPrimaryKey();
    }

    public OperateDataConverter(IDataModel model, Map<BasedataItem, Object> basePKs, Map<String, Map<Object, DynamicObject>> baseObjs, ApiPropConvertContext apiPropConvertContext) {
        this.model = model;
        this.modelEventProxy = (ModelEventProxy)model.getService(ModelEventProxy.class);
        this.context = apiPropConvertContext;
        if (apiPropConvertContext == null) {
            this.context = new ApiPropConvertContext(model, this.modelEventProxy, basePKs, baseObjs);
        }
        this.pkFieldProp = (PKFieldProp)this.model.getDataEntityType().getPrimaryKey();
    }

    public void setHasPermResult(HasPermDimObjResult hasPermResult) {
        this.context.setHasPermResult(hasPermResult);
    }

    public boolean isModify() {
        return this.context.isModify();
    }

    public void setModify(boolean modify) {
        this.context.setModify(modify);
    }

    public Set<String> getNeedUpdateFields() {
        return this.context.getNeedUpdateFields();
    }

    public void setNeedUpdateFields(Set<String> needUpdateFields) {
        this.context.setNeedUpdateFields(needUpdateFields);
    }

    public EntyRowMatchStyle getEntyRowMatchStyle() {
        return this.context.getEntyRowMatchStyle();
    }

    public void setEntyRowMatchStyle(EntyRowMatchStyle entyRowMatchStyle) {
        this.context.setEntyRowMatchStyle(entyRowMatchStyle);
    }

    public boolean isImportMode() {
        return this.context.isImportMode();
    }

    public void setImportMode(boolean importMode) {
        this.context.setImportMode(importMode);
    }

    public Long getMainOrgId() {
        return this.context.getMainOrgId();
    }

    public Map<BasedataItem, Object> getBasePKs() {
        return this.context.getBasePKs();
    }

    public Map<String, Map<Object, DynamicObject>> getBaseObjs() {
        return this.context.getBaseObjs();
    }

    public List<AttachmentPanelForImportDto> getAttachmentPanelTempUrlList() {
        return this.context.getAttachmentPanelTempUrlList();
    }

    public Set<AttachmentFieldForImportDto> getAttachmentFieldPkSet() {
        return this.context.getAttachmentFieldAttPkSet();
    }

    @Deprecated
    public void beginNewBill() {
        this.context.setMainOrgId(null);
        this.context.clearErrorInfos();
    }

    public void beginNewBill(int rowNum) {
        this.context.setMainOrgId(null);
        this.context.clearErrorInfos();
        this.context.setEntityExcelRowIndex(rowNum);
        this.context.getAttachmentPanelTempUrlList().clear();
        this.context.getAttachmentFieldAttPkSet().clear();
        this.clearFlexValueReaderContext();
    }

    private void clearFlexValueReaderContext() {
        for (IApiPropConverter propConverter : this.context.getPropConverters().values()) {
            if (!(propConverter instanceof ApiFlexPropConverter)) continue;
            ((ApiFlexPropConverter)propConverter).setFlexValueReader(null);
        }
    }

    public void filterBasedatas(Map<String, Object> sourceObj, DynamicObject targetObj, int rowIndex) {
        RowMapper currRowMapper = new RowMapper(sourceObj, targetObj, null, rowIndex);
        List<ApiPropConvertItem> fieldItems = this.context.sortPropConverters((EntityType)this.context.getModel().getDataEntityType(), sourceObj);
        for (ApiPropConvertItem fieldItem : fieldItems) {
            fieldItem.getPropConverter().beginParseValue(currRowMapper, fieldItem.getValue());
        }
        this.cacheCurrId(sourceObj, targetObj);
    }

    public void cacheBasedataPKIds() {
        ArrayList<IApiPropConverter> propConverters = new ArrayList<IApiPropConverter>(this.context.getPropConverters().values());
        propConverters.sort(new Comparator<IApiPropConverter>(){

            @Override
            public int compare(IApiPropConverter o1, IApiPropConverter o2) {
                return o1.getConvertSeq() - o2.getConvertSeq();
            }
        });
        for (IApiPropConverter propConverter : propConverters) {
            propConverter.endParseValue();
        }
    }

    public void convertComplexProperty(Map<String, Object> sourceObj, DynamicObject targetObj, int rowIndex) {
        if (sourceObj == null) {
            return;
        }
        if (targetObj == null) {
            return;
        }
        RowMapper currRowMapper = new RowMapper(sourceObj, targetObj, null, rowIndex);
        List<ApiPropConvertItem> fieldItems = this.context.sortPropConverters((EntityType)this.context.getModel().getDataEntityType(), sourceObj);
        for (ApiPropConvertItem fieldItem : fieldItems) {
            fieldItem.getPropConverter().setValue(currRowMapper, targetObj, fieldItem.getValue());
        }
    }

    private void cacheCurrId(Map<String, Object> sourceObj, DynamicObject targetObj) {
        if (!(targetObj.getDataEntityType() instanceof BasedataEntityType)) {
            return;
        }
        BasedataEntityType bdType = (BasedataEntityType)targetObj.getDataEntityType();
        Object pkValue = this.pkFieldProp.getValueFast((Object)targetObj);
        if (this.pkFieldProp.getValueComparator().compareValue(pkValue)) {
            pkValue = this.pkFieldProp instanceof VarcharProp ? DB.genStringIds((String)"", (int)1)[0] : Long.valueOf(DB.genGlobalLongId());
            this.pkFieldProp.setValueFast((Object)targetObj, pkValue);
        }
        String searchKey = null;
        String searchValue = null;
        if (sourceObj.containsKey("number")) {
            searchKey = bdType.getNumberProperty();
            searchValue = (String)sourceObj.get("number");
            BasedataItem currItem = new BasedataItem(bdType.getName(), bdType.getName(), bdType, this.getMainOrgId(), searchKey, searchValue);
            this.getBasePKs().put(currItem, pkValue);
        }
        if (sourceObj.containsKey("name")) {
            searchKey = bdType.getNameProperty();
            Object nameObj = sourceObj.get("name");
            searchValue = nameObj instanceof Map ? LocaleString.fromMap((Map)((Map)nameObj)).toString() : String.valueOf(nameObj);
            BasedataItem currItem = new BasedataItem(bdType.getName(), bdType.getName(), bdType, this.getMainOrgId(), searchKey, searchValue);
            this.getBasePKs().put(currItem, pkValue);
        }
    }

    @Deprecated
    public List<String> getContextErrorInfos() {
        return this.context.getErrorInfos();
    }

    public Map<Integer, List<String>> getContextErrorInfo() {
        return this.context.getErrorInfo();
    }

    public ModelEventProxy getModelEventProxy() {
        return this.modelEventProxy;
    }

    public void setModelEventProxy(ModelEventProxy modelEventProxy) {
        this.modelEventProxy = modelEventProxy;
    }

    public List<String> getDataConvertOrder() {
        return this.dataConvertOrder;
    }

    public void setDataConvertOrder(List<String> dataConvertOrder) {
        this.dataConvertOrder = dataConvertOrder;
        this.context.setDataConvertOrder(dataConvertOrder);
    }

    public void setCheckImportable(boolean checkImportable) {
        this.context.setCheckImportable(checkImportable);
    }

    public void setContextFormShowParameterAppId(String appId) {
        if (this.context != null) {
            this.context.setFormShowParameterAppId(appId);
        }
    }

    public void setApiPropConvertContext(ApiPropConvertContext context) {
        this.context = context;
    }

    public BidiMap<Integer, Integer> getEntryRowMappingExcelRows() {
        return this.context.getEntryRowMappingExcelRows();
    }

    public void setCurrentEntryList(DynamicObjectCollection currentEntryList) {
        if (this.context != null) {
            this.context.setCurrentEntryList(currentEntryList);
        }
    }

    public void setImportEntryType(ImportEntryTypeEnum importEntryType) {
        if (this.context != null) {
            this.context.setImportEntryType(importEntryType);
        }
    }
}

