/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.plugin.IImportDataPlugin;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.webapi.AbstractOperateWebApi;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.lang.Lang;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BillStatusField;
import kd.bos.metadata.entity.businessfield.ModifierField;
import kd.bos.metadata.entity.businessfield.PrintCountField;
import kd.bos.metadata.entity.businessfield.UserAvatarField;
import kd.bos.metadata.entity.commonfield.AttachmentCountField;
import kd.bos.metadata.entity.commonfield.AttachmentField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IconField;
import kd.bos.metadata.entity.commonfield.PictureField;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.entity.commonfield.RadioGroupField;
import kd.bos.param.ParameterReader;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class ImportBigBillStartPlugin
extends AbstractFormPlugin
implements UploadListener {
    protected static ThreadPool InitThreadPool = ThreadPools.newFixedThreadPool((String)"ImportBigBillInitThreadPool", (int)6);
    private static final String FIELD_CONTROL = "field_control";
    private static final String FIELD_VALUE = "fieldValue";

    private String getImportPlugin(FormShowParameter showParam) {
        List plugins;
        String pluginName = (String)showParam.getCustomParam("ImportPlugin");
        if (StringUtils.isBlank((CharSequence)pluginName) && (plugins = (List)showParam.getCustomParam("plugins")) != null) {
            for (Map p : plugins) {
                if (!Boolean.TRUE.equals(p.get("Enabled"))) continue;
                return (String)p.get("ClassName");
            }
        }
        return pluginName;
    }

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btndownload", "btnresetfile"});
        Image label = (Image)this.getControl("btnupload");
        label.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String appid = (String)showParam.getCustomParam("ServiceAppId");
        String checkrightappid = (String)showParam.getCustomParam("CheckRightAppId");
        String formShowParameterAppId = showParam.getAppId();
        String billFormId = (String)showParam.getCustomParam("BillFormId");
        String listName = (String)showParam.getCustomParam("ListName");
        String pluginName = this.getImportPlugin(showParam);
        Label title = (Label)this.getControl("title");
        if (Lang.en_US == RequestContext.get().getLang()) {
            title.setText("&nbsp;&nbsp;" + listName);
        } else {
            title.setText(listName);
        }
        this.init(appid, checkrightappid, formShowParameterAppId, listName, billFormId, pluginName);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if ("importtype".equalsIgnoreCase(propertyName)) {
            String importtype = (String)this.getModel().getValue(propertyName);
            String keyfields = (String)this.getModel().getValue("keyfields");
            if (StringUtils.equals((CharSequence)"new", (CharSequence)importtype)) {
                this.getPageCache().put(FIELD_VALUE, keyfields);
                this.getModel().setValue("keyfields", null);
                this.getView().setEnable(Boolean.FALSE, new String[]{"keyfields"});
            } else {
                if (StringUtils.isBlank((CharSequence)keyfields)) {
                    keyfields = this.getPageCache().get(FIELD_VALUE);
                }
                this.getModel().setValue("keyfields", (Object)keyfields);
                String fieldControl = this.getPageCache().get(FIELD_CONTROL);
                if ("2".equals(fieldControl)) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"keyfields"});
                } else {
                    this.getView().setEnable(Boolean.TRUE, new String[]{"keyfields"});
                }
            }
        }
    }

    public void click(EventObject evt) {
        switch (((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.importData();
                break;
            }
            case "btndownload": {
                FormShowParameter currShowParameter = this.getView().getFormShowParameter();
                String billFormId = (String)currShowParameter.getCustomParam("BillFormId");
                String importPlugin = this.getImportPlugin(currShowParameter);
                if (StringUtils.isBlank((CharSequence)billFormId)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7c7b\u578b", (String)"ImportBigBillStartPlugin_0", (String)"bos-import", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("bos_downloadtemplate");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCustomParam("BillFormId", (Object)billFormId);
                showParameter.setCustomParam("BillTypeId", currShowParameter.getCustomParam("BillTypeId"));
                showParameter.setCustomParam("ImportPlugin", (Object)importPlugin);
                showParameter.setCustomParam("TemplateType", (Object)"IMPT");
                this.getView().showForm(showParameter);
                break;
            }
            case "btnresetfile": {
                this.getModel().setValue("filename", (Object)"");
                this.getModel().setValue("filepath", (Object)"");
                this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"uploadpanel"});
            }
        }
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            IFormView view = this.getView();
            String url = (String)urls[0];
            view.setVisible(Boolean.TRUE, new String[]{"filepanel"});
            view.setVisible(Boolean.FALSE, new String[]{"uploadpanel"});
            IDataModel model = this.getModel();
            model.setValue("filename", (Object)url.substring(url.lastIndexOf(47) + 1));
            model.setValue("filepath", (Object)url);
        }
    }

    private void init(String appid, String checkRightAppId, String formShowParameterAppId, String listName, final String billFormId, String pluginName) {
        String keyfields;
        IImportDataPlugin plugin;
        ComboEdit combo = (ComboEdit)this.getControl("keyfields");
        List<String> lockKeys = new ArrayList<String>(0);
        String importType = "new";
        ArrayList<ComboItem> keyfieldItems = new ArrayList<ComboItem>(0);
        boolean busiPluginSetField = false;
        if (StringUtils.isNotBlank((CharSequence)pluginName) && (plugin = (IImportDataPlugin)TypesContainer.createInstance((String)pluginName)) instanceof BatchImportPlugin) {
            final BatchImportPlugin batchPlugin = (BatchImportPlugin)plugin;
            Operations ops = EntityMetadataCache.getDataEntityOperations((String)FormMetadataCache.getFormConfig((String)billFormId).getEntityTypeId());
            ImportContext importContext = new ImportContext(this.getView(), null, appid, checkRightAppId, listName, billFormId, ops.getSave(), null);
            importContext.setFormShowParameterAppId(formShowParameterAppId);
            batchPlugin.setContext(RequestContext.get(), importContext, null);
            lockKeys = batchPlugin.getDefaultLockUIs();
            String pluginImportType = batchPlugin.getDefaultImportType();
            if (StringUtils.isNotBlank((CharSequence)pluginImportType)) {
                importType = pluginImportType;
            }
            String keyfields2 = batchPlugin.getDefaultKeyFields();
            keyfieldItems = new ArrayList<ComboItem>(batchPlugin.getOverrideFieldsConfig());
            if (StringUtils.isNotBlank((CharSequence)keyfields2)) {
                busiPluginSetField = true;
                this.getPageCache().put(FIELD_CONTROL, "1");
                this.getPageCache().put(FIELD_VALUE, keyfields2);
            }
            final RequestContext rc = RequestContext.get();
            InitThreadPool.submit(new Callable(){

                public Object call() throws Exception {
                    RequestContext.copyAndSet((RequestContext)rc);
                    AbstractOperateWebApi webApi = batchPlugin.getSaveWebApi();
                    webApi.initialize(billFormId, new HashMap(0));
                    return null;
                }
            });
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billFormId);
        String entityFormId = billFormId;
        if (entityType instanceof QueryEntityType) {
            entityFormId = ((QueryEntityType)entityType).getEntityName();
        }
        if (keyfieldItems.isEmpty()) {
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityFormId, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
            List entityItems = entityMetadata.getItems();
            HashSet itemSet = new HashSet(16);
            entityItems.stream().forEach(item -> {
                boolean valid = item instanceof Field;
                if (valid) {
                    Field f = (Field)item;
                    boolean bl = valid = StringUtils.isNotBlank((CharSequence)f.getFieldName()) && f.getFeatures().isImportable() && !(f instanceof BillStatusField) && !(f instanceof CheckBoxField) && !(f instanceof RadioField) && !(f instanceof RadioGroupField) && !(f instanceof ModifierField) && !(f instanceof PictureField) && !(f instanceof UserAvatarField) && !(f instanceof IconField) && !(f instanceof AttachmentCountField) && !(f instanceof AttachmentField) && !(f instanceof PrintCountField);
                }
                if (valid) {
                    if (item instanceof DateRangeField) {
                        DateRangeField field = (DateRangeField)item;
                        itemSet.add(field.getStartDateFieldKey());
                        itemSet.add(field.getEndDateFieldKey());
                    } else {
                        itemSet.add(item.getKey());
                    }
                }
            });
            for (IDataEntityProperty p : entityType.getProperties()) {
                if (!itemSet.contains(p.getName())) continue;
                keyfieldItems.add(new ComboItem(p.getDisplayName(), p.getName()));
            }
            if (entityType.getPrimaryKey() != null) {
                keyfieldItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5185\u7801", (String)"ImportBigBillStartPlugin_1", (String)"bos-import", (Object[])new Object[0])), entityType.getPrimaryKey().getName()));
            }
        }
        if (!keyfieldItems.isEmpty()) {
            this.sortKeyfieldItems(keyfieldItems, entityType);
            combo.setComboItems(keyfieldItems);
        }
        if ("new".equals(importType) && !lockKeys.contains("keyfields")) {
            lockKeys.add("keyfields");
        }
        if (!busiPluginSetField && StringUtils.isNotBlank((CharSequence)(keyfields = this.getBillUniqueKeys(entityFormId)))) {
            this.getPageCache().put(FIELD_CONTROL, "2");
            this.getPageCache().put(FIELD_VALUE, keyfields);
        }
        this.getView().setEnable(Boolean.FALSE, lockKeys.toArray(new String[0]));
        this.getModel().setValue("importtype", (Object)importType);
        this.getModel().setValue("keyfields", null);
    }

    private void importData() {
        String url = (String)this.getModel().getValue("filepath");
        if (StringUtils.isBlank((CharSequence)url)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c\u3002", (String)"ImportBigBillStartPlugin_2", (String)"bos-import", (Object[])new Object[0]));
            return;
        }
        if (!"new".equals(this.getModel().getValue("importtype")) && StringUtils.isBlank((Object)this.getModel().getValue("keyfields"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5339\u914d\u89c4\u5219\u3002", (String)"ImportBigBillStartPlugin_3", (String)"bos-import", (Object[])new Object[0]));
            return;
        }
        this.importData(url);
    }

    private void importData(String url) {
        IFormView view = this.getView();
        FormShowParameter showParam = view.getFormShowParameter();
        String billFormId = (String)showParam.getCustomParam("BillFormId");
        String listName = (String)showParam.getCustomParam("ListName");
        String serviceAppId = view.getFormShowParameter().getServiceAppId();
        String checkRightAppId = (String)showParam.getCustomParam("CheckRightAppId");
        Operations ops = EntityMetadataCache.getDataEntityOperations((String)FormMetadataCache.getFormConfig((String)billFormId).getEntityTypeId());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_importing");
        showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        HashMap<String, Object> params = new HashMap<String, Object>();
        String importType = (String)this.getModel().getValue("importtype");
        params.put("Type", importType);
        if (!"new".equals(importType)) {
            params.put("KeyFields", this.getModel().getValue("keyfields"));
        }
        params.put("ServiceAppId", serviceAppId);
        params.put("CheckRightAppId", checkRightAppId);
        params.put("BillFormId", billFormId);
        params.put("ListName", listName);
        params.put("OpSave", ops.getSave());
        params.put("Url", url);
        params.put("ImportPlugin", this.getImportPlugin(showParam));
        params.put("OperateKey", showParam.getCustomParam("OperateKey"));
        showParameter.setCustomParams(params);
        showParameter.setParentPageId(view.getFormShowParameter().getParentPageId());
        showParameter.setCloseCallBack(view.getFormShowParameter().getCloseCallBack());
        showParameter.addCustPlugin("kd.bos.form.plugin.ImportBigBillProcessPlugin");
        view.showForm(showParameter);
    }

    private void sortKeyfieldItems(List<ComboItem> keyfieldItems, MainEntityType entityType) {
        HashMap<String, Integer> sortMap = new HashMap<String, Integer>();
        String pk = entityType.getPrimaryKey().getName();
        sortMap.put(pk, 10);
        sortMap.put("billno", 8);
        if (entityType.getMainOrg() != null) {
            sortMap.put(entityType.getMainOrg(), 9);
        }
        Collections.sort(keyfieldItems, (o1, o2) -> {
            String v1 = o1.getValue();
            String v2 = o2.getValue();
            return sortMap.getOrDefault(v2, 0) - sortMap.getOrDefault(v1, 0);
        });
    }

    private String getBillUniqueKeys(String billFormId) {
        DynamicObject obj = ParameterReader.getBillParameter((String)billFormId);
        if (obj != null) {
            String billUniqueKeys = obj.getString("billuniquekeys");
            return billUniqueKeys;
        }
        return null;
    }
}

