/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Operations;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.upload.UploadOption;

@Deprecated
public class ImportDataPlugin
extends AbstractFormPlugin
implements UploadListener,
RowClickEventListener {
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final String BTNUPLOAD = "btnupload";
    private static final String URLSFLEX = "urlsflex";
    private static final String BILLFORMID = "BillFormId";
    private static final String EXTENDDATA = "ExtendData";
    private static final String UPLOAD_URLS = "upload_urls";
    private static final String FILELIST = "_file_list_";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", BTNUPLOAD, "btndownload", "btndel"});
        Image label = (Image)this.getControl(BTNUPLOAD);
        label.addUploadListener((UploadListener)this);
        AbstractGrid grid = (AbstractGrid)this.getControl("entryentity");
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{URLSFLEX});
        List preInsFiles = (List)this.getView().getFormShowParameter().getCustomParam("PreInsFiles");
        if (preInsFiles != null) {
            IDataModel model = this.getModel();
            int[] rows = model.batchCreateNewEntryRow("entryentity", preInsFiles.size());
            for (int i = 0; i < preInsFiles.size(); ++i) {
                String url = (String)((Map)preInsFiles.get(i)).get("url");
                model.setValue("preinsfile", (Object)url, rows[i]);
                model.setValue("filename", (Object)url.substring(url.lastIndexOf(47) + 1), rows[i]);
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        String preinsfile = (String)this.getModel().getValue("preinsfile", evt.getRow());
        if (StringUtils.isNotBlank((CharSequence)preinsfile)) {
            this.importData(Collections.singletonList(preinsfile));
        }
    }

    public void click(EventObject evt) {
        switch (((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.importData();
                break;
            }
            case "btnupload": {
                UploadOption opt = new UploadOption();
                opt.setMultiple(true);
                opt.setTitle(ResManager.loadKDString((String)"\u4e0a\u4f20\u6570\u636e\u6587\u4ef6", (String)"ImportDataPlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                opt.setSuffix(".xlsx");
                this.getView().showUpload(opt, BTNUPLOAD);
                break;
            }
            case "btndownload": {
                String billFormId = (String)this.getView().getFormShowParameter().getCustomParam(BILLFORMID);
                String importPlugin = (String)this.getView().getFormShowParameter().getCustomParam("ImportPlugin");
                if (StringUtils.isBlank((CharSequence)billFormId)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7c7b\u578b", (String)"ImportDataPlugin_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                    return;
                }
                String extendData = (String)this.getView().getFormShowParameter().getCustomParam(EXTENDDATA);
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("bos_downloadtemplate");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCustomParam(BILLFORMID, (Object)billFormId);
                showParameter.setCustomParam("ImportPlugin", (Object)importPlugin);
                showParameter.setCustomParam("TemplateType", (Object)"IMPT");
                showParameter.setCustomParam(EXTENDDATA, (Object)extendData);
                this.getView().showForm(showParameter);
                break;
            }
            case "btndel": {
                IDataModel model = this.getModel();
                int i = model.getEntryCurrentRowIndex(UPLOAD_URLS);
                String cacheUrls = this.getPageCache().get(FILELIST);
                List<Map> filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
                String url = (String)model.getValue("url", i);
                filelist.removeIf(f -> f.get("url").equals(url));
                this.getPageCache().put(FILELIST, SerializationUtils.serializeToBase64(filelist));
                model.deleteEntryRow(UPLOAD_URLS, i);
                if (!filelist.isEmpty()) break;
                this.getView().setVisible(Boolean.FALSE, new String[]{URLSFLEX});
                break;
            }
        }
    }

    private void importData() {
        String cacheUrls = this.getPageCache().get(FILELIST);
        if (StringUtils.isBlank((CharSequence)cacheUrls)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6587\u4ef6\u6216\u8005\u7b49\u5f85\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210\uff01", (String)"ImportDataPlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return;
        }
        List filelist = (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        ArrayList<String> urls = new ArrayList<String>(10);
        for (Map file : filelist) {
            String tempUrl = (String)file.get("url");
            urls.add(tempUrl);
        }
        this.importData(urls);
    }

    private void importData(List<String> filelist) {
        IFormView view = this.getView();
        FormShowParameter showParam = view.getFormShowParameter();
        List plugins = (List)showParam.getCustomParam("plugins");
        ArrayList<String> pluginClasses = new ArrayList<String>();
        if (plugins != null) {
            for (Map p : plugins) {
                if (!Boolean.TRUE.equals(p.get("Enabled"))) continue;
                pluginClasses.add((String)p.get("ClassName"));
            }
        }
        String billFormId = (String)showParam.getCustomParam(BILLFORMID);
        String appId = FormMetadataCache.getFormConfig((String)billFormId).getAppId();
        String serviceAppId = ServiceLookup.getServiceAppId((String)appId);
        Operations ops = EntityMetadataCache.getDataEntityOperations((String)FormMetadataCache.getFormConfig((String)billFormId).getEntityTypeId());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(filelist.size() > 1 ? "bos_importprogress_batch" : "bos_importprogress");
        showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("Type", this.getModel().getValue("importtype"));
        params.put("ServiceAppId", serviceAppId);
        params.put(BILLFORMID, billFormId);
        params.put("OpSave", ops.getSave());
        params.put("Urls", filelist);
        params.put(EXTENDDATA, showParam.getCustomParam(EXTENDDATA));
        if (pluginClasses != null && !pluginClasses.isEmpty()) {
            params.put("Plugins", pluginClasses);
        }
        showParameter.setCustomParams(params);
        showParameter.setParentPageId(view.getFormShowParameter().getParentPageId());
        showParameter.setCloseCallBack(view.getFormShowParameter().getCloseCallBack());
        view.showForm(showParameter);
    }

    public void remove(UploadEvent evt) {
        String cacheUrls = this.getPageCache().get(FILELIST);
        List<Map> filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        for (Object url : evt.getUrls()) {
            filelist.removeIf(f -> f.get("uid").equals(((Map)url).get("uid")));
        }
        this.getPageCache().put(FILELIST, SerializationUtils.serializeToBase64(filelist));
    }

    public void upload(UploadEvent evt) {
        this.getView().setVisible(Boolean.TRUE, new String[]{URLSFLEX});
        String cacheUrls = this.getPageCache().get(FILELIST);
        List<Map> filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        Object[] urls = evt.getUrls();
        IDataModel model = this.getModel();
        for (int i = 0; i < urls.length; ++i) {
            String urlStr;
            if (urls[i] == null || !StringUtils.isNotBlank((CharSequence)(urlStr = (String)((Map)urls[i]).get("url")))) continue;
            filelist.add((Map)urls[i]);
            int index = model.createNewEntryRow(UPLOAD_URLS);
            model.setValue("name", (Object)urlStr.substring(urlStr.lastIndexOf(47) + 1), index);
            model.setValue("url", (Object)urlStr, index);
        }
        this.getPageCache().put(FILELIST, SerializationUtils.serializeToBase64(filelist));
    }
}

