/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.concurrent.Callable;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.data.ImportLogHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.impt.ImportConfig;
import kd.bos.form.plugin.impt.ImportDataTask;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

@Deprecated
public class ImportProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log log = LogFactory.getLog(ImportProgressPlugin.class);
    private static final String BOS_IMPORT = "bos-import";
    public static final int THREAD_COUNT = 128;
    protected static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"ImportThreadPool", (int)128);
    private static final String BTNOK = "btnok";
    private static final String PROGRESSBARAP = "progressbarap";
    private static final String PROGRESS = "progress";
    private static final String BILLFORMID = "BillFormId";
    private static final String BOS_IMPORTLOG = "bos_importlog";

    public void initialize() {
        this.addClickListeners(new String[]{BTNOK});
        ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESSBARAP);
        progressbar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        ProgressBar progress = (ProgressBar)this.getControl(PROGRESSBARAP);
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam(BILLFORMID);
        String billFormName = (String)this.getView().getFormShowParameter().getCustomParam("BillFormName");
        Object logId = this.createImportlog(billFormId, billFormName);
        try {
            ImportConfig conf = new ImportConfig(view, logId);
            RequestContext rc = RequestContext.get();
            threadPool.submit((Callable)new ImportDataTask(rc, conf, "resolveExcel"));
            threadPool.submit((Callable)new ImportDataTask(rc, conf, "importData"));
            this.getView().setVisible(Boolean.FALSE, new String[]{"imageap", "operatepanel"});
            this.getPageCache().put(PROGRESS, "1");
            progress.setPercent(1, ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u5165...", (String)"ImportProgressPlugin_0", (String)BOS_IMPORT, (Object[])new Object[0]));
            progress.start();
        }
        catch (Throwable ex) {
            log.error(ex);
            progress.setPercent(100, ResManager.loadKDString((String)"\u5f02\u5e38\u4e2d\u65ad", (String)"ImportProgressPlugin_1", (String)BOS_IMPORT, (Object[])new Object[0]));
            String errMsg = ex instanceof KDBizException ? ex.getMessage() : ResManager.loadKDString((String)"\u5bfc\u5165\u8fc7\u7a0b\u4e2d\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"ImportProgressPlugin_2", (String)BOS_IMPORT, (Object[])new Object[0]);
            this.getView().showErrorNotification(errMsg);
            ImportLogHelper.append((Object)logId, (String)errMsg);
        }
    }

    public void onProgress(ProgressEvent evt) {
        int progress = Integer.parseInt(this.getPageCache().get(PROGRESS));
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam(BILLFORMID);
        JSONObject info = (JSONObject)AppCache.get((String)"bos").get(ImportDataTask.getCacheKey(billFormId, this.getView().getPageId()), JSONObject.class);
        if (info != null) {
            int importProgress = (Integer)info.get((Object)PROGRESS);
            if (importProgress < 0) {
                String err = info.containsKey((Object)"err") ? (String)info.get((Object)"err") : ResManager.loadKDString((String)"\u5bfc\u5165\u8fc7\u7a0b\u9047\u5230\u672a\u77e5\u9519\u8bef", (String)"ImportProgressPlugin_3", (String)BOS_IMPORT, (Object[])new Object[0]);
                this.getView().showErrorNotification(err);
                ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESSBARAP);
                progressbar.stop();
                return;
            }
            Label label = (Label)this.getControl("title");
            Label count1 = (Label)this.getControl("count1");
            Label count2 = (Label)this.getControl("count2");
            int succeed = (Integer)info.getOrDefault((Object)"succeed", (Object)0);
            int failed = (Integer)info.getOrDefault((Object)"failed", (Object)0);
            count1.setText("" + succeed);
            count2.setText("" + failed);
            log.debug(String.format("----import--progress--pageid=%s--total=%d--succeed=%d--failed=%d", this.getView().getPageId(), info.getOrDefault((Object)"total", (Object)0), succeed, failed));
            if (importProgress >= 100) {
                int total;
                progress = 100;
                evt.setText(ResManager.loadKDString((String)"\u5bfc\u5165\u5b8c\u6210", (String)"ImportProgressPlugin_4", (String)BOS_IMPORT, (Object[])new Object[0]));
                this.getView().setVisible(Boolean.FALSE, new String[]{PROGRESSBARAP});
                this.getView().setVisible(Boolean.TRUE, new String[]{"imageap", "operatepanel"});
                if (failed == 0 && (total = ((Integer)info.getOrDefault((Object)"total", (Object)0)).intValue()) > 0) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{BTNOK});
                }
            }
        }
        if (progress <= 95) {
            progress = Math.min(95, progress == 95 ? progress - 1 : progress + 1);
            this.getPageCache().put(PROGRESS, "" + progress);
        }
        evt.setProgress(progress);
    }

    public void click(EventObject evt) {
        if (BTNOK.equals(((Control)evt.getSource()).getKey())) {
            String jsonData;
            String billFormId = (String)this.getView().getFormShowParameter().getCustomParam(BILLFORMID);
            String billno = this.getPageCache().get(ImportDataTask.getCacheKey(billFormId, this.getView().getPageId()));
            DynamicObject taskData = QueryServiceHelper.queryOne((String)BOS_IMPORTLOG, (String)"data", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
            if (taskData == null || StringUtils.isBlank((CharSequence)(jsonData = taskData.getString("data")))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e5\u5fd7\u6570\u636e\u4e0d\u5b58\u5728", (String)"ImportProgressPlugin_5", (String)BOS_IMPORT, (Object[])new Object[0]));
                return;
            }
            JSONObject data = JSON.parseObject((String)jsonData);
            try {
                JSONObject info = data.getJSONObject("info");
                for (Object obj : info.values()) {
                    ImportLogger logger = (ImportLogger)JSONObject.parseObject((String)((JSONObject)obj).toJSONString(), ImportLogger.class);
                    IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                    if (StringUtils.isNotBlank((CharSequence)logger.getErrFile())) {
                        proxy.addAction("download", (Object)(logger.getErrFile() + "&a=t"));
                        continue;
                    }
                    if (logger.getFailed() > 0) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"ImportProgressPlugin_6", (String)BOS_IMPORT, (Object[])new Object[0]));
                        continue;
                    }
                    String msg = logger.toString().trim();
                    if (msg.isEmpty()) continue;
                    this.getView().showErrorNotification(msg);
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
                this.getView().showMessage(ResManager.loadKDString((String)"\u4ece\u65e5\u5fd7\u4e2d\u63d0\u53d6\u4e0b\u8f7d\u5730\u5740\u5931\u8d25\uff0c\u53ef\u80fd\u65e5\u5fd7\u683c\u5f0f\u5316\u592a\u65e7\uff0c\u8bf7\u5c1d\u8bd5\u4ece\u65e5\u5fd7\u4e2d\u624b\u52a8\u63d0\u53d6\u5230\u5730\u5740\u680f\u4e0b\u8f7d\u3002", (String)"ImportProgressPlugin_7", (String)BOS_IMPORT, (Object[])new Object[0]));
            }
        }
    }

    private Object createImportlog(String billFormId, String name) {
        MainEntityType objType = EntityMetadataCache.getDataEntityType((String)BOS_IMPORTLOG);
        DynamicObject dyn = (DynamicObject)objType.createInstance();
        dyn.set("name", (Object)name);
        dyn.set("billstatus", (Object)"C");
        dyn.set("importstatus", (Object)"0");
        dyn.set("createtime", (Object)new TimeService().now());
        ICodeRuleService coderule = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        String billno = coderule.getNumber(BOS_IMPORTLOG, dyn, null);
        this.getPageCache().put(ImportDataTask.getCacheKey(billFormId, this.getView().getPageId()), billno);
        dyn.set("billno", (Object)billno);
        dyn = (DynamicObject)BusinessDataWriter.save((IDataEntityType)objType, (Object[])new Object[]{dyn})[0];
        return dyn.getPkValue();
    }
}

