/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.TreeListBizAppsPlugin;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.mvc.export.ListExporter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.svc.util.TreeNodeFilter;
import org.apache.commons.lang3.StringUtils;

public class ImportTemplateTreeListEdit
extends TreeListBizAppsPlugin {
    private static final String BIZOBJECT = "bizobject";
    private static final String BOS_IMPORT = "bos-import";

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void initializeTree(EventObject e) {
        ITreeModel treeModel = this.getTreeModel();
        TreeNode root = treeModel.createRootNode();
        treeModel.setRoot(root);
        treeModel.setCurrentNodeId((Object)root.getId());
        root.setIsOpened(true);
        root.setChildren(new TreeNodeFilter(TreeNodeFilter.FilterTypeEnum.ONLY_CLOUD).getCloudNodes());
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnnew"});
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"btnedit", "btndel"});
    }

    protected List<TreeNode> getAppNodesBy(String cloudNodeId) {
        List treeNodes = super.getAppNodesBy(cloudNodeId);
        return new TreeNodeFilter(TreeNodeFilter.FilterTypeEnum.ONLY_APP).filterAppTreeNode(treeNodes);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        TreeNodeFilter treeNodeFilter = new TreeNodeFilter(TreeNodeFilter.FilterTypeEnum.ONLY_APP);
        QFilter appFilter = treeNodeFilter.getAppFilter("bizobject.bizappid.id");
        if (appFilter != null) {
            e.addCustomQFilter(appFilter);
        }
        e.addCustomQFilter(new QFilter(BIZOBJECT, "in", this.getBillNumbers()));
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String nodeId = e.getNodeId().toString();
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode node = root.getTreeNode(nodeId, 20);
        QFilter filter = this.getFilter(node);
        e.addQFilter(filter);
        e.setCancel(true);
    }

    private QFilter getFilter(TreeNode node) {
        if (node == null) {
            return null;
        }
        String nodeId = node.getId();
        if (this.isTopNode(nodeId)) {
            return null;
        }
        switch ((String)node.getData()) {
            case "cloud": {
                return new QFilter(BIZOBJECT, "in", (Object)this.getBillIdInCloud(nodeId));
            }
            case "app": {
                return new QFilter(BIZOBJECT, "in", (Object)this.getBillIdInApp(nodeId));
            }
        }
        return new QFilter(BIZOBJECT, "=", (Object)nodeId);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter param = e.getParameter();
        String currentNodeId = this.getTreeModel().getCurrentNodeId().toString();
        String rootId = this.getTreeModel().getRoot().getId();
        if (currentNodeId.contains("cloud_") || currentNodeId.contains("app_") || rootId.equals(currentNodeId)) {
            return;
        }
        param.setCustomParam("tree_parent_id", null);
        param.setCustomParam(BIZOBJECT, (Object)currentNodeId);
    }

    public void treeNodeClick(TreeNodeEvent treenodeevent) {
        this.getTreeModel().setNodeClickExpand(false);
        String nodeId = treenodeevent.getNodeId().toString();
        this.getPageCache().put("nodeId", nodeId);
        TreeNode node = this.getTreeModel().getRoot().getTreeNode(nodeId, 10);
        this.getPageCache().remove("_IMPORTTEMPLATETREELIST_BIZOBJID_");
        if (node != null && node.getData() != null) {
            String nodeData = (String)node.getData();
            if (node.getChildren() != null || "app".equals(nodeData) || "cloud".equals(nodeData)) {
                nodeData = null;
            }
            this.getPageCache().put("_IMPORTTEMPLATETREELIST_BIZOBJID_", nodeData);
        }
        super.treeNodeClick(treenodeevent);
    }

    public static boolean checkPagePermission(String permissionItemId) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        int flag = PermissionServiceHelper.checkFunctionPermission((long)userId, (long)0L, (String)"bas_manageprinttpl", (String)permissionItemId);
        return flag == 1;
    }

    private List<String> getBillNumbers() {
        String fields = "number";
        String orderby = "bizappid asc";
        QFilter modelTypeFilter = new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel", "QueryListModel"));
        QFilter isTemplateFilter = new QFilter("istemplate", "=", (Object)Boolean.FALSE);
        QFilter enableImport = new QFilter("enableimport", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{modelTypeFilter, isTemplateFilter, enableImport};
        ArrayList<String> billNumbers = new ArrayList<String>();
        try (DataSet ds = ORM.create().queryDataSet("bos_entityobject", "bos_entityobject", fields, filters, orderby);){
            for (Row row : ds) {
                billNumbers.add(row.getString("number"));
            }
        }
        return billNumbers;
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        DynamicObject[] datas;
        for (DynamicObject data : datas = e.getQueryValues()) {
            String bizObjectId = data.getString("bizobject_id");
            try {
                if (!StringUtils.isNotBlank((CharSequence)bizObjectId)) continue;
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)bizObjectId);
                Map properties = mainEntityType.getAllFields();
                Map entities = mainEntityType.getAllEntities();
                IDataEntityProperty dataEntityProperty = (IDataEntityProperty)properties.get("treeentryentity");
                if (dataEntityProperty == null) continue;
                DynamicObjectCollection arr = data.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject row : arr) {
                    String exportprop;
                    String fieldKey = row.getString("entitynumber");
                    IDataEntityProperty prop = (IDataEntityProperty)properties.get(fieldKey);
                    if (row.getDynamicObjectType().getProperty("entityname") != null) {
                        this.setEntityName(row, entities, prop, fieldKey);
                    }
                    if (row.getDynamicObjectType().getProperty("exportprop") == null || !StringUtils.isNotBlank((CharSequence)(exportprop = row.getString("exportprop")))) continue;
                    this.setExportPropName(row, entities, prop, exportprop);
                }
            }
            catch (Exception ex) {
                String errMsg = ex instanceof KDBizException || !SystemParamServiceHelper.isShowStackTrace() ? ex.getMessage() : ListExporter.formatException((Throwable)ex);
                throw new RuntimeException(String.format(ResManager.loadKDString((String)"(\u5bf9\u8c61\u6807\u8bc6\uff1a%s) ", (String)"ImportTemplateTreeListEdit_3", (String)BOS_IMPORT, (Object[])new Object[0]), bizObjectId) + errMsg);
            }
        }
    }

    private void setExportPropName(DynamicObject row, Map<String, EntityType> entities, IDataEntityProperty prop, String exportpropStr) {
        ArrayList<String> propNames = new ArrayList<String>();
        if (!(prop instanceof IBasedataField)) {
            row.set("exportprop", null);
            return;
        }
        if (prop instanceof ItemClassProp || prop instanceof FlexProp) {
            if (exportpropStr.contains("name")) {
                propNames.add(new LocaleString(ResManager.loadKDString((String)"\u540d\u79f0", (String)"ImportTemplateTreeListEdit_4", (String)BOS_IMPORT, (Object[])new Object[0])).toString());
            }
            if (exportpropStr.contains("number")) {
                propNames.add(new LocaleString(ResManager.loadKDString((String)"\u7f16\u7801", (String)"ImportTemplateTreeListEdit_5", (String)BOS_IMPORT, (Object[])new Object[0])).toString());
            }
        } else {
            BasedataEntityType type = (BasedataEntityType)((IBasedataField)prop).getComplexType();
            HashSet<String> exportProps = new HashSet<String>(Arrays.asList(StringUtils.split((String)exportpropStr, (char)',')));
            DataEntityPropertyCollection properties = type.getProperties();
            for (IDataEntityProperty refProp : properties) {
                if (refProp instanceof AttachmentProp || !(refProp instanceof IFieldHandle) || !((IFieldHandle)refProp).isExportable() || !exportProps.remove(refProp.getName())) continue;
                LocaleString disp = refProp.getDisplayName();
                propNames.add(disp != null && StringUtils.isNotBlank((CharSequence)disp.toString()) ? disp.toString() : refProp.getName());
            }
            if (exportProps.contains("name")) {
                String displayProp = type.getNameProperty();
                propNames.add(0, this.getPropDisplayName(properties, displayProp, new LocaleString(ResManager.loadKDString((String)"\u540d\u79f0", (String)"ImportTemplateTreeListEdit_4", (String)BOS_IMPORT, (Object[])new Object[0]))).toString());
            }
            if (exportProps.contains("number")) {
                String numberProp = type.getNumberProperty();
                propNames.add(0, this.getPropDisplayName(properties, numberProp, new LocaleString(ResManager.loadKDString((String)"\u7f16\u7801", (String)"ImportTemplateTreeListEdit_5", (String)BOS_IMPORT, (Object[])new Object[0]))).toString());
            }
        }
        if (propNames.isEmpty()) {
            row.set("exportprop", null);
        }
        if (row.getDynamicObjectType().getProperty("exportpropname") != null) {
            row.set("exportpropname", (Object)String.join((CharSequence)",", propNames));
        }
    }

    private Object getPropDisplayName(DataEntityPropertyCollection properties, String propKey, LocaleString defaultDisplay) {
        if (propKey == null) {
            return defaultDisplay;
        }
        IDataEntityProperty prop = (IDataEntityProperty)properties.get((Object)propKey);
        if (prop != null) {
            return this.getPropDisplayName(prop);
        }
        return defaultDisplay;
    }

    private void setEntityName(DynamicObject row, Map<String, EntityType> entities, IDataEntityProperty prop, String fieldKey) {
        if (prop != null) {
            row.set("entityname", this.getPropDisplayName(prop));
        } else {
            EntityType entityType = entities.get(fieldKey);
            if (entityType != null) {
                row.set("entityname", this.getEntityDisplayName(entityType));
            } else if ("billhead".equals(fieldKey)) {
                row.set("entityname", (Object)ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"ImportTemplateTreeListEdit_0", (String)BOS_IMPORT, (Object[])new Object[0]));
            } else if ("id".equals(fieldKey) || fieldKey.endsWith(".id")) {
                row.set("entityname", (Object)ResManager.loadKDString((String)"\u5185\u7801", (String)"ImportTemplateTreeListEdit_1", (String)BOS_IMPORT, (Object[])new Object[0]));
            } else if (fieldKey.endsWith(".pid")) {
                row.set("entityname", (Object)ResManager.loadKDString((String)"\u4e0a\u7ea7\u5185\u7801", (String)"ImportTemplateTreeListEdit_2", (String)BOS_IMPORT, (Object[])new Object[0]));
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private Object getEntityDisplayName(EntityType entityType) {
        LocaleString display = entityType.getDisplayName();
        if (display == null || StringUtils.isBlank((CharSequence)display.toString())) {
            return entityType.getName();
        }
        return display.toString();
    }

    private Object getPropDisplayName(IDataEntityProperty prop) {
        LocaleString display = prop.getDisplayName();
        if (display == null || StringUtils.isBlank((CharSequence)display.toString())) {
            return prop.getName();
        }
        return display.toString();
    }
}

