/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.inte.api.EnabledLang;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.web.actions.export.ExportWriter;

public class MultilangDesSettingPlugin
extends AbstractFormPlugin {
    private static final String FIELD_LANGUAGE_NAME = "languagename";
    private static final String FIELD_LANGUAGE_NUMBER = "languagenumber";
    private static final String FIELD_ENTRYENTITY = "entryentity";
    private static final String FIELD_ENTRY_PREFIX = "entryfield";
    private static final String FIELD_ENTITYDESCRIPTION = "entitydescription";
    private static final String FIELD_IMPORTPROP = "importprop";
    private static final String FIELD_EXPORTPROP = "exportprop";
    private static final String EXPORTPROPMAP = "exportPropMap";
    private static final String SIMPLEFIELD = "simpleField";
    private static final String FIELDMAPPING = "fieldMapping";
    private static final int ENTRYFIELDCOUNT = 30;
    private static final String BUTTON_OK = "btnok";
    private static final String BOS_MULTILANG_DES_SETTING = "bos_multilang_des_setting";
    private static final String BOS_IMPORT = "bos-import";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BUTTON_OK});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String desValue = (String)customParams.get(FIELD_ENTITYDESCRIPTION);
        String exportPropMapString = (String)customParams.get(EXPORTPROPMAP);
        LinkedHashMap exportPropMap = (LinkedHashMap)SerializationUtils.fromJsonString((String)exportPropMapString, Map.class);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(FIELD_ENTRYENTITY);
        LinkedHashMap<String, String> fieldMapping = new LinkedHashMap<String, String>();
        ArrayList<String> fieldKeyList = new ArrayList<String>(exportPropMap.size());
        this.initEntryGridMetadata(entryGrid, exportPropMap, fieldKeyList, fieldMapping);
        this.fillEntryGridData(desValue, fieldKeyList, fieldMapping);
    }

    private void initEntryGridMetadata(EntryGrid entryGrid, LinkedHashMap<String, String> exportPropMap, List<String> fieldKeyList, Map<String, String> fieldMapping) {
        for (int i = 1; i <= 30; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_ENTRY_PREFIX + i});
        }
        int index = 1;
        for (Map.Entry<String, String> exportPropEntry : exportPropMap.entrySet()) {
            entryGrid.setColumnProperty(FIELD_ENTRY_PREFIX + index, "header", (Object)new LocaleString(exportPropEntry.getValue()));
            this.getView().setVisible(Boolean.TRUE, new String[]{FIELD_ENTRY_PREFIX + index});
            String fieldKey = exportPropEntry.getKey();
            if (fieldKey.contains(".")) {
                fieldKey = fieldKey.substring(fieldKey.indexOf(".") + 1);
            }
            fieldMapping.put(FIELD_ENTRY_PREFIX + index, fieldKey);
            fieldKeyList.add(fieldKey);
            ++index;
        }
        this.getView().getPageCache().put(FIELDMAPPING, SerializationUtils.toJsonString(fieldMapping));
    }

    private void fillEntryGridData(String desValue, List<String> fieldKeyList, Map<String, String> fieldMapping) {
        Map langPropDesMapping = ExportWriter.getLangPropDesMapping((String)desValue, fieldKeyList);
        List enabledLang = InteServiceHelper.getMultiLangEnabledLang();
        IDataModel model = this.getModel();
        int[] rows = model.batchCreateNewEntryRow(FIELD_ENTRYENTITY, enabledLang.size());
        for (int i = 0; i < enabledLang.size(); ++i) {
            String number = ((EnabledLang)enabledLang.get(i)).getNumber();
            String name = ((EnabledLang)enabledLang.get(i)).getName();
            model.setValue(FIELD_LANGUAGE_NAME, (Object)name, rows[i]);
            model.setValue(FIELD_LANGUAGE_NUMBER, (Object)number, rows[i]);
            Map propDesMapping = (Map)langPropDesMapping.get(number);
            if (propDesMapping == null) continue;
            for (Map.Entry<String, String> fieldMappingEntry : fieldMapping.entrySet()) {
                String cellValue = (String)propDesMapping.get(fieldMappingEntry.getValue());
                model.setValue(fieldMappingEntry.getKey(), (Object)cellValue, rows[i]);
            }
        }
    }

    public void click(EventObject evt) {
        if (!(evt.getSource() instanceof Button)) {
            return;
        }
        Button btn = (Button)evt.getSource();
        if (BUTTON_OK.equals(btn.getKey())) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(FIELD_ENTRYENTITY);
            String fieldMappingString = this.getView().getPageCache().get(FIELDMAPPING);
            LinkedHashMap fieldMapping = (LinkedHashMap)SerializationUtils.fromJsonString((String)fieldMappingString, Map.class);
            LinkedHashMap langKeyDesMapping = new LinkedHashMap();
            for (DynamicObject entry : entryEntity) {
                String language = entry.getString(FIELD_LANGUAGE_NUMBER);
                LinkedHashMap<String, String> keyDesMapping = new LinkedHashMap<String, String>(fieldMapping.size());
                for (Map.Entry fieldMappingEntry : fieldMapping.entrySet()) {
                    String propKey = (String)fieldMappingEntry.getValue();
                    String fieldDes = entry.getString((String)fieldMappingEntry.getKey());
                    keyDesMapping.put(propKey, fieldDes);
                }
                langKeyDesMapping.put(language, keyDesMapping);
            }
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(langKeyDesMapping));
            this.getView().close();
        }
    }
}

