/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.importentry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.TreeEntryType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.importentry.model.ImportTreeRowFactory;
import kd.bos.form.plugin.importentry.model.ImportTreeRowInfo;
import kd.bos.form.plugin.importentry.model.ImportTreeRowTypeEnum;
import kd.bos.form.plugin.importentry.model.ImportTreeRowView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class AbstractImportEntryTemplatePlugin
extends AbstractBillPlugIn {
    public static final String BOS_IMPORT = "bos-import";
    protected static final String TREEENTRYENTITY = "treeentryentity";
    protected static final String TOOLBAR = "advcontoolbarap";
    protected static final String TOOLBAR_TBMAIN = "tbmain";
    protected static final String FIELD_BIZOBJ = "bizobject";
    protected static final String FIELD_ISMUSTINPUT = "ismustinput";
    protected static final String FIELD_ISIMPORT = "isimport";
    protected static final String FIELD_IMPORTPROP = "importprop";
    protected static final String FIELD_BIZOBJ_ID = "bizobject_Id";
    protected static final String BTN_MOVEUP = "advconbaritemap";
    protected static final String BTN_MOVEDOWN = "advconbaritemap1";
    protected static final String FIELD_ENTITYNAME = "entityname";
    protected static final String FIELD_ENTITYNUMBER = "entitynumber";
    protected static final String FIELD_ISBASEDATA = "isbasedata";
    protected static final String ENTITY_TEMP_LATEDESCKEY = "entitydescription";
    protected static final String FIELD_SEQ = "seq";
    protected static final String FIELD_NUMBER = "number";
    protected static final String FIELD_ID = "id";
    protected static final String FIELD_PID = "pid";
    protected static final String PARAM_BINDENTITYID = "bindEntityId";
    protected static final String PARAM_CUSTOMTEMPLATE = "customTemplate";
    protected static final String FILEPATH = "filepath";
    protected static final String FILENAME = "filename";
    protected static final String BTN_OK = "btnok";
    protected static final String EXPORTALL = "exportall";
    protected static final String FLEXPANELAPRESULT = "flexpanelapresult";
    protected static final String BTN_DOWNLOAD = "btndownload";
    protected static final String IMPORTENTRYPLUGIN = "ImportEntryPlugin";
    protected static final String OPTION_SETNULL = "SetNULL";
    protected static final String OPTION_SPLITSUBENTRIES = "SplitSubEntries";
    protected static final String MULCOMBO = "mulcombo";
    protected static final String FIELD_ISNEW = "isnew";
    protected final String RES_IF_IMPORT = ResManager.loadKDString((String)"\u662f\u5426\u5bfc\u5165", (String)"ImportTemplatePlugin_1", (String)"bos-import", (Object[])new Object[0]);
    protected final String RES_BILLHEAD_NAME = ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"ImportTemplatePlugin_3", (String)"bos-import", (Object[])new Object[0]);
    protected final String RES_ID_NAME = ResManager.loadKDString((String)"\u5339\u914did", (String)"ImportEntryTemplatePlugin_4", (String)"bos-import", (Object[])new Object[0]);
    private static final String PAGECACHE_KEY_IMPORTENTRYTREEINFO = "PAGECACHE_KEY_IMPORTENTRYTREEINFO";
    protected static final String PAGECACHE_KEY_IMPORTSTOREDATA = "PAGECACHE_KEY_IMPORTSTOREDATA";
    protected static final String PLUGIN = "plugin";
    protected ImportTreeRowFactory treeRowFactory = new ImportTreeRowFactory();
    private static final Log log = LogFactory.getLog(AbstractImportEntryTemplatePlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBAR});
        this.addItemClickListeners(new String[]{TOOLBAR_TBMAIN});
        this.addClickListeners(new String[]{FIELD_ISIMPORT, PLUGIN});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (FIELD_ISMUSTINPUT.equalsIgnoreCase(propertyName)) {
            int currentRow = e.getChangeSet()[0].getRowIndex();
            Boolean currentValue = (Boolean)e.getChangeSet()[0].getNewValue();
            this.triggerLinkage(e, FIELD_ISMUSTINPUT);
            if (currentValue.booleanValue()) {
                this.getModel().setValue(FIELD_ISIMPORT, (Object)true, currentRow);
            }
        }
        if (FIELD_ISIMPORT.equalsIgnoreCase(propertyName)) {
            this.triggerLinkage(e, FIELD_ISIMPORT);
        }
    }

    private void triggerLinkage(PropertyChangedArgs e, String changeKey) {
        this.getModel().beginInit();
        DynamicObject bizDataEntity = (DynamicObject)this.getModel().getValue(FIELD_BIZOBJ);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)bizDataEntity.getPkValue().toString());
        ImportTreeRowInfo importEntryTreeInfo = this.getCacheOfImportTreeRowInfo(dataEntityType, false);
        int currentRow = e.getChangeSet()[0].getRowIndex();
        Boolean currentValue = (Boolean)e.getChangeSet()[0].getNewValue();
        ImportTreeRowView importTreeRowView = this.treeRowFactory.convertInfoToView(importEntryTreeInfo);
        ImportTreeRowView.RowView rowView = importTreeRowView.getTreeRowInfosAtRow().get(currentRow);
        if (rowView.getTreeRowTypeEnum() == ImportTreeRowTypeEnum.MAINENTITY) {
            this.triggerLinkageFromMainEntity(importTreeRowView, currentValue, changeKey);
        }
        if (rowView.getTreeRowTypeEnum() == ImportTreeRowTypeEnum.HEAD || rowView.getTreeRowTypeEnum() == ImportTreeRowTypeEnum.ENTITY || rowView.getTreeRowTypeEnum() == ImportTreeRowTypeEnum.SUBENTITY) {
            this.triggerLinkageFromEntity(importTreeRowView, rowView, currentValue, changeKey);
        }
        if (rowView.getTreeRowTypeEnum() == ImportTreeRowTypeEnum.HEAD_PROPERTY || rowView.getTreeRowTypeEnum() == ImportTreeRowTypeEnum.ENTITY_PROPERTY || rowView.getTreeRowTypeEnum() == ImportTreeRowTypeEnum.SUBENTITY_PROPERTY) {
            this.triggerLinkageFromProperty(importTreeRowView, rowView, currentValue, changeKey);
        }
        this.resetLock(importTreeRowView);
        this.getModel().endInit();
        this.getView().updateView(TREEENTRYENTITY);
    }

    private void resetLock(ImportTreeRowView importTreeRowView) {
        Collection<ImportTreeRowView.RowView> rowViews = importTreeRowView.getTreeRowInfosAtRow().values();
        for (ImportTreeRowView.RowView rowView : rowViews) {
            if (rowView.isBaseDataProp()) continue;
            this.getView().setEnable(Boolean.FALSE, rowView.getRow(), new String[]{FIELD_IMPORTPROP});
        }
    }

    private void triggerLinkageFromMainEntity(ImportTreeRowView importTreeRowView, Boolean currentValue, String changeKey) {
        Set<Integer> rows = importTreeRowView.getTreeRowInfosAtRow().keySet();
        for (Integer row : rows) {
            this.getModel().setValue(changeKey, (Object)currentValue, row.intValue());
        }
    }

    private void triggerLinkageFromEntity(ImportTreeRowView importEntryTreeInfo, ImportTreeRowView.RowView rowView, Boolean currentValue, String changeKey) {
        int parentRow = rowView.getParentRow();
        int currRow = rowView.getRow();
        if (!currentValue.booleanValue()) {
            this.getModel().setValue(changeKey, (Object)false, parentRow);
        }
        this.triggerFromEntity(importEntryTreeInfo, currentValue, currRow, changeKey);
        if (rowView.getTreeRowTypeEnum() == ImportTreeRowTypeEnum.SUBENTITY) {
            int entryRow = rowView.getParentRow();
            if (currentValue.booleanValue()) {
                this.triggerChangeWithSameLevelRows(importEntryTreeInfo, entryRow, changeKey);
            } else {
                this.getModel().setValue(changeKey, (Object)false, entryRow);
            }
        }
        this.setMainEntityButton(importEntryTreeInfo, changeKey);
    }

    private void triggerFromEntity(ImportTreeRowView importEntryTreeInfo, Boolean currentValue, int currRow, String changeKey) {
        List childViews = importEntryTreeInfo.getTreeRowInfosAtRow().values().stream().filter(val -> val.getParentRow() == currRow).collect(Collectors.toList());
        for (ImportTreeRowView.RowView view : childViews) {
            this.getModel().setValue(changeKey, (Object)currentValue, view.getRow());
            if (view.getTreeRowTypeEnum() != ImportTreeRowTypeEnum.SUBENTITY) continue;
            this.triggerFromEntity(importEntryTreeInfo, currentValue, view.getRow(), changeKey);
        }
    }

    private void setMainEntityButton(ImportTreeRowView importEntryTreeInfo, String changeKey) {
        Optional<Object> anyNotChoose = importEntryTreeInfo.getTreeRowInfosAtRow().values().stream().filter(val -> val.getParentRow() == 0 && val.getRow() != 0).map(ImportTreeRowView.RowView::getRow).map(i -> this.getModel().getValue(changeKey, i.intValue())).collect(Collectors.toList()).stream().filter(value -> (Boolean)value == false).findAny();
        if (!anyNotChoose.isPresent()) {
            this.getModel().setValue(changeKey, (Object)true, 0);
        } else {
            this.getModel().setValue(changeKey, (Object)false, 0);
        }
    }

    protected void triggerLinkageFromProperty(ImportTreeRowView importEntryTreeInfo, ImportTreeRowView.RowView treeRowInfo, Boolean currentValue, String changeKey) {
        int refRow = treeRowInfo.getRefRow();
        List ref4Rows = treeRowInfo.getRef4Rows();
        if (0 != refRow && currentValue.booleanValue()) {
            this.getModel().setValue(changeKey, (Object)true, treeRowInfo.getRefRow());
        }
        if (!currentValue.booleanValue() && ref4Rows != null && ref4Rows.size() > 0) {
            for (Integer ref4Row : ref4Rows) {
                this.getModel().setValue(changeKey, (Object)false, ref4Row.intValue());
            }
        }
        this.getModel().setValue(changeKey, (Object)false, treeRowInfo.getParentRow());
        if (!currentValue.booleanValue()) {
            this.getModel().setValue(changeKey, (Object)false, treeRowInfo.getParentRow());
            this.getModel().setValue(changeKey, (Object)false, 0);
        }
        int parentRow = treeRowInfo.getParentRow();
        this.triggerChangeWithSameLevelRows(importEntryTreeInfo, parentRow, changeKey);
        if (treeRowInfo.getTreeRowTypeEnum() == ImportTreeRowTypeEnum.SUBENTITY_PROPERTY) {
            int entryRow = importEntryTreeInfo.getTreeRowInfosAtRow().get(treeRowInfo.getParentRow()).getParentRow();
            if (currentValue.booleanValue()) {
                this.triggerChangeWithSameLevelRows(importEntryTreeInfo, entryRow, changeKey);
            } else {
                this.getModel().setValue(changeKey, (Object)false, entryRow);
            }
        }
        this.setMainEntityButton(importEntryTreeInfo, changeKey);
    }

    private void triggerChangeWithSameLevelRows(ImportTreeRowView importEntryTreeInfo, int entryRow, String changeKey) {
        List childRows = importEntryTreeInfo.getTreeRowInfosAtRow().values().stream().filter(val -> val.getParentRow() == entryRow).map(ImportTreeRowView.RowView::getRow).collect(Collectors.toList());
        Optional<Integer> disableSubEntry = childRows.stream().filter(row -> {
            Object value = this.getModel().getValue(changeKey, row.intValue());
            return value == null || (Boolean)value == false;
        }).findAny();
        if (!disableSubEntry.isPresent()) {
            this.getModel().setValue(changeKey, (Object)true, entryRow);
        }
    }

    protected void functionWhenInitModel(Consumer<Void> consumer) {
        this.getModel().beginInit();
        consumer.accept(null);
        this.getModel().endInit();
    }

    protected ImportTreeRowInfo getCacheOfImportTreeRowInfo(MainEntityType mainEntityType, Boolean refresh) {
        String json = this.getPageCache().get(PAGECACHE_KEY_IMPORTENTRYTREEINFO);
        if (StringUtils.isBlank((CharSequence)json) || refresh.booleanValue()) {
            ImportTreeRowInfo importTreeRowInfo = this.createImportEntryTreeInfo(mainEntityType, this.getNeedShowEntity());
            this.refreshCacheOfImportEntryTreeInfo(importTreeRowInfo);
            return importTreeRowInfo;
        }
        return (ImportTreeRowInfo)SerializationUtils.fromJsonString((String)json, ImportTreeRowInfo.class);
    }

    protected void refreshCacheOfImportEntryTreeInfo(ImportTreeRowInfo importTreeRowInfo) {
        this.getPageCache().put(PAGECACHE_KEY_IMPORTENTRYTREEINFO, SerializationUtils.toJsonString((Object)importTreeRowInfo));
    }

    private ImportTreeRowInfo createImportEntryTreeInfo(MainEntityType mainType, List<String> needShowEntity) {
        ImportTreeRowInfo importTreeRowInfo = this.treeRowFactory.newInstance(mainType, needShowEntity);
        importTreeRowInfo.pruneAboutHead();
        return importTreeRowInfo;
    }

    protected void clearImportInfo(int row) {
        this.getModel().setValue(FIELD_IMPORTPROP, null, row);
        this.getModel().setValue(FIELD_ISBASEDATA, (Object)Boolean.FALSE, row);
        this.getModel().setValue(FIELD_ISIMPORT, (Object)Boolean.FALSE, row);
    }

    protected void fillTreeRowInfoAboutEntity(EntityType currentEntityType, int row) {
        String entityNumber = this.getEntityNodeNumberInMainEntity(currentEntityType);
        String entityName = this.getEntityNodeNameInMainEntity(currentEntityType);
        this.getModel().setValue(FIELD_ENTITYNAME, (Object)entityName, row);
        this.getModel().setValue(FIELD_ENTITYNUMBER, (Object)entityNumber, row);
        this.getView().setEnable(Boolean.FALSE, row, new String[]{FIELD_IMPORTPROP});
        this.getView().setEnable(Boolean.FALSE, row, new String[]{ENTITY_TEMP_LATEDESCKEY});
    }

    protected String getEntityNodeNumberInMainEntity(EntityType currentEntityType) {
        String entityNumber = currentEntityType.getName();
        if (currentEntityType instanceof MainEntityType) {
            entityNumber = "billhead";
        }
        return entityNumber;
    }

    protected String getEntityNodeNameInMainEntity(EntityType currentEntityType) {
        String entityName;
        String string = entityName = currentEntityType.getDisplayName() != null ? currentEntityType.getDisplayName().toString() : "";
        if (currentEntityType instanceof MainEntityType) {
            entityName = this.RES_BILLHEAD_NAME;
        }
        return entityName;
    }

    protected void fillTreeRowInfoAboutEntityProp(DynamicProperty property, int row) {
        String propertyName = property.getDisplayName() == null ? property.getName() : property.getDisplayName().toString();
        String propertyNumber = property.getName();
        if (property instanceof PKFieldProp && property == property.getParent().getPrimaryKey()) {
            propertyName = this.RES_ID_NAME;
            if (property.getParent() instanceof EntryType) {
                propertyNumber = property.getParent().getName() + ".$matchid$";
            }
        } else if (property.getName().equals(FIELD_PID) && property.getParent() instanceof TreeEntryType) {
            propertyName = ResManager.loadKDString((String)"\u4e0a\u7ea7\u5185\u7801", (String)"ImportTemplatePlugin_13", (String)BOS_IMPORT, (Object[])new Object[0]);
            propertyNumber = property.getParent().getName() + "." + property.getName();
        }
        if (property instanceof FieldProp && ((FieldProp)property).isMustInput() || property instanceof BasedataProp && ((BasedataProp)property).isMustInput() || property instanceof MulBasedataProp && ((MulBasedataProp)property).isMustInput()) {
            propertyName = propertyName + "*";
        }
        this.getModel().setValue(FIELD_ENTITYNAME, (Object)propertyName, row);
        this.getModel().setValue(FIELD_ENTITYNUMBER, (Object)propertyNumber, row);
    }

    protected void fillTreeImportPropAboutEntityProp(IDataEntityProperty property, int row) {
        boolean isbasedata;
        boolean bl = isbasedata = property instanceof IBasedataField && !(property instanceof FlexProp);
        if (isbasedata) {
            this.getModel().setValue(FIELD_IMPORTPROP, (Object)FIELD_NUMBER, row);
            this.getModel().setValue(FIELD_ISBASEDATA, (Object)Boolean.TRUE, row);
        } else {
            this.getView().setEnable(Boolean.FALSE, row, new String[]{FIELD_IMPORTPROP});
        }
    }

    protected void fillTreeIsImportAndIsMustInputAboutEntityProp(IDataEntityProperty property, int propRow) {
        if (property instanceof FieldProp && ((FieldProp)property).isMustInput() || property instanceof BasedataProp && ((BasedataProp)property).isMustInput() || property instanceof MulBasedataProp && ((MulBasedataProp)property).isMustInput()) {
            this.getModel().setValue(FIELD_ISIMPORT, (Object)Boolean.TRUE, propRow);
            this.getModel().setValue(FIELD_ISMUSTINPUT, (Object)Boolean.TRUE, propRow);
        }
    }

    protected void createEntryRow(MainEntityType mainEntityType, ImportTreeRowView importTreeRowView) {
        for (Map.Entry<Integer, ImportTreeRowView.RowView> entry : importTreeRowView.getTreeRowInfosAtRow().entrySet()) {
            ImportTreeRowView.RowView treeRowInfo = entry.getValue();
            if (treeRowInfo.getTreeRowTypeEnum() == ImportTreeRowTypeEnum.MAINENTITY) {
                this.functionWhenInitModel(v -> {
                    int newEntryRow = this.getModel().createNewEntryRow(TREEENTRYENTITY);
                    log.debug(String.format("\u751f\u6210%s\u884c, \u4e3b\u5b9e\u4f53", newEntryRow));
                });
                this.getModel().setValue(FIELD_ENTITYNAME, (Object)mainEntityType.getDisplayName().toString(), treeRowInfo.getRow());
                this.getModel().setValue(FIELD_ENTITYNUMBER, (Object)mainEntityType.getName(), treeRowInfo.getRow());
                this.getView().setEnable(Boolean.FALSE, treeRowInfo.getRow(), new String[]{FIELD_IMPORTPROP});
                this.getView().setEnable(Boolean.FALSE, treeRowInfo.getRow(), new String[]{ENTITY_TEMP_LATEDESCKEY});
                continue;
            }
            if (treeRowInfo.getTreeRowTypeEnum() == ImportTreeRowTypeEnum.HEAD || treeRowInfo.getTreeRowTypeEnum() == ImportTreeRowTypeEnum.ENTITY || treeRowInfo.getTreeRowTypeEnum() == ImportTreeRowTypeEnum.SUBENTITY) {
                this.functionWhenInitModel(v -> {
                    int newEntryRow = this.getModel().insertEntryRow(TREEENTRYENTITY, treeRowInfo.getParentRow());
                    log.info(String.format("\u751f\u6210%s\u884c, \u5b9e\u4f53\u7c7b\u578b%s, \u5b9e\u4f53\u7f16\u7801%s, \u4e0a\u7ea7\u884c%s", newEntryRow, treeRowInfo.getTreeRowTypeEnum().getDesc(), treeRowInfo.getEntityNumber(), treeRowInfo.getParentRow()));
                });
                this.fillTreeRowInfoAboutEntity(treeRowInfo.getEntityType(mainEntityType), treeRowInfo.getRow());
                continue;
            }
            if (treeRowInfo.getTreeRowTypeEnum() != ImportTreeRowTypeEnum.HEAD_PROPERTY && treeRowInfo.getTreeRowTypeEnum() != ImportTreeRowTypeEnum.ENTITY_PROPERTY && treeRowInfo.getTreeRowTypeEnum() != ImportTreeRowTypeEnum.SUBENTITY_PROPERTY) continue;
            this.functionWhenInitModel(v -> {
                int newEntryRow = this.getModel().insertEntryRow(TREEENTRYENTITY, treeRowInfo.getParentRow());
                log.debug(String.format("\u751f\u6210%s\u884c, \u5b9e\u4f53\u7c7b\u578b%s, \u5c5e\u6027\u7f16\u7801%s, \u4e0a\u7ea7\u884c%s", newEntryRow, treeRowInfo.getTreeRowTypeEnum().getDesc(), treeRowInfo.getPropertyNumber(), treeRowInfo.getParentRow()));
            });
            this.clearImportInfo(treeRowInfo.getRow());
            IDataEntityProperty property = treeRowInfo.getProperty(mainEntityType);
            this.fillTreeRowInfoAboutEntityProp((DynamicProperty)property, treeRowInfo.getRow());
            this.fillTreeImportPropAboutEntityProp(property, treeRowInfo.getRow());
            this.fillTreeIsImportAndIsMustInputAboutEntityProp(property, treeRowInfo.getRow());
        }
    }

    protected Optional<Map<String, Map<String, Object>>> loadDataEntiy() {
        String mapJson = this.getPageCache().get(PAGECACHE_KEY_IMPORTSTOREDATA);
        if (StringUtils.isNotBlank((CharSequence)mapJson)) {
            Map s = (Map)SerializationUtils.deSerializeFromBase64((String)mapJson);
            return Optional.of(s);
        }
        EntryGrid grid = (EntryGrid)this.getControl(TREEENTRYENTITY);
        grid.setColumnProperty(FIELD_ISIMPORT, "header", (Object)new LocaleString(this.RES_IF_IMPORT));
        String bizEntityId = (String)this.getModel().getValue(FIELD_BIZOBJ_ID);
        if (StringUtils.isNotBlank((CharSequence)bizEntityId)) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_importentry_template", (QFilter[])new QFilter(FIELD_ID, "=", this.getModel().getValue(FIELD_ID)).toArray());
            boolean isNullDyn = dynamicObject == null;
            DynamicObjectCollection dynColl = isNullDyn ? new DynamicObjectCollection() : dynamicObject.getDynamicObjectCollection(TREEENTRYENTITY);
            Optional<Map<String, Map<String, Object>>> storeDatas = this.getStoreDatas(dynColl);
            this.getPageCache().put(PAGECACHE_KEY_IMPORTSTOREDATA, SerializationUtils.serializeToBase64(storeDatas.get()));
            return storeDatas;
        }
        return Optional.empty();
    }

    protected Optional<Map<String, Map<String, Object>>> loadDataEntiyFromModel() {
        EntryGrid grid = (EntryGrid)this.getControl(TREEENTRYENTITY);
        grid.setColumnProperty(FIELD_ISIMPORT, "header", (Object)new LocaleString(this.RES_IF_IMPORT));
        String bizEntityId = (String)this.getModel().getValue(FIELD_BIZOBJ_ID);
        if (StringUtils.isNotBlank((CharSequence)bizEntityId)) {
            DynamicObjectCollection dynColl = this.getModel().getEntryEntity(TREEENTRYENTITY);
            return this.getStoreDatas(dynColl);
        }
        return Optional.empty();
    }

    private Optional<Map<String, Map<String, Object>>> getStoreDatas(DynamicObjectCollection dynColl) {
        LinkedHashMap storeDatas = new LinkedHashMap();
        String root = "";
        for (DynamicObject dyn : dynColl) {
            long pid = dyn.getLong(FIELD_PID);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(FIELD_ID, dyn.getPkValue());
            data.put(FIELD_PID, pid);
            data.put(FIELD_ISMUSTINPUT, dyn.getBoolean(FIELD_ISMUSTINPUT));
            data.put(FIELD_ISIMPORT, dyn.getBoolean(FIELD_ISIMPORT));
            data.put(FIELD_IMPORTPROP, dyn.getString(FIELD_IMPORTPROP));
            data.put(FIELD_ISBASEDATA, dyn.getBoolean(FIELD_ISBASEDATA));
            data.put(FIELD_SEQ, dyn.getInt(FIELD_SEQ));
            data.put(ENTITY_TEMP_LATEDESCKEY, dyn.getLocaleString(ENTITY_TEMP_LATEDESCKEY));
            if (pid == 0L) {
                root = dyn.getString(FIELD_ENTITYNUMBER);
                storeDatas.put(root, data);
                continue;
            }
            storeDatas.put(root + "." + dyn.getString(FIELD_ENTITYNUMBER), data);
        }
        return Optional.of(storeDatas);
    }

    protected List<String> getNeedShowEntity() {
        ArrayList<String> needShowEntity = new ArrayList<String>();
        String value = (String)this.getModel().getValue(MULCOMBO);
        if (StringUtils.isBlank((CharSequence)value)) {
            return needShowEntity;
        }
        List collect = Arrays.stream(value.split(",")).collect(Collectors.toList());
        DynamicObject bizObj = (DynamicObject)this.getModel().getValue(FIELD_BIZOBJ);
        String billFormId = bizObj.getString(((BasedataEntityType)bizObj.getDataEntityType()).getNumberProperty());
        MainEntityType mainType = null;
        try {
            mainType = (MainEntityType)EntityMetadataCache.getDataEntityType((String)billFormId).clone();
        }
        catch (CloneNotSupportedException e) {
            log.error((Throwable)e);
        }
        if (mainType == null) {
            return needShowEntity;
        }
        mainType.getAllEntities().entrySet().forEach(entry -> {
            if (collect.contains(entry.getKey()) && entry.getValue() instanceof EntryType && !(entry.getValue() instanceof SubEntryType)) {
                for (IDataEntityProperty property : ((EntityType)entry.getValue()).getProperties()) {
                    if (!(property instanceof SubEntryProp)) continue;
                    needShowEntity.add(property.getName());
                }
                needShowEntity.add((String)entry.getKey());
            }
        });
        return needShowEntity;
    }

    protected void initEntryMulCombo(String entityId, String mulComboValue) {
        Collection mulIntersection;
        String entryValues;
        MulComboEdit mulCombo = (MulComboEdit)this.getView().getControl(MULCOMBO);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityId);
        List entryEntity = mainType.getAllEntities().values().stream().filter(i -> i.getClass().equals(EntryType.class)).collect(Collectors.toList());
        ArrayList<ComboItem> keyfieldItems = new ArrayList<ComboItem>(10);
        for (Object entityType : entryEntity) {
            keyfieldItems.add(new ComboItem(entityType.getDisplayName(), entityType.getName()));
            for (IDataEntityProperty property : entityType.getProperties()) {
                if (!(property instanceof SubEntryType)) continue;
                property.getName();
            }
        }
        mulCombo.setComboItems(keyfieldItems);
        StringBuilder mulValueBuilder = new StringBuilder();
        for (EntityType entityType : entryEntity) {
            mulValueBuilder.append(entityType.getName()).append(",");
        }
        String mulValue = mulValueBuilder.toString();
        List<Object> mulValues = new ArrayList();
        List<Object> mulComboValues = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)mulValue)) {
            mulValues = Arrays.asList(mulValue.split(","));
        }
        if (StringUtils.isNotBlank((CharSequence)mulComboValue)) {
            mulComboValues = Arrays.asList(mulComboValue.split(","));
        }
        if (StringUtils.isBlank((CharSequence)(entryValues = String.join((CharSequence)",", mulIntersection = CollectionUtils.intersection(mulValues, mulComboValues))))) {
            entryValues = mulValue;
        }
        this.getModel().setValue(MULCOMBO, (Object)(StringUtils.isBlank((CharSequence)entryValues) ? null : entryValues));
        this.getView().updateView(MULCOMBO);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals(PLUGIN)) {
            this.showPlugin();
        }
    }

    private void showPlugin() {
        Object value = this.getModel().getValue(PLUGIN);
        String formId = this.getView().getFormShowParameter().getFormId();
        List<?> plugins = this.getPluginsArray(value);
        FormShowParameter formShowParameter = this.buildShowParams(formId, plugins, new CloseCallBack((IFormPlugin)this, PLUGIN));
        this.getView().showForm(formShowParameter);
    }

    private List<?> getPluginsArray(Object val) {
        List plugins = new ArrayList();
        if (val != null && StringUtils.isNotEmpty((CharSequence)val.toString())) {
            plugins = SerializationUtils.fromJsonStringToList((String)val.toString(), Map.class);
        }
        return plugins;
    }

    private FormShowParameter buildShowParams(String formId, List<?> plugins, CloseCallBack callback) {
        FormShowParameter showParam = new FormShowParameter();
        showParam.setFormId("ide_plugins");
        showParam.getOpenStyle().setShowType(ShowType.Modal);
        showParam.setCustomParam("value", plugins);
        showParam.setCustomParam("formId", (Object)formId);
        showParam.setCloseCallBack(callback);
        return showParam;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        Map value;
        if (closedCallBackEvent.getActionId().equals(PLUGIN) && (value = (Map)(returnData = closedCallBackEvent.getReturnData())) != null && value.get("value") != null && value.get("value") instanceof List) {
            List plugins = (List)value.get("value");
            this.callBackPlugin(PLUGIN, plugins);
        }
    }

    private void callBackPlugin(String actionId, List<Map<String, Object>> plugins) {
        if (plugins.isEmpty()) {
            return;
        }
        if (!CollectionUtils.isEmpty(plugins)) {
            this.getModel().setValue(actionId, (Object)SerializationUtils.toJsonString(plugins));
        }
    }

    protected void restoreTreeRowPkIdInfosFromStore(ImportTreeRowView importTreeRowView, Map<String, Map<String, Object>> storeDatas) {
        for (Map.Entry<Integer, ImportTreeRowView.RowView> entry : importTreeRowView.getTreeRowInfosAtRow().entrySet()) {
            ImportTreeRowView.RowView treeRowInfo = entry.getValue();
            treeRowInfo.functionToConditionTreeRowType(storeDatas, this::restoreTreeRowPkIdInfo);
        }
    }

    private void restoreTreeRowPkIdInfo(Map<String, Object> storeData, int row) {
        DynamicObject rowObj = this.getModel().getEntryRowEntity(TREEENTRYENTITY, row);
        if (storeData != null) {
            if (storeData.get(FIELD_ID) != null) {
                rowObj.set(FIELD_ID, storeData.get(FIELD_ID));
            } else {
                storeData.put(FIELD_ID, rowObj.get(FIELD_ID));
            }
            rowObj.set(FIELD_PID, storeData.get(FIELD_PID));
        }
    }

    protected void restoreTreeRowImportInfosFromStore(ImportTreeRowView importTreeRowView, Map<String, Map<String, Object>> storeDatas) {
        for (Map.Entry<Integer, ImportTreeRowView.RowView> entry : importTreeRowView.getTreeRowInfosAtRow().entrySet()) {
            ImportTreeRowView.RowView treeRowInfo = entry.getValue();
            treeRowInfo.functionToConditionTreeRowType(storeDatas, this::restoreTreeRowImportInfo);
        }
    }

    private void restoreTreeRowImportInfo(Map<String, Object> storeData, int row) {
        DynamicObject rowObj = this.getModel().getEntryRowEntity(TREEENTRYENTITY, row);
        if (storeData != null && storeData.get(FIELD_ISNEW) == null) {
            this.clearImportInfo(row);
            rowObj.set(FIELD_ISMUSTINPUT, storeData.get(FIELD_ISMUSTINPUT));
            rowObj.set(FIELD_ISIMPORT, storeData.get(FIELD_ISIMPORT));
            rowObj.set(FIELD_IMPORTPROP, storeData.get(FIELD_IMPORTPROP));
            rowObj.set(FIELD_ISBASEDATA, storeData.get(FIELD_ISBASEDATA));
            rowObj.set(ENTITY_TEMP_LATEDESCKEY, storeData.get(ENTITY_TEMP_LATEDESCKEY));
        }
    }
}

