/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.importentry;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.dto.ImportPermissionParam;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.exportentry.ImportEntryModelExporter;
import kd.bos.form.exportentry.ImportEntryWriterBuilder;
import kd.bos.form.mservice.ImportPermissionService;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.util.ImportOperationLog;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;

public class DownLoadEntryTemplatePlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final Log log = LogFactory.getLog(DownLoadEntryTemplatePlugin.class);
    private static final String BILLLISTAP = "billlistap";
    private static final String BTN_OK = "btnok";
    private static final String BTN_NEWTEMPLATE = "newtemplate";
    private static final String PARAM_BINDENTITYID = "BillFormId";
    private static final String FIELD_BIZOBJ_NUMBER = "bizobject.number";
    private static final String FIELD_NAME = "name";
    public static final String BTN_SURE = "btnsure";
    private static final String FIELD_TEMPORARYFIELD = "temporaryfield";
    private static final String FIELD_ATTACHMENTFIELD = "sampletemplateattach";
    private final String RES_SAMPLE = ResManager.loadKDString((String)"\u793a\u4f8b", (String)"DownloadTemplatePlugin_3", (String)"bos-import", (Object[])new Object[0]);
    private static final String FIELD_BASEDATA_ID = "fbasedataid";
    private static final String FIELD_URL = "url";
    private ImportPermissionService importPermissionService = new ImportPermissionService();
    private static final String MAIN_ORG_IDS = "MainOrgIds";

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        Long pkId = (Long)billList.getFocusRowPkId();
        if (fieldName.equalsIgnoreCase(FIELD_NAME)) {
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId(billList.getEntityId());
            parameter.setStatus(OperationStatus.EDIT);
            parameter.setPkId((Object)pkId);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "viewtemplate"));
            this.getView().showForm((FormShowParameter)parameter);
            return;
        }
        if (fieldName.equalsIgnoreCase(FIELD_TEMPORARYFIELD)) {
            BillList billlist = (BillList)evt.getSource();
            DynamicObject row = BusinessDataServiceHelper.loadSingle((Object)billlist.getCurrentSelectedRowInfo().getPrimaryKeyValue(), (DynamicObjectType)billlist.getEntityType());
            DynamicObjectCollection attachments = row.getDynamicObjectCollection(FIELD_ATTACHMENTFIELD);
            attachments.forEach(attach -> {
                DynamicObject attachment = attach.getDynamicObject(FIELD_BASEDATA_ID);
                String url = attachment.getString(FIELD_URL);
                if (StringUtils.isNotBlank((CharSequence)url)) {
                    String attachmentFullUrl = UrlService.getAttachmentFullUrl((String)url);
                    String entityNum = billlist.getEntityType().getName();
                    if (StringUtils.isNotBlank((CharSequence)entityNum)) {
                        String appId = EntityMetadataCache.getDataEntityType((String)entityNum).getAppId();
                        attachmentFullUrl = attachmentFullUrl + "&fId=" + entityNum + "&appId=" + appId;
                    }
                    this.getView().download(attachmentFullUrl);
                }
            });
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK, BTN_NEWTEMPLATE, BTN_SURE});
        BillList list = (BillList)this.getControl(BILLLISTAP);
        list.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        BillList list = (BillList)this.getControl(BILLLISTAP);
        list.addPackageDataListener(pkg -> {
            if (FIELD_TEMPORARYFIELD.equalsIgnoreCase(((AbstractColumnDesc)pkg.getSource()).getKey()) && !pkg.getRowData().getDynamicObjectCollection(FIELD_ATTACHMENTFIELD).isEmpty()) {
                pkg.setFormatValue((Object)this.RES_SAMPLE);
            }
        });
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_BINDENTITYID);
        String isForExportEntryStr = (String)this.getView().getFormShowParameter().getCustomParam("isForExportEntry");
        boolean isForExportEntry = StringUtils.isNotEmpty((CharSequence)isForExportEntryStr) && Boolean.parseBoolean(isForExportEntryStr);
        this.getView().setVisible(Boolean.valueOf(isForExportEntry), new String[]{BTN_SURE});
        this.getView().setVisible(Boolean.valueOf(!isForExportEntry), new String[]{BTN_OK});
        if (isForExportEntry) {
            this.getView().setFormTitle(new LocaleString(ResManager.loadKDString((String)"\u9009\u62e9\u6a21\u677f", (String)"ImportTemplateTreeListEdit_6", (String)"bos-export", (Object[])new Object[0])));
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            billList.setMulti(false);
        }
        if (!StringUtils.isBlank((CharSequence)billFormId)) {
            FilterParameter filterParameter = new FilterParameter();
            QFilter filter = this.buildQFilter(billFormId);
            filterParameter.setFilter(filter);
            list.setQueryFilterParameter(filterParameter);
        }
    }

    private QFilter buildQFilter(String billFormId) {
        Long userId = Long.parseLong(RequestContext.getOrCreate().getUserId());
        QFilter availableTemplate = new QFilter("enable", "=", (Object)"1");
        QFilter filter = new QFilter(FIELD_BIZOBJ_NUMBER, "=", (Object)billFormId).and(availableTemplate);
        return filter;
    }

    public void afterBindData(EventObject e) {
        BillList list = (BillList)this.getControl(BILLLISTAP);
        list.selectRows(0, true);
    }

    public void click(EventObject evt) {
        switch (((Control)evt.getSource()).getKey()) {
            case "btnok": {
                try {
                    this.pushBillTemplate();
                    break;
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                    throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
                }
            }
            case "newtemplate": {
                BillList list = (BillList)this.getControl(BILLLISTAP);
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId(list.getEntityId());
                parameter.setCustomParam("bindEntityId", this.getView().getFormShowParameter().getCustomParam(PARAM_BINDENTITYID));
                parameter.setStatus(OperationStatus.ADDNEW);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_NEWTEMPLATE));
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "btnsure": {
                FormShowParameter currShowParameter = this.getView().getFormShowParameter();
                OperationResult result = new OperationResult();
                String orgIdsStr = (String)currShowParameter.getCustomParam(MAIN_ORG_IDS);
                ImportPermissionParam.Buidler importPermissionParamBuidler = new ImportPermissionParam.Buidler().setBizAppId((String)currShowParameter.getCustomParam("CheckRightAppId")).setRealEntityId((String)currShowParameter.getCustomParam("RealPermissionEntityId")).setCurrentEntityId((String)currShowParameter.getCustomParam(PARAM_BINDENTITYID)).setOperateName((String)currShowParameter.getCustomParam("OperateName")).setPermissionItemId((String)currShowParameter.getCustomParam("PermissionItemId")).setMainOrgIds(StringUtils.isNotBlank((CharSequence)orgIdsStr) ? JSON.parseArray((String)orgIdsStr, Long.class) : new ArrayList(0)).setResult(result);
                if (!this.importPermissionService.validatePermission(importPermissionParamBuidler.build())) {
                    this.importPermissionService.doFailCheckRight(this.getView(), result);
                    return;
                }
                BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
                Object[] templates = billList.getSelectedRows().getPrimaryKeyValues();
                if (templates == null || templates.length == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u3002", (String)"SelectExportTemplatePlugin_0", (String)"bos-export", (Object[])new Object[0]));
                    return;
                }
                this.getView().returnDataToParent((Object)templates);
                this.getView().close();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        BillList list = (BillList)this.getControl(BILLLISTAP);
        list.refreshData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushBillTemplate() throws IOException {
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_BINDENTITYID);
        if (StringUtils.isBlank((CharSequence)billFormId)) {
            return;
        }
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        Object[] templates = billList.getSelectedRows().getPrimaryKeyValues();
        if (templates == null || templates.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4e0b\u8f7d\u7684\u6a21\u677f\u3002", (String)"DownloadTemplatePlugin_7", (String)"bos-import", (Object[])new Object[0]));
            return;
        }
        int maxTemplate = this.getMaxDownloadTemplateCountProperty();
        if (templates.length > maxTemplate) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u540c\u65f6\u4e0b\u8f7d%s\u4e2a\u6a21\u677f\u3002", (String)"DownloadTemplatePlugin_5", (String)"bos-import", (Object[])new Object[0]), maxTemplate));
            return;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)billFormId);
        for (Object template : templates) {
            String fileName = this.createFileName(mainEntityType, (Long)template);
            ExportWriterFormat format = new ImportEntryWriterBuilder().build(billFormId, ((Long)template).longValue());
            try (ImportEntryModelExporter dataExporter = new ImportEntryModelExporter(format);){
                dataExporter.init(null);
                dataExporter.write();
                String url = dataExporter.flush(this.getModel().getDataEntityType(), fileName);
                url = UrlService.getAttachmentFullUrl((String)url);
                this.getView().download(url);
                this.getView().sendFormAction(this.getView());
            }
        }
        ImportOperationLog.getInstance().createAppLog(billFormId, new MultiLangEnumBridge("\u4e0b\u8f7d", "DownLoadEntryTemplatePlugin_0", "bos-import"), new MultiLangEnumBridge("\u5355\u636e\u4f53\u5bfc\u5165\u6a21\u677f\u4e0b\u8f7d\u6210\u529f", "DownLoadEntryTemplatePlugin_1", "bos-import"), new String[0]);
    }

    private String createFileName(MainEntityType mainEntityType, Long templateId) {
        DynamicObject templateData = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"bos_importentry_template");
        String fileName = mainEntityType.getDisplayName().getLocaleValue() + "_";
        fileName = templateData != null ? fileName + templateData.get(FIELD_NAME) : fileName + ResManager.loadKDString((String)"\u65e0\u6a21\u677f\u540d\u79f0", (String)"ImportTemplatePlugin_24", (String)"bos-import", (Object[])new Object[0]);
        return fileName;
    }

    private int getMaxDownloadTemplateCountProperty() {
        try {
            return Integer.parseInt(System.getProperty("max.download.template.count", "20"));
        }
        catch (NumberFormatException e) {
            log.warn((Throwable)e);
            return 20;
        }
    }
}

