/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.importentry;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.dto.ImportPermissionParam;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.ImportStartData;
import kd.bos.form.plugin.importentry.ImportEntryUploadFilePlugin;
import kd.bos.form.plugin.importentry.model.ImportEntryTypeEnum;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.svc.util.FileHandlerUtil;

public class ImportEntryStartPlugin
extends ImportEntryUploadFilePlugin {
    private static final Log log = LogFactory.getLog(ImportEntryStartPlugin.class);
    private static final String MAIN_ORG_IDS = "MainOrgIds";
    private static final String REAL_PERMISSION_ENTITY_ID = "RealPermissionEntityId";
    private static final String OPERATE_NAME = "OperateName";
    private static final String PERMISSION_ITEM_ID = "PermissionItemId";
    private static final String TOP_PAGE_ID = "topPageId";
    private static final String BOS_DOWNLOADENTRYTEMPLATE = "bos_downloadentrytemplate";
    private static final String BTN_DOWNLOAD = "btndownload";
    private static final String BTN_OK = "btnok";
    private static final String BTN_DELETE = "btndelete";
    private static final String BOS_ENTRY_IMPORTING = "bos_entryimporting";
    private static final String NEW_TIPS_FLEX = "new_tips_flex";
    private static final String BIG_ENTRY_TIPS = "bigentry_tips";
    private static final String OVERRIDE_TYPE_FLEX = "override_typeflex";
    private static final String OVERRIDE_NEW_TYPE_FLEX = "overridenew_typeflex";

    public void initialize() {
        this.addClickListeners(new String[]{BTN_OK, BTN_DOWNLOAD, BTN_DELETE});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"import_type", (CharSequence)name)) {
            String importType = (String)this.getModel().getValue("import_type");
            ImportEntryTypeEnum importTypeEnum = ImportEntryTypeEnum.getImportTypeEnum(importType);
            this.resetImportTypeTips(importTypeEnum);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.resetImportTypeTips(ImportEntryTypeEnum.NEW);
        this.setImportTypeVisible();
    }

    private void setImportTypeVisible() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object importEntryTypeVisible = formShowParameter.getCustomParam("ImportEntryTypeVisible");
        if (StringUtils.isNotBlank((Object)importEntryTypeVisible)) {
            this.getView().setVisible(Boolean.valueOf(Boolean.parseBoolean(importEntryTypeVisible.toString())), new String[]{"import_type"});
        }
    }

    private void resetImportTypeTips(ImportEntryTypeEnum typeEnum) {
        if (ImportEntryTypeEnum.NEW == typeEnum) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{OVERRIDE_TYPE_FLEX, BIG_ENTRY_TIPS, OVERRIDE_NEW_TYPE_FLEX});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{NEW_TIPS_FLEX});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(ImportEntryTypeEnum.OVERRIDE_AND_NEW == typeEnum), new String[]{OVERRIDE_NEW_TYPE_FLEX});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{OVERRIDE_TYPE_FLEX, BIG_ENTRY_TIPS});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{NEW_TIPS_FLEX});
    }

    public void click(EventObject evt) {
        FormShowParameter currShowParameter = this.getView().getFormShowParameter();
        OperationResult result = new OperationResult();
        String orgIdsStr = (String)currShowParameter.getCustomParam(MAIN_ORG_IDS);
        ImportPermissionParam.Buidler importPermissionParamBuidler = new ImportPermissionParam.Buidler().setBizAppId((String)currShowParameter.getCustomParam("CheckRightAppId")).setMainOrgIds(StringUtils.isNotBlank((CharSequence)orgIdsStr) ? JSON.parseArray((String)orgIdsStr, Long.class) : new ArrayList(0)).setRealEntityId((String)currShowParameter.getCustomParam(REAL_PERMISSION_ENTITY_ID)).setCurrentEntityId((String)currShowParameter.getCustomParam("BillFormId")).setOperateName((String)currShowParameter.getCustomParam(OPERATE_NAME)).setPermissionItemId((String)currShowParameter.getCustomParam(PERMISSION_ITEM_ID)).setResult(result);
        switch (((Control)evt.getSource()).getKey()) {
            case "btnok": {
                try {
                    if (!this.validatePermission(importPermissionParamBuidler.build())) {
                        this.doFailCheckRight(result);
                        this.createNoPermissionOperationLog(result);
                        return;
                    }
                    if (!this.isCanContinue()) {
                        return;
                    }
                    String url = this.checkAndReturnUrl();
                    this.showImportingForm(url);
                    this.createOperationLogByStart(true);
                }
                catch (KDBizException e) {
                    log.error((Throwable)e);
                    this.createOperationLogByStart(false);
                    this.getView().showErrorNotification(e.getMessage());
                }
                break;
            }
            case "btndownload": {
                if (!this.validatePermission(importPermissionParamBuidler.build())) {
                    this.doFailCheckRight(result);
                    return;
                }
                String billFormId = (String)currShowParameter.getCustomParam("BillFormId");
                if (StringUtils.isBlank((CharSequence)billFormId)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7c7b\u578b", (String)"ImportStartPlugin_6", (String)"bos-import", (Object[])new Object[0]));
                    return;
                }
                this.createTemplateForm(currShowParameter, billFormId);
                break;
            }
            case "btndelete": {
                if (!this.validatePermission(importPermissionParamBuidler.build())) {
                    this.doFailCheckRight(result);
                    return;
                }
                String value = (String)this.getModel().getValue("filepath");
                if (StringUtils.isBlank((CharSequence)value)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u4e0a\u4f20\u6587\u4ef6", (String)"ImportStartPlugin_46", (String)"bos-import", (Object[])new Object[0]));
                    return;
                }
                this.deleteUpLoadFile();
                break;
            }
        }
    }

    private boolean isCanContinue() {
        String type = (String)this.getModel().getValue("import_type");
        ImportEntryTypeEnum importTypeEnum = ImportEntryTypeEnum.getImportTypeEnum(type);
        String includeId = this.getPageCache().get("IMPORT_ENTRY_IS_INCLUDE_MATCH_ID");
        return this.showMatchIdTips(importTypeEnum, Boolean.parseBoolean(includeId), true);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String filePath = this.getModel().getValue("filepath").toString();
        FileHandlerUtil.tryDelFile((String)filePath);
    }

    private void deleteUpLoadFile() {
        FileHandlerUtil.tryDelFile((String)((String)this.getModel().getValue("filepath")));
        this.getModel().setValue("filename", (Object)"");
        this.getModel().setValue("filepath", (Object)"");
        this.getView().setVisible(Boolean.TRUE, new String[]{"buttonap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelapresult"});
    }

    private void createTemplateForm(FormShowParameter currShowParameter, String billFormId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(BOS_DOWNLOADENTRYTEMPLATE);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("BillFormId", (Object)billFormId);
        showParameter.setCustomParam("BillTypeId", currShowParameter.getCustomParam("BillTypeId"));
        showParameter.setCustomParam("ImportEntryPlugin", (Object)this.getImportEntryPlugin(currShowParameter));
        showParameter.setCustomParam("TemplateType", (Object)"IMPT");
        showParameter.setCustomParam(TOP_PAGE_ID, currShowParameter.getCustomParam(TOP_PAGE_ID));
        showParameter.setCustomParam("ServiceAppId", (Object)this.getView().getFormShowParameter().getServiceAppId());
        this.getView().showForm(showParameter);
    }

    private String getImportEntryPlugin(FormShowParameter showParam) {
        List plugins;
        String pluginName = (String)showParam.getCustomParam("ImportEntryPlugin");
        if (StringUtils.isBlank((CharSequence)pluginName) && (plugins = (List)showParam.getCustomParam("plugins")) != null) {
            for (Map p : plugins) {
                if (!Boolean.TRUE.equals(p.get("Enabled"))) continue;
                return (String)p.get("ClassName");
            }
        }
        return pluginName;
    }

    private void showImportingForm(String url) {
        ImportStartData.getInstance(this, importStartData -> {
            IFormView view = this.getView();
            FormShowParameter showParam = view.getFormShowParameter();
            Operations ops = EntityMetadataCache.getDataEntityOperations((String)FormMetadataCache.getFormConfig((String)importStartData.getCustomParamData().getBillFormId()).getEntityTypeId());
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(BOS_ENTRY_IMPORTING);
            showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("SetNULL", view.getPageCache().get("SetNULL"));
            params.put("SplitSubEntries", view.getPageCache().get("SplitSubEntries"));
            params.put("ServiceAppId", importStartData.getCustomParamData().getServiceAppId());
            params.put("CheckRightAppId", importStartData.getCustomParamData().getCheckrightappid());
            params.put("BillFormId", importStartData.getCustomParamData().getBillFormId());
            params.put("ListName", importStartData.getCustomParamData().getListName());
            params.put("OpSave", ops.getSave());
            params.put("Url", url);
            params.put("ImportEntryPlugin", this.getImportEntryPlugin(showParam));
            params.put("OperateKey", showParam.getCustomParam("OperateKey"));
            params.put(OPERATE_NAME, showParam.getCustomParam(OPERATE_NAME));
            params.put(REAL_PERMISSION_ENTITY_ID, showParam.getCustomParam(REAL_PERMISSION_ENTITY_ID));
            params.put(PERMISSION_ITEM_ID, showParam.getCustomParam(PERMISSION_ITEM_ID));
            params.put(MAIN_ORG_IDS, showParam.getCustomParam(MAIN_ORG_IDS));
            params.put(TOP_PAGE_ID, showParam.getCustomParam(TOP_PAGE_ID));
            params.put("validSheetNames", this.getPageCache().get("validSheetNames"));
            params.put("exportall", this.getModel().getValue("exportall"));
            params.put("importType", this.getModel().getValue("import_type"));
            params.put("importEntryNamesMap", this.getPageCache().get("IMPORT_ENTRY_NAMES_MAP"));
            showParameter.setCustomParams(params);
            showParameter.setParentPageId(showParam.getParentPageId());
            showParameter.setCloseCallBack(showParam.getCloseCallBack());
            view.showForm(showParameter);
        });
    }

    private String checkAndReturnUrl() {
        String url = (String)this.getModel().getValue("filepath");
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c\u3002", (String)"ImportStartPlugin_7", (String)"bos-import", (Object[])new Object[0]));
        }
        return url;
    }
}

