/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.importentry;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.plugin.importentry.AbstractImportEntryTemplatePlugin;
import kd.bos.form.plugin.importentry.model.ImportTreeRowInfo;
import kd.bos.form.plugin.importentry.model.ImportTreeRowTypeEnum;
import kd.bos.form.plugin.importentry.model.ImportTreeRowView;
import kd.bos.isv.ISVService;

public class ImportEntryTemplateCreatePlugin
extends AbstractImportEntryTemplatePlugin {
    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        if (((IBillModel)model).isFromImport()) {
            return;
        }
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("bindEntityId");
        if (StringUtils.isBlank((CharSequence)entityId)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"mulcombo"});
            return;
        }
        this.setDefaultNumber(entityId);
        if (!Boolean.TRUE.equals(this.getView().getFormShowParameter().getCustomParam("customTemplate"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bizobject"});
            this.getModel().setValue("bizobject", (Object)entityId);
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{"mulcombo"});
        this.initEntryMulCombo(entityId, null);
        this.buildEntryTree(entityId);
    }

    protected void setDefaultNumber(String entityId) {
        if (StringUtils.isNotBlank((CharSequence)entityId)) {
            String billno = entityId + "_IMPT_ENTRY";
            String currentIsv = ISVService.getISVInfo().getId();
            if ("kingdee".equals(currentIsv)) {
                billno = billno + "_S";
            }
            this.getModel().setValue("number", (Object)billno);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if ("bizobject".equalsIgnoreCase(propertyName)) {
            DynamicObject bizObj = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (bizObj == null) {
                this.functionWhenInitModel(v -> this.getModel().deleteEntryData("treeentryentity"));
                this.getView().updateView("treeentryentity");
                this.getModel().setValue("mulcombo", null);
                this.getView().updateView("mulcombo");
                return;
            }
            String entityId = bizObj.getString(((BasedataEntityType)bizObj.getDataEntityType()).getNumberProperty());
            if (StringUtils.isBlank((CharSequence)entityId)) {
                return;
            }
            this.setDefaultNumber(entityId);
            this.initEntryMulCombo(entityId, null);
            this.buildEntryTree(entityId);
            this.getView().setEnable(Boolean.TRUE, new String[]{"mulcombo"});
            this.getView().updateView("treeentryentity");
        }
        super.propertyChanged(e);
    }

    private void buildEntryTree(String number) {
        this.getModel().beginInit();
        this.functionWhenInitModel(v -> this.getModel().deleteEntryData("treeentryentity"));
        String value = (String)this.getModel().getValue("mulcombo");
        if (StringUtils.isBlank((CharSequence)value)) {
            this.getModel().endInit();
            this.getView().updateView("treeentryentity");
            return;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)number);
        ImportTreeRowInfo importTreeRowInfo = this.getCacheOfImportTreeRowInfo(mainType, true);
        this.createEntryRow(mainType, this.treeRowFactory.convertInfoToView(importTreeRowInfo));
        this.triggerLinkage(mainType, this.treeRowFactory.convertInfoToView(importTreeRowInfo));
        this.getModel().endInit();
        this.getView().updateView("treeentryentity");
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("treeentryentity");
        grid.setCollapse(false);
    }

    private void triggerLinkage(MainEntityType mainEntityType, ImportTreeRowView importTreeRowView) {
        for (Map.Entry<Integer, ImportTreeRowView.RowView> entry : importTreeRowView.getTreeRowInfosAtRow().entrySet()) {
            ImportTreeRowView.RowView treeRowInfo = entry.getValue();
            IDataEntityProperty property = treeRowInfo.getProperty(mainEntityType);
            if (treeRowInfo.getTreeRowTypeEnum() != ImportTreeRowTypeEnum.HEAD_PROPERTY && treeRowInfo.getTreeRowTypeEnum() != ImportTreeRowTypeEnum.ENTITY_PROPERTY && treeRowInfo.getTreeRowTypeEnum() != ImportTreeRowTypeEnum.SUBENTITY_PROPERTY || !(property instanceof FieldProp && ((FieldProp)property).isMustInput() || property instanceof BasedataProp && ((BasedataProp)property).isMustInput()) && (!(property instanceof MulBasedataProp) || !((MulBasedataProp)property).isMustInput())) continue;
            this.triggerLinkageFromProperty(importTreeRowView, treeRowInfo, true, "isimport");
            this.triggerLinkageFromProperty(importTreeRowView, treeRowInfo, true, "ismustinput");
        }
    }
}

