/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.importentry;

import java.util.EventObject;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.plugin.importentry.ImportEntryTemplateVerifySavePlugin;
import kd.bos.form.plugin.importentry.model.ImportTreeRowInfo;
import kd.bos.form.plugin.importentry.model.ImportTreeRowView;

public class ImportEntryTemplateLoadPlugin
extends ImportEntryTemplateVerifySavePlugin {
    public void afterLoadData(EventObject e) {
        String entityId = (String)this.getModel().getValue("bizobject_Id");
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return;
        }
        if (!Boolean.TRUE.equals(this.getView().getFormShowParameter().getCustomParam("customTemplate"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bizobject"});
            this.getModel().setValue("bizobject", (Object)entityId);
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{"mulcombo"});
        String value = (String)this.getModel().getValue("mulcombo");
        this.initEntryMulCombo(entityId, value);
        this.buildEntryTree(entityId, false);
        this.getModel().setDataChanged(false);
    }

    public void afterCopyData(EventObject e) {
        String entityId = (String)this.getModel().getValue("bizobject_Id");
        this.setDefaultNumber(entityId);
        String value = (String)this.getModel().getValue("mulcombo");
        this.initEntryMulCombo(entityId, value);
        this.buildEntryTree(entityId, true);
        this.getModel().setDataChanged(false);
    }

    private void buildEntryTree(String number, boolean isCopy) {
        this.getModel().beginInit();
        String value = (String)this.getModel().getValue("mulcombo");
        if (StringUtils.isBlank((CharSequence)value)) {
            this.functionWhenInitModel(v -> this.getModel().deleteEntryData("treeentryentity"));
            this.getModel().endInit();
            this.getView().updateView("treeentryentity");
            return;
        }
        Optional<Map<String, Map<String, Object>>> storeDatas = this.loadDataEntiy();
        if (!storeDatas.isPresent()) {
            return;
        }
        this.functionWhenInitModel(v -> this.getModel().deleteEntryData("treeentryentity"));
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)number);
        ImportTreeRowInfo importTreeRowInfo = this.getCacheOfImportTreeRowInfo(dataEntityType, true);
        importTreeRowInfo.comparatorTreeRowInfo(storeDatas.get());
        this.refreshCacheOfImportEntryTreeInfo(importTreeRowInfo);
        ImportTreeRowView importTreeRowView = this.treeRowFactory.convertInfoToView(importTreeRowInfo);
        this.createEntryRow(dataEntityType, importTreeRowView);
        if (!isCopy) {
            this.restoreTreeRowPkIdInfosFromStore(importTreeRowView, storeDatas.get());
        }
        this.restoreTreeRowImportInfosFromStore(importTreeRowView, storeDatas.get());
        this.resetTreeRowImportInfos(importTreeRowView);
        this.getModel().endInit();
        this.getView().updateView("treeentryentity");
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("treeentryentity");
        grid.setCollapse(false);
    }

    private void resetTreeRowImportInfos(ImportTreeRowView importTreeRowView) {
        Map<Integer, ImportTreeRowView.RowView> treeRowInfosAtRow = importTreeRowView.getTreeRowInfosAtRow();
        boolean hasClosed = false;
        for (ImportTreeRowView.RowView rowView : treeRowInfosAtRow.values()) {
            int currentRow = rowView.getRow();
            Object value = this.getModel().getValue("isimport", currentRow);
            if (value != null && ((Boolean)value).booleanValue()) continue;
            int parentRow = rowView.getParentRow();
            this.getModel().beginInit();
            this.getModel().setValue("isimport", (Object)false, parentRow);
            this.getModel().endInit();
            hasClosed = true;
        }
        if (hasClosed) {
            this.getModel().beginInit();
            this.getModel().setValue("isimport", (Object)false, 0);
            this.getModel().endInit();
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        IDataModel model = this.getModel();
        String propertyName = e.getProperty().getName();
        int row = e.getChangeSet()[0].getRowIndex();
        if ("mulcombo".equalsIgnoreCase(propertyName)) {
            DynamicObject bizObj = (DynamicObject)this.getModel().getValue("bizobject");
            if (bizObj == null) {
                return;
            }
            String entityId = bizObj.getString(((BasedataEntityType)bizObj.getDataEntityType()).getNumberProperty());
            if (StringUtils.isBlank((CharSequence)entityId)) {
                return;
            }
            this.buildEntryTree(entityId, false);
            this.getModel().setDataChanged(false);
        }
    }
}

