/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.importentry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.TreeListBizAppsPlugin;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.svc.util.TreeNodeFilter;

public class ImportEntryTemplateTreeListEdit
extends TreeListBizAppsPlugin {
    private static final String BIZOBJECT = "bizobject";
    private static final String BOSENTITYOBJECT = "bos_entityobject";
    private static final String NUMBER = "number";
    private static final String TREEPARENTID = "tree_parent_id";

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        TreeNodeFilter treeNodeFilter = new TreeNodeFilter(TreeNodeFilter.FilterTypeEnum.ONLY_APP);
        QFilter appFilter = treeNodeFilter.getAppFilter("bizobject.bizappid.id");
        if (appFilter != null) {
            e.addCustomQFilter(appFilter);
        }
        e.addCustomQFilter(new QFilter(BIZOBJECT, "in", this.getBillNumbers()));
    }

    public void initializeTree(EventObject e) {
        ITreeModel treeModel = this.getTreeModel();
        TreeNode root = treeModel.createRootNode();
        treeModel.setRoot(root);
        treeModel.setCurrentNodeId((Object)root.getId());
        root.setIsOpened(true);
        root.setChildren(new TreeNodeFilter(TreeNodeFilter.FilterTypeEnum.ONLY_CLOUD).getCloudNodes());
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnnew"});
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"btnedit", "btndel"});
    }

    protected List<TreeNode> getAppNodesBy(String cloudNodeId) {
        List treeNodes = super.getAppNodesBy(cloudNodeId);
        return new TreeNodeFilter(TreeNodeFilter.FilterTypeEnum.ONLY_APP).filterAppTreeNode(treeNodes);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String nodeId = e.getNodeId().toString();
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode node = root.getTreeNode(nodeId, 20);
        QFilter filter = this.getFilter(node);
        e.addQFilter(filter);
        e.setCancel(true);
    }

    private QFilter getFilter(TreeNode node) {
        if (node == null) {
            return null;
        }
        String nodeId = node.getId();
        if (this.isTopNode(nodeId)) {
            return null;
        }
        switch ((String)node.getData()) {
            case "cloud": {
                return new QFilter(BIZOBJECT, "in", (Object)this.getBillIdInCloud(nodeId));
            }
            case "app": {
                return new QFilter(BIZOBJECT, "in", (Object)this.getBillIdInApp(nodeId));
            }
        }
        return new QFilter(BIZOBJECT, "=", (Object)nodeId);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter param = e.getParameter();
        String currentNodeId = this.getTreeModel().getCurrentNodeId().toString();
        String rootId = this.getTreeModel().getRoot().getId();
        if (currentNodeId.contains("cloud_") || currentNodeId.contains("app_") || rootId.equals(currentNodeId)) {
            return;
        }
        param.setCustomParam(TREEPARENTID, null);
        param.setCustomParam(BIZOBJECT, (Object)currentNodeId);
    }

    public void treeNodeClick(TreeNodeEvent treenodeevent) {
        this.getTreeModel().setNodeClickExpand(false);
        String nodeId = treenodeevent.getNodeId().toString();
        this.getPageCache().put("nodeId", nodeId);
        TreeNode node = this.getTreeModel().getRoot().getTreeNode(nodeId, 10);
        if (node != null && node.getData() != null) {
            String nodeData = (String)node.getData();
            if (node.getChildren() != null || "app".equals(nodeData) || "cloud".equals(nodeData)) {
                nodeData = null;
            }
            this.getPageCache().put("_IMPORTTEMPLATETREELIST_BIZOBJID_", nodeData);
        }
        super.treeNodeClick(treenodeevent);
    }

    private List<String> getBillNumbers() {
        String fields = NUMBER;
        String orders = "bizappid asc";
        QFilter modelTypeFilter = new QFilter("modeltype", "in", Arrays.asList("BaseFormModel", "BillFormModel"));
        QFilter isTemplateFilter = new QFilter("istemplate", "=", (Object)Boolean.FALSE);
        QFilter enableImport = new QFilter("enableimport", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{modelTypeFilter, isTemplateFilter, enableImport};
        ArrayList<String> billNumbers = new ArrayList<String>();
        try (DataSet ds = ORM.create().queryDataSet(BOSENTITYOBJECT, BOSENTITYOBJECT, fields, filters, orders);){
            for (Row row : ds) {
                billNumbers.add(row.getString(NUMBER));
            }
        }
        return billNumbers;
    }
}

