/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.importentry;

import com.alibaba.fastjson.JSON;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.TreeEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeUploadEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.dto.ImportPermissionParam;
import kd.bos.form.plugin.ImportPermissionPlugin;
import kd.bos.form.plugin.importentry.model.ImportEntryTypeEnum;
import kd.bos.form.plugin.importentry.model.ImportEntryValid;
import kd.bos.form.util.ImportOperationLog;
import kd.bos.impt.ExcelReaderForEntry;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.attachment.extend.importdata.FileImportExtensionFactory;
import kd.bos.svc.util.FileHandlerUtil;
import org.apache.commons.collections4.MapUtils;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.openxml4j.exceptions.InvalidOperationException;
import org.apache.poi.openxml4j.exceptions.NotOfficeXmlFileException;
import org.apache.poi.openxml4j.exceptions.OLE2NotOfficeXmlFileException;

public class ImportEntryUploadFilePlugin
extends ImportPermissionPlugin
implements UploadListener,
IConfirmCallBack {
    private static final Log log = LogFactory.getLog(ImportEntryUploadFilePlugin.class);
    private static final String BOS_IMPORT = "bos-import";
    protected static final String FLEXPANELAP1 = "flexpanelap1";
    protected static final String BTN_UPLOAD = "buttonap";
    protected static final String IMPORT_TYPE = "import_type";
    private static final String BILLFORMID = "BillFormId";
    private static final String TEXTFIELD1 = "textareafield221";
    private static final String TEXTFIELD2 = "textareafield22";
    private static final DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button panel = (Button)this.getControl(BTN_UPLOAD);
        panel.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue(TEXTFIELD1, (Object)ResManager.loadKDString((String)"\u2022 \u4ec5\u652f\u630130MB\u4ee5\u5185\u7684xlsx\u6587\u4ef6\u3002", (String)"ImportStartPlugin_27", (String)BOS_IMPORT, (Object[])new Object[0]));
        this.getModel().setValue(TEXTFIELD2, (Object)ResManager.loadKDString((String)"\u2022 \u5982\u4e00\u6b21\u5bfc\u5165\u591a\u4e2a\u5206\u5f55\uff0c\u8bf7\u4f7f\u7528\u591a\u4e2asheet\u9875\u7b7e\u3002", (String)"ImportStartPlugin_28", (String)BOS_IMPORT, (Object[])new Object[0]));
    }

    public void beforeUpload(BeforeUploadEvent evt) {
        FormShowParameter currShowParameter = this.getView().getFormShowParameter();
        OperationResult result = new OperationResult();
        String orgIdsStr = (String)currShowParameter.getCustomParam("MainOrgIds");
        ImportPermissionParam.Buidler importPermissionParamBuidler = new ImportPermissionParam.Buidler().setBizAppId((String)currShowParameter.getCustomParam("CheckRightAppId")).setMainOrgIds(StringUtils.isNotBlank((CharSequence)orgIdsStr) ? JSON.parseArray((String)orgIdsStr, Long.class) : new ArrayList(0)).setRealEntityId((String)currShowParameter.getCustomParam("RealPermissionEntityId")).setCurrentEntityId((String)currShowParameter.getCustomParam(BILLFORMID)).setOperateName((String)currShowParameter.getCustomParam("OperateName")).setPermissionItemId((String)currShowParameter.getCustomParam("PermissionItemId")).setResult(result);
        if (!this.validatePermission(importPermissionParamBuidler.build())) {
            HashMap<String, Integer> param = new HashMap<String, Integer>(1);
            param.put("status", 0);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("beforeUploadResult", param);
            this.doFailCheckRight(result);
        }
        redisCache.put("import_" + currShowParameter.getCustomParam(BILLFORMID) + "_" + currShowParameter.getPageId(), (Object)"true", 10000);
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            IFormView view = this.getView();
            String url = urls[0].toString();
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            final ImportEntryValid importEntryValid = new ImportEntryValid();
            final HashMap entryNamesMap = new HashMap();
            try (InputStream in = FileImportExtensionFactory.getFileImportExtension().decode(url, fileService.getInputStream(url));){
                new ExcelReaderForEntry().readForEntryValid(in, importEntryValid, new SheetHandler(){

                    @Override
                    public void handleRow(SheetHandler.ParsedRow currentRow) {
                        if (currentRow.getSheetName().equals("table")) {
                            ImportEntryUploadFilePlugin.this.validTable(currentRow);
                            ImportEntryUploadFilePlugin.this.validMatchIdColData(currentRow, importEntryValid);
                            return;
                        }
                        ImportEntryUploadFilePlugin.this.validRowOne(currentRow, importEntryValid, entryNamesMap);
                        ImportEntryUploadFilePlugin.this.validRowTwo(currentRow, importEntryValid);
                        ImportEntryUploadFilePlugin.this.validRowThree(currentRow, importEntryValid);
                        ImportEntryUploadFilePlugin.this.validRowFour(currentRow, importEntryValid);
                        ImportEntryUploadFilePlugin.this.validHasData(currentRow, importEntryValid);
                    }
                });
                if (importEntryValid.getEntryNames().isEmpty()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677fsheet\u5de5\u4f5c\u8868\u4e2d\u4e0d\u5b58\u5728\u5339\u914d\u7684\u5355\u636e\u4f53\u3002", (String)"ImportStartPlugin_26", (String)BOS_IMPORT, (Object[])new Object[0]));
                }
                if (Boolean.FALSE.equals(importEntryValid.getHasData())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u672a\u89e3\u6790\u5230\u6709\u6548\u6570\u636e\uff0c\u8bf7\u5f55\u5165\u6570\u636e\u540e\u518d\u8bd5\u3002", (String)"ImportStartPlugin_18", (String)BOS_IMPORT, (Object[])new Object[0]));
                }
                this.getPageCache().put("validSheetNames", JSON.toJSONString(importEntryValid.getValidSheetNames()));
            }
            catch (KDBizException e) {
                log.error((Throwable)e);
                this.createOpLogAndDelFileByUpload(false, url);
                view.showErrorNotification(e.getMessage());
                this.getModel().setValue("filename", (Object)"");
                this.getModel().setValue("filepath", (Object)"");
                fileService.delete(url);
                return;
            }
            catch (Exception e) {
                this.createOpLogAndDelFileByUpload(false, url);
                log.error((Throwable)e);
                if (e instanceof OLE2NotOfficeXmlFileException) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u89e3\u6790\u8bbe\u7f6e\u5bc6\u7801\u7684\u6587\u4ef6\u3002", (String)"ImportStartPlugin_44", (String)BOS_IMPORT, (Object[])new Object[0]));
                } else if (e instanceof NotOfficeXmlFileException || e instanceof InvalidOperationException) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u5df2\u635f\u574f\u6216\u8be5\u6587\u4ef6\u88ab\u5b89\u5168\u8f6f\u4ef6\u52a0\u5bc6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u3002", (String)"ImportStartPlugin_42", (String)BOS_IMPORT, (Object[])new Object[0]));
                } else if (e instanceof EncryptedDocumentException) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u89e3\u6790\u8bbe\u7f6e\u5bc6\u7801\u7684\u6587\u4ef6\u3002", (String)"ImportStartPlugin_44", (String)BOS_IMPORT, (Object[])new Object[0]));
                } else {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u683c\u5f0f\u7684\u6570\u636e\u6a21\u677f\u3002 \u8bf7\u68c0\u67e5\u6570\u636e\u6a21\u677f\uff1a1\u3001Sheet\u9875\u7b7e\u4e2d\u662f\u5426\u5b58\u5728\u5339\u914d\u7684\u5355\u636e\u4f53\uff1b2\u3001\u540c\u4e00Sheet\u9875\u7b7e\u4e0d\u80fd\u5305\u542b\u591a\u4e2a\u5355\u636e\u4f53\uff1b3\u3001\u6682\u4e0d\u652f\u6301\u6811\u5f62\u5355\u636e\u4f53\u3002", (String)"ImportStartPlugin_21", (String)BOS_IMPORT, (Object[])new Object[0]));
                }
                this.getModel().setValue("filename", (Object)"");
                this.getModel().setValue("filepath", (Object)"");
                return;
            }
            IDataModel model = this.getModel();
            model.setValue("filename", (Object)url.substring(url.lastIndexOf(47) + 1));
            model.setValue("filepath", (Object)url);
            view.setVisible(Boolean.FALSE, new String[]{BTN_UPLOAD});
            view.setVisible(Boolean.TRUE, new String[]{"flexpanelapresult"});
            this.checkMatchId(importEntryValid);
            this.getPageCache().put("IMPORT_ENTRY_NAMES_MAP", SerializationUtils.toJsonString(entryNamesMap));
        }
    }

    private void validMatchIdColData(SheetHandler.ParsedRow currentRow, ImportEntryValid importEntryValid) {
        if (!currentRow.getSheetName().equals("table") || currentRow.getRowNum() < 1) {
            return;
        }
        Map<Integer, String> data = currentRow.getData();
        if (MapUtils.isEmpty(data) || data.size() < 2) {
            return;
        }
        try {
            long rows = Long.parseLong(data.get(1));
            String matchId = data.get(0);
            if (matchId.contains("_$matchid$")) {
                matchId = matchId.replace("_$matchid$", "");
            }
            importEntryValid.addMatchIdDataRow(matchId, rows);
        }
        catch (Exception e) {
            log.error("\u5339\u914did\u7edf\u8ba1\u62a5\u9519\uff1a" + currentRow.getRowNum(), (Throwable)e);
        }
    }

    private void checkMatchId(ImportEntryValid importEntryValid) {
        String type = (String)this.getModel().getValue(IMPORT_TYPE);
        ImportEntryTypeEnum importTypeEnum = ImportEntryTypeEnum.getImportTypeEnum(type);
        List<String> entryNames = this.getEntryNames(this.getView().getParentView());
        long rows = 0L;
        Map<String, Long> matchIdDataRows = importEntryValid.getMatchIdDataRows();
        for (Map.Entry<String, Long> matchIdRows : matchIdDataRows.entrySet()) {
            if (!entryNames.contains(matchIdRows.getKey())) continue;
            rows += matchIdRows.getValue().longValue();
        }
        boolean hasMatchIdData = rows > 0L;
        this.getPageCache().put("IMPORT_ENTRY_IS_INCLUDE_MATCH_ID", String.valueOf(hasMatchIdData));
        this.showMatchIdTips(importTypeEnum, hasMatchIdData, false);
    }

    protected boolean showMatchIdTips(ImportEntryTypeEnum importType, boolean hasMatchIdData, boolean isBlock) {
        if (importType == ImportEntryTypeEnum.NEW && hasMatchIdData) {
            if (isBlock) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u65e0\u9700\u5bfc\u5165\u5339\u914did\u3002", (String)"ImportEntryUploadFilePlugin_0", (String)BOS_IMPORT, (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5bfc\u5165\u7684\u6587\u4ef6\u65e0\u9700\u5305\u542b\u5339\u914did\uff0c\u5efa\u8bae\u66f4\u6539\u5bfc\u5165\u65b9\u5f0f\u6216\u91cd\u4f20\u6587\u4ef6\u3002", (String)"ImportEntryUploadFilePlugin_3", (String)BOS_IMPORT, (Object[])new Object[0]));
            }
            return false;
        }
        if (!(importType != ImportEntryTypeEnum.OVERRIDE && importType != ImportEntryTypeEnum.OVERRIDE_AND_NEW || hasMatchIdData)) {
            String msg = ResManager.loadKDString((String)"\u8be5\u6587\u4ef6\u4e0d\u542b\u5339\u914did\u5b57\u6bb5\uff0c\u5982\u9700\u66f4\u65b0\u6570\u636e\uff0c\u8bf7\u5148\u6309\u5bfc\u5165\u6a21\u677f\u5bfc\u51fa\u5339\u914did\u3002", (String)"ImportEntryUploadFilePlugin_1", (String)BOS_IMPORT, (Object[])new Object[0]);
            if (isBlock) {
                this.getView().showErrorNotification(msg);
            } else {
                this.getView().showTipNotification(msg);
            }
            return false;
        }
        return true;
    }

    public void remove(UploadEvent evt) {
        super.remove(evt);
    }

    protected void createOperationLogByStart(boolean status) {
        if (status) {
            ImportOperationLog.getInstance().createAppLog(this.getView(), (String)this.getView().getFormShowParameter().getCustomParam(BILLFORMID), ImportOperationLog.OperationEnum.IMPORT_START_SUCCESS.getOpNameBridge(), ImportOperationLog.OperationEnum.IMPORT_START_SUCCESS.getOpDescFormatBridge(), new String[0]);
            return;
        }
        ImportOperationLog.getInstance().createAppLog(this.getView(), (String)this.getView().getFormShowParameter().getCustomParam(BILLFORMID), ImportOperationLog.OperationEnum.IMPORT_START_FAIL.getOpNameBridge(), ImportOperationLog.OperationEnum.IMPORT_START_FAIL.getOpDescFormatBridge(), new String[0]);
    }

    private void createOpLogAndDelFileByUpload(boolean status, String url) {
        if (status) {
            ImportOperationLog.getInstance().createAppLog(this.getView(), (String)this.getView().getFormShowParameter().getCustomParam(BILLFORMID), ImportOperationLog.OperationEnum.UPLOAD_FILE_SUCCESS.getOpNameBridge(), ImportOperationLog.OperationEnum.UPLOAD_FILE_SUCCESS.getOpDescFormatBridge(), new String[]{url.substring(url.lastIndexOf(47) + 1)});
            return;
        }
        FileHandlerUtil.tryDelFile((String)url);
        ImportOperationLog.getInstance().createAppLog(this.getView(), (String)this.getView().getFormShowParameter().getCustomParam(BILLFORMID), ImportOperationLog.OperationEnum.UPLOAD_FILE_FAIL.getOpNameBridge(), ImportOperationLog.OperationEnum.UPLOAD_FILE_FAIL.getOpDescFormatBridge(), new String[]{url.substring(url.lastIndexOf(47) + 1)});
    }

    protected void createNoPermissionOperationLog(OperationResult result) {
        List errList = result.getValidateResult().getValidateErrors();
        StringBuilder sb = new StringBuilder();
        for (ValidateResult errResult : errList) {
            for (IOperateInfo errInfo : errResult.getAllErrorInfo()) {
                sb.append(errInfo.getMessage());
            }
        }
        String errorTips = sb.toString();
        ImportOperationLog.getInstance().createAppLog((String)this.getView().getFormShowParameter().getCustomParam(BILLFORMID), ImportOperationLog.OperationEnum.IMPORT_NOPERMISSION_FAIL.getOpNameBridge(), ImportOperationLog.OperationEnum.IMPORT_NOPERMISSION_FAIL.getOpDescFormatBridge(), new String[0]);
    }

    private void validRowOne(SheetHandler.ParsedRow currentRow, ImportEntryValid importEntryValid, Map<String, String> entryNamesMap) {
        if (currentRow.getRowNum() != 0) {
            return;
        }
        IFormView view = this.getView();
        String entryName = currentRow.get(0);
        if (StringUtils.isEmpty((CharSequence)entryName)) {
            entryName = currentRow.get(1);
            importEntryValid.setHasErrorCol(true);
        }
        if (entryName == null) {
            this.toNextSheetByException(ResManager.loadKDString((String)"\u65e0\u6548\u9875\u7b7e\uff0c\u8df3\u8fc7\u68c0\u67e5\u3002", (String)"ImportStartPlugin_17", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
        List<String> entryNames = this.getEntryNames(view.getParentView());
        String[] splitName = entryName.split(" # ");
        if (splitName.length < 2 || !entryNames.contains(splitName[1])) {
            this.toNextSheetByException(ResManager.loadKDString((String)"\u65e0\u6548\u9875\u7b7e\uff0c\u8df3\u8fc7\u68c0\u67e5\u3002", (String)"ImportStartPlugin_17", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
        String entryNameTmp = splitName[1];
        EntityType entityType = (EntityType)view.getParentView().getModel().getDataEntityType().getAllEntities().get(entryNameTmp);
        if (entityType instanceof TreeEntryType || entityType instanceof LinkEntryType) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677fsheet\u5de5\u4f5c\u8868\u4e2d\u5b58\u5728\u6811\u5f62\u5355\u636e\u4f53\u6216\u67e5\u8be2\u5b9e\u4f53\uff0c\u6682\u4e0d\u652f\u6301\u5bfc\u5165\u3002", (String)"ImportStartPlugin_24", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
        if (importEntryValid.getEntryNames().contains(entryNameTmp)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u5de5\u4f5c\u8868\u4e2d\u5b58\u5728\u540d\u79f0\u76f8\u540c\u7684\u5355\u636e\u4f53\u3002", (String)"ImportStartPlugin_20", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
        importEntryValid.getEntryNames().add(entryNameTmp);
        int entrys = (int)currentRow.getData().values().stream().filter(colValue -> colValue.split(" # ").length == 2 && entryNames.contains(colValue.split(" # ")[1])).count();
        if (entrys > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677fsheet\u5de5\u4f5c\u8868\u4e2d\u5b58\u5728\u591a\u4e2a\u5355\u636e\u4f53\u3002", (String)"ImportStartPlugin_25", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
        importEntryValid.setValidSeq(importEntryValid.getValidSeq() + 1);
        entryNamesMap.put(splitName[1], splitName[0]);
    }

    private void toNextSheetByException(String msg) {
        throw new KDBizException(new ErrorCode("nextSheet", msg), new Object[0]);
    }

    private void validRowTwo(SheetHandler.ParsedRow currentRow, ImportEntryValid importEntryValid) {
        if (currentRow.getRowNum() != 1 || importEntryValid.getValidSeq() != 1) {
            return;
        }
        IFormView view = this.getView();
        Map<Integer, String> commentRow = currentRow.getData();
        String specialComment = commentRow.get(Boolean.TRUE.equals(importEntryValid.getHasErrorCol()) ? 1 : 0);
        if (specialComment != null) {
            view.getPageCache().put("SetNULL", String.valueOf(specialComment.contains("#SetNULL")));
        }
        importEntryValid.setValidSeq(importEntryValid.getValidSeq() + 1);
    }

    private void validRowThree(SheetHandler.ParsedRow currentRow, ImportEntryValid importEntryValid) {
        if (currentRow.getRowNum() != 2 || importEntryValid.getValidSeq() != 2) {
            return;
        }
        if (currentRow.isEmpty()) {
            this.toNextSheetByException(ResManager.loadKDString((String)"\u65e0\u6548\u9875\u7b7e\uff0c\u8df3\u8fc7\u68c0\u67e5\u3002", (String)"ImportStartPlugin_17", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
        importEntryValid.setValidSeq(importEntryValid.getValidSeq() + 1);
    }

    private void validRowFour(SheetHandler.ParsedRow currentRow, ImportEntryValid importEntryValid) {
        if (currentRow.getRowNum() != 3) {
            return;
        }
        if (currentRow.isEmpty()) {
            this.toNextSheetByException(ResManager.loadKDString((String)"\u65e0\u6548\u9875\u7b7e\uff0c\u8df3\u8fc7\u68c0\u67e5\u3002", (String)"ImportStartPlugin_17", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
        importEntryValid.setValidSeq(importEntryValid.getValidSeq() + 1);
    }

    private void validHasData(SheetHandler.ParsedRow currentRow, ImportEntryValid importEntryValid) {
        if (currentRow.getRowNum() <= 3) {
            return;
        }
        if (importEntryValid.getHasErrorCol().booleanValue()) {
            Map<Integer, String> data = currentRow.getData();
            data.remove(0);
        }
        if (!currentRow.isEmpty()) {
            importEntryValid.setHasData(true);
            importEntryValid.setHasAnySheetValid(Boolean.TRUE);
            importEntryValid.getValidSheetNames().add(currentRow.getSheetName());
            this.toNextSheetByException(ResManager.loadKDString((String)"\u6587\u4ef6\u5408\u6cd5\uff0c\u65e0\u9700\u7ee7\u7eed\u68c0\u67e5", (String)"ImportStartPlugin_9", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
    }

    private void validTable(SheetHandler.ParsedRow currentRow) {
        if (!currentRow.getSheetName().equals("table") || currentRow.getRowNum() != 0) {
            return;
        }
        String tableName = currentRow.get(0);
        if (tableName == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677ftable\u5de5\u4f5c\u8868\u4e2d\u7684\u5355\u636e\u6807\u8bc6\u4e0e\u5f53\u524d\u5355\u636e\u4e0d\u5339\u914d\u3002", (String)"ImportEntryUploadFilePlugin_2", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
        IFormView view = this.getView().getParentView();
        String name = view.getModel().getDataEntityType().getName();
        String[] splitTableName = tableName.split("#");
        if (splitTableName.length > 0 && name.equals(splitTableName[splitTableName.length - 1].trim())) {
            return;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677ftable\u5de5\u4f5c\u8868\u4e2d\u7684\u5355\u636e\u6807\u8bc6\u4e0e\u5f53\u524d\u5355\u636e\u4e0d\u5339\u914d\u3002", (String)"ImportEntryUploadFilePlugin_2", (String)BOS_IMPORT, (Object[])new Object[0]));
    }

    private List<String> getEntryNames(IFormView view) {
        Map allEntities = view.getModel().getDataEntityType().getAllEntities();
        List<String> entryNames = allEntities.values().stream().filter(entityType -> entityType instanceof EntryType && !(entityType instanceof SubEntryType)).map(DynamicObjectType::getName).collect(Collectors.toList());
        return entryNames;
    }
}

