/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.importentry.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.TreeEntryType;
import kd.bos.entity.property.AttachmentCountProp;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.form.plugin.importentry.model.ImportTreeRowInfo;
import kd.bos.form.plugin.importentry.model.ImportTreeRowTypeEnum;
import kd.bos.form.plugin.importentry.model.ImportTreeRowView;
import kd.bos.util.StringUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ImportTreeRowFactory {
    public ImportTreeRowInfo newInstance(MainEntityType mainEntityType, List<String> needShowEntity) {
        ImportTreeRowInfo.RowInfo rootRowInfo = new ImportTreeRowInfo.RowInfo(mainEntityType.getName(), ImportTreeRowTypeEnum.MAINENTITY, mainEntityType.getName());
        this.createEntity(mainEntityType, rootRowInfo, needShowEntity);
        return new ImportTreeRowInfo(rootRowInfo);
    }

    private void createEntity(MainEntityType mainEntityType, ImportTreeRowInfo.RowInfo parentRowInfo, List<String> needShowEntity) {
        HashMap<EntityType, ImportTreeRowInfo.RowInfo> rowInfoAtEntityType = new HashMap<EntityType, ImportTreeRowInfo.RowInfo>();
        ImportTreeRowInfo.RowInfo rootRowInfo = parentRowInfo;
        for (Map.Entry entry : mainEntityType.getAllEntities().entrySet()) {
            EntityType currentEntityType = (EntityType)entry.getValue();
            if (currentEntityType instanceof LinkEntryType || currentEntityType instanceof QueryEntityType || !needShowEntity.contains(((EntityType)entry.getValue()).getName()) && !(currentEntityType instanceof MainEntityType)) continue;
            ImportTreeRowInfo.RowInfo currentRowInfo = new ImportTreeRowInfo.RowInfo(mainEntityType.getName(), ImportTreeRowTypeEnum.getTreeRowEntityEnum(currentEntityType), this.getEntityNodeNumberInMainEntity(currentEntityType));
            if (currentEntityType instanceof SubEntryType) {
                parentRowInfo = (ImportTreeRowInfo.RowInfo)rowInfoAtEntityType.get(currentEntityType.getParent());
                currentRowInfo.setEntryEntityNumber(parentRowInfo.getEntityNumber());
            } else if (currentEntityType instanceof EntryType) {
                parentRowInfo = rootRowInfo;
            }
            rowInfoAtEntityType.putIfAbsent(currentEntityType, currentRowInfo);
            parentRowInfo.addChildRowInfo(currentRowInfo);
            this.createEntityProp(mainEntityType, currentEntityType, currentRowInfo);
        }
        parentRowInfo = rootRowInfo;
    }

    private String getEntityNodeNumberInMainEntity(EntityType currentEntityType) {
        String entityNumber = currentEntityType.getName();
        if (currentEntityType instanceof MainEntityType) {
            entityNumber = "billhead";
        }
        return entityNumber;
    }

    private void createEntityProp(MainEntityType mainEntityType, EntityType parentEntityType, ImportTreeRowInfo.RowInfo parentRowInfo) {
        ArrayList<IDataEntityProperty> properties = new ArrayList<IDataEntityProperty>(parentEntityType.getFields().values());
        this.appendPkIdProperty(parentEntityType, properties);
        for (IDataEntityProperty property : properties) {
            boolean isPKFieldProp = property instanceof PKFieldProp;
            boolean isImportable = ((IFieldHandle)property).isImportable() || isPKFieldProp;
            if (!isImportable || property instanceof AttachmentProp || property instanceof AttachmentCountProp) continue;
            String propertyNumber = this.getSpecialPropertyNumber(property);
            boolean isBaseDataProp = property instanceof BasedataProp || property instanceof MulBasedataProp;
            ImportTreeRowInfo.RowInfo currentRowInfo = new ImportTreeRowInfo.RowInfo(mainEntityType.getName(), ImportTreeRowTypeEnum.getTreeRowPropertyEnum(parentEntityType), parentEntityType.getName(), propertyNumber, isPKFieldProp, isBaseDataProp);
            if (property instanceof ItemClassProp) {
                currentRowInfo.setRefPropNumber(((ItemClassProp)property).getTypePropName());
            }
            if (property instanceof FlexProp) {
                currentRowInfo.setRefPropNumber(((FlexProp)property).getBasePropertyKey());
            }
            parentRowInfo.addChildRowInfo(currentRowInfo);
        }
    }

    private String getSpecialPropertyNumber(IDataEntityProperty property) {
        if (property == property.getParent().getPrimaryKey() ? property.getParent() instanceof EntryType : property.getName().equals("pid") && property.getParent() instanceof TreeEntryType) {
            return property.getParent().getName() + "." + property.getName();
        }
        return property.getName();
    }

    private void appendPkIdProperty(EntityType currentEntityType, List<IDataEntityProperty> properties) {
        if (currentEntityType instanceof TreeEntryType) {
            properties.add(0, (IDataEntityProperty)currentEntityType.getProperty("pid"));
        }
        properties.add(0, (IDataEntityProperty)currentEntityType.getPrimaryKey());
    }

    public ImportTreeRowView convertInfoToView(ImportTreeRowInfo treeRowInfo) {
        TreeMap<Integer, ImportTreeRowView.RowView> treeRowInfosAtRow = new TreeMap<Integer, ImportTreeRowView.RowView>(Comparator.comparingInt(key -> key));
        int parentRowIndex = 0;
        ReferenceInteger referenceInteger = new ReferenceInteger(0);
        ImportTreeRowView.RowView rootRowView = treeRowInfo.getRootRowInfo().convertToView();
        rootRowView.setParentRow(parentRowIndex);
        rootRowView.setRow(referenceInteger.getValue());
        treeRowInfosAtRow.put(rootRowView.getRow(), rootRowView);
        this.convertToChildView(treeRowInfosAtRow, treeRowInfo.getRootRowInfo(), referenceInteger, rootRowView.getRow());
        this.addRefRow(treeRowInfosAtRow);
        return new ImportTreeRowView(treeRowInfosAtRow);
    }

    private void addRefRow(Map<Integer, ImportTreeRowView.RowView> treeRowInfosAtRow) {
        TreeMap rowNumberAndProperty = new TreeMap();
        treeRowInfosAtRow.forEach((rowNum, rowView) -> {
            if (StringUtils.isNotEmpty((String)rowView.getPropertyNumber())) {
                rowNumberAndProperty.put(rowView.getPropertyNumber(), rowNum);
            }
        });
        treeRowInfosAtRow.forEach((key, value) -> {
            Integer refRow;
            if (StringUtils.isNotEmpty((String)value.getRefPropertyNumber()) && null != (refRow = (Integer)rowNumberAndProperty.get(value.getRefPropertyNumber()))) {
                value.setRefRow(refRow);
                ((ImportTreeRowView.RowView)treeRowInfosAtRow.get(refRow)).getRef4Rows().add(key);
            }
        });
    }

    private void convertToChildView(Map<Integer, ImportTreeRowView.RowView> treeRowInfosAtRow, ImportTreeRowInfo.RowInfo parentRowInfo, ReferenceInteger currentRowIndex, int parentRowIndex) {
        List<ImportTreeRowInfo.RowInfo> childTreeRows = parentRowInfo.getChildTreeRows();
        if (CollectionUtils.isEmpty(childTreeRows)) {
            return;
        }
        for (ImportTreeRowInfo.RowInfo childRowInfo : childTreeRows) {
            ImportTreeRowView.RowView rowView = childRowInfo.convertToView();
            rowView.setParentRow(parentRowIndex);
            rowView.setRow(currentRowIndex.increase());
            treeRowInfosAtRow.put(rowView.getRow(), rowView);
            this.convertToChildView(treeRowInfosAtRow, childRowInfo, currentRowIndex, rowView.getRow());
        }
    }

    static class ReferenceInteger {
        Integer value;

        public ReferenceInteger(Integer value) {
            this.value = value;
        }

        public Integer getValue() {
            return this.value;
        }

        public void setValue(Integer value) {
            this.value = value;
        }

        public Integer increase() {
            Integer n = this.value;
            Integer n2 = this.value = Integer.valueOf(this.value + 1);
            return this.value;
        }
    }
}

