/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.importentry.resolving;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.importentry.model.ImportEntryTypeEnum;
import kd.bos.form.plugin.importentry.resolving.ImportEntryData;
import kd.bos.mservice.sysparam.SystemParamService;
import kd.bos.service.ServiceFactory;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;

public class ImportEntryContext {
    public static final String IMPORTCACHEKEY = "Cached_Import_Entry_Logger";
    public static final String IMPORTENTRYLOGGERDATA = "Cached_Import_Entry_Logger_DATA";
    public static final int DEFAULT_BATCH_IMPORT_SIZE = 1000;
    public static final String PROGRESS = "progress";
    protected static final String BOS_IMPORT = "bos-import";
    public static final String RESOLVE = "resolve";
    public static final String INSERTENTRYROWS = "insertEntryRows";
    private final IFormView view;
    private final String topPageId;
    private final String appid;
    private String checkRightAppId;
    private String formShowParameterAppId;
    private final String listName;
    private final String billFormId;
    private String fileUrl;
    private final List<String> validSheetNames;
    private final BidiMap<String, String> entryNameBindSheetName = new DualHashBidiMap();
    private final Map<String, String> entryNameBindName = new HashMap<String, String>();
    private final LinkedBlockingQueue<ImportEntryData> dataQueue = new LinkedBlockingQueue();
    private final Map<String, ImportLogger> importLoggerMap = new HashMap<String, ImportLogger>();
    private final Map<String, Integer> dealedRows = new HashMap<String, Integer>();
    private final ImportLogger importLogger = new ImportLogger();
    private Boolean isCompleted = false;
    private Boolean exportAll = false;
    private String importEntryLogPk;
    private ImportEntryTypeEnum importType;
    private final JSONObject option = new JSONObject();
    private RequestContext requestContext;
    private int LIMIT_FOR_ERROR_MESSAGE = 5000;

    public ImportEntryContext(IFormView view, String topPageId, String appid, String checkRightAppId, String listName, String billFormId, String fileUrl, List validSheetNames) {
        this.view = view;
        this.topPageId = topPageId;
        this.appid = appid;
        this.checkRightAppId = checkRightAppId;
        this.listName = listName;
        this.billFormId = billFormId;
        this.fileUrl = fileUrl;
        this.validSheetNames = validSheetNames;
        SystemParamService systemParamService = (SystemParamService)ServiceFactory.getService(SystemParamService.class);
        Object importMaxErrCount = systemParamService.loadPublicParameterFromCache("import_max_errcount");
        if (importMaxErrCount != null && StringUtils.isNumeric((CharSequence)importMaxErrCount.toString()) && Integer.parseInt(importMaxErrCount.toString()) > 0) {
            this.LIMIT_FOR_ERROR_MESSAGE = Integer.parseInt(importMaxErrCount.toString());
        }
        this.importLogger.setSrcFile(fileUrl);
        this.importLogger.setLimitForErrorMessage(this.LIMIT_FOR_ERROR_MESSAGE);
    }

    public String getBillFormId() {
        return this.billFormId;
    }

    public ImportEntryContext addOption(String key, Object val) {
        this.option.put(key, val);
        return this;
    }

    public Map<String, Object> getOption() {
        return this.option != null ? this.option.clone() : null;
    }

    public String getTopPageId() {
        return this.topPageId;
    }

    public IFormView getView() {
        return this.view;
    }

    public String getAppId() {
        return this.appid;
    }

    public String getListName() {
        return this.listName;
    }

    public String getCheckRightAppId() {
        return this.checkRightAppId;
    }

    public void setCheckRightAppId(String checkRightAppId) {
        this.checkRightAppId = checkRightAppId;
    }

    public Boolean getExportAll() {
        return this.exportAll;
    }

    public void setExportAll(Boolean exportAll) {
        this.exportAll = exportAll;
    }

    public String getImportEntryLogPk() {
        return this.importEntryLogPk;
    }

    public void setImportEntryLogPk(String importEntryLogPk) {
        this.importEntryLogPk = importEntryLogPk;
    }

    public void feedbackProgress(String entryName, int endIndex, Boolean finish) {
        IPageCache cache = this.view.getPageCache();
        String cachedLogStr = cache.get(IMPORTCACHEKEY);
        JSONObject map = StringUtils.isNotBlank((CharSequence)cachedLogStr) ? JSON.parseObject((String)cachedLogStr) : new JSONObject();
        List errMsg = (List)this.importLogger.getLogCache().get(0);
        if (!this.importLoggerMap.isEmpty()) {
            if (endIndex >= 0 && Boolean.FALSE.equals(finish)) {
                this.dealedRows.put(entryName, endIndex + 1);
            }
            int curRowNum = this.dealedRows.values().stream().reduce(0, (a, b) -> a + b - 4);
            int totalRowNum = this.importLoggerMap.values().stream().map(ImportLogger::getLastRowIndex).collect(Collectors.toList()).stream().reduce(0, (a, b) -> a + b - 4);
            int total = this.importLoggerMap.values().stream().map(ImportLogger::getTotal).collect(Collectors.toList()).stream().reduce(0, (a, b) -> a + b);
            int failed = this.importLoggerMap.values().stream().map(ImportLogger::getFailed).collect(Collectors.toList()).stream().reduce(0, (a, b) -> a + b);
            int succeed = total - failed;
            map.put("curRowNum", (Object)curRowNum);
            map.put("totalRowNum", (Object)totalRowNum);
            map.put("total", (Object)total);
            map.put("succeed", (Object)succeed);
            map.put("failed", (Object)failed);
            map.put("importLoggerMap", this.importLoggerMap);
            map.put("entryNameBindName", this.entryNameBindName);
            int progress = curRowNum * 100 / totalRowNum;
            if (Boolean.TRUE.equals(finish)) {
                progress = 100;
            }
            if (progress > map.getIntValue(PROGRESS)) {
                map.put(PROGRESS, (Object)progress);
            }
        }
        if (errMsg != null && errMsg.size() > 0 && StringUtils.isNotBlank(errMsg.get(0))) {
            map.put("err", (Object)((ImportLogger.ImportLog)errMsg.get(0)).toString());
        }
        cachedLogStr = JSON.toJSONString((Object)map);
        cache.put(IMPORTCACHEKEY, cachedLogStr);
        cache.saveChanges();
    }

    public String getFormShowParameterAppId() {
        return this.formShowParameterAppId;
    }

    public void setFormShowParameterAppId(String formShowParameterAppId) {
        this.formShowParameterAppId = formShowParameterAppId;
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public Map<String, ImportLogger> getImportLoggerMap() {
        return this.importLoggerMap;
    }

    public Boolean getCompleted() {
        return this.isCompleted;
    }

    public void setCompleted(Boolean completed) {
        this.isCompleted = completed;
    }

    public LinkedBlockingQueue<ImportEntryData> getDataQueue() {
        return this.dataQueue;
    }

    public void addEntryNameBindSheetName(String entryName, String sheetName) {
        this.entryNameBindSheetName.put((Object)entryName, (Object)sheetName);
    }

    public BidiMap<String, String> getEntryNameBindSheetNames() {
        return this.entryNameBindSheetName;
    }

    public Map<String, String> getEntryNameBindName() {
        return this.entryNameBindName;
    }

    public void addEntryNameBindName(String entryName, String name) {
        this.entryNameBindName.put(entryName, name);
    }

    public ImportLogger getImportLogger() {
        return this.importLogger;
    }

    public Map<String, Integer> getDealedRows() {
        return this.dealedRows;
    }

    public void setDealedRows(String entryName, Integer dealedRows) {
        this.dealedRows.put(entryName, dealedRows);
    }

    public List<String> getValidSheetNames() {
        return this.validSheetNames;
    }

    public ImportEntryTypeEnum getImportType() {
        return this.importType;
    }

    public void setImportType(ImportEntryTypeEnum importType) {
        this.importType = importType;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public void setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
    }
}

