/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.importentry.resolving;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.KDBizException;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.collections.MapUtils;

public class ImportEntryEntityMapping {
    private static final Log log = LogFactory.getLog(ImportEntryEntityMapping.class);
    private EntryType entryEntityType;
    private final Map<String, ColInfo> cols = new HashMap<String, ColInfo>();
    private final Map<String, ImportEntryEntityMapping> subEntries = new HashMap<String, ImportEntryEntityMapping>();
    private final Map<Integer, Map<String, FlexProperty>> flexProperties = new HashMap<Integer, Map<String, FlexProperty>>();
    private static final String NUMBER = "number";
    private static final String ROWNUM = "rowNum";
    private static final String IMPORTPROP = "importprop";

    public static ImportEntryEntityMapping createMapping(EntryType entityType, Map<String, ColInfo> names, Map<String, Object> option) {
        ImportEntryEntityMapping mapping = new ImportEntryEntityMapping();
        mapping.entryEntityType = entityType;
        boolean forMultiLang = Boolean.TRUE.equals(option.get("ForUpdateMultiLangFields"));
        for (IDataEntityProperty prop : entityType.getProperties()) {
            ColInfo colInfo;
            String propName = prop.getName();
            if (prop instanceof EntryProp) {
                ImportEntryEntityMapping entry = ImportEntryEntityMapping.createMapping((EntryType)((EntryProp)prop).getDynamicCollectionItemPropertyType(), names, option);
                if (entry.cols.isEmpty()) continue;
                mapping.subEntries.put(propName, entry);
                continue;
            }
            if (forMultiLang && !(prop instanceof MuliLangTextProp) && !"id".equals(propName) && !"pid".equals(propName) || (colInfo = names.get(propName)) == null) continue;
            if (prop instanceof FlexProp) {
                String displayName = colInfo.getDisplayName();
                colInfo.getFlexColIndex().put(colInfo.getIndex(), new String[]{colInfo.getBasedataProp(), displayName});
            }
            colInfo.setProperty(prop);
            mapping.cols.put(propName, colInfo);
        }
        String matchIdKey = entityType.getName() + "_$matchid$";
        if (names.containsKey(matchIdKey)) {
            mapping.cols.put("$matchid$", names.get(matchIdKey));
        }
        return mapping;
    }

    public void push(SheetHandler.ParsedRow prevRow, Map<Integer, String> row, JSONObject data, int rowNum, ImportLogger logger) {
        try {
            boolean sameOne = this.isSameEntryRow(prevRow, row, rowNum);
            if (!sameOne) {
                if (MapUtils.isNotEmpty(this.cols)) {
                    data.put(ROWNUM, (Object)rowNum);
                }
                this.pushProperties(row, data);
            }
            for (Map.Entry<String, ImportEntryEntityMapping> entry : this.subEntries.entrySet()) {
                String entryKey = entry.getKey();
                JSONArray entryRows = this.getEntryRows(data, entryKey);
                ImportEntryEntityMapping entryMapping = entry.getValue();
                JSONObject entryRow = new JSONObject();
                entryRow.put(ROWNUM, (Object)rowNum);
                boolean entryRowEmpty = entryMapping.pushProperties(row, entryRow);
                if (entryRowEmpty) continue;
                entryRows.add((Object)entryRow);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            String errMsg = ResManager.loadKDString((String)"\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"ImportEntityMapping_0", (String)"bos-import", (Object[])new Object[0]);
            logger.log(Integer.valueOf(rowNum), String.join((CharSequence)"\uff1b", e instanceof KDBizException ? e.getMessage() : errMsg) + "\uff1b");
            throw new KDBizException(errMsg);
        }
    }

    private boolean pushProperties(Map<Integer, String> row, JSONObject data) throws KDBizException {
        boolean rowEmpty = true;
        for (Map.Entry<String, ColInfo> col : this.cols.entrySet()) {
            String v;
            JSONObject flexVal;
            ColInfo colInfo = col.getValue();
            IDataEntityProperty prop = colInfo.getProperty();
            boolean isFlexProp = prop instanceof FlexProp;
            boolean isMultiLang = prop instanceof MuliLangTextProp;
            if (!isFlexProp && !isMultiLang && !row.containsKey(colInfo.getIndex())) continue;
            JSONObject val = null;
            if (isFlexProp) {
                flexVal = new HashMap();
                Map<Integer, String[]> colIndex = colInfo.getFlexColIndex();
                ArrayList list = new ArrayList(colIndex.size());
                colIndex.keySet().forEach(list::add);
                Collections.sort(list);
                HashMap flexPropertyMap = this.flexProperties.get(((FlexProp)prop).getFlexTypeId());
                if (flexPropertyMap == null) {
                    HashMap tempFlexPropertyMap = new HashMap();
                    FlexEntityMetaUtils.getFlexProperties((int)((FlexProp)prop).getFlexTypeId()).forEach(item -> {
                        if (StringUtils.isNotBlank((Object)item.getName())) {
                            tempFlexPropertyMap.put(item.getName().getLocaleValue(), item);
                        }
                    });
                    this.flexProperties.put(((FlexProp)prop).getFlexTypeId(), tempFlexPropertyMap);
                    flexPropertyMap = tempFlexPropertyMap;
                }
                for (int i = 0; i < list.size(); i += 3) {
                    int index = (Integer)list.get(i);
                    String v2 = row.get(index);
                    if (!StringUtils.isNotBlank((Object)v2)) continue;
                    if (flexPropertyMap.containsKey(v2)) {
                        FlexProperty fp = (FlexProperty)flexPropertyMap.get(v2);
                        String flexColName = v2;
                        String valueType = fp.getValueType();
                        if ("1".equals(valueType) || "2".equals(valueType)) {
                            HashMap<String, String> item2 = (HashMap<String, String>)flexVal.get(flexColName);
                            if (item2 == null) {
                                item2 = new HashMap<String, String>();
                                flexVal.put(flexColName, item2);
                            }
                            if (StringUtils.isNotBlank((CharSequence)row.get(index + 1))) {
                                item2.put(IMPORTPROP, NUMBER);
                                item2.put(NUMBER, row.get(index + 1));
                            }
                            if (!StringUtils.isNotBlank((CharSequence)row.get(index + 2))) continue;
                            if (StringUtils.isBlank(item2.get(IMPORTPROP))) {
                                item2.put(IMPORTPROP, "name");
                            }
                            item2.put("name", row.get(index + 2));
                            continue;
                        }
                        flexVal.put(flexColName, row.get(index + 2));
                        continue;
                    }
                    log.warn(String.format("----\u8b66\u544a\uff1a\u5bfc\u5165\u7684\u5f39\u6027\u57df\u7ef4\u5ea6\u5df2\u4e22\u5931\u3002\u7ef4\u5ea6\u4e0d\u5b58\u5728\u6216\u8005\u5f55\u5165\u7684\u7ef4\u5ea6\u201c%s\u201d\u4e0e\u5f39\u6027\u57df\u5b57\u6bb5\u7684\u5f39\u6027\u57df\u7c7b\u578b\u4e0d\u4e00\u81f4\uff1a%s", v2, flexPropertyMap.keySet()));
                }
                if (!flexVal.isEmpty()) {
                    val = flexVal;
                }
            } else if (isMultiLang) {
                flexVal = new HashMap();
                v = row.get(colInfo.index);
                if (row.containsKey(colInfo.index)) {
                    flexVal.put(StringUtils.isNotBlank((CharSequence)colInfo.basedataProp) ? colInfo.basedataProp : RequestContext.get().getLang().name(), v);
                }
                Map<Integer, String[]> colIndex = colInfo.getFlexColIndex();
                for (Map.Entry<Integer, String[]> entry : colIndex.entrySet()) {
                    v = row.get(entry.getKey());
                    if (!row.containsKey(entry.getKey())) continue;
                    flexVal.put(entry.getValue()[0], v);
                }
                if ((colInfo.isMustInput() || flexVal.isEmpty()) && !flexVal.containsKey(RequestContext.getOrCreate().getLang().name())) continue;
                val = flexVal;
            } else if (prop instanceof BasedataProp || prop instanceof MulBasedataProp) {
                v = row.get(colInfo.getIndex());
                if (row.containsKey(colInfo.getIndex())) {
                    boolean nullVal = true;
                    JSONObject jsonData = new JSONObject();
                    jsonData.put(IMPORTPROP, (Object)colInfo.getBasedataProp());
                    jsonData.put(colInfo.getBasedataProp(), (Object)v);
                    if (StringUtils.isNotBlank((Object)v)) {
                        nullVal = false;
                    }
                    for (Map.Entry<Integer, String[]> splitCol : colInfo.getFlexColIndex().entrySet()) {
                        v = row.get(splitCol.getKey());
                        if (row.containsKey(splitCol.getKey())) {
                            jsonData.put(splitCol.getValue()[0], (Object)v);
                        }
                        if (!nullVal || !StringUtils.isNotBlank((Object)v)) continue;
                        nullVal = false;
                    }
                    val = nullVal ? null : jsonData;
                }
            } else {
                val = row.get(colInfo.getIndex());
            }
            data.put(col.getKey(), (Object)val);
            if (!StringUtils.isNotBlank((Object)val)) continue;
            rowEmpty = false;
        }
        return rowEmpty;
    }

    private JSONArray getEntryRows(JSONObject data, String key) {
        JSONArray entry;
        if (data.containsKey((Object)key)) {
            entry = data.getJSONArray(key);
        } else {
            entry = new JSONArray();
            data.put(key, (Object)entry);
        }
        return entry;
    }

    public boolean isSameEntryRow(SheetHandler.ParsedRow prevRow, Map<Integer, String> currRowData, int currRowNum) {
        if (prevRow == null) {
            return false;
        }
        if (!this.isNearRow(prevRow.getRowNum(), currRowNum)) {
            return false;
        }
        return this.isSameOne(prevRow, currRowData);
    }

    private boolean isNearRow(int preRowNum, int currRowNum) {
        return currRowNum - preRowNum == 1;
    }

    public boolean isSameOne(SheetHandler.ParsedRow prevRow, Map<Integer, String> row) {
        if (prevRow == null) {
            return false;
        }
        boolean entityEmpty = true;
        for (Map.Entry<String, ColInfo> entry : this.cols.entrySet()) {
            Integer i = entry.getValue().getIndex();
            if (!entityEmpty || !StringUtils.isNotBlank((CharSequence)row.get(i))) continue;
            entityEmpty = false;
        }
        return entityEmpty;
    }

    public boolean isEntityEmpty(Map<Integer, String> row) {
        boolean isEmpty = true;
        for (Map.Entry<String, ColInfo> entry : this.cols.entrySet()) {
            if (!StringUtils.isNotBlank((CharSequence)row.get(entry.getValue().getIndex()))) continue;
            isEmpty = false;
            break;
        }
        return isEmpty;
    }

    public static Map<String, ColInfo> getEntityPropertyNames(Map<Integer, String> nameRow, Map<Integer, String> titleRow) {
        HashMap<String, ColInfo> names = new HashMap<String, ColInfo>();
        for (Map.Entry<Integer, String> entry : nameRow.entrySet()) {
            Integer i = entry.getKey();
            String fullName = entry.getValue();
            String fullTitle = titleRow.get(i);
            if (!StringUtils.isNotBlank((CharSequence)fullName)) continue;
            String[] tempNameSplit = fullName.split("\\.");
            String propertyDisplayName = StringUtils.isNotBlank((CharSequence)fullTitle) ? fullTitle.replace("*", "") : fullName;
            String propertyName = tempNameSplit[0];
            String endFix = tempNameSplit.length > 1 ? tempNameSplit[1] : "";
            ColInfo colInfo = (ColInfo)names.get(propertyName);
            if (colInfo != null) {
                Map<Integer, String[]> idx = colInfo.getFlexColIndex();
                idx.put(i, new String[]{endFix, propertyDisplayName});
                continue;
            }
            names.put(propertyName, new ColInfo(i, StringUtils.isNotBlank((CharSequence)propertyDisplayName) ? propertyDisplayName : propertyName, fullTitle != null && fullTitle.startsWith("*"), endFix));
        }
        return names;
    }

    public EntryType getEntryEntityType() {
        return this.entryEntityType;
    }

    public Map<String, ColInfo> getCols() {
        return this.cols;
    }

    public Map<String, ImportEntryEntityMapping> getSubEntries() {
        return this.subEntries;
    }

    public Map<Integer, Map<String, FlexProperty>> getFlexProperties() {
        return this.flexProperties;
    }

    public static class ColInfo {
        private int index;
        private String displayName;
        private boolean mustInput;
        private String basedataProp;
        private IDataEntityProperty property;
        private final Map<Integer, String[]> flexColIndex = new HashMap<Integer, String[]>();

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public boolean isMustInput() {
            return this.mustInput;
        }

        public void setMustInput(boolean mustInput) {
            this.mustInput = mustInput;
        }

        public String getBasedataProp() {
            return this.basedataProp;
        }

        public void setBasedataProp(String basedataProp) {
            this.basedataProp = basedataProp;
        }

        public ColInfo(int index, String displayName, boolean mustInput, String basedataProp) {
            this.index = index;
            this.displayName = displayName;
            this.mustInput = mustInput;
            this.basedataProp = basedataProp;
        }

        public IDataEntityProperty getProperty() {
            return this.property;
        }

        public void setProperty(IDataEntityProperty property) {
            this.property = property;
        }

        public Map<Integer, String[]> getFlexColIndex() {
            return this.flexColIndex;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }
    }
}

