/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.importentry.resolving;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.importentry.resolving.ImportEntryContext;
import kd.bos.form.plugin.importentry.resolving.ImportEntryData;
import kd.bos.form.plugin.importentry.resolving.ImportEntryEntityMapping;
import kd.bos.form.plugin.impt.HeartBeat;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.sysparam.SystemParamService;
import kd.bos.service.ServiceFactory;

public class ImportEntrySheetHandler
extends SheetHandler {
    private static final Log log = LogFactory.getLog(ImportEntrySheetHandler.class);
    private final ImportEntryContext ctx;
    private final MainEntityType mainEntityType;
    private final LinkedBlockingQueue<ImportEntryData> dataQueue;
    private final Map<String, ImportLogger> importLoggerMap;
    private Map<Integer, String> nameRow;
    private int startRowNum = 4;
    private final int nameColRight = 0;
    private final int nameColFalse = 1;
    private final Map<String, JSONObject> dataMap = new HashMap<String, JSONObject>();
    private String entryName;
    private ImportEntryEntityMapping importEntryEntityMapping;
    private SheetHandler.ParsedRow currentRow;
    private ImportLogger importLogger;
    private final Map<String, Object> option;
    private int ERR_ROW_COUNT = 5000;
    private final HeartBeat heartbeat;

    @Override
    public Map<String, Object> getOption() {
        return this.option;
    }

    public ImportEntrySheetHandler(ImportEntryContext ctx, MainEntityType mainEntityType, Map<String, Object> option, HeartBeat heartbeat) {
        this.ctx = ctx;
        this.mainEntityType = mainEntityType;
        this.dataQueue = ctx.getDataQueue();
        this.importLoggerMap = ctx.getImportLoggerMap();
        this.option = option;
        this.heartbeat = heartbeat;
        SystemParamService systemParamService = (SystemParamService)ServiceFactory.getService(SystemParamService.class);
        Object importMaxErrCount = systemParamService.loadPublicParameterFromCache("import_max_errcount");
        if (importMaxErrCount != null && StringUtils.isNumeric((CharSequence)importMaxErrCount.toString()) && Integer.parseInt(importMaxErrCount.toString()) > 0) {
            this.ERR_ROW_COUNT = Integer.parseInt(importMaxErrCount.toString());
        }
    }

    @Override
    public void handleRow(SheetHandler.ParsedRow row) {
        if (this.heartbeat != null) {
            this.heartbeat.refresh();
        }
        int currRowNum = row.getRowNum();
        if (this.entryName != null && this.importLogger != null) {
            this.importLogger.setRowIndex(currRowNum);
        }
        if (currRowNum == 0) {
            if (row.isEmpty()) {
                return;
            }
            this.entryName = StringUtils.isNotBlank((CharSequence)row.get(0)) ? row.get(0).split(" # ")[1] : row.get(1).split(" # ")[1];
            this.importLogger = this.importLoggerMap.computeIfAbsent(this.entryName, newImportLogger -> {
                ImportLogger importLoggerTmp = new ImportLogger();
                importLoggerTmp.setLimitForErrorMessage(this.ERR_ROW_COUNT);
                return importLoggerTmp;
            });
            this.ctx.addEntryNameBindSheetName(this.entryName, row.getSheetName());
            this.importLogger.setLastRowIndex(this.getRowCount());
            this.startRowNum = 4;
            this.ctx.feedbackProgress(this.entryName, -1, false);
        }
        if (currRowNum == 2) {
            this.nameRow = row.getData();
        }
        if (currRowNum >= 3) {
            this.buildEntrys(row);
        }
    }

    private void buildEntrys(SheetHandler.ParsedRow row) {
        int currRowNum = row.getRowNum();
        if (currRowNum == 3) {
            EntryType entryType = (EntryType)((EntryProp)this.mainEntityType.getProperties().get((Object)this.entryName)).getItemType();
            String name = ResManager.loadKDString((String)"\u672a\u547d\u540d\u5355\u636e\u4f53", (String)"ImportEntrySheetHandler_0", (String)"bos-import", (Object[])new Object[0]);
            if (null != entryType.getDisplayName() && StringUtils.isNotBlank((CharSequence)entryType.getDisplayName().getLocaleValue())) {
                name = entryType.getDisplayName().getLocaleValue();
            }
            this.ctx.addEntryNameBindName(this.entryName, name);
            Map<String, ImportEntryEntityMapping.ColInfo> names = ImportEntryEntityMapping.getEntityPropertyNames(this.nameRow, row.getData());
            this.importEntryEntityMapping = ImportEntryEntityMapping.createMapping(entryType, names, this.option);
            this.dataMap.putIfAbsent(this.entryName, new JSONObject());
        } else if (currRowNum > 3) {
            if (this.importEntryEntityMapping == null) {
                return;
            }
            try {
                if (currRowNum > 4 && !row.isEmpty() && !this.importEntryEntityMapping.isSameEntryRow(this.currentRow, row.getData(), row.getRowNum())) {
                    JSONObject jsonObject = this.dataMap.get(this.entryName).clone();
                    if (!this.dataQueue.offer(new ImportEntryData(this.startRowNum, currRowNum - 1, jsonObject, this.entryName, this.importEntryEntityMapping), 100L, TimeUnit.SECONDS)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u7684\u7f13\u5b58\u6c60\u5f02\u5e38\u3002", (String)"BatchImportSheetHandler_1", (String)"bos-import", (Object[])new Object[0]));
                    }
                    this.dataMap.get(this.entryName).clear();
                    this.startRowNum = currRowNum;
                }
                if (!row.isEmpty()) {
                    this.importEntryEntityMapping.push(this.currentRow, row.getData(), this.dataMap.get(this.entryName), row.getRowNum(), this.importLogger);
                }
            }
            catch (InterruptedException e) {
                log.error((Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                log.error((Throwable)e);
                throw new KDBizException(e instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u89e3\u6790\u7ebf\u7a0b\u5f02\u5e38\u3002", (String)"BatchImportSheetHandler_2", (String)"bos-import", (Object[])new Object[0]));
            }
            finally {
                if (!row.isEmpty()) {
                    this.currentRow = row;
                }
            }
        }
    }

    @Override
    public void endDocument() {
        this.setInterrupt(false);
        if (this.currentRow != null) {
            int currRowNum = this.currentRow.getRowNum();
            if (!this.dataMap.get(this.entryName).isEmpty()) {
                JSONObject jsonObject = this.dataMap.get(this.entryName).clone();
                this.dataQueue.offer(new ImportEntryData(this.startRowNum, currRowNum, jsonObject, this.entryName, this.importEntryEntityMapping));
            }
        }
        this.entryName = null;
    }
}

