/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.impt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.impt.background.ImportProgress;
import kd.bos.form.impt.monitor.ImportMonitor;
import kd.bos.form.plugin.importentry.model.PictureCheckBase;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.mservice.sysparam.SystemParamService;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic(scriptName="\u5bfc\u5165\u6d41\u7a0b\u7ebf\u7a0b\u901a\u4fe1\u4e0a\u4e0b\u6587")
public class ImportContext {
    private static final String IMPORTCACHEKEY = "Cached_Import_Logger";
    public static final int DEFAULT_BATCH_IMPORT_SIZE = 1000;
    public static final String PROGRESS = "progress";
    private final IFormView view;
    private final Object logId;
    private final String appid;
    private String checkRightAppId;
    private String formShowParameterAppId;
    private final String listName;
    private final String billFormId;
    private final Map<String, LinkedBlockingQueue<ImportBillData>> dataQueues = new HashMap<String, LinkedBlockingQueue<ImportBillData>>(1);
    private final Map<String, ImportLogger> importLoggers = new LinkedHashMap<String, ImportLogger>(1);
    private final Set<String> completeUrls = new HashSet<String>(1);
    private final JSONObject option = new JSONObject();
    private final String opSaveKey;
    private boolean isNewFormatType = true;
    private boolean batchByEntry;
    private int batchEntryRowSize = 5000;
    protected String taskId;
    private CountDownLatch countDownLatch;
    private ImportProgress importProgress;
    private Boolean isFromTask = Boolean.FALSE;
    private final Map<String, String> imgDataWithServerUrl = new HashMap<String, String>();
    private final Map<PictureCheckBase, String> imgInfoWithServerUrl = new HashMap<PictureCheckBase, String>();
    private String imgZipUrl;
    private String attZipUrl;
    private ImportMonitor importMonitor = new ImportMonitor();
    private Boolean readOriginalNum = Boolean.FALSE;
    private int LIMIT_FOR_ERROR_MESSAGE = 5000;

    @Deprecated
    public ImportContext(IFormView view, Object logId, String appid, String listName, String billFormId, String opSaveKey, String url) {
        this.view = view;
        this.logId = logId;
        this.appid = appid;
        this.listName = listName;
        this.billFormId = billFormId;
        this.opSaveKey = opSaveKey;
        SystemParamService systemParamService = (SystemParamService)ServiceFactory.getService(SystemParamService.class);
        Object importMaxErrCount = systemParamService.loadPublicParameterFromCache("import_max_errcount");
        if (importMaxErrCount != null && StringUtils.isNumeric((CharSequence)importMaxErrCount.toString()) && Integer.parseInt(importMaxErrCount.toString()) > 0) {
            this.LIMIT_FOR_ERROR_MESSAGE = Integer.parseInt(importMaxErrCount.toString());
        }
        ImportLogger importLogger = new ImportLogger(url);
        importLogger.setLimitForErrorMessage(this.LIMIT_FOR_ERROR_MESSAGE);
        this.importLoggers.put(url, importLogger);
        this.dataQueues.put(url, new LinkedBlockingQueue(3000));
    }

    public ImportContext(IFormView view, Object logId, String appid, String checkRightAppId, String listName, String billFormId, String opSaveKey, String url) {
        this(view, logId, appid, listName, billFormId, opSaveKey, url);
        this.checkRightAppId = checkRightAppId;
    }

    public ImportContext(IFormView view, Object logId, String appid, String checkRightAppId, String listName, String billFormId, String opSaveKey, String url, String formShowParameterAppId, Boolean fromTask, String taskId, CountDownLatch countDownLatch, ImportProgress importProgress, String imgZipUrl, ImportMonitor importMonitor) {
        this(view, logId, appid, listName, billFormId, opSaveKey, url);
        this.checkRightAppId = checkRightAppId;
        this.taskId = taskId;
        this.countDownLatch = countDownLatch;
        this.importProgress = importProgress;
        this.formShowParameterAppId = formShowParameterAppId;
        this.isFromTask = fromTask;
        this.imgZipUrl = imgZipUrl;
        this.importMonitor = importMonitor;
    }

    public ImportContext(IFormView view, Object logId, String appid, String checkRightAppId, String listName, String billFormId, String opSaveKey, String url, String formShowParameterAppId, Boolean fromTask, String taskId, CountDownLatch countDownLatch, ImportProgress importProgress, String imgZipUrl, ImportMonitor importMonitor, Boolean readOriginalNum) {
        this(view, logId, appid, checkRightAppId, listName, billFormId, opSaveKey, url, formShowParameterAppId, fromTask, taskId, countDownLatch, importProgress, imgZipUrl, importMonitor);
        this.readOriginalNum = readOriginalNum;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getBillFormId() {
        return this.billFormId;
    }

    public Set<String> getAllUrls() {
        return this.importLoggers.keySet();
    }

    public ImportLogger getLogger(String url) {
        return this.importLoggers.get(url);
    }

    public void addBillData(String url, ImportBillData importBillData) {
        this.getDataQueue(url).add(importBillData);
    }

    public boolean isResolveComplete(String key) {
        return this.completeUrls.contains(key);
    }

    public void setResolveComplete(String url) {
        if (this.importLoggers.containsKey(url)) {
            this.completeUrls.add(url);
        }
    }

    public CountDownLatch getCountDownLatch() {
        return this.countDownLatch;
    }

    public void setCountDownLatch(CountDownLatch countDownLatch) {
        this.countDownLatch = countDownLatch;
    }

    public LinkedBlockingQueue<ImportBillData> getDataQueue(String url) {
        return this.dataQueues.get(url);
    }

    public ImportContext addOption(String key, Object val) {
        this.option.put(key, val);
        return this;
    }

    public Map<String, Object> getOption() {
        return this.option.clone();
    }

    public void feedbackProgress(int progress, ImportLogger logger, String errMsg) {
        JSONObject map;
        IPageCache cache = (IPageCache)this.view.getService(IPageCache.class);
        String cachedLogStr = cache.get(IMPORTCACHEKEY);
        JSONObject jSONObject = map = StringUtils.isNotBlank((CharSequence)cachedLogStr) ? JSON.parseObject((String)cachedLogStr) : new JSONObject();
        if (progress > map.getIntValue(PROGRESS)) {
            map.put(PROGRESS, (Object)progress);
        }
        if (logger != null) {
            int headRowCount = this.isNewFormatType ? 4 : 3;
            map.put("curRowNum", (Object)(logger.getRowIndex() + 1 - headRowCount));
            map.put("totalRowNum", (Object)(logger.getLastRowIndex() - headRowCount));
            map.put("total", (Object)logger.getTotal());
            map.put("succeed", (Object)logger.getDelRows().size());
            map.put("failed", (Object)logger.getFailed());
            map.put("totalRow", (Object)logger.getTotalRow());
        }
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            map.put("err", (Object)errMsg);
        }
        cachedLogStr = JSON.toJSONString((Object)map);
        cache.put(IMPORTCACHEKEY, cachedLogStr);
        cache.saveChanges();
        if (this.isFromTask.booleanValue()) {
            this.getImportProgress().feedbackProgress(map);
            if (progress >= 100) {
                this.getImportProgress().complete();
            }
        }
    }

    public void feedbackProgress(int progress, int total, int fail) {
        JSONObject map;
        IPageCache cache = (IPageCache)this.view.getService(IPageCache.class);
        String cachedLogStr = cache.get(IMPORTCACHEKEY);
        JSONObject jSONObject = map = StringUtils.isNotBlank((CharSequence)cachedLogStr) ? JSON.parseObject((String)cachedLogStr) : new JSONObject();
        if (progress > map.getIntValue(PROGRESS)) {
            map.put(PROGRESS, (Object)progress);
        }
        map.put("total", (Object)total);
        map.put("succeed", (Object)(total - fail));
        map.put("failed", (Object)fail);
        cachedLogStr = JSON.toJSONString((Object)map);
        cache.put(IMPORTCACHEKEY, cachedLogStr);
        cache.saveChanges();
        if (this.isFromTask.booleanValue()) {
            this.getImportProgress().feedbackProgress(map);
        }
    }

    public Object getUrlLoggers() {
        return this.importLoggers;
    }

    public Object getLogId() {
        return this.logId;
    }

    public String getOpSaveKey() {
        return this.opSaveKey;
    }

    public String getAppId() {
        return this.appid;
    }

    public String getListName() {
        return this.listName;
    }

    public String getCheckRightAppId() {
        return this.checkRightAppId;
    }

    public void setCheckRightAppId(String checkRightAppId) {
        this.checkRightAppId = checkRightAppId;
    }

    public boolean isNewFormat() {
        return this.isNewFormatType;
    }

    public void setNewFormat(boolean newFormat) {
        this.isNewFormatType = newFormat;
    }

    public boolean isBatchByEntry() {
        return this.batchByEntry;
    }

    public void setBatchByEntry(boolean batchByEntry) {
        this.batchByEntry = batchByEntry;
    }

    public int getBatchEntryRowSize() {
        return this.batchEntryRowSize;
    }

    public void setBatchEntryRowSize(int batchEntryRowSize) {
        this.batchEntryRowSize = batchEntryRowSize;
    }

    public String getFormShowParameterAppId() {
        return this.formShowParameterAppId;
    }

    public void setFormShowParameterAppId(String formShowParameterAppId) {
        this.formShowParameterAppId = formShowParameterAppId;
    }

    public ImportProgress getImportProgress() {
        return this.importProgress;
    }

    public void setImportProgress(ImportProgress importProgress) {
        this.importProgress = importProgress;
    }

    public Boolean isFromTask() {
        return this.isFromTask;
    }

    public void setFromTask(Boolean fromTask) {
        this.isFromTask = fromTask;
    }

    public Map<String, String> getImgDataWithServerUrl() {
        return this.imgDataWithServerUrl;
    }

    public Map<PictureCheckBase, String> getImgInfoWithServerUrl() {
        return this.imgInfoWithServerUrl;
    }

    public String getImgZipUrl() {
        return this.imgZipUrl;
    }

    public void setImgZipUrl(String imgZipUrl) {
        this.imgZipUrl = imgZipUrl;
    }

    public boolean hasPicProp() {
        return false;
    }

    public ImportMonitor getImportMonitor() {
        return this.importMonitor;
    }

    public void setImportMonitor(ImportMonitor importMonitor) {
        this.importMonitor = importMonitor;
    }

    public Boolean getReadOriginalNum() {
        return this.readOriginalNum;
    }

    public String getAttZipUrl() {
        return this.attZipUrl;
    }

    public void setAttZipUrl(String attZipUrl) {
        this.attZipUrl = attZipUrl;
    }
}

