/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.impt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.data.ImportLogHelper;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.IImportServicePlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.operate.webapi.AbstractOperateWebApi;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportConfig;
import kd.bos.form.plugin.impt.ImportFailedSheetHandler;
import kd.bos.form.plugin.impt.ImportHelper;
import kd.bos.form.plugin.impt.ImportSheetHandler;
import kd.bos.impt.ExcelReader;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.attachment.extend.importdata.FileImportExtensionFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class ImportDataTask
implements Callable<Object> {
    private static final Log log = LogFactory.getLog(ImportDataTask.class);
    private static final String BOS_IMPORT = "bos-import";
    private static final String KEY_IMPORTPROP = "importprop";
    private static final String KEY_NUMBER = "number";
    private static final String IMPORT_NUMBER_FORMAT = "IMPORT_%s_%s";
    private final RequestContext ctx;
    private final ImportConfig conf;
    private final String action;
    private AbstractOperateWebApi saveWebApi = null;

    public static String getCacheKey(String formId, String pageid) {
        String cacheKey = String.format(IMPORT_NUMBER_FORMAT, formId, pageid);
        return cacheKey.substring(0, Math.min(cacheKey.length(), 50));
    }

    public ImportDataTask(RequestContext ctx, ImportConfig conf, String action) {
        this.conf = conf;
        this.action = action;
        this.ctx = ctx;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object call() {
        try {
            RequestContext.copyAndSet((RequestContext)this.ctx);
            OperationContext oc = new OperationContext();
            oc.setAppId(this.conf.getAppId());
            if (this.conf.getEntityType() != null) {
                oc.setFormId(this.conf.getEntityType().getName());
            }
            oc.setOpKey("importdata");
            OperationContext.set((OperationContext)oc);
            switch (this.action) {
                case "resolveExcel": {
                    log.debug(this.conf.getPageId() + "\u3002\u3002\u3002\u5bfc\u5165\u7ebf\u7a0b\u5f00\u59cb\u89e3\u6790\u6570\u636e\u3002\u3002\u3002");
                    this.resolveExcel();
                    log.debug(this.conf.getPageId() + "\u3002\u3002\u3002\u5bfc\u5165\u7ebf\u7a0b\u5f00\u59cb\u89e3\u6790\u6570\u636e\u3002\u3002\u3002\u7ed3\u675f");
                    return null;
                }
                case "importData": {
                    log.debug(this.conf.getPageId() + "\u3002\u3002\u3002\u5bfc\u5165\u7ebf\u7a0b\u5f00\u59cb\u5bfc\u5165\u6570\u636e\u3002\u3002\u3002");
                    this.importData();
                    if (this.conf.getFromTask().booleanValue()) {
                        this.conf.getCountDownLatch().countDown();
                    }
                    log.debug(this.conf.getPageId() + "\u3002\u3002\u3002\u5bfc\u5165\u7ebf\u7a0b\u5f00\u59cb\u5bfc\u5165\u6570\u636e\u3002\u3002\u3002\u7ed3\u675f");
                    return null;
                }
            }
            return null;
        }
        catch (Throwable e) {
            log.error(e);
            throw new RuntimeException(e);
        }
        finally {
            RequestContext.set(null);
        }
    }

    private AbstractOperateWebApi getSaveWebApi() {
        if (this.saveWebApi == null) {
            this.saveWebApi = FormMetadataCache.getFormOperationApi((String)FormMetadataCache.getFormConfig((String)this.conf.getEntityType().getName()).getEntityTypeId(), (String)this.conf.getOpSave());
        }
        return this.saveWebApi;
    }

    private void importData() throws InterruptedException {
        ImportBillData rowdata = null;
        Map<String, LinkedBlockingQueue<ImportBillData>> dataQueues = this.conf.getDataQueues();
        HashMap<Integer, Tuple> dIndexMap = new HashMap<Integer, Tuple>();
        String importErrMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"ImportDataTask_0", (String)BOS_IMPORT, (Object[])new Object[0]);
        boolean isShowStackTrace = SystemParamServiceHelper.isShowStackTrace();
        for (Map.Entry<String, ImportLogger> url : this.conf.getUrlLoggers().entrySet()) {
            LinkedBlockingQueue<ImportBillData> dataQ = dataQueues.get(url.getKey());
            ArrayList<int[]> delRows = new ArrayList<int[]>();
            ImportLogger importLogger = url.getValue();
            importLogger.setDelRows(delRows);
            int timeout = 0;
            ArrayList<ImportBillData> leftRowdatas = new ArrayList<ImportBillData>();
            List<Object> propKeys = this.buildBaseRefPropKeys((BillEntityType)this.conf.getEntityType());
            while (!(this.conf.isComplete(url.getKey()) && dataQ.isEmpty() && leftRowdatas.isEmpty() || timeout > 5)) {
                ArrayList<ImportBillData> rowdatas = new ArrayList<ImportBillData>();
                if (!propKeys.isEmpty()) {
                    this.getFromLeftRowDatas(leftRowdatas, rowdatas, propKeys);
                }
                int lastLeftCount = rowdatas.size();
                int needCount = 500 - lastLeftCount;
                if (leftRowdatas.isEmpty() && rowdatas.isEmpty() && needCount > 0) {
                    rowdata = dataQ.poll(1L, TimeUnit.MINUTES);
                    if (rowdata == null || rowdata.isEmpty()) {
                        if (rowdatas.isEmpty()) {
                            log.debug(this.conf.getPageId() + "...read...null");
                            ++timeout;
                            continue;
                        }
                    } else {
                        rowdatas.add(rowdata);
                        dataQ.drainTo(rowdatas, needCount);
                        rowdatas.removeIf(ImportBillData::isEmpty);
                    }
                    if (!propKeys.isEmpty()) {
                        this.filterLeftRowDatas(rowdatas, leftRowdatas, propKeys);
                    }
                }
                timeout = 0;
                dIndexMap.clear();
                ArrayList<JSONObject> bills = new ArrayList<JSONObject>();
                int firstRow = 0;
                int lastEndIndex = ((ImportBillData)rowdatas.get(rowdatas.size() - 1)).getEndIndex();
                ImportHelper.invalidBill(rowdatas, importLogger);
                for (ImportBillData temp : rowdatas) {
                    int beginSeq = temp.getStartIndex();
                    int endSeq = temp.getEndIndex();
                    if (firstRow == 0) {
                        firstRow = beginSeq;
                    }
                    ArrayList<ImportLogger.ImportLog> logs = new ArrayList<ImportLogger.ImportLog>();
                    boolean completeImport = false;
                    boolean pluginBreak = false;
                    try {
                        pluginBreak = this.fireBeforeImportEvent(temp.getData(), logs);
                        if (!pluginBreak) {
                            completeImport = this.fireImportEvent(temp.getData(), logs) || !logs.isEmpty();
                        }
                    }
                    catch (Throwable throwable) {
                        log.error(throwable);
                        logs.add(isShowStackTrace ? new ImportLogger.ImportLog(throwable) : new ImportLogger.ImportLog(importErrMsg));
                        pluginBreak = true;
                    }
                    if (!pluginBreak && !completeImport) {
                        bills.add(temp.getData());
                        dIndexMap.put(bills.size() - 1, new Tuple((Object)beginSeq, (Object)endSeq));
                        continue;
                    }
                    if (!logs.isEmpty()) {
                        importLogger.logAll(Integer.valueOf(beginSeq), logs).fail();
                        continue;
                    }
                    if (!completeImport) continue;
                    delRows.add(new int[]{beginSeq, endSeq});
                }
                if (!bills.isEmpty()) {
                    JSONObject dataPack = new JSONObject();
                    dataPack.put("datas", bills);
                    dataPack.put("appid", (Object)this.conf.getCheckRightAppId());
                    dataPack.put("option", (Object)this.conf.getOption());
                    ApiResult apiResult = null;
                    try {
                        AbstractOperateWebApi webApi = this.getSaveWebApi();
                        webApi.initialize(this.conf.getEntityType().getName(), (Map)dataPack);
                        apiResult = webApi.execute();
                    }
                    catch (KDBizException kdexp) {
                        if (isShowStackTrace) {
                            importLogger.log(Integer.valueOf(firstRow), (Throwable)kdexp).setFailed(importLogger.getFailed() + bills.size());
                        } else {
                            importLogger.log(Integer.valueOf(firstRow), importErrMsg).setFailed(importLogger.getFailed() + bills.size());
                        }
                        log.error((Throwable)kdexp);
                    }
                    catch (Throwable exp) {
                        if (isShowStackTrace) {
                            importLogger.log(Integer.valueOf(firstRow), exp).setFailed(importLogger.getFailed() + bills.size());
                        } else {
                            importLogger.log(Integer.valueOf(firstRow), importErrMsg).setFailed(importLogger.getFailed() + bills.size());
                        }
                        log.error(exp);
                    }
                    if (apiResult != null) {
                        List billResults = (List)apiResult.getData();
                        for (int i = 0; i < billResults.size(); ++i) {
                            Map billResult = (Map)billResults.get(i);
                            if (((Boolean)billResult.get("success")).booleanValue()) {
                                ArrayList<Object> successIds = new ArrayList<Object>();
                                successIds.add(billResult.get("id"));
                                ArrayList logs = new ArrayList();
                                this.fireAfterImportEvent(successIds, logs);
                                if (logs.isEmpty()) {
                                    delRows.add(new int[]{(Integer)((Tuple)dIndexMap.get((Object)Integer.valueOf((int)i))).item1, (Integer)((Tuple)dIndexMap.get((Object)Integer.valueOf((int)i))).item2});
                                    continue;
                                }
                                url.getValue().logAll((Integer)((Tuple)dIndexMap.get((Object)Integer.valueOf((int)i))).item1, (List)logs).fail();
                                continue;
                            }
                            if (billResult.containsKey("convertResult")) {
                                Map convertResult = (Map)billResult.get("convertResult");
                                for (Map.Entry entry : convertResult.entrySet()) {
                                    url.getValue().log((Integer)entry.getKey(), StringUtils.join((Object[])((List)entry.getValue()).toArray(), (String)";"));
                                }
                                url.getValue().fail();
                                continue;
                            }
                            String msg = (String)billResult.get("message");
                            if (StringUtils.isBlank((CharSequence)msg)) {
                                List list;
                                Object objData = billResult.get("data");
                                if (objData instanceof Map) {
                                    List errList;
                                    Map map = (Map)objData;
                                    if (map != null && ((Boolean)map.get("success")).booleanValue() && (errList = (List)map.get("AllErrorOrValidateInfo")) != null && !errList.isEmpty()) {
                                        StringBuilder stb = new StringBuilder();
                                        for (Map errinfo : errList) {
                                            stb.append(errinfo.get("message"));
                                        }
                                        msg = stb.toString();
                                    }
                                } else if (objData instanceof List && !(list = (List)objData).isEmpty()) {
                                    StringBuilder stb = new StringBuilder();
                                    for (OperateErrorInfo errinfo : list) {
                                        stb.append(errinfo.getMessage());
                                    }
                                    msg = stb.toString();
                                }
                            }
                            Integer dindex = (Integer)billResult.get("dindex");
                            url.getValue().log((Integer)((Tuple)dIndexMap.get((Object)dindex)).item1, msg).fail();
                        }
                    }
                }
                importLogger.setTotal(importLogger.getFailed() + importLogger.getDelRows().size());
                this.conf.feedbackProgress(Math.min(99, lastEndIndex * 100 / importLogger.getLastRowIndex()), importLogger, null);
                log.debug(String.format("----import %s --batch--succeed=%d--failed=%d", importLogger.getSrcFile(), importLogger.getDelRows().size(), importLogger.getFailed()));
            }
        }
        HashMap<String, Object> retdata = new HashMap<String, Object>();
        retdata.put("complete", Boolean.TRUE);
        retdata.put("info", this.conf.getUrlLoggers());
        int total = 0;
        int failed = 0;
        for (Map.Entry<String, ImportLogger> urllogger : this.conf.getUrlLoggers().entrySet()) {
            ImportLogger logger = urllogger.getValue();
            total += logger.getTotal();
            failed += logger.getRowIndex() < logger.getLastRowIndex() - 1 ? logger.getTotal() - logger.getDelRows().size() : logger.getFailed();
            if (logger.getFailed() <= 0 && logger.getRowIndex() >= logger.getLastRowIndex() - 1) continue;
            this.outputFailedData(logger.getDelRows(), urllogger);
        }
        ImportLogHelper.logAll((Object)this.conf.getLogId(), (String)JSON.toJSONString(retdata), (int)total, (int)failed);
        this.conf.feedbackProgress(100, null, null);
    }

    private void getFromLeftRowDatas(List<ImportBillData> leftRowdatas, List<ImportBillData> rowdatas, List<Object> propKeys) {
        BillEntityType billType = (BillEntityType)this.conf.getEntityType();
        HashSet<String> numberRowMapping = new HashSet<String>();
        HashSet<String> nameRowMapping = new HashSet<String>();
        if (!propKeys.isEmpty()) {
            boolean refPrevData = false;
            int i = 0;
            while (i < leftRowdatas.size()) {
                if (!refPrevData) {
                    JSONObject billdata = leftRowdatas.get(i).getData();
                    refPrevData = this.checkIfRefPrevData(billType, billdata, propKeys, numberRowMapping, nameRowMapping);
                }
                if (refPrevData) break;
                rowdatas.add(leftRowdatas.remove(i));
            }
        }
    }

    private void filterLeftRowDatas(List<ImportBillData> rowdatas, List<ImportBillData> leftRowdatas, List<Object> propKeys) {
        BillEntityType billType = (BillEntityType)this.conf.getEntityType();
        HashSet<String> numberRowMapping = new HashSet<String>();
        HashSet<String> nameRowMapping = new HashSet<String>();
        if (!propKeys.isEmpty()) {
            boolean refPrevData = false;
            int i = 0;
            while (i < rowdatas.size()) {
                if (!refPrevData) {
                    JSONObject billdata = rowdatas.get(i).getData();
                    refPrevData = this.checkIfRefPrevData(billType, billdata, propKeys, numberRowMapping, nameRowMapping);
                }
                if (refPrevData) {
                    leftRowdatas.add(rowdatas.remove(i));
                    continue;
                }
                ++i;
            }
        }
    }

    private List<Object> buildBaseRefPropKeys(BillEntityType billType) {
        if (!(this.conf.getEntityType() instanceof BillEntityType)) {
            return new ArrayList<Object>(0);
        }
        ArrayList<Object> propKeys = new ArrayList<Object>();
        DataEntityPropertyCollection coll = billType.getProperties();
        String entityName = this.conf.getEntityType().getName();
        for (IDataEntityProperty prop : coll) {
            if (prop instanceof IBasedataField && entityName.equals(((IBasedataField)prop).getBaseEntityId())) {
                propKeys.add(prop.getName());
                continue;
            }
            if (!(prop instanceof EntryProp)) continue;
            HashMap entryPropMap = new HashMap();
            ArrayList<Object> entryPropKeys = new ArrayList<Object>();
            entryPropMap.put(prop.getName(), entryPropKeys);
            int entryCount = 0;
            for (IDataEntityProperty entryProp : ((EntryProp)prop).getDynamicCollectionItemPropertyType().getProperties()) {
                if (entryProp instanceof IBasedataField && entityName.equals(((IBasedataField)entryProp).getBaseEntityId())) {
                    entryPropKeys.add(entryProp.getName());
                    ++entryCount;
                    continue;
                }
                if (!(entryProp instanceof EntryProp)) continue;
                HashMap subEntryPropMap = new HashMap();
                ArrayList<String> subEntryPropKeys = new ArrayList<String>();
                subEntryPropMap.put(entryProp.getName(), subEntryPropKeys);
                int subEntryCount = 0;
                for (IDataEntityProperty subEntryProp : ((EntryProp)entryProp).getDynamicCollectionItemPropertyType().getProperties()) {
                    if (!(subEntryProp instanceof IBasedataField) || !entityName.equals(((IBasedataField)subEntryProp).getBaseEntityId())) continue;
                    subEntryPropKeys.add(subEntryProp.getName());
                    ++subEntryCount;
                }
                if (subEntryCount <= 0) continue;
                entryPropKeys.add(subEntryPropMap);
                ++entryCount;
            }
            if (entryCount <= 0) continue;
            propKeys.add(entryPropMap);
        }
        return propKeys;
    }

    private boolean checkIfRefPrevData(BillEntityType billType, JSONObject billdata, List<Object> propKeys, Set<String> numberRowMapping, Set<String> nameRowMapping) {
        for (Object obj : propKeys) {
            if (obj instanceof String) {
                JSONObject data = billdata.getJSONObject((String)obj);
                if (data == null || !data.containsKey((Object)KEY_IMPORTPROP)) continue;
                String string = data.getString(KEY_IMPORTPROP);
                if (string.equals(KEY_NUMBER) && numberRowMapping.contains(data.get((Object)string))) {
                    return true;
                }
                if (!string.equals("name") || !nameRowMapping.contains(data.get((Object)string))) continue;
                return true;
            }
            if (!(obj instanceof Map)) continue;
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                String entryKey = (String)entry.getKey();
                List entryFieldKeys = (List)entry.getValue();
                JSONArray entryRows = billdata.getJSONArray(entryKey);
                if (entryRows == null) continue;
                for (int j = 0; j < entryRows.size(); ++j) {
                    JSONObject entryRow = entryRows.getJSONObject(j);
                    for (Object entryObj : entryFieldKeys) {
                        if (entryObj instanceof String) {
                            JSONObject data = entryRow.getJSONObject((String)entryObj);
                            if (data == null || !data.containsKey((Object)KEY_IMPORTPROP)) continue;
                            String dataType = data.getString(KEY_IMPORTPROP);
                            if (dataType.equals(KEY_NUMBER) && numberRowMapping.contains(data.get((Object)dataType))) {
                                return true;
                            }
                            if (!dataType.equals("name") || !nameRowMapping.contains(data.get((Object)dataType))) continue;
                            return true;
                        }
                        if (!(entryObj instanceof Map)) continue;
                        for (Map.Entry subEntryKeyObj : ((Map)entryObj).entrySet()) {
                            String subEntryKey = (String)subEntryKeyObj.getKey();
                            List subEntryFieldKeys = (List)subEntryKeyObj.getValue();
                            JSONArray subEntryRows = entryRow.getJSONArray(subEntryKey);
                            for (int k = 0; k < subEntryRows.size(); ++k) {
                                JSONObject subEntryRow = subEntryRows.getJSONObject(j);
                                for (Object subEntryObj : subEntryFieldKeys) {
                                    JSONObject data = subEntryRow.getJSONObject((String)subEntryObj);
                                    if (data == null || !data.containsKey((Object)KEY_IMPORTPROP)) continue;
                                    String dataType = data.getString(KEY_IMPORTPROP);
                                    if (dataType.equals(KEY_NUMBER) && numberRowMapping.contains(data.get((Object)dataType))) {
                                        return true;
                                    }
                                    if (!dataType.equals("name") || !nameRowMapping.contains(data.get((Object)dataType))) continue;
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        if (billType != null) {
            String billNoKey = billType.getBillNo();
            String billNameKey = billType.getName();
            if (StringUtils.isNotBlank((CharSequence)billNoKey)) {
                String billno = billdata.getString(billNoKey);
                numberRowMapping.add(billno);
            }
            if (StringUtils.isNotBlank((CharSequence)billNameKey)) {
                String billname = billdata.getString(billNameKey);
                nameRowMapping.add(billname);
            }
        }
        return false;
    }

    private void resolveExcel() {
        IImportServicePlugin oldPlugin;
        IImportPlugin p;
        boolean complete = false;
        Iterator<IImportPlugin> iterator = this.conf.getImportPlugins().iterator();
        while (iterator.hasNext() && !(complete = (p = iterator.next()) instanceof IImportServicePlugin ? (oldPlugin = (IImportServicePlugin)p).resolve(new ArrayList<String>(this.conf.getUrlLoggers().keySet()), (data, option) -> {
            String errorMsg = oldPlugin.beforeImportData(data, option);
            if (StringUtils.isBlank((CharSequence)errorMsg)) {
                errorMsg = oldPlugin.importData(data, option);
            }
            return errorMsg;
        }) == null : p.resolve(this.conf.getUrlLoggers(), (data, option) -> {
            List pkIds;
            ArrayList logs = new ArrayList();
            if (p.beforeImportData(data, option, logs) && !(pkIds = p.importData(data, option, logs)).isEmpty()) {
                p.afterImportData(pkIds, logs);
            }
            return logs;
        }))) {
        }
        if (!complete) {
            this.resolve(this.conf.getUrlLoggers());
        }
    }

    public void resolve(Map<String, ImportLogger> urls) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        for (Map.Entry<String, ImportLogger> url : urls.entrySet()) {
            String path = url.getKey();
            log.debug(this.conf.getPageId() + "----\u5bfc\u5165\u51c6\u5907\u4e0b\u8f7d\u6587\u4ef6----" + path);
            try {
                InputStream in = FileImportExtensionFactory.getFileImportExtension().decode(path, service.getInputStream(path));
                Throwable throwable = null;
                try {
                    new ExcelReader().read(in, new ImportSheetHandler(this.conf, path, this.conf.getDataQueues().get(path)));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Throwable e) {
                log.error(e);
                if (SystemParamServiceHelper.isShowStackTrace()) {
                    url.getValue().log(Integer.valueOf(0), e);
                } else {
                    Throwable cause = e.getCause();
                    String importErrMsg = cause instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"ImportDataTask_1", (String)BOS_IMPORT, (Object[])new Object[0]);
                    url.getValue().log(Integer.valueOf(0), importErrMsg);
                }
                this.conf.getDataQueues().get(path).add(new ImportBillData(new JSONObject(), 0, 0));
                this.conf.setComplete(url.getKey());
            }
        }
    }

    private boolean fireBeforeImportEvent(JSONObject data, List<ImportLogger.ImportLog> logs) {
        boolean pluginBreak = false;
        for (IImportPlugin p : this.conf.getImportPlugins()) {
            if (p instanceof IImportServicePlugin) {
                IImportServicePlugin oldPlugin = (IImportServicePlugin)p;
                pluginBreak = StringUtils.isNotBlank((CharSequence)oldPlugin.beforeImportData((Map)data, (Map)this.conf.getOption()));
            } else {
                boolean bl = pluginBreak = !p.beforeImportData((Map)data, (Map)this.conf.getOption(), logs);
            }
            if (!pluginBreak) continue;
            if (!logs.isEmpty()) break;
            logs.add(new ImportLogger.ImportLog(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u63d2\u4ef6%s\u6821\u9a8c\u4e0d\u901a\u8fc7", (String)"ImportDataTask_12", (String)BOS_IMPORT, (Object[])new Object[0]), p.getClass().getName())));
            break;
        }
        return pluginBreak;
    }

    private boolean fireImportEvent(JSONObject data, List<ImportLogger.ImportLog> logs) {
        boolean completeImport = false;
        for (IImportPlugin p : this.conf.getImportPlugins()) {
            if (p instanceof IImportServicePlugin) {
                IImportServicePlugin oldPlugin = (IImportServicePlugin)p;
                completeImport = oldPlugin.importData((Map)data, (Map)this.conf.getOption()) != null;
                continue;
            }
            List pkIds = p.importData((Map)data, (Map)this.conf.getOption(), logs);
            completeImport = !pkIds.isEmpty();
            if (!completeImport) continue;
            p.afterImportData(pkIds, logs);
        }
        return completeImport;
    }

    private void fireAfterImportEvent(List<Object> successIds, List<ImportLogger.ImportLog> logs) {
        try {
            for (IImportPlugin p : this.conf.getImportPlugins()) {
                p.afterImportData(successIds, logs);
            }
        }
        catch (Throwable e) {
            log.error(e);
            logs.add(new ImportLogger.ImportLog(e instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u63d2\u4ef6\u5bfc\u51fa\u540e\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"ImportDataTask_4", (String)BOS_IMPORT, (Object[])new Object[0])));
        }
    }

    private void outputFailedData(List<int[]> delRows, Map.Entry<String, ImportLogger> urlLogger) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        try (InputStream inputStream = service.getInputStream(urlLogger.getKey());){
            log.debug(this.conf.getPageId() + "\u3002\u3002\u3002\u5bfc\u5165\u51c6\u5907\u751f\u6210\u9519\u8bef\u6570\u636e\u6587\u4ef6------" + urlLogger.getKey());
            new ExcelReader().read(inputStream, new ImportFailedSheetHandler(this.conf, urlLogger.getValue(), service));
        }
        catch (Throwable e) {
            log.error(e);
            urlLogger.getValue().log(Integer.valueOf(0), e instanceof KDBizException ? e.getMessage() : ResManager.loadKDString((String)"\u751f\u6210\u9519\u8bef\u6570\u636e\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"ImportDataTask_5", (String)BOS_IMPORT, (Object[])new Object[0]));
        }
    }
}

