/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.impt;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.exception.KDBizException;
import kd.bos.export.util.ImpExpAttachmentUtil;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.AttachmentPanelAp;

public class ImportEntityMapping {
    private static final Log log = LogFactory.getLog(ImportEntityMapping.class);
    private DynamicObjectType entityType;
    private final Map<String, ColInfo> cols = new HashMap<String, ColInfo>();
    private final Map<String, ImportEntityMapping> entries = new HashMap<String, ImportEntityMapping>();
    private static boolean isNewFormat;
    private static Boolean splitSubEntries;
    private static final String NUMBER = "number";
    private static final String ROWNUM = "rowNum";
    private static final String IMPORTPROP = "importprop";
    private boolean isAttachmentPanel;
    private final Map<Integer, Map<String, FlexProperty>> flexProperties = new HashMap<Integer, Map<String, FlexProperty>>();

    public Map<String, ColInfo> getCols() {
        return this.cols;
    }

    public Map<String, ImportEntityMapping> getEntries() {
        return this.entries;
    }

    @Deprecated
    public static ImportEntityMapping create(DynamicObjectType entityType, Map<Integer, String> nameRow) {
        isNewFormat = false;
        Map<String, ColInfo> names = ImportEntityMapping.getEntityPropertyNames(entityType, nameRow);
        return ImportEntityMapping.createMapping(entityType, names, nameRow, new HashMap<String, Object>(0));
    }

    private static ImportEntityMapping createMapping(DynamicObjectType entityType, Map<String, ColInfo> names, Map<Integer, String> nameRow, Map<String, Object> option) {
        ImportEntityMapping mapping = new ImportEntityMapping();
        mapping.entityType = entityType;
        for (IDataEntityProperty prop : entityType.getProperties()) {
            String propName = prop.getName();
            if (prop instanceof EntryProp) {
                ImportEntityMapping entry = ImportEntityMapping.createMapping(((EntryProp)prop).getDynamicCollectionItemPropertyType(), names, nameRow, option);
                if (entry.cols.isEmpty()) continue;
                mapping.entries.put(propName, entry);
                continue;
            }
            boolean isEntryId = entityType instanceof EntryType && ("id".equalsIgnoreCase(propName) || "pid".equalsIgnoreCase(propName));
            ColInfo colInfo = names.get(isEntryId ? entityType.getName() + "_" + propName : propName);
            if (colInfo == null) continue;
            if (prop instanceof FlexProp) {
                String displayName = nameRow.get(colInfo.getIndex()).split(" # ")[0].replace("*", "");
                colInfo.getFlexColIndex().put(colInfo.getIndex(), new String[]{colInfo.getBasedataProp(), displayName});
            } else if (prop instanceof IBasedataField) {
                String imptPropName = ImportEntityMapping.convertBasePropName(prop, colInfo.getBasedataProp());
                colInfo.setBasedataProp(imptPropName);
                for (String[] colsplit : colInfo.getFlexColIndex().values()) {
                    if (colsplit == null || colsplit.length < 2) continue;
                    colsplit[0] = ImportEntityMapping.convertBasePropName(prop, colsplit[0]);
                }
            }
            colInfo.setProperty(prop);
            mapping.cols.put(propName, colInfo);
        }
        return mapping;
    }

    private static String convertBasePropName(IDataEntityProperty prop, String basedataProp) {
        if (((IBasedataField)prop).getComplexType().getProperties().get((Object)basedataProp) != null) {
            return basedataProp;
        }
        String propName = basedataProp;
        BasedataEntityType refPropType = (BasedataEntityType)((IBasedataField)prop).getComplexType();
        if ("name".equals(propName)) {
            propName = refPropType.getNameProperty();
        } else if (NUMBER.equals(propName)) {
            propName = refPropType.getNumberProperty();
        }
        return propName;
    }

    private static Map<String, ColInfo> getEntityPropertyNames(DynamicObjectType entityType, Map<Integer, String> nameRow) {
        HashMap<String, ColInfo> names = new HashMap<String, ColInfo>();
        for (Map.Entry<Integer, String> entry : nameRow.entrySet()) {
            Integer i = entry.getKey();
            String fullName = entry.getValue();
            if (!StringUtils.isNotBlank((CharSequence)fullName) || !fullName.contains(" # ")) continue;
            String[] tempName = fullName.split(" # ");
            String[] tempNameSplit = tempName[1].split("\\.");
            String propertyDisplayName = tempName[0].replace("*", "");
            String propertyName = tempNameSplit[0];
            String endFix = tempNameSplit.length > 1 ? tempNameSplit[1] : "";
            ColInfo colInfo = (ColInfo)names.get(propertyName);
            if (colInfo != null) {
                Map<Integer, String[]> idx = colInfo.getFlexColIndex();
                idx.put(i, new String[]{endFix, propertyDisplayName});
                continue;
            }
            names.put(propertyName, new ColInfo(i, StringUtils.isNotBlank((CharSequence)propertyDisplayName) ? propertyDisplayName : propertyName, fullName.startsWith("*"), endFix));
        }
        return names;
    }

    public static ImportEntityMapping create(DynamicObjectType entityType, Map<Integer, String> nameRow, Map<Integer, String> titleRow) {
        return ImportEntityMapping.create(entityType, nameRow, titleRow, new HashMap<String, Object>(0));
    }

    public static ImportEntityMapping create(DynamicObjectType entityType, Map<Integer, String> nameRow, Map<Integer, String> titleRow, Map<String, Object> option) {
        isNewFormat = true;
        splitSubEntries = Boolean.TRUE.equals(option.get("SplitSubEntries"));
        Map<String, ColInfo> names = ImportEntityMapping.getEntityPropertyNames(nameRow, titleRow);
        ImportEntityMapping mapping = ImportEntityMapping.createMapping(entityType, names, option);
        List attachmentPanelAps = ImpExpAttachmentUtil.getAttachmentPanelAps((String)entityType.getName());
        for (AttachmentPanelAp attachmentPanelAp : attachmentPanelAps) {
            ColInfo colInfo = names.get(attachmentPanelAp.getKey());
            if (colInfo == null) continue;
            ImportEntityMapping attachmentPanelMapping = new ImportEntityMapping();
            attachmentPanelMapping.setAttachmentPanel(true);
            attachmentPanelMapping.cols.put(attachmentPanelAp.getKey(), colInfo);
            mapping.entries.put(attachmentPanelAp.getKey(), attachmentPanelMapping);
        }
        return mapping;
    }

    private static ImportEntityMapping createMapping(DynamicObjectType entityType, Map<String, ColInfo> names, Map<String, Object> option) {
        ImportEntityMapping mapping = new ImportEntityMapping();
        mapping.entityType = entityType;
        boolean forMultiLang = Boolean.TRUE.equals(option.get("ForUpdateMultiLangFields"));
        String keyfields = (String)option.get("KeyFields");
        HashSet<String> keyFieldSet = StringUtils.isNotBlank((CharSequence)keyfields) ? new HashSet<String>(Arrays.asList(keyfields.split(","))) : new HashSet();
        for (IDataEntityProperty prop : entityType.getProperties()) {
            boolean isEntryId;
            ColInfo colInfo;
            String propName = prop.getName();
            if (prop instanceof EntryProp) {
                ImportEntityMapping entry = ImportEntityMapping.createMapping(((EntryProp)prop).getDynamicCollectionItemPropertyType(), names, option);
                if (entry.cols.isEmpty()) continue;
                mapping.entries.put(propName, entry);
                continue;
            }
            if (forMultiLang && !(prop instanceof MuliLangTextProp) && !keyFieldSet.contains(propName) && !"id".equals(propName) && !"pid".equals(propName) || (colInfo = names.get((isEntryId = entityType instanceof EntryType && ("id".equalsIgnoreCase(propName) || "pid".equalsIgnoreCase(propName))) ? entityType.getName() + "_" + propName : propName)) == null) continue;
            if (prop instanceof FlexProp) {
                String displayName = colInfo.getDisplayName();
                colInfo.getFlexColIndex().put(colInfo.getIndex(), new String[]{colInfo.getBasedataProp(), displayName});
            }
            colInfo.setProperty(prop);
            mapping.cols.put(propName, colInfo);
        }
        return mapping;
    }

    private static Map<String, ColInfo> getEntityPropertyNames(Map<Integer, String> nameRow, Map<Integer, String> titleRow) {
        HashMap<String, ColInfo> names = new HashMap<String, ColInfo>();
        for (Map.Entry<Integer, String> entry : nameRow.entrySet()) {
            Integer i = entry.getKey();
            String fullName = entry.getValue();
            String fullTitle = titleRow.get(i);
            if (!StringUtils.isNotBlank((CharSequence)fullName)) continue;
            String[] tempNameSplit = fullName.split("\\.");
            String propertyDisplayName = StringUtils.isNotBlank((CharSequence)fullTitle) ? fullTitle.replace("*", "") : fullName;
            String propertyName = tempNameSplit[0];
            String endFix = tempNameSplit.length > 1 ? tempNameSplit[1] : "";
            ColInfo colInfo = (ColInfo)names.get(propertyName);
            if (colInfo != null) {
                Map<Integer, String[]> idx = colInfo.getFlexColIndex();
                idx.put(i, new String[]{endFix, propertyDisplayName});
                continue;
            }
            names.put(propertyName, new ColInfo(i, StringUtils.isNotBlank((CharSequence)propertyDisplayName) ? propertyDisplayName : propertyName, fullTitle != null && fullTitle.startsWith("*"), endFix));
        }
        return names;
    }

    @Deprecated
    public List<String> push(Map<Integer, String> row, JSONObject data) {
        return this.push(row, data, -1);
    }

    @Deprecated
    public List<String> push(SheetHandler.ParsedRow curRow, JSONObject data) {
        return this.push(curRow.getData(), data, curRow.getRowNum());
    }

    @Deprecated
    private List<String> push(Map<Integer, String> row, JSONObject data, int rowNum) {
        ArrayList<String> logs = new ArrayList<String>(16);
        try {
            boolean sameOne = this.isEntityEmpty(row);
            if (!sameOne) {
                data.put(ROWNUM, (Object)rowNum);
                this.pushData(row, data);
            }
            for (Map.Entry<String, ImportEntityMapping> entry : this.entries.entrySet()) {
                JSONObject entryRow;
                boolean sameEntry;
                String entryKey = entry.getKey();
                JSONArray entryRows = this.getEntryRows(data, entryKey);
                ImportEntityMapping entryMapping = entry.getValue();
                boolean bl = sameEntry = sameOne && entryMapping.isEntityEmpty(row);
                if (!sameEntry) {
                    entryRow = new JSONObject();
                    entryRow.put(ROWNUM, (Object)rowNum);
                    boolean entryRowEmpty = entryMapping.pushData(row, entryRow);
                    if (!entryRowEmpty) {
                        entryRows.add((Object)entryRow);
                    }
                }
                if (entryRows.size() <= 0) continue;
                entryRow = entryRows.getJSONObject(entryRows.size() - 1);
                for (Map.Entry<String, ImportEntityMapping> subentry : entryMapping.entries.entrySet()) {
                    String subEntryKey = subentry.getKey();
                    JSONArray subEntryRows = this.getEntryRows(entryRow, subEntryKey);
                    ImportEntityMapping subEntryMapping = subentry.getValue();
                    JSONObject subRow = new JSONObject();
                    subRow.put(ROWNUM, (Object)rowNum);
                    boolean subEntryRowEmpty = subEntryMapping.pushData(row, subRow);
                    if (subEntryRowEmpty) continue;
                    subEntryRows.add((Object)subRow);
                }
            }
        }
        catch (Throwable e) {
            log.warn(e);
            String errMsg = ResManager.loadKDString((String)"\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"ImportEntityMapping_0", (String)"bos-import", (Object[])new Object[0]);
            logs.add(e instanceof KDBizException ? e.getMessage() : errMsg);
        }
        return logs;
    }

    @Deprecated
    public List<String> push(SheetHandler.ParsedRow prevRow, Map<Integer, String> row, JSONObject data) {
        return this.push(prevRow, row, data, -1);
    }

    public List<String> push(SheetHandler.ParsedRow prevRow, SheetHandler.ParsedRow curRow, JSONObject data) {
        Map<Integer, String> row = curRow.getData();
        int rowNum = curRow.getRowNum();
        return this.push(prevRow, row, data, rowNum);
    }

    private List<String> push(SheetHandler.ParsedRow prevRow, Map<Integer, String> row, JSONObject data, int rowNum) {
        ArrayList<String> logs = new ArrayList<String>(16);
        try {
            boolean isEntryRow = this.isEntryRow(prevRow, row, rowNum);
            if (!isEntryRow) {
                data.put(ROWNUM, (Object)rowNum);
                this.pushData(row, data);
            }
            for (Map.Entry<String, ImportEntityMapping> entry : this.entries.entrySet()) {
                JSONObject entryRow;
                boolean sameEntry;
                String entryKey = entry.getKey();
                JSONArray entryRows = this.getEntryRows(data, entryKey);
                ImportEntityMapping entryMapping = entry.getValue();
                boolean bl = sameEntry = isEntryRow && entryMapping.isEntryRow(prevRow, row, rowNum);
                if (!sameEntry) {
                    entryRow = new JSONObject();
                    entryRow.put(ROWNUM, (Object)rowNum);
                    boolean entryRowEmpty = entryMapping.pushData(row, entryRow);
                    if (!entryRowEmpty) {
                        entryRows.add((Object)entryRow);
                    }
                }
                if (entryRows.size() <= 0) continue;
                entryRow = entryRows.getJSONObject(entryRows.size() - 1);
                for (Map.Entry<String, ImportEntityMapping> subentry : entryMapping.entries.entrySet()) {
                    String subEntryKey = subentry.getKey();
                    JSONArray subEntryRows = this.getEntryRows(entryRow, subEntryKey);
                    ImportEntityMapping subEntryMapping = subentry.getValue();
                    JSONObject subRow = new JSONObject();
                    subRow.put(ROWNUM, (Object)rowNum);
                    boolean subEntryRowEmpty = subEntryMapping.pushData(row, subRow);
                    if (subEntryRowEmpty) continue;
                    subEntryRows.add((Object)subRow);
                }
            }
        }
        catch (Throwable e) {
            log.warn(e);
            String errMsg = ResManager.loadKDString((String)"\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"ImportEntityMapping_0", (String)"bos-import", (Object[])new Object[0]);
            logs.add(e instanceof KDBizException ? e.getMessage() : errMsg);
        }
        return logs;
    }

    private JSONArray getEntryRows(JSONObject data, String key) {
        JSONArray entry;
        if (data.containsKey((Object)key)) {
            entry = data.getJSONArray(key);
        } else {
            entry = new JSONArray();
            data.put(key, (Object)entry);
        }
        return entry;
    }

    /*
     * WARNING - void declaration
     */
    private boolean pushData(Map<Integer, String> row, JSONObject data) throws KDBizException {
        boolean rowEmpty = true;
        for (Map.Entry<String, ColInfo> col : this.cols.entrySet()) {
            String v;
            ColInfo colInfo = col.getValue();
            IDataEntityProperty prop = colInfo.getProperty();
            boolean isFlexProp = prop instanceof FlexProp;
            boolean isMultiLang = prop instanceof MuliLangTextProp;
            if (!isFlexProp && !isMultiLang && !row.containsKey(colInfo.getIndex())) continue;
            boolean existVal = row.containsKey(colInfo.getIndex());
            JSONObject val = null;
            JSONObject flexVal = null;
            if (isFlexProp) {
                flexVal = new HashMap();
                Map<Integer, String[]> colIndex = colInfo.getFlexColIndex();
                if (isNewFormat) {
                    ArrayList list = new ArrayList(colIndex.size());
                    colIndex.keySet().forEach(i -> list.add(i));
                    Collections.sort(list);
                    Map<String, FlexProperty> map = this.flexProperties.get(((FlexProp)prop).getFlexTypeId());
                    if (map == null) {
                        HashMap tempFlexPropertyMap = new HashMap();
                        FlexEntityMetaUtils.getFlexProperties((int)((FlexProp)prop).getFlexTypeId()).forEach(item -> {
                            if (StringUtils.isNotBlank((Object)item.getName())) {
                                tempFlexPropertyMap.put(item.getName().getLocaleValue(), (FlexProperty)item);
                            }
                        });
                        this.flexProperties.put(((FlexProp)prop).getFlexTypeId(), tempFlexPropertyMap);
                        HashMap hashMap = tempFlexPropertyMap;
                    }
                    for (int i2 = 0; i2 < list.size(); i2 += 3) {
                        void var15_20;
                        int index = (Integer)list.get(i2);
                        String v2 = row.get(index);
                        if (!StringUtils.isNotBlank((Object)v2)) continue;
                        if (var15_20.containsKey(v2)) {
                            FlexProperty fp = (FlexProperty)var15_20.get(v2);
                            String flexColName = v2;
                            String valueType = fp.getValueType();
                            if ("1".equals(valueType) || "2".equals(valueType)) {
                                HashMap<String, String> item2 = (HashMap<String, String>)flexVal.get(flexColName);
                                if (item2 == null) {
                                    item2 = new HashMap<String, String>();
                                    flexVal.put(flexColName, item2);
                                }
                                if (StringUtils.isNotBlank((CharSequence)row.get(index + 1))) {
                                    item2.put(IMPORTPROP, NUMBER);
                                    item2.put(NUMBER, row.get(index + 1));
                                }
                                if (!StringUtils.isNotBlank((CharSequence)row.get(index + 2))) continue;
                                if (StringUtils.isBlank(item2.get(IMPORTPROP))) {
                                    item2.put(IMPORTPROP, "name");
                                }
                                item2.put("name", row.get(index + 2));
                                continue;
                            }
                            flexVal.put(flexColName, row.get(index + 2));
                            continue;
                        }
                        log.warn(String.format("----\u8b66\u544a\uff1a\u5bfc\u5165\u7684\u5f39\u6027\u57df\u7ef4\u5ea6\u5df2\u4e22\u5931\u3002\u7ef4\u5ea6\u4e0d\u5b58\u5728\u6216\u8005\u5f55\u5165\u7684\u7ef4\u5ea6\u201c%s\u201d\u4e0e\u5f39\u6027\u57df\u5b57\u6bb5\u7684\u5f39\u6027\u57df\u7c7b\u578b\u4e0d\u4e00\u81f4\uff1a%s", v2, var15_20.keySet()));
                    }
                } else {
                    for (Map.Entry entry : colIndex.entrySet()) {
                        if (!row.containsKey(entry.getKey())) continue;
                        String flexColName = ((String[])entry.getValue())[1].split("\\.")[1];
                        String importprop = ((String[])entry.getValue())[0];
                        String v2 = row.get(entry.getKey());
                        if (StringUtils.isNotBlank((CharSequence)importprop)) {
                            HashMap<String, String> item3 = (HashMap<String, String>)flexVal.get(flexColName);
                            if (item3 == null) {
                                item3 = new HashMap<String, String>();
                                item3.put(IMPORTPROP, importprop);
                                flexVal.put(flexColName, item3);
                            }
                            if (!StringUtils.isNotBlank((Object)v2)) continue;
                            item3.put(((String[])entry.getValue())[0], v2);
                            continue;
                        }
                        flexVal.put(flexColName, v2);
                    }
                }
                if (!flexVal.isEmpty()) {
                    val = flexVal;
                }
            } else if (isMultiLang) {
                flexVal = new HashMap();
                v = row.get(colInfo.index);
                if (row.containsKey(colInfo.index)) {
                    flexVal.put(StringUtils.isNotBlank((CharSequence)colInfo.basedataProp) ? colInfo.basedataProp : RequestContext.get().getLang().name(), v);
                }
                Map<Integer, String[]> colIndex = colInfo.getFlexColIndex();
                for (Map.Entry<Integer, String[]> entry2 : colIndex.entrySet()) {
                    v = row.get(entry2.getKey());
                    if (!row.containsKey(entry2.getKey())) continue;
                    flexVal.put(entry2.getValue()[0], v);
                }
                if ((colInfo.isMustInput() || flexVal.isEmpty()) && !flexVal.containsKey(RequestContext.getOrCreate().getLang().name())) continue;
                val = flexVal;
            } else if (prop instanceof BasedataProp || !(prop instanceof AttachmentProp) && prop instanceof MulBasedataProp || prop instanceof RefBillProp) {
                v = row.get(colInfo.getIndex());
                if (row.containsKey(colInfo.getIndex())) {
                    boolean nullVal = true;
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put(IMPORTPROP, (Object)colInfo.getBasedataProp());
                    jSONObject.put(colInfo.getBasedataProp(), (Object)v);
                    if (StringUtils.isNotBlank((Object)v)) {
                        nullVal = false;
                    }
                    for (Map.Entry<Integer, String[]> splitCol : colInfo.getFlexColIndex().entrySet()) {
                        v = row.get(splitCol.getKey());
                        if (row.containsKey(splitCol.getKey())) {
                            jSONObject.put(splitCol.getValue()[0], (Object)v);
                        }
                        if (!nullVal || !StringUtils.isNotBlank((Object)v)) continue;
                        nullVal = false;
                    }
                    val = nullVal ? null : jSONObject;
                }
            } else {
                val = row.get(colInfo.getIndex());
            }
            data.put(col.getKey(), (Object)val);
            if (!StringUtils.isNotBlank((Object)val)) continue;
            rowEmpty = false;
        }
        return rowEmpty;
    }

    @Deprecated
    public boolean isEntityEmpty(Map<Integer, String> row) {
        boolean isEmpty = true;
        for (Map.Entry<String, ColInfo> entry : this.cols.entrySet()) {
            if (!StringUtils.isNotBlank((CharSequence)row.get(entry.getValue().getIndex()))) continue;
            isEmpty = false;
            break;
        }
        return isEmpty;
    }

    private boolean isEntryRow(SheetHandler.ParsedRow prevRow, Map<Integer, String> currRowData, int currRowNum) {
        if (prevRow == null) {
            return false;
        }
        if (!this.isNearRow(prevRow.getRowNum(), currRowNum)) {
            return false;
        }
        return this.isSameOne(prevRow, currRowData);
    }

    public boolean isEntryRow(SheetHandler.ParsedRow prevRow, SheetHandler.ParsedRow currRow) {
        if (prevRow == null || currRow == null) {
            return false;
        }
        if (!this.isNearRow(prevRow.getRowNum(), currRow.getRowNum())) {
            return false;
        }
        return this.isSameOne(prevRow, currRow.getData());
    }

    public boolean isSameOne(SheetHandler.ParsedRow prevRow, Map<Integer, String> row) {
        if (prevRow == null || this.entries.isEmpty()) {
            return false;
        }
        boolean entityEmpty = true;
        boolean sameOne = true;
        for (Map.Entry<String, ColInfo> entry : this.cols.entrySet()) {
            Integer i = entry.getValue().getIndex();
            if (entityEmpty && StringUtils.isNotBlank((CharSequence)row.get(i))) {
                entityEmpty = false;
            }
            if (sameOne && !this.equalsString(prevRow.get(i), row.get(i))) {
                sameOne = false;
                continue;
            }
            if (entityEmpty || sameOne) continue;
            break;
        }
        if (splitSubEntries.booleanValue()) {
            return entityEmpty;
        }
        return entityEmpty || sameOne && this.hasEntryData(row);
    }

    private boolean isNearRow(int preRowNum, int currRowNum) {
        return currRowNum - preRowNum == 1;
    }

    private boolean hasEntryData(Map<Integer, String> data) {
        for (Map.Entry<String, ImportEntityMapping> entry : this.entries.entrySet()) {
            String entryKey = entry.getKey();
            ImportEntityMapping entryMapping = entry.getValue();
            if (entryMapping.isEntityEmpty(data)) continue;
            return true;
        }
        return false;
    }

    private boolean equalsString(String v1, String v2) {
        if (v1 == null || (v1 = v1.trim()).isEmpty()) {
            return v2 == null || v2.trim().isEmpty();
        }
        return v2 != null && v1.equals(v2.trim());
    }

    public DynamicObjectType getEntityType() {
        return this.entityType;
    }

    public boolean isAttachmentPanel() {
        return this.isAttachmentPanel;
    }

    public void setAttachmentPanel(boolean attachmentPanel) {
        this.isAttachmentPanel = attachmentPanel;
    }

    static {
        splitSubEntries = Boolean.FALSE;
    }

    public static class ColInfo {
        private int index;
        private String displayName;
        private boolean mustInput;
        private String basedataProp;
        private IDataEntityProperty property;
        private Map<Integer, String[]> flexColIndex = new HashMap<Integer, String[]>();

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public boolean isMustInput() {
            return this.mustInput;
        }

        public void setMustInput(boolean mustInput) {
            this.mustInput = mustInput;
        }

        public String getBasedataProp() {
            return this.basedataProp;
        }

        public void setBasedataProp(String basedataProp) {
            this.basedataProp = basedataProp;
        }

        @Deprecated
        public ColInfo(int index, boolean mustInput, String basedataProp) {
            this.index = index;
            this.mustInput = mustInput;
            this.basedataProp = basedataProp;
        }

        public ColInfo(int index, String displayName, boolean mustInput, String basedataProp) {
            this.index = index;
            this.displayName = displayName;
            this.mustInput = mustInput;
            this.basedataProp = basedataProp;
        }

        public IDataEntityProperty getProperty() {
            return this.property;
        }

        public void setProperty(IDataEntityProperty property) {
            this.property = property;
        }

        public Map<Integer, String[]> getFlexColIndex() {
            return this.flexColIndex;
        }

        public void setFlexColIndex(Map<Integer, String[]> flexColIndex) {
            this.flexColIndex = flexColIndex;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }
    }
}

