/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.impt;

import com.alibaba.fastjson.JSONObject;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.attachment.util.FileSecurityUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.form.plugin.impt.ImportConfig;
import kd.bos.form.plugin.impt.ImportHelper;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.attachment.FileSource;
import kd.bos.svc.util.FileServerUtil;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.xml.sax.SAXException;

public class ImportFailedSheetHandler
extends SheetHandler {
    private static final Log log = LogFactory.getLog(ImportFailedSheetHandler.class);
    private SXSSFWorkbook book;
    private final Map<String, CellStyle> styles = new HashMap<String, CellStyle>();
    private ImportLogger importLogger;
    private final FileService service;
    private ImportConfig conf;
    private int cursorRowNum;
    private SheetHandler.ParsedRow currentRow;
    private final Map<String, SXSSFSheet> sheets = new HashMap<String, SXSSFSheet>();
    private boolean isNewFormat = true;
    private boolean hasErrorCol;
    private final int ERR_ROW_COUNT = 5000;
    private static final String BOS_IMPORT = "bos-import";
    private static final String COLOR = "color";
    private boolean isDropdownItemsSheet = false;
    private final Map<String, SXSSFRow> nameRows = new HashMap<String, SXSSFRow>();

    public SheetHandler.ParsedRow getCurrentRow() {
        return this.currentRow;
    }

    public void setCurrentRow(SheetHandler.ParsedRow currentRow) {
        this.currentRow = currentRow;
    }

    ImportFailedSheetHandler(ImportConfig conf, ImportLogger importLogger, FileService service) {
        this.setInterrupt(false);
        this.conf = conf;
        this.importLogger = importLogger;
        this.service = service;
        importLogger.getDelRows().sort((o1, o2) -> o1[0] - o2[0]);
    }

    @Override
    public void handleRow(SheetHandler.ParsedRow row) {
        SXSSFSheet sheet = this.sheets.get(row.getSheetName());
        if (sheet == null) {
            if (this.book == null) {
                this.book = new SXSSFWorkbook(1000);
                this.book.setCompressTempFiles(true);
            }
            sheet = this.book.createSheet(row.getSheetName());
            if (this.sheets.size() == 0) {
                sheet.setColumnWidth(0, 10000);
            }
            this.isDropdownItemsSheet = "dropdown_items_sheet".equals(row.getSheetName());
            this.sheets.put(row.getSheetName(), sheet);
        }
        this.currentRow = row;
        int currRowNum = this.currentRow.getRowNum();
        if (this.isDropdownItemsSheet) {
            this.handleDropdownSheet(sheet, currRowNum);
            return;
        }
        if (this.sheets.size() > 1) {
            this.handleSheet(sheet, currRowNum);
            return;
        }
        this.handleWorkSheet(row, sheet, currRowNum);
    }

    private void handleWorkSheet(SheetHandler.ParsedRow row, SXSSFSheet sheet, int currRowNum) {
        JSONObject styleObj;
        SXSSFCell cell;
        int titleRowIndex;
        String entityName;
        if (currRowNum == 0 && (StringUtils.isBlank((CharSequence)(entityName = this.currentRow.get(0))) || !entityName.contains(" # "))) {
            this.hasErrorCol = true;
        }
        if (currRowNum == 2) {
            this.isNewFormat = !row.getData().get(this.hasErrorCol ? 1 : 0).contains(" # ");
        }
        int n = titleRowIndex = this.isNewFormat ? 3 : 2;
        if (currRowNum == titleRowIndex) {
            SXSSFRow nameRow = this.getRow(sheet, this.cursorRowNum);
            this.nameRows.put(row.getSheetName(), nameRow);
            cell = nameRow.createCell(0);
            cell.setCellValue(ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0", (String)"ImportFailedSheetHandler_0", (String)BOS_IMPORT, (Object[])new Object[0]));
        } else if (currRowNum > titleRowIndex) {
            if (this.isRowSucceed(this.importLogger.getDelRows(), currRowNum)) {
                return;
            }
            List logs = (List)this.importLogger.getLogCache().get(currRowNum);
            if (logs != null && !logs.isEmpty()) {
                String mergeLogStr;
                if (this.cursorRowNum - titleRowIndex <= 5000) {
                    StringBuilder sb = new StringBuilder();
                    for (ImportLogger.ImportLog log : logs) {
                        sb.append(log).append("\n\t");
                        if (sb.length() <= 4000) continue;
                        sb.replace(3997, 4000, "...").setLength(4000);
                        break;
                    }
                    mergeLogStr = sb.toString();
                } else {
                    mergeLogStr = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u884c\u6570\u636e", (String)"ImportFailedSheetHandler_1", (String)BOS_IMPORT, (Object[])new Object[0]);
                }
                cell = this.getRow(sheet, this.cursorRowNum).createCell(0);
                styleObj = new JSONObject();
                styleObj.put(COLOR, (Object)IndexedColors.RED.getIndex());
                cell.setCellStyle(this.getCellStyle(styleObj));
                cell.setCellValue(mergeLogStr);
            }
        }
        for (Map.Entry<Integer, String> entry : this.currentRow.getData().entrySet()) {
            String fmt;
            CellStyle style;
            if (this.hasErrorCol && entry.getKey() == 0) continue;
            styleObj = this.currentRow.getStyles().get(entry.getKey());
            int cellIndex = this.countIndex(entry.getKey());
            cell = this.getRow(sheet, this.cursorRowNum).createCell(cellIndex);
            if (currRowNum == titleRowIndex) {
                styleObj.put("bg", (Object)IndexedColors.GREY_25_PERCENT.getIndex());
                if (entry.getValue().startsWith("*")) {
                    styleObj.put(COLOR, (Object)IndexedColors.RED.getIndex());
                }
                Map<String, Object> colProperty = this.getColHolder().getColProperty().get(cellIndex);
                double colWidth = 0.0;
                if (colProperty != null && NumberUtils.isParsable((String)String.valueOf(colProperty.get("colWidth")))) {
                    colWidth = Double.parseDouble(String.valueOf(colProperty.get("colWidth")));
                }
                sheet.setColumnWidth(cellIndex, ImportHelper.calcColumnWidth(entry.getValue(), 0, colWidth));
            }
            if ((style = this.getCellStyle(styleObj)) != null) {
                cell.setCellStyle(style);
            }
            if (StringUtils.isNotBlank((CharSequence)(fmt = styleObj.getString("fmt")))) {
                try {
                    cell.setCellValue(new BigDecimal(entry.getValue()).doubleValue());
                }
                catch (Throwable e) {
                    cell.setCellValue(entry.getValue());
                }
                continue;
            }
            cell.setCellValue(entry.getValue());
        }
        ++this.cursorRowNum;
    }

    private void handleSheet(SXSSFSheet sheet, int currRowNum) {
        this.hasErrorCol = true;
        for (Map.Entry<Integer, String> entry : this.currentRow.getData().entrySet()) {
            String fmt;
            JSONObject styleObj = this.currentRow.getStyles().get(entry.getKey());
            SXSSFCell cell = this.getRow(sheet, currRowNum).createCell(entry.getKey().intValue());
            CellStyle style = this.getCellStyle(styleObj);
            if (style != null) {
                cell.setCellStyle(style);
            }
            if (StringUtils.isNotBlank((CharSequence)(fmt = styleObj.getString("fmt")))) {
                try {
                    cell.setCellValue(new BigDecimal(entry.getValue()).doubleValue());
                }
                catch (Throwable e) {
                    cell.setCellValue(entry.getValue());
                }
                continue;
            }
            cell.setCellValue(entry.getValue());
        }
    }

    private void handleDropdownSheet(SXSSFSheet sheet, int currRowNum) {
        for (Map.Entry<Integer, String> entry : this.currentRow.getData().entrySet()) {
            SXSSFCell cell = this.getRow(sheet, currRowNum).createCell(entry.getKey().intValue());
            cell.setCellType(CellType.STRING);
            cell.setCellValue(entry.getValue());
        }
    }

    private int countIndex(int index) {
        if (this.hasErrorCol) {
            return index;
        }
        return ++index;
    }

    private CellStyle getCellStyle(JSONObject style) {
        String fmt = (String)style.getOrDefault((Object)"fmt", (Object)"@");
        String align = style.getString("align");
        Short bg = style.getShort("bg");
        Short color = style.getShort(COLOR);
        String styleStr = String.format("%s_-_%d_-_%d_-_%s", fmt, bg, color, align);
        CellStyle cellStyle = this.styles.get(styleStr);
        if (cellStyle == null) {
            cellStyle = this.book.createCellStyle();
            this.styles.put(styleStr, cellStyle);
            cellStyle.setDataFormat(this.book.createDataFormat().getFormat(fmt));
            if (bg != null) {
                cellStyle.setFillForegroundColor(bg.shortValue());
                cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
            if (color != null) {
                Font font = this.book.createFont();
                font.setColor(color.shortValue());
                cellStyle.setFont(font);
            }
            cellStyle.setAlignment(this.getAlignment(align));
        }
        return cellStyle;
    }

    private HorizontalAlignment getAlignment(String align) {
        try {
            return HorizontalAlignment.valueOf((String)align.toUpperCase());
        }
        catch (Throwable e) {
            return HorizontalAlignment.GENERAL;
        }
    }

    private CellType convertCellType(SheetHandler.XSSFDataType xssfDataType, String fmt) {
        if (xssfDataType != null) {
            switch (xssfDataType) {
                case BOOL: {
                    return CellType.BOOLEAN;
                }
                case ERROR: {
                    return CellType.ERROR;
                }
                case FORMULA: {
                    return CellType.FORMULA;
                }
                case INLINESTR: 
                case SSTINDEX: {
                    if (StringUtils.isNotBlank((CharSequence)fmt)) {
                        return CellType.NUMERIC;
                    }
                    return CellType.STRING;
                }
                case NUMBER: {
                    return CellType.NUMERIC;
                }
            }
        }
        return CellType.BLANK;
    }

    private boolean isRowSucceed(List<int[]> delRows, int currRowNum) {
        for (int[] rs : delRows) {
            if (rs[1] < rs[0]) {
                return currRowNum >= rs[0];
            }
            if (currRowNum > rs[1]) continue;
            return currRowNum >= rs[0];
        }
        return false;
    }

    public SXSSFRow getRow(SXSSFSheet sheet, int r) {
        SXSSFRow row = sheet.getRow(r);
        if (row == null) {
            row = sheet.createRow(r);
        }
        return row;
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        Set<String> sheetNames = this.getSheetNames();
        sheetNames.remove(this.getSheetName());
        if (sheetNames.isEmpty()) {
            File temp = null;
            FileOutputStream fos = null;
            try {
                temp = File.createTempFile(UUID.randomUUID().toString(), "xlsx");
                fos = new FileOutputStream(temp);
                int indexDropdownItemsSheet = this.book.getSheetIndex("dropdown_items_sheet");
                if (indexDropdownItemsSheet >= 0) {
                    this.book.setSheetHidden(indexDropdownItemsSheet, true);
                }
                this.book.write((OutputStream)fos);
                this.book.dispose();
                LocalDate now = LocalDate.now();
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMdd");
                String formattedStr = now.format(formatter);
                String fileName = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25_%1$s_%2$s.xlsx", (String)"ImportFailedSheetHandler_3", (String)BOS_IMPORT, (Object[])new Object[0]), this.conf.getEntityType().getDisplayName(), formattedStr);
                fileName = fileName.replaceAll("[\n`~!@#$%^&*()+=|{}':;',\\[\\]<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c \u3001\uff1f]", "");
                RequestContext ctx = RequestContext.getOrCreate();
                String path = FileNameUtils.getExportFileName((String)ctx.getTenantId(), (String)ctx.getAccountId(), (String)this.conf.getAppId(), (String)(this.conf.getEntityType().getName() + UUID.randomUUID()), (String)fileName);
                String url = this.service.upload((FileItem)FileServerUtil.createFileItem((String)fileName, (String)path, (InputStream)new FileInputStream(temp), (FileSource)FileSource.EXCEL_IMPORT));
                this.importLogger.setErrFile(UrlService.getAttachmentFullUrl((String)url));
            }
            catch (IOException e) {
                try {
                    throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
                }
                catch (Throwable throwable) {
                    FileSecurityUtil.safeClose((Closeable)this.book);
                    FileSecurityUtil.safeClose(fos);
                    FileSecurityUtil.safeDeleteFile((File)temp);
                    this.conf = null;
                    this.sheets.clear();
                    this.book = null;
                    this.importLogger = null;
                    throw throwable;
                }
            }
            FileSecurityUtil.safeClose((Closeable)this.book);
            FileSecurityUtil.safeClose((Closeable)fos);
            FileSecurityUtil.safeDeleteFile((File)temp);
            this.conf = null;
            this.sheets.clear();
            this.book = null;
            this.importLogger = null;
        }
    }

    @Override
    public void handleDataValidation(Set<SheetHandler.CellValidation> cellValidations) {
        for (SheetHandler.CellValidation validation : cellValidations) {
            String[] rangeStrs;
            SXSSFSheet sheet = this.sheets.get(validation.getSheetName());
            DataValidationHelper helper = sheet.getDataValidationHelper();
            String refValidation = validation.getValidation();
            if (refValidation == null || refValidation.endsWith("dropdown_items_sheet!#REF!") || (rangeStrs = validation.getRange().toUpperCase().split(" ")) == null || rangeStrs.length <= 0) continue;
            for (String rg : rangeStrs) {
                List<Integer> ranges = this.splitRange(rg.split(":"));
                int rangeSize = ranges.size();
                CellRangeAddressList addressList = null;
                if (rangeSize == 2) {
                    addressList = new CellRangeAddressList(ranges.get(1) - 1, ranges.get(1) - 1, ranges.get(0).intValue(), ranges.get(0).intValue());
                } else if (rangeSize == 4) {
                    addressList = new CellRangeAddressList(ranges.get(1) - 1, ranges.get(3) - 1, ranges.get(0).intValue(), ranges.get(2).intValue());
                }
                if (addressList == null) continue;
                DataValidationConstraint constraint = helper.createFormulaListConstraint(validation.getValidation());
                DataValidation dataValidation = helper.createValidation(constraint, addressList);
                if (dataValidation instanceof XSSFDataValidation) {
                    dataValidation.setSuppressDropDownArrow(true);
                    dataValidation.setShowErrorBox(true);
                } else {
                    dataValidation.setSuppressDropDownArrow(false);
                }
                sheet.addValidationData(dataValidation);
            }
        }
    }

    @Override
    public void handleSheetComments(Map<String, CommentsTable> comments) {
        int rowNum;
        int n = rowNum = this.isNewFormat ? 3 : 2;
        if (!comments.isEmpty()) {
            for (Map.Entry<String, CommentsTable> entry : comments.entrySet()) {
                String sheetName = entry.getKey();
                SXSSFSheet sheet = this.book.getSheet(sheetName);
                SXSSFRow row = this.nameRows.get(entry.getKey());
                if (row == null) continue;
                SXSSFDrawing p = sheet.createDrawingPatriarch();
                CommentsTable commentsTable = entry.getValue();
                Iterator cellAddresses = commentsTable.getCellAddresses();
                while (cellAddresses.hasNext()) {
                    CellAddress addr = (CellAddress)cellAddresses.next();
                    SXSSFCell cell = row.getCell(this.countIndex(addr.getColumn()));
                    XSSFComment comment = commentsTable.findCellComment(addr);
                    if (comment.getRow() != rowNum) continue;
                    Comment temp = p.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, (int)((short)this.countIndex(comment.getColumn())), rowNum, (short)this.countIndex(comment.getColumn()) + 2, 5));
                    temp.setString((RichTextString)comment.getString());
                    cell.setCellComment(temp);
                }
            }
            comments.clear();
        }
    }

    private List<Integer> splitRange(String[] subRanges) {
        ArrayList<Integer> ranges = new ArrayList<Integer>();
        try {
            for (int i = 0; i < subRanges.length; ++i) {
                char c;
                int k;
                int j = 0;
                int len = subRanges[i].length();
                for (k = 1; k < len && (c = subRanges[i].charAt(k)) >= 'A' && c <= 'Z'; ++k) {
                }
                ranges.add(this.CharsToNumber(subRanges[i].substring(j, k)));
                ranges.add(Integer.parseInt(subRanges[i].substring(k)));
            }
        }
        catch (Throwable e) {
            log.error(e);
        }
        return ranges;
    }

    private int CharsToNumber(String letter) {
        if (letter == null || letter.isEmpty()) {
            return -1;
        }
        String upperLetter = letter.toUpperCase();
        if (!upperLetter.matches("[A-Z]+")) {
            return -1;
        }
        long num = 0L;
        long base = 1L;
        for (int i = upperLetter.length() - 1; i >= 0; --i) {
            char ch = upperLetter.charAt(i);
            if ((num += (long)(ch - 65 + this.countIndex(0)) * (base *= 26L)) <= Integer.MAX_VALUE) continue;
            return -1;
        }
        return (int)num;
    }
}

