/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.impt.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mulimport.background.MulImportProgress;
import kd.bos.mulimport.resolve.context.MulImportContext;
import kd.bos.mulimport.resolve.model.MulEntityImportingInfo;
import kd.bos.mulimport.resolve.model.MulImportConvertData;
import kd.bos.mulimport.result.model.MulEntityImportResult;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class MulImportSaveService {
    private static final Log log = LogFactory.getLog(MulImportSaveService.class);
    private static final String BOS_IMPORT = "bos-import";
    private final String CACHE_KEY_CHOOSE_FIRST_IMPORT = "chooseFirstImport";

    public void manageData(MulImportContext context, int startRow) {
        Set<String> entityNumberSet = context.getEntityNumberSet();
        Map<String, MulEntityImportResult> entityImportResult = context.getEntityImportResult();
        ArrayList<MulEntityImportingInfo> entityProgressInfos = new ArrayList<MulEntityImportingInfo>();
        int index = 0;
        for (String entityNumber : entityNumberSet) {
            OperationResult operationResult;
            LinkedBlockingQueue entityDatas = (LinkedBlockingQueue)context.getEntityData(entityNumber);
            MulEntityImportResult importResult = entityImportResult.get(entityNumber);
            if (CollectionUtils.isEmpty((Collection)entityDatas)) {
                this.addEntityProgressInfo(entityProgressInfos, importResult, entityNumber, index++);
                continue;
            }
            HashMap<DynamicObject, Integer> entityDataMap = new HashMap<DynamicObject, Integer>(8);
            HashMap<Integer, MulImportConvertData> convertDataMap = new HashMap<Integer, MulImportConvertData>(8);
            int size = entityDatas.size();
            for (int i = 0; i < size; ++i) {
                MulImportConvertData data = (MulImportConvertData)entityDatas.poll();
                entityDataMap.put(data.getData(), data.getExcelRow());
                convertDataMap.put(data.getExcelRow(), data);
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("importtype", "new");
            option.setVariableValue("autogeneratebillno", String.valueOf(true));
            option.setVariableValue("ignorewarn", String.valueOf(true));
            option.setVariableValue("batchImport", String.valueOf(true));
            option.setVariableValue("ignoreinteraction", String.valueOf(true));
            option.setVariableValue("importtag_of_datasource", String.valueOf(true));
            option.setVariableValue("updateEntrySummaryEnable", String.valueOf(true));
            Operations ops = EntityMetadataCache.getDataEntityOperations((String)FormMetadataCache.getFormConfig((String)entityNumber).getEntityTypeId());
            String opSave = ops.getSave();
            DynamicObject[] dynamicObjects = entityDataMap.keySet().toArray(new DynamicObject[0]);
            log.error("[\u672c\u6b21\u4fdd\u5b58\uff1a]" + entityDataMap.size() + "\u5f20\u5355\u636e");
            try {
                EntityTraceSpan entityTraceSpan = EntityTracer.create((String)this.getClass().getSimpleName(), (String)"mulImportSave");
                Object object = null;
                try {
                    operationResult = OperationServiceHelper.executeOperate((String)opSave, (String)entityNumber, (DynamicObject[])dynamicObjects, (OperateOption)option);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (entityTraceSpan != null) {
                        if (object != null) {
                            try {
                                entityTraceSpan.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            entityTraceSpan.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
                this.dealSaveFailResult(importResult, startRow, convertDataMap, e.getMessage());
                this.addEntityProgressInfo(entityProgressInfos, importResult, entityNumber, index++);
                continue;
            }
            if (operationResult != null && !operationResult.isSuccess()) {
                List errorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
                for (IOperateInfo errorInfo : errorOrValidateInfo) {
                    OperateErrorInfo operateErrorInfo;
                    int dataEntityIndex;
                    DynamicObject dynamicObject;
                    Integer excelRowIndex;
                    if (!(errorInfo instanceof OperateErrorInfo) || (excelRowIndex = (Integer)entityDataMap.get(dynamicObject = dynamicObjects[dataEntityIndex = (operateErrorInfo = (OperateErrorInfo)errorInfo).getDataEntityIndex()])) == null) continue;
                    importResult.setFailedRow(excelRowIndex);
                    importResult.recodeErrorInfo(excelRowIndex, errorInfo.getMessage());
                    MulImportConvertData convertData = (MulImportConvertData)convertDataMap.get(excelRowIndex);
                    convertData.setSuccess(false);
                }
                entityDataMap.clear();
            }
            this.addEntityProgressInfo(entityProgressInfos, importResult, entityNumber, index++);
        }
        int totalBillNum = this.calculateWholeDataNum(entityImportResult);
        context.feedbackProgress(totalBillNum, entityProgressInfos, context.isFirstImport());
        MulImportProgress importProgress = context.getImportProgress();
        if (importProgress != null) {
            int finishBillNum = this.calculateFinishBillNum(entityProgressInfos);
            boolean chooseFirstImport = Boolean.parseBoolean(context.getView().getPageCache().get("chooseFirstImport"));
            context.getImportProgress().feedbackProgress(finishBillNum, totalBillNum, context.isFirstImport(), chooseFirstImport);
        }
    }

    private void dealSaveFailResult(MulEntityImportResult importResult, int startRow, Map<Integer, MulImportConvertData> convertDataMap, String message) {
        String showMessage = StringUtils.isBlank((CharSequence)message) || StringUtils.equals((CharSequence)"null", (CharSequence)message) ? ResManager.loadKDString((String)"\u4fdd\u5b58\u670d\u52a1\u51fa\u9519\uff0c\u672c\u6279\u6570\u636e\u4fdd\u5b58\u5931\u8d25\u3002", (String)"MulImportStepPlugin_41", (String)BOS_IMPORT, (Object[])new Object[0]) : String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u670d\u52a1\u51fa\u9519\uff0c\u672c\u6279\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s", (String)"MulImportStepPlugin_36", (String)BOS_IMPORT, (Object[])new Object[0]), message);
        importResult.recodeErrorInfo(startRow, showMessage);
        for (Map.Entry<Integer, MulImportConvertData> entry : convertDataMap.entrySet()) {
            MulImportConvertData convertData = entry.getValue();
            convertData.setSuccess(false);
            int excelRow = convertData.getExcelRow();
            importResult.setFailedRow(excelRow);
            if (excelRow <= startRow) continue;
            importResult.recodeErrorInfo(excelRow, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u670d\u52a1\u51fa\u9519\uff0c\u672c\u6279\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u5148\u89e3\u51b3\u62a5\u9519\u3002", (String)"MulImportStepPlugin_37", (String)BOS_IMPORT, (Object[])new Object[0]), message));
        }
    }

    private void addEntityProgressInfo(List<MulEntityImportingInfo> entityProgressInfos, MulEntityImportResult importResult, String entityNumber, int index) {
        int total = importResult.getTotalRowsIndex().size();
        int covertDataSize = importResult.getCovertRows().size();
        int failed = importResult.getFailed();
        int success = covertDataSize - failed;
        entityProgressInfos.add(new MulEntityImportingInfo(covertDataSize, entityNumber, importResult.getEntityName(), total, success, failed, index));
    }

    private int calculateWholeDataNum(Map<String, MulEntityImportResult> entityImportResult) {
        int wholeDataNum = 0;
        for (Map.Entry<String, MulEntityImportResult> importResultEntry : entityImportResult.entrySet()) {
            MulEntityImportResult importResult = importResultEntry.getValue();
            if (importResult.getEntityType() instanceof EntryType) continue;
            wholeDataNum += importResult.getTotalRowsIndex().size();
        }
        return wholeDataNum;
    }

    private int calculateFinishBillNum(List<MulEntityImportingInfo> entityProgressInfos) {
        int FinishBillNum = 0;
        for (MulEntityImportingInfo entityProgressInfo : entityProgressInfos) {
            FinishBillNum += entityProgressInfo.getCovertDataSize();
        }
        return FinishBillNum;
    }
}

