/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.resolve.convert;

import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.read.metadata.holder.ReadRowHolder;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.TextProp;
import kd.bos.mulimport.resolve.context.MulImportContext;
import kd.bos.mulimport.resolve.convert.IMulImportPropConvert;
import kd.bos.mulimport.resolve.model.MulImportConvertData;
import kd.bos.mulimport.resolve.model.MulImportDataMappingRule;
import kd.bos.mulimport.resolve.model.MulImportPropColMapping;
import kd.bos.mulimport.result.model.MulEntityImportResult;
import org.apache.commons.beanutils.ConvertUtils;

public class MulImportPropConvert
implements IMulImportPropConvert {
    protected IDataEntityProperty property;
    private MulImportContext mulImportContext;
    private MulImportDataMappingRule curSheetInfo;
    private MulImportConvertData convertedData;
    private MulImportPropColMapping propColMapping;
    private ReadRowHolder readRowHolder;
    private ReadCellData<Object> cellData;
    protected static final String BOS_IMPORT = "bos-import";

    public MulImportPropConvert(IDataEntityProperty property) {
        this.property = property;
    }

    public void init(ReadRowHolder readRowHolder, MulImportDataMappingRule dataMappingRule, MulImportConvertData convertedData) {
        this.readRowHolder = readRowHolder;
        this.setCurSheetInfo(dataMappingRule);
        this.setConvertedData(convertedData);
    }

    public void init(ReadRowHolder readRowHolder, MulImportDataMappingRule dataMappingRule, MulImportConvertData convertedData, MulImportPropColMapping propColMapping) {
        this.init(readRowHolder, dataMappingRule, convertedData);
        this.setPropColMapping(propColMapping);
    }

    public void init(ReadRowHolder readRowHolder, MulImportDataMappingRule dataMappingRule, MulImportConvertData convertedData, MulImportPropColMapping propColMapping, ReadCellData<Object> cellData) {
        this.init(readRowHolder, dataMappingRule, convertedData, propColMapping);
        this.cellData = cellData;
    }

    @Override
    public void setValue(DynamicObject data, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        if (this.property instanceof TextProp && !((TextProp)this.property).checkScope((Object)value)) {
            this.addErrorInfo(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u503c\u4e3a\u201c%2$s\u201d\uff0c\u4e0d\u7b26\u5408\u6620\u5c04\u7684\u5b9e\u4f53\u5b57\u6bb5\u201c%3$s\u201d\u957f\u5ea6\u8303\u56f4\u4e3a[%4$s,%5$s]\u7684\u8981\u6c42\u3002", (String)"MulImportPropConvert_0", (String)BOS_IMPORT, (Object[])new Object[0]), this.getPropColMapping().getColName(), value, this.getProperty().getDisplayName().getLocaleValue(), ((TextProp)this.property).getMinLenth(), ((TextProp)this.property).getMaxLenth()));
            return;
        }
        this.property.setValueFast((Object)data, ConvertUtils.convert((String)value, (Class)this.property.getPropertyType()));
    }

    protected void addErrorInfo(String errorMsg) {
        MulEntityImportResult entityImportResult = this.mulImportContext.getEntityImportResult().get(this.getImportResultKey(this.property.getParent()));
        entityImportResult.recodeErrorInfo(this.getExcelRowIndex(), errorMsg);
    }

    public IDataEntityProperty getProperty() {
        return this.property;
    }

    public MulImportContext getMulImportContext() {
        return this.mulImportContext;
    }

    public void setMulImportContext(MulImportContext mulImportContext) {
        this.mulImportContext = mulImportContext;
    }

    public Map<Integer, String> getCurRowData() {
        return (Map)this.readRowHolder.getCurrentRowAnalysisResult();
    }

    public MulImportDataMappingRule getCurSheetInfo() {
        return this.curSheetInfo;
    }

    public void setCurSheetInfo(MulImportDataMappingRule curSheetInfo) {
        this.curSheetInfo = curSheetInfo;
    }

    public MulImportConvertData getConvertedData() {
        return this.convertedData;
    }

    public void setConvertedData(MulImportConvertData convertedData) {
        this.convertedData = convertedData;
    }

    public MulImportPropColMapping getPropColMapping() {
        return this.propColMapping;
    }

    public void setPropColMapping(MulImportPropColMapping propColMapping) {
        this.propColMapping = propColMapping;
    }

    public int getExcelRowIndex() {
        return this.readRowHolder.getRowIndex();
    }

    public ReadCellData<Object> getCellData() {
        return this.cellData;
    }

    public void setCellData(ReadCellData<Object> cellData) {
        this.cellData = cellData;
    }

    public ReadRowHolder getReadRowHolder() {
        return this.readRowHolder;
    }

    public void setReadRowHolder(ReadRowHolder readRowHolder) {
        this.readRowHolder = readRowHolder;
    }

    private String getImportResultKey(IDataEntityType entityType) {
        if (entityType instanceof SubEntryType) {
            return entityType.getParent().getParent().getName() + "." + entityType.getParent().getName() + "." + entityType.getName();
        }
        if (entityType instanceof EntryType) {
            return entityType.getParent().getName() + "." + entityType.getName();
        }
        return entityType.getName();
    }
}

