/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mulimport.resolve.convert;

import com.alibaba.excel.metadata.Cell;
import com.alibaba.excel.metadata.data.ReadCellData;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.TimeProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mulimport.resolve.convert.MulImportPropConvert;
import kd.bos.mulimport.resolve.model.MulImportPropColMapping;
import org.apache.commons.collections4.BidiMap;
import org.apache.poi.ss.usermodel.DateUtil;

public class MulImportTimePropConvert
extends MulImportPropConvert {
    private static final Log log = LogFactory.getLog(MulImportTimePropConvert.class);

    public MulImportTimePropConvert(IDataEntityProperty property) {
        super(property);
    }

    @Override
    public void setValue(DynamicObject data, String value) {
        TimeProp property = this.getProperty();
        property.setValueFast((Object)data, (Object)-1);
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        BigDecimal numberValue = this.getCellData().getOriginalNumberValue();
        int secondOfTime = -1;
        try {
            if (numberValue != null) {
                Date date = DateUtil.getJavaDate((double)numberValue.doubleValue());
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                int hour = calendar.get(11);
                int minute = calendar.get(12);
                int second = calendar.get(13);
                secondOfTime = second + minute * 60 + hour * 3600;
            } else {
                secondOfTime = TimeProp.timeToSecond((Object)value, (String)property.getName());
            }
            if (!this.validateTimeRange(secondOfTime, value)) {
                return;
            }
        }
        catch (Exception e) {
            log.error("\u65f6\u95f4\u5b57\u6bb5\u8f6c\u6362\u5931\u8d25\uff1a" + value, (Throwable)e);
            this.addErrorInfo(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u503c\u4e3a\u201c%2$s\u201d\uff0c\u4e0d\u7b26\u5408\u6620\u5c04\u7684\u5b9e\u4f53\u5b57\u6bb5\u201c%3$s\u201d\u7684\u683c\u5f0f\u8981\u6c42hh:mm:ss\u3002", (String)"MulImportTimePropConvert_0", (String)"bos-import", (Object[])new Object[0]), this.getPropColMapping().getColName(), value, this.getProperty().getDisplayName().getLocaleValue()));
            return;
        }
        property.setValueFast((Object)data, (Object)secondOfTime);
    }

    private boolean validateTimeRange(int date, String value) {
        TimeProp property = this.getProperty();
        String relateTimeRange = property.getRelateTimeRange();
        if (StringUtils.isBlank((CharSequence)relateTimeRange)) {
            return true;
        }
        Integer relatePropIndex = null;
        BidiMap<Integer, MulImportPropColMapping> excelCol2PropInfoMap = this.getCurSheetInfo().getExcelCol2PropInfoMap();
        for (Map.Entry entry : excelCol2PropInfoMap.entrySet()) {
            MulImportPropColMapping propColMapping = (MulImportPropColMapping)entry.getValue();
            if (!StringUtils.equals((CharSequence)propColMapping.getPropNumber(), (CharSequence)relateTimeRange)) continue;
            relatePropIndex = (Integer)entry.getKey();
            break;
        }
        IDataEntityProperty relateDateProp = (IDataEntityProperty)property.getParent().getProperties().get((Object)relateTimeRange);
        if (relatePropIndex == null || !(relateDateProp instanceof TimeProp)) {
            this.addErrorInfo(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u6839\u636e\u6620\u5c04\u5b57\u6bb5\u201c%2$s\u201d\u65e0\u6cd5\u627e\u5230\u8d77\u59cb\u6216\u7ed3\u675f\u65f6\u95f4\u3002", (String)"MulImportTimePropConvert_1", (String)"bos-import", (Object[])new Object[0]), this.getPropColMapping().getColName(), property.getDisplayName().getLocaleValue()));
            return false;
        }
        int relateDate = this.getRelateDate(relatePropIndex, (TimeProp)relateDateProp);
        if (relateDate == -1) {
            this.addErrorInfo(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u6839\u636e\u6620\u5c04\u5b57\u6bb5\u201c%2$s\u201d\u65e0\u6cd5\u627e\u5230\u8d77\u59cb\u6216\u7ed3\u675f\u65f6\u95f4\u3002", (String)"MulImportTimePropConvert_1", (String)"bos-import", (Object[])new Object[0]), this.getPropColMapping().getColName(), property.getDisplayName().getLocaleValue()));
            return false;
        }
        if (property.isStartTimeRange() && date > relateDate || ((TimeProp)relateDateProp).isStartTimeRange() && relateDate > date) {
            this.addErrorInfo(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u503c\u4e3a\u201c%2$s\u201d\uff0c\u4e0d\u7b26\u5408\u6620\u5c04\u7684\u5b9e\u4f53\u5b57\u6bb5\u201c%3$s\u201d\u7684\u8d77\u59cb\u65f6\u95f4\u5c0f\u4e8e\u7ed3\u675f\u65f6\u95f4\u7684\u8981\u6c42\u3002", (String)"MulImportTimePropConvert_2", (String)"bos-import", (Object[])new Object[0]), this.getPropColMapping().getColName(), value, property.getDisplayName().getLocaleValue()));
            return false;
        }
        return true;
    }

    private int getRelateDate(Integer relatePropIndex, TimeProp relateDateProp) {
        ReadCellData cellData;
        BigDecimal numberValue;
        Cell cell = (Cell)this.getReadRowHolder().getCellMap().get(relatePropIndex);
        int relateDate = -1;
        if (cell instanceof ReadCellData && (numberValue = (cellData = (ReadCellData)cell).getNumberValue()) != null) {
            Date date = DateUtil.getJavaDate((double)numberValue.doubleValue());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int hour = calendar.get(11);
            int minute = calendar.get(12);
            int second = calendar.get(13);
            relateDate = second + minute * 60 + hour * 3600;
        }
        if (relateDate != -1) {
            return relateDate;
        }
        String relateValue = this.getCurRowData().get(relatePropIndex);
        if (StringUtils.isNotBlank((CharSequence)relateValue)) {
            try {
                relateDate = TimeProp.timeToSecond((Object)relateValue, (String)relateDateProp.getName());
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        return relateDate;
    }

    public TimeProp getProperty() {
        return (TimeProp)super.getProperty();
    }
}

